/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.schema;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonProviders;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.AvroConstants;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.schema.AvroRecordField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AvroType {
    private final String type;

    AvroType(String type) {
        this.type = type;
    }

    String getType() {
        return this.type;
    }

    public static AvroType getType(String jsonString) {
        AvroType avroType;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader(jsonString);
            try {
                avroType = AvroType.getType(jsonReader.readUntyped());
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            jsonReader.close();
        }
        return avroType;
    }

    private static AvroType getType(Object jsonSchema) {
        if (jsonSchema instanceof String) {
            return AvroType.getJsonStringType((String)jsonSchema);
        }
        if (jsonSchema instanceof List) {
            return AvroType.getJsonArrayType((List)jsonSchema);
        }
        if (jsonSchema instanceof Map) {
            return AvroType.getJsonObjectType((Map)jsonSchema);
        }
        throw new RuntimeException("Unsupported type");
    }

    private static AvroType getJsonStringType(String jsonSchema) {
        if (AvroConstants.Types.PRIMITIVE_TYPES.contains(jsonSchema)) {
            return new AvroPrimitiveType(jsonSchema);
        }
        throw new RuntimeException("Unsupported type");
    }

    private static AvroType getJsonArrayType(List<Object> jsonSchema) {
        List<AvroType> types = AvroType.getUnionTypes(jsonSchema);
        return new AvroUnionType(types);
    }

    private static AvroType getJsonObjectType(Map<String, Object> jsonSchema) {
        String type;
        switch (type = String.valueOf(jsonSchema.get("type"))) {
            case "null": 
            case "boolean": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "bytes": 
            case "string": {
                return new AvroPrimitiveType(type);
            }
            case "record": {
                if (jsonSchema.get("aliases") != null) {
                    throw new IllegalArgumentException("Unexpected aliases in schema.");
                }
                String fullName = String.valueOf(jsonSchema.get("name"));
                String name = fullName.substring(fullName.lastIndexOf(46) + 1);
                List<AvroRecordField> fields = AvroType.getRecordFields((List)jsonSchema.get("fields"));
                return new AvroRecordType(name, fields);
            }
            case "enum": {
                if (jsonSchema.get("aliases") != null) {
                    throw new IllegalArgumentException("Unexpected aliases in schema.");
                }
                List<String> symbols = AvroType.getEnumSymbols((List)jsonSchema.get("symbols"));
                return new AvroEnumType(String.valueOf(jsonSchema.get("name")), symbols);
            }
            case "array": {
                AvroType items = AvroType.getType(jsonSchema.get("items"));
                return new AvroArrayType(items);
            }
            case "map": {
                AvroType values2 = AvroType.getType(jsonSchema.get("values"));
                return new AvroMapType(values2);
            }
            case "fixed": {
                return new AvroFixedType(Long.parseLong(String.valueOf(jsonSchema.get("size"))));
            }
        }
        throw new RuntimeException("Unsupported type");
    }

    private static List<AvroType> getUnionTypes(List<Object> parent) {
        ArrayList<AvroType> types = new ArrayList<AvroType>(parent.size());
        for (Object child : parent) {
            types.add(AvroType.getType(child));
        }
        return types;
    }

    private static List<String> getEnumSymbols(List<Object> parent) {
        ArrayList<String> symbols = new ArrayList<String>(parent.size());
        for (Object child : parent) {
            symbols.add(String.valueOf(child));
        }
        return symbols;
    }

    private static List<AvroRecordField> getRecordFields(List<Map<String, Object>> parent) {
        ArrayList<AvroRecordField> fields = new ArrayList<AvroRecordField>(parent.size());
        for (Map<String, Object> child : parent) {
            fields.add(new AvroRecordField(String.valueOf(child.get("name")), AvroType.getType(child.get("type"))));
        }
        return fields;
    }

    static class AvroPrimitiveType
    extends AvroType {
        AvroPrimitiveType(String type) {
            super(type);
        }
    }

    static class AvroUnionType
    extends AvroType {
        private final List<AvroType> types;

        AvroUnionType(List<AvroType> types) {
            super("union");
            this.types = types;
        }

        List<AvroType> getTypes() {
            return this.types;
        }
    }

    static class AvroRecordType
    extends AvroType {
        private final String name;
        private final List<AvroRecordField> fields;

        AvroRecordType(String name, List<AvroRecordField> fields) {
            super("record");
            this.name = name;
            this.fields = fields;
        }

        String getName() {
            return this.name;
        }

        List<AvroRecordField> getFields() {
            return this.fields;
        }
    }

    static class AvroEnumType
    extends AvroType {
        private final String name;
        private final List<String> symbols;

        AvroEnumType(String name, List<String> symbols) {
            super("enum");
            this.name = name;
            this.symbols = symbols;
        }

        String getName() {
            return this.name;
        }

        List<String> getSymbols() {
            return this.symbols;
        }
    }

    static class AvroArrayType
    extends AvroType {
        private final AvroType itemType;

        AvroArrayType(AvroType itemType) {
            super("array");
            this.itemType = itemType;
        }

        AvroType getItemType() {
            return this.itemType;
        }
    }

    static class AvroMapType
    extends AvroType {
        private final AvroType valueType;

        AvroMapType(AvroType valueType) {
            super("map");
            this.valueType = valueType;
        }

        AvroType getValueType() {
            return this.valueType;
        }
    }

    static class AvroFixedType
    extends AvroType {
        private final Long size;

        AvroFixedType(Long size) {
            super("fixed");
            this.size = size;
        }

        Long getSize() {
            return this.size;
        }
    }
}

