/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out;

import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.impl.ErrorConsts;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.CharWName;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.OutputCharTypes;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.WName;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.WriterConfig;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.XmlWriter;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.util.XmlCharTypes;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;

public final class CharXmlWriter
extends XmlWriter {
    static final int DEFAULT_SMALL_SIZE = 200;
    static final int DEFAULT_FULL_BUFFER_SIZE = 1000;
    private final int mSmallWriteSize;
    private Writer _out;
    private char[] _outputBuffer;
    private int _outputPtr;
    private final int _outputBufferLen;
    private final int mEncHighChar;
    private final int mTableCheckEnd;
    final XmlCharTypes mCharTypes;

    public CharXmlWriter(WriterConfig cfg, Writer out) {
        super(cfg);
        this._out = out;
        this._outputBuffer = cfg.allocFullCBuffer(1000);
        this._outputBufferLen = this._outputBuffer.length;
        this.mSmallWriteSize = 200;
        this._outputPtr = 0;
        int bitsize = CharXmlWriter.guessEncodingBitSize(cfg);
        this.mEncHighChar = bitsize < 16 ? 1 << bitsize : 65534;
        this.mTableCheckEnd = Math.min(256, this.mEncHighChar);
        this.mCharTypes = bitsize < 8 ? OutputCharTypes.getAsciiCharTypes() : OutputCharTypes.getLatin1CharTypes();
    }

    @Override
    protected int getOutputPtr() {
        return this._outputPtr;
    }

    @Override
    public int getHighestEncodable() {
        return this.mEncHighChar;
    }

    @Override
    public WName constructName(String localName) {
        return new CharWName(localName);
    }

    @Override
    public WName constructName(String prefix, String localName) {
        return new CharWName(prefix, localName);
    }

    @Override
    public void _releaseBuffers() {
        super._releaseBuffers();
        if (this._outputBuffer != null) {
            this._config.freeFullCBuffer(this._outputBuffer);
            this._outputBuffer = null;
        }
    }

    @Override
    public void _closeTarget(boolean doClose) throws IOException {
        if (this._out != null && doClose) {
            this._out.close();
            this._out = null;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._out != null) {
            this.flushBuffer();
            this._out.flush();
        }
    }

    @Override
    public void writeRaw(char[] cbuf, int offset, int len) throws IOException {
        if (this._out == null) {
            return;
        }
        if (len < this.mSmallWriteSize) {
            if (this._outputPtr + len > this._outputBufferLen) {
                this.flushBuffer();
            }
            System.arraycopy(cbuf, offset, this._outputBuffer, this._outputPtr, len);
            this._outputPtr += len;
            return;
        }
        int ptr = this._outputPtr;
        if (ptr > 0) {
            if (ptr < this.mSmallWriteSize) {
                int needed = this.mSmallWriteSize - ptr;
                System.arraycopy(cbuf, offset, this._outputBuffer, ptr, needed);
                this._outputPtr = ptr + needed;
                len -= needed;
                offset += needed;
            }
            this.flushBuffer();
        }
        this._out.write(cbuf, offset, len);
    }

    @Override
    public void writeRaw(String str, int offset, int len) throws IOException {
        if (this._out == null) {
            return;
        }
        if (len < this.mSmallWriteSize) {
            if (this._outputPtr + len >= this._outputBufferLen) {
                this.flushBuffer();
            }
            str.getChars(offset, offset + len, this._outputBuffer, this._outputPtr);
            this._outputPtr += len;
            return;
        }
        int ptr = this._outputPtr;
        if (ptr > 0) {
            if (ptr < this.mSmallWriteSize) {
                int needed = this.mSmallWriteSize - ptr;
                str.getChars(offset, offset + needed, this._outputBuffer, ptr);
                this._outputPtr = ptr + needed;
                len -= needed;
                offset += needed;
            }
            this.flushBuffer();
        }
        this._out.write(str, offset, len);
    }

    public void writeCDataStart() throws IOException {
        this.fastWriteRaw("<![CDATA[");
    }

    public void writeCDataEnd() throws IOException {
        this.fastWriteRaw("]]>");
    }

    public void writeCommentStart() throws IOException {
        this.fastWriteRaw("<!--");
    }

    public void writeCommentEnd() throws IOException {
        this.fastWriteRaw("-->");
    }

    @Override
    public int writeCData(String data) throws IOException, XMLStreamException {
        int len2;
        this.writeCDataStart();
        int offset = 0;
        for (int len = data.length(); len > 0; len -= len2) {
            char[] buf = this._copyBuffer;
            int blen = buf.length;
            len2 = Math.min(len, blen);
            data.getChars(offset, offset + len2, buf, 0);
            int cix = this.writeCDataContents(buf, 0, len2);
            if (cix >= 0) {
                return offset + cix;
            }
            offset += len2;
        }
        this.writeCDataEnd();
        return -1;
    }

    private int writeCDataContents(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        int start = offset;
        block6: while (offset < len) {
            char ch;
            int[] charTypes = this.mCharTypes.OTHER_CHARS;
            int limit = this.mTableCheckEnd;
            while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = ch;
                if (++offset < len) continue;
                break block6;
            }
            if ((ch = cbuf[offset++]) < limit) {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("CDATA block", ch);
                    }
                    case 17: {
                        if (offset - start < 3 || cbuf[offset - 2] != ']' || cbuf[offset - 3] != ']') break;
                        --offset;
                        this.writeCDataEnd();
                        this.writeCDataStart();
                    }
                }
            } else if (ch >= this.mEncHighChar) {
                this.reportFailedEscaping("CDATA block", ch);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
        return -1;
    }

    @Override
    public void writeCharacters(String text) throws IOException, XMLStreamException {
        int len2;
        if (this._out == null) {
            return;
        }
        int offset = 0;
        for (int len = text.length(); len > 0; len -= len2) {
            char[] buf = this._copyBuffer;
            int blen = buf.length;
            len2 = Math.min(len, blen);
            text.getChars(offset, offset + len2, buf, 0);
            this.writeCharacters(buf, 0, len2);
            offset += len2;
        }
    }

    @Override
    public void writeCharacters(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        len += offset;
        block6: while (offset < len) {
            char ch;
            int[] charTypes = this.mCharTypes.TEXT_CHARS;
            int limit = this.mTableCheckEnd;
            while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = ch;
                if (++offset < len) continue;
                break block6;
            }
            if ((ch = cbuf[offset++]) < limit) {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 11: {
                        if (offset < len && cbuf[offset] != '>') break;
                    }
                    case 4: 
                    case 9: 
                    case 10: {
                        this.writeAsEntity(ch);
                        continue block6;
                    }
                    case 2: {
                        this.writeAsEntity(ch);
                        continue block6;
                    }
                }
            } else if (ch >= this.mEncHighChar) {
                this.writeAsEntity(ch);
                continue;
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
    }

    @Override
    public void writeSpace(String data) throws IOException, XMLStreamException {
        int len2;
        if (this._out == null) {
            return;
        }
        int offset = 0;
        for (int len = data.length(); len > 0; len -= len2) {
            char[] buf = this._copyBuffer;
            int blen = buf.length;
            len2 = Math.min(len, blen);
            data.getChars(offset, offset + len2, buf, 0);
            this.writeSpace(buf, 0, len2);
            offset += len2;
        }
    }

    @Override
    public void writeSpace(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        len += offset;
        while (offset < len) {
            char ch;
            if ((ch = cbuf[offset++]) > ' ') {
                this.reportNwfContent(ErrorConsts.WERR_SPACE_CONTENT, ch, offset - 1);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
    }

    @Override
    public int writeComment(String data) throws IOException, XMLStreamException {
        int blen;
        if (this._out == null) {
            return -1;
        }
        this.writeCommentStart();
        int offset = 0;
        int cix = -1;
        for (int len = data.length(); len > 0; len -= blen) {
            char[] buf = this._copyBuffer;
            blen = buf.length;
            if (blen > len) {
                blen = len;
            }
            data.getChars(offset, offset + blen, buf, 0);
            cix = this.writeCommentContents(buf, 0, blen);
            if (cix >= 0) break;
            offset += blen;
        }
        if (cix >= 0) {
            return offset + cix;
        }
        this.writeCommentEnd();
        return -1;
    }

    private int writeCommentContents(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        block6: while (offset < len) {
            char ch;
            int[] charTypes = this.mCharTypes.OTHER_CHARS;
            int limit = this.mTableCheckEnd;
            while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = ch;
                if (++offset < len) continue;
                break block6;
            }
            if ((ch = cbuf[offset++]) < limit) {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("comment", ch);
                    }
                    case 13: {
                        if (offset != len && cbuf[offset] != '-') break;
                        if (this._outputPtr >= this._outputBufferLen) {
                            this.flushBuffer();
                        }
                        this._outputBuffer[this._outputPtr++] = 32;
                    }
                }
            } else if (ch >= this.mEncHighChar) {
                this.reportFailedEscaping("comment", ch);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
        return -1;
    }

    @Override
    public void writeDTD(String data) throws IOException {
        this.writeRaw(data, 0, data.length());
    }

    @Override
    public void writeEntityReference(WName name) throws IOException {
        this.fastWriteRaw('&');
        this.writeName(name);
        this.fastWriteRaw(';');
    }

    @Override
    public void writeXmlDeclaration(String version, String encoding, String standalone) throws IOException {
        this.fastWriteRaw("<?xml version=\"");
        this.fastWriteRaw(version);
        this.fastWriteRaw('\"');
        if (encoding != null && !encoding.isEmpty()) {
            this.fastWriteRaw(" encoding=\"");
            this.fastWriteRaw(encoding);
            this.fastWriteRaw('\"');
        }
        if (standalone != null) {
            this.fastWriteRaw(" standalone=\"");
            this.fastWriteRaw(standalone);
            this.fastWriteRaw('\"');
        }
        this.fastWriteRaw('?', '>');
    }

    @Override
    public int writePI(WName target, String data) throws IOException, XMLStreamException {
        this.fastWriteRaw('<', '?');
        this.writeName(target);
        if (data != null && !data.isEmpty()) {
            int blen;
            int offset = 0;
            int cix = -1;
            this.fastWriteRaw(' ');
            for (int len = data.length(); len > 0; len -= blen) {
                char[] buf = this._copyBuffer;
                blen = buf.length;
                if (blen > len) {
                    blen = len;
                }
                data.getChars(offset, offset + blen, buf, 0);
                cix = this.writePIContents(buf, 0, blen);
                if (cix >= 0) break;
                offset += blen;
            }
            if (cix >= 0) {
                return offset + cix;
            }
        }
        this.fastWriteRaw('?', '>');
        return -1;
    }

    private int writePIContents(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        block6: while (offset < len) {
            char ch;
            int[] charTypes = this.mCharTypes.OTHER_CHARS;
            int limit = this.mTableCheckEnd;
            while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = ch;
                if (++offset < len) continue;
                break block6;
            }
            if ((ch = cbuf[offset++]) < limit) {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("processing instruction", ch);
                    }
                    case 12: {
                        if (offset >= len || cbuf[offset] != '>') break;
                        return offset;
                    }
                }
            } else if (ch >= this.mEncHighChar) {
                this.reportFailedEscaping("processing instruction", ch);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
        return -1;
    }

    @Override
    public void writeStartTagStart(WName name) throws IOException {
        int ptr = this._outputPtr;
        int len = name.serializedLength();
        if (ptr + len + 1 > this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
            if (len >= this._outputBufferLen) {
                this._out.write(60);
                name.writeChars(this._out);
                return;
            }
            ptr = this._outputPtr;
        }
        char[] buf = this._outputBuffer;
        buf[ptr++] = 60;
        name.appendChars(buf, ptr);
        this._outputPtr = ptr + len;
    }

    @Override
    public void writeStartTagEnd() throws IOException {
        this.fastWriteRaw('>');
    }

    @Override
    public void writeStartTagEmptyEnd() throws IOException {
        int ptr = this._outputPtr;
        if (ptr + 2 > this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
            ptr = this._outputPtr;
        }
        char[] buf = this._outputBuffer;
        buf[ptr++] = 47;
        buf[ptr++] = 62;
        this._outputPtr = ptr;
    }

    @Override
    public void writeEndTag(WName name) throws IOException {
        int ptr = this._outputPtr;
        int len = name.serializedLength();
        if (ptr + len + 3 > this._outputBufferLen) {
            this.flushBuffer();
            if (len + 3 > this._outputBufferLen) {
                this._out.write(60);
                this._out.write(47);
                name.writeChars(this._out);
                this._outputBuffer[this._outputPtr++] = 62;
                return;
            }
            ptr = this._outputPtr;
        }
        char[] buf = this._outputBuffer;
        buf[ptr++] = 60;
        buf[ptr++] = 47;
        name.appendChars(buf, ptr);
        ptr += len;
        buf[ptr++] = 62;
        this._outputPtr = ptr;
    }

    @Override
    public void writeAttribute(WName name, String value) throws IOException, XMLStreamException {
        int len;
        if (this._out == null) {
            return;
        }
        this.fastWriteRaw(' ');
        this.writeName(name);
        this.fastWriteRaw('=', '\"');
        int n = len = value == null ? 0 : value.length();
        if (len > 0) {
            this.writeAttrValue(value, len);
        }
        this.fastWriteRaw('\"');
    }

    @Override
    public void writeAttribute(WName name, char[] value, int offset, int vlen) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        this.fastWriteRaw(' ');
        this.writeName(name);
        this.fastWriteRaw('=', '\"');
        if (vlen > 0) {
            this.writeAttrValue(value, offset, vlen);
        }
        this.fastWriteRaw('\"');
    }

    private void writeAttrValue(String value, int len) throws IOException, XMLStreamException {
        int offset = 0;
        while (len > 0) {
            char[] buf = this._copyBuffer;
            int blen = buf.length;
            int len2 = Math.min(len, blen);
            value.getChars(offset, offset + len2, buf, 0);
            this.writeAttrValue(buf, 0, len2);
            offset += len2;
            len -= len2;
        }
    }

    private void writeAttrValue(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        if (this._outputPtr + len > this._outputBufferLen) {
            this.writeSplitAttrValue(cbuf, offset, len);
            return;
        }
        len += offset;
        block5: while (offset < len) {
            char ch;
            block11: {
                block10: {
                    int[] charTypes = this.mCharTypes.ATTR_CHARS;
                    int limit = this.mTableCheckEnd;
                    while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                        this._outputBuffer[this._outputPtr++] = ch;
                        if (++offset < len) continue;
                        break block5;
                    }
                    if ((ch = cbuf[offset++]) >= limit) break block10;
                    switch (charTypes[ch]) {
                        case 1: {
                            this.reportInvalidChar(ch);
                        }
                        case 4: 
                        case 9: 
                        case 10: 
                        case 14: {
                            break block11;
                        }
                        case 2: 
                        case 3: {
                            break block11;
                        }
                        default: {
                            this._outputBuffer[this._outputPtr++] = ch;
                            break;
                        }
                    }
                    continue;
                }
                if (ch < this.mEncHighChar) {
                    this._outputBuffer[this._outputPtr++] = ch;
                    continue;
                }
            }
            this.writeAsEntity(ch);
            if (len - offset < this._outputBufferLen - this._outputPtr) continue;
            this.flushBuffer();
        }
    }

    private void writeSplitAttrValue(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        block5: while (offset < len) {
            char ch;
            int[] charTypes = this.mCharTypes.ATTR_CHARS;
            int limit = this.mTableCheckEnd;
            while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = ch;
                if (++offset < len) continue;
                break block5;
            }
            if ((ch = cbuf[offset++]) < limit) {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 4: 
                    case 9: 
                    case 10: 
                    case 14: {
                        this.writeAsEntity(ch);
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        this.writeAsEntity(ch);
                        continue block5;
                    }
                }
            } else if (ch >= this.mEncHighChar) {
                this.writeAsEntity(ch);
                continue;
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
    }

    private void flushBuffer() throws IOException {
        if (this._outputPtr > 0 && this._out != null) {
            int ptr = this._outputPtr;
            this._locPastChars += ptr;
            this._locRowStartOffset -= ptr;
            this._outputPtr = 0;
            this._out.write(this._outputBuffer, 0, ptr);
        }
    }

    private void writeName(WName name) throws IOException {
        int ptr = this._outputPtr;
        int len = name.serializedLength();
        if (ptr + len > this._outputBufferLen) {
            this.flushBuffer();
            if (len >= this._outputBufferLen) {
                name.writeChars(this._out);
                return;
            }
            ptr = this._outputPtr;
        }
        name.appendChars(this._outputBuffer, ptr);
        this._outputPtr += len;
    }

    private void fastWriteRaw(char c) throws IOException {
        if (this._outputPtr >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = c;
    }

    private void fastWriteRaw(char c1, char c2) throws IOException {
        if (this._outputPtr + 1 >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = c1;
        this._outputBuffer[this._outputPtr++] = c2;
    }

    private void fastWriteRaw(String str) throws IOException {
        int ptr = this._outputPtr;
        int len = str.length();
        if (ptr + len >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            if (len > this._outputBufferLen) {
                this.writeRaw(str, 0, str.length());
                return;
            }
            this.flushBuffer();
            ptr = this._outputPtr;
        }
        str.getChars(0, len, this._outputBuffer, ptr);
        this._outputPtr = ptr + len;
    }

    private void writeAsEntity(int c) throws IOException {
        int ptr = this._outputPtr;
        char[] buf = this._outputBuffer;
        if (ptr + 10 >= buf.length) {
            this.flushBuffer();
            ptr = this._outputPtr;
        }
        buf[ptr++] = 38;
        if (c < 256) {
            if (c == 38) {
                buf[ptr++] = 97;
                buf[ptr++] = 109;
                buf[ptr++] = 112;
            } else if (c == 60) {
                buf[ptr++] = 108;
                buf[ptr++] = 116;
            } else if (c == 62) {
                buf[ptr++] = 103;
                buf[ptr++] = 116;
            } else if (c == 39) {
                buf[ptr++] = 97;
                buf[ptr++] = 112;
                buf[ptr++] = 111;
                buf[ptr++] = 115;
            } else if (c == 34) {
                buf[ptr++] = 113;
                buf[ptr++] = 117;
                buf[ptr++] = 111;
                buf[ptr++] = 116;
            } else {
                buf[ptr++] = 35;
                buf[ptr++] = 120;
                if (c >= 16) {
                    int digit = c >> 4;
                    buf[ptr++] = (char)(digit < 10 ? 48 + digit : 87 + digit);
                    c &= 0xF;
                }
                buf[ptr++] = (char)(c < 10 ? 48 + c : 87 + c);
            }
        } else {
            buf[ptr++] = 35;
            buf[ptr++] = 120;
            int shift = 20;
            int origPtr = ptr;
            do {
                int digit;
                if ((digit = c >> shift & 0xF) <= 0 && ptr == origPtr) continue;
                buf[ptr++] = (char)(digit < 10 ? 48 + digit : 87 + digit);
            } while ((shift -= 4) > 0);
            buf[ptr++] = (char)((c &= 0xF) < 10 ? 48 + c : 87 + c);
        }
        buf[ptr++] = 59;
        this._outputPtr = ptr;
    }
}

