/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out;

import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.impl.ErrorConsts;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.impl.IoStreamException;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.impl.LocationImpl;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.impl.StreamExceptionBase;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.OutputElement;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.WName;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.WNameTable;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.WriterConfig;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.XmlWriter;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.stax2.ri.Stax2WriterImpl;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public abstract class StreamWriterBase
extends Stax2WriterImpl
implements NamespaceContext {
    protected final WriterConfig _config;
    protected NamespaceContext _rootNsContext;
    protected WNameTable _symbols;
    protected final XmlWriter _xmlWriter;
    protected State _state = State.PROLOG;
    protected OutputElement _currElem = OutputElement.createRoot();
    protected boolean _stateAnyOutput = false;
    protected boolean _stateStartElementOpen = false;
    protected boolean _stateEmptyElement = false;
    protected String _dtdRootElemName = null;
    protected OutputElement _outputElemPool = null;
    static final int MAX_POOL_SIZE = 8;
    protected int _poolSize = 0;

    protected StreamWriterBase(WriterConfig cfg, XmlWriter writer, WNameTable symbols) {
        this._config = cfg;
        this._xmlWriter = writer;
        this._symbols = symbols;
    }

    @Override
    public void close() throws XMLStreamException {
        this._finishDocument();
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this._xmlWriter.flush();
        }
        catch (IOException ie) {
            throw new IoStreamException(ie);
        }
    }

    @Override
    public final NamespaceContext getNamespaceContext() {
        return this;
    }

    @Override
    public Object getProperty(String name) {
        return this._config.getProperty(name, true);
    }

    @Override
    public abstract void setDefaultNamespace(String var1) throws XMLStreamException;

    @Override
    public void setNamespaceContext(NamespaceContext ctxt) throws XMLStreamException {
        if (this._state != State.PROLOG) {
            StreamWriterBase.throwOutputError("Called setNamespaceContext() after having already output root element.");
        }
        this._rootNsContext = ctxt;
    }

    @Override
    public final void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (prefix.isEmpty()) {
            this.setDefaultNamespace(uri);
            return;
        }
        if (uri == null) {
            throw new NullPointerException();
        }
        if (prefix.equals("xml")) {
            if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, uri);
            }
        } else if (prefix.equals("xmlns")) {
            if (!uri.equals("http://www.w3.org/2000/xmlns/")) {
                StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, uri);
            }
        } else if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, prefix);
        } else if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, prefix);
        }
        if (uri.isEmpty()) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_EMPTY);
        }
        this._setPrefix(prefix, uri);
    }

    protected abstract void _setPrefix(String var1, String var2);

    @Override
    public final void writeAttribute(String localName, String value) throws XMLStreamException {
        if (!this._stateStartElementOpen) {
            StreamWriterBase.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        this._writeAttribute(this._symbols.findSymbol(localName), value);
    }

    @Override
    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this._verifyWriteCData();
        try {
            int ix = this._xmlWriter.writeCData(data);
            if (ix >= 0) {
                StreamWriterBase._reportNwfContent(ErrorConsts.WERR_CDATA_CONTENT, ix);
            }
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this.inPrologOrEpilog()) {
            this.writeSpace(text, start, len);
            return;
        }
        if (len > 0) {
            try {
                this._xmlWriter.writeCharacters(text, start, len);
            }
            catch (IOException ioe) {
                throw new IoStreamException(ioe);
            }
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this.inPrologOrEpilog()) {
            this.writeSpace(text);
            return;
        }
        try {
            this._xmlWriter.writeCharacters(text);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            int ix = this._xmlWriter.writeComment(data);
            if (ix >= 0) {
                StreamWriterBase._reportNwfContent(ErrorConsts.WERR_COMMENT_CONTENT, ix);
            }
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    @Override
    public final void writeDTD(String dtd) throws XMLStreamException {
        this._verifyWriteDTD();
        this._dtdRootElemName = "";
        try {
            this._xmlWriter.writeDTD(dtd);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this._verifyStartElement(null, localName);
        WName name = this._symbols.findSymbol(localName);
        this._writeStartTag(name, true);
    }

    @Override
    public abstract void writeEmptyElement(String var1, String var2) throws XMLStreamException;

    @Override
    public abstract void writeEmptyElement(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this._finishDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this._stateStartElementOpen && this._stateEmptyElement) {
            this._stateEmptyElement = false;
            this._closeStartElement(true);
        }
        if (this._state != State.TREE) {
            StreamWriterBase._reportNwfStructure("No open start element, when trying to write end element");
        }
        OutputElement thisElem = this._currElem;
        this._currElem = thisElem.getParent();
        if (this._poolSize < 8) {
            thisElem.addToPool(this._outputElemPool);
            this._outputElemPool = thisElem;
            ++this._poolSize;
        }
        try {
            if (this._stateStartElementOpen) {
                this._stateStartElementOpen = false;
                this._xmlWriter.writeStartTagEmptyEnd();
            } else {
                this._xmlWriter.writeEndTag(thisElem.getName());
            }
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        if (this._currElem.isRoot()) {
            this._state = State.EPILOG;
        }
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this.inPrologOrEpilog()) {
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_ENTITY);
        }
        try {
            this._xmlWriter.writeEntityReference(this._symbols.findSymbol(name));
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public abstract void writeNamespace(String var1, String var2) throws XMLStreamException;

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, null);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            int ix = this._xmlWriter.writePI(this._symbols.findSymbol(target), data);
            if (ix >= 0) {
                StreamWriterBase._reportNwfContent(ErrorConsts.WERR_PI_CONTENT, ix);
            }
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        String enc = this._config.getActualEncoding();
        if (enc == null) {
            enc = "UTF-8";
            this._config.setActualEncodingIfNotSet(enc);
        }
        this._writeStartDocument("1.0", enc);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this._writeStartDocument(version, this._config.getActualEncoding());
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this._writeStartDocument(version, encoding);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this._verifyStartElement(null, localName);
        WName name = this._symbols.findSymbol(localName);
        this._writeStartTag(name, false);
    }

    @Override
    public abstract void writeStartElement(String var1, String var2) throws XMLStreamException;

    @Override
    public abstract void writeStartElement(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public String getNamespaceURI(String prefix) {
        String uri = this._currElem.getNamespaceURI(prefix);
        if (uri == null && this._rootNsContext != null) {
            uri = this._rootNsContext.getNamespaceURI(prefix);
        }
        return uri;
    }

    @Override
    public String getPrefix(String uri) {
        String prefix = this._currElem.getPrefix(uri);
        if (prefix == null && this._rootNsContext != null) {
            prefix = this._rootNsContext.getPrefix(uri);
        }
        return prefix;
    }

    @Override
    public Iterator<String> getPrefixes(String uri) {
        return this._currElem.getPrefixes(uri, this._rootNsContext);
    }

    @Override
    public void writeSpace(String text) throws XMLStreamException {
        try {
            this._xmlWriter.writeSpace(text);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeSpace(char[] cbuf, int offset, int len) throws XMLStreamException {
        try {
            this._xmlWriter.writeSpace(cbuf, offset, len);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public Location getLocation() {
        return new LocationImpl(this._xmlWriter.getAbsOffset(), this._xmlWriter.getRow(), this._xmlWriter.getColumn());
    }

    @Override
    public void writeRaw(String text) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            this._xmlWriter.writeRaw(text, 0, text.length());
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeRaw(String text, int start, int offset) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            this._xmlWriter.writeRaw(text, start, offset);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeRaw(char[] text, int offset, int length) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            this._xmlWriter.writeRaw(text, offset, length);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected void _closeStartElement(boolean emptyElem) throws XMLStreamException {
        this._stateStartElementOpen = false;
        try {
            if (emptyElem) {
                this._xmlWriter.writeStartTagEmptyEnd();
            } else {
                this._xmlWriter.writeStartTagEnd();
            }
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        if (emptyElem) {
            OutputElement thisElem = this._currElem;
            this._currElem = thisElem.getParent();
            if (this._currElem.isRoot()) {
                this._state = State.EPILOG;
            }
            if (this._poolSize < 8) {
                thisElem.addToPool(this._outputElemPool);
                this._outputElemPool = thisElem;
                ++this._poolSize;
            }
        }
    }

    protected final boolean inPrologOrEpilog() {
        return this._state != State.TREE;
    }

    protected final void _writeAttribute(WName name, String value) throws XMLStreamException {
        try {
            this._xmlWriter.writeAttribute(name, value);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected final void _writeDefaultNamespace(String uri) throws XMLStreamException {
        WName name = this._symbols.findSymbol("xmlns");
        try {
            this._xmlWriter.writeAttribute(name, uri);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected final void _writeNamespace(String prefix, String uri) throws XMLStreamException {
        WName name = this._symbols.findSymbol("xmlns", prefix);
        try {
            this._xmlWriter.writeAttribute(name, uri);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected void _writeStartDocument(String version, String encoding) throws XMLStreamException {
        if (this._stateAnyOutput) {
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_DUP_XML_DECL);
        }
        this._stateAnyOutput = true;
        if (!(version == null || version.isEmpty() || version.equals("1.0") || version.equals("1.1"))) {
            StreamWriterBase._reportNwfContent("Illegal version argument ('" + version + "'); should only use '" + "1.0" + "' or '" + "1.1" + "'");
        }
        if (version == null || version.isEmpty()) {
            version = "1.0";
        }
        if ("1.1".equals(version)) {
            this._xmlWriter.enableXml11();
        }
        if (encoding != null && !encoding.isEmpty()) {
            this._config.setActualEncodingIfNotSet(encoding);
        }
        try {
            this._xmlWriter.writeXmlDeclaration(version, encoding, null);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected void _writeStartTag(WName name, boolean isEmpty) throws XMLStreamException {
        this._stateAnyOutput = true;
        this._stateStartElementOpen = true;
        if (this._outputElemPool != null) {
            OutputElement newCurr = this._outputElemPool;
            this._outputElemPool = newCurr.reuseAsChild(this._currElem, name);
            --this._poolSize;
            this._currElem = newCurr;
        } else {
            this._currElem = this._currElem.createChild(name);
        }
        try {
            this._xmlWriter.writeStartTagStart(name);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        this._stateEmptyElement = isEmpty;
    }

    protected void _writeStartTag(WName name, boolean isEmpty, String uri) throws XMLStreamException {
        this._stateAnyOutput = true;
        this._stateStartElementOpen = true;
        if (uri == null) {
            uri = "";
        }
        if (this._outputElemPool != null) {
            OutputElement newCurr = this._outputElemPool;
            this._outputElemPool = newCurr.reuseAsChild(this._currElem, name, uri);
            --this._poolSize;
            this._currElem = newCurr;
        } else {
            this._currElem = this._currElem.createChild(name, uri);
        }
        try {
            this._xmlWriter.writeStartTagStart(name);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        this._stateEmptyElement = isEmpty;
    }

    protected void _verifyStartElement(String prefix, String localName) throws XMLStreamException {
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        } else if (this._state == State.PROLOG) {
            this._verifyRootElement();
        } else if (this._state == State.EPILOG) {
            String name = prefix == null ? localName : prefix + ":" + localName;
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_SECOND_ROOT, name);
            this._state = State.TREE;
        }
    }

    protected final void _verifyWriteCData() throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this.inPrologOrEpilog()) {
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_CDATA);
        }
    }

    protected final void _verifyWriteDTD() throws XMLStreamException {
        if (this._state != State.PROLOG) {
            throw new XMLStreamException("Can not write DOCTYPE declaration (DTD) when not in prolog any more (state " + (Object)((Object)this._state) + "; start element(s) written)");
        }
        if (this._dtdRootElemName != null) {
            throw new XMLStreamException("Trying to write multiple DOCTYPE declarations");
        }
    }

    protected void _verifyRootElement() {
        this._state = State.TREE;
    }

    protected static void throwOutputError(String msg) throws XMLStreamException {
        throw new StreamExceptionBase(msg);
    }

    protected static void throwOutputError(String format, Object arg) throws XMLStreamException {
        String msg = MessageFormat.format(format, arg);
        StreamWriterBase.throwOutputError(msg);
    }

    protected static void _reportNwfStructure(String msg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg);
    }

    protected static void _reportNwfStructure(String msg, Object arg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg, arg);
    }

    protected static void _reportNwfContent(String msg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg);
    }

    protected static void _reportNwfContent(String msg, Object arg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg, arg);
    }

    private void _finishDocument() throws XMLStreamException {
        if (this._state != State.EPILOG) {
            if (this._state == State.PROLOG) {
                StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_NO_ROOT);
            }
            if (this._stateStartElementOpen) {
                this._closeStartElement(this._stateEmptyElement);
            }
            while (this._state != State.EPILOG) {
                this.writeEndElement();
            }
        }
        if (this._symbols.maybeDirty()) {
            this._symbols.mergeToParent();
        }
        try {
            this._xmlWriter.close(false);
        }
        catch (IOException ie) {
            throw new IoStreamException(ie);
        }
    }

    public String toString() {
        return "[StreamWriter: " + this.getClass() + ", underlying outputter: " + (this._xmlWriter == null ? "NULL" : this._xmlWriter.toString());
    }

    protected static enum State {
        PROLOG,
        TREE,
        EPILOG;

    }
}

