/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out;

import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.impl.ErrorConsts;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.impl.IoStreamException;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.WName;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.WNameFactory;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.out.WriterConfig;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.util.CharsetNames;
import com.dataiku.dss.shadelibazure.com.azure.xml.implementation.aalto.util.XmlChars;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;

public abstract class XmlWriter
extends WNameFactory {
    protected static final int SURR1_FIRST = 55296;
    protected static final int SURR2_FIRST = 56320;
    protected static final int SURR2_LAST = 57343;
    protected static final int DEFAULT_COPYBUFFER_LEN = 512;
    protected final WriterConfig _config;
    protected char[] _copyBuffer;
    protected final int _copyBufferLen;
    protected boolean _xml11 = false;
    protected int _locPastChars = 0;
    protected int _locRowNr = 1;
    protected int _locRowStartOffset = 0;

    protected XmlWriter(WriterConfig cfg) {
        this._config = cfg;
        this._copyBuffer = cfg.allocMediumCBuffer(512);
        this._copyBufferLen = this._copyBuffer.length;
    }

    @Override
    public abstract WName constructName(String var1) throws XMLStreamException;

    @Override
    public abstract WName constructName(String var1, String var2) throws XMLStreamException;

    public void enableXml11() {
        this._xml11 = true;
    }

    protected abstract int getOutputPtr();

    public abstract int getHighestEncodable();

    public final void close(boolean forceTargetClose) throws IOException {
        this.flush();
        this._releaseBuffers();
        this._closeTarget(forceTargetClose);
    }

    public void _releaseBuffers() {
        char[] buf = this._copyBuffer;
        if (buf != null) {
            this._copyBuffer = null;
            this._config.freeMediumCBuffer(buf);
        }
    }

    public abstract void _closeTarget(boolean var1) throws IOException;

    public abstract void flush() throws IOException;

    public abstract int writeCData(String var1) throws IOException, XMLStreamException;

    public abstract void writeCharacters(String var1) throws IOException, XMLStreamException;

    public abstract void writeCharacters(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeSpace(String var1) throws IOException, XMLStreamException;

    public abstract void writeSpace(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract int writeComment(String var1) throws IOException, XMLStreamException;

    public abstract void writeDTD(String var1) throws IOException, XMLStreamException;

    public abstract void writeEntityReference(WName var1) throws IOException, XMLStreamException;

    public abstract int writePI(WName var1, String var2) throws IOException, XMLStreamException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeXmlDeclaration(String var1, String var2, String var3) throws IOException, XMLStreamException;

    public abstract void writeStartTagStart(WName var1) throws IOException, XMLStreamException;

    public abstract void writeStartTagEnd() throws IOException, XMLStreamException;

    public abstract void writeStartTagEmptyEnd() throws IOException, XMLStreamException;

    public abstract void writeEndTag(WName var1) throws IOException, XMLStreamException;

    public abstract void writeAttribute(WName var1, String var2) throws IOException, XMLStreamException;

    public abstract void writeAttribute(WName var1, char[] var2, int var3, int var4) throws IOException, XMLStreamException;

    public int getRow() {
        return this._locRowNr;
    }

    public int getColumn() {
        return this.getOutputPtr() - this._locRowStartOffset + 1;
    }

    public int getAbsOffset() {
        return this._locPastChars + this.getOutputPtr();
    }

    public static int guessEncodingBitSize(WriterConfig cfg) {
        String enc = cfg.getPreferredEncoding();
        if (enc == null || enc.isEmpty()) {
            return 16;
        }
        if (Objects.equals(enc = CharsetNames.normalize(enc), "UTF-8")) {
            return 16;
        }
        if (Objects.equals(enc, "ISO-8859-1")) {
            return 8;
        }
        if (Objects.equals(enc, "US-ASCII")) {
            return 7;
        }
        if (Objects.equals(enc, "UTF-16") || Objects.equals(enc, "UTF-16BE") || Objects.equals(enc, "UTF-16LE") || Objects.equals(enc, "UTF-32BE") || Objects.equals(enc, "UTF-32LE")) {
            return 16;
        }
        return 8;
    }

    protected void reportNwfName(String msg) throws XMLStreamException {
        this.throwOutputError(msg);
    }

    protected void reportNwfContent(String msg) throws XMLStreamException {
        this.throwOutputError(msg);
    }

    protected void reportNwfContent(String format, Object arg1, Object arg2) throws XMLStreamException {
        String msg = MessageFormat.format(format, arg1, arg2);
        this.reportNwfContent(msg);
    }

    protected void reportFailedEscaping(String type, int ch) throws XMLStreamException {
        if (ch == 65534 || ch == 65535 || ch >= 55296 && ch <= 57343) {
            this.reportInvalidChar(ch);
        }
        if (ch < 32) {
            this.reportInvalidChar(ch);
        }
        String msg = MessageFormat.format(ErrorConsts.WERR_NO_ESCAPING, type, ch);
        this.reportNwfContent(msg);
    }

    protected void reportInvalidChar(int c) throws XMLStreamException {
        try {
            this.flush();
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        if (c == 0) {
            this.reportNwfContent("Invalid null character in text to output");
        }
        if (c < 32 || c >= 127 && c <= 159) {
            String msg = "Invalid white space character (0x" + Integer.toHexString(c) + ") in text to output";
            if (this._xml11) {
                msg = msg + " (can only be output using character entity)";
            }
            this.reportNwfContent(msg);
        }
        if (c > 0x10FFFF) {
            this.reportNwfContent("Illegal unicode character point (0x" + Integer.toHexString(c) + ") to output; max is 0x10FFFF as per RFC 3629");
        }
        if (c >= 55296 && c <= 57343) {
            this.reportNwfContent("Illegal surrogate pair -- can only be output via character entities (for current encoding), which are not allowed in this content");
        }
        this.reportNwfContent("Invalid XML character " + XmlChars.getCharDesc(c) + " in text to output");
    }

    protected void throwOutputError(String msg) throws XMLStreamException {
        try {
            this.flush();
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        throw new XMLStreamException(msg);
    }
}

