/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j;

import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.AbstractApplicationBase;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.IApplicationBase;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.PublicApi;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.StringHelper;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.UserIdentifier;
import java.util.UUID;
import lombok.Generated;

class RequestContext {
    private String telemetryRequestId;
    private String clientId;
    private String correlationId;
    private PublicApi publicApi;
    private String applicationName;
    private String applicationVersion;
    private String authority;
    private IAcquireTokenParameters apiParameters;
    private IApplicationBase clientApplication;
    private UserIdentifier userIdentifier;

    public RequestContext(AbstractApplicationBase clientApplication, PublicApi publicApi, IAcquireTokenParameters apiParameters) {
        this.clientApplication = clientApplication;
        this.clientId = StringHelper.isBlank(clientApplication.clientId()) ? "unset_client_id" : clientApplication.clientId();
        String string = this.correlationId = StringHelper.isBlank(clientApplication.correlationId()) ? RequestContext.generateNewCorrelationId() : clientApplication.correlationId();
        if (clientApplication instanceof AbstractClientApplicationBase) {
            this.applicationVersion = ((AbstractClientApplicationBase)clientApplication).applicationVersion();
            this.applicationName = ((AbstractClientApplicationBase)clientApplication).applicationName();
        }
        this.publicApi = publicApi;
        this.authority = clientApplication.authority();
        this.apiParameters = apiParameters;
    }

    public RequestContext(AbstractApplicationBase clientApplication, PublicApi publicApi, IAcquireTokenParameters apiParameters, UserIdentifier userIdentifier) {
        this(clientApplication, publicApi, apiParameters);
        this.userIdentifier = userIdentifier;
    }

    private static String generateNewCorrelationId() {
        return UUID.randomUUID().toString();
    }

    @Generated
    String telemetryRequestId() {
        return this.telemetryRequestId;
    }

    @Generated
    String clientId() {
        return this.clientId;
    }

    @Generated
    String correlationId() {
        return this.correlationId;
    }

    @Generated
    PublicApi publicApi() {
        return this.publicApi;
    }

    @Generated
    String applicationName() {
        return this.applicationName;
    }

    @Generated
    String applicationVersion() {
        return this.applicationVersion;
    }

    @Generated
    String authority() {
        return this.authority;
    }

    @Generated
    IAcquireTokenParameters apiParameters() {
        return this.apiParameters;
    }

    @Generated
    IApplicationBase clientApplication() {
        return this.clientApplication;
    }

    @Generated
    UserIdentifier userIdentifier() {
        return this.userIdentifier;
    }

    @Generated
    RequestContext telemetryRequestId(String telemetryRequestId) {
        this.telemetryRequestId = telemetryRequestId;
        return this;
    }
}

