/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.jarm;

import com.dataiku.dss.shadelibazure.com.nimbusds.jose.Algorithm;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.EncryptionMethod;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.JOSEException;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.JWEAlgorithm;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.JWSAlgorithm;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.jwk.JWKSet;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.jwk.source.ImmutableSecret;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.jwk.source.JWKSource;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.proc.BadJOSEException;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.proc.JWEDecryptionKeySelector;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.proc.JWEKeySelector;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.proc.JWSKeySelector;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.util.ResourceRetriever;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.EncryptedJWT;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.JWT;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.JWTParser;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.PlainJWT;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.SignedJWT;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.proc.BadJWTException;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.proc.ClockSkewAware;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.GeneralException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.auth.Secret;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.client.ClientInformation;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.ClientID;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.Issuer;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.jarm.JARMClaimsVerifier;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.validators.AbstractJWTValidator;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.ThreadSafe;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;

@ThreadSafe
public class JARMValidator
extends AbstractJWTValidator
implements ClockSkewAware {
    public JARMValidator(Issuer expectedIssuer, ClientID clientID, JWSAlgorithm expectedJWSAlg, JWKSet jwkSet) {
        this(expectedIssuer, clientID, new JWSVerificationKeySelector(expectedJWSAlg, new ImmutableJWKSet(jwkSet)), null);
    }

    public JARMValidator(Issuer expectedIssuer, ClientID clientID, JWSAlgorithm expectedJWSAlg, URL jwkSetURI) {
        this(expectedIssuer, clientID, expectedJWSAlg, jwkSetURI, null);
    }

    public JARMValidator(Issuer expectedIssuer, ClientID clientID, JWSAlgorithm expectedJWSAlg, URL jwkSetURI, ResourceRetriever resourceRetriever) {
        this(expectedIssuer, clientID, new JWSVerificationKeySelector(expectedJWSAlg, new RemoteJWKSet(jwkSetURI, resourceRetriever)), null);
    }

    public JARMValidator(Issuer expectedIssuer, ClientID clientID, JWSAlgorithm expectedJWSAlg, Secret clientSecret) {
        this(expectedIssuer, clientID, new JWSVerificationKeySelector(expectedJWSAlg, new ImmutableSecret(clientSecret.getValueBytes())), null);
    }

    public JARMValidator(Issuer expectedIssuer, ClientID clientID, JWSKeySelector jwsKeySelector, JWEKeySelector jweKeySelector) {
        super(expectedIssuer, clientID, jwsKeySelector, jweKeySelector);
    }

    public JWTClaimsSet validate(String jwtResponseString) throws BadJOSEException, JOSEException {
        try {
            return this.validate(JWTParser.parse(jwtResponseString));
        }
        catch (ParseException e) {
            throw new BadJOSEException("Invalid JWT: " + e.getMessage(), e);
        }
    }

    public JWTClaimsSet validate(JWT jwtResponse) throws BadJOSEException, JOSEException {
        if (jwtResponse instanceof SignedJWT) {
            return this.validate((SignedJWT)jwtResponse);
        }
        if (jwtResponse instanceof EncryptedJWT) {
            return this.validate((EncryptedJWT)jwtResponse);
        }
        if (jwtResponse instanceof PlainJWT) {
            throw new BadJWTException("The JWT must not be plain (unsecured)");
        }
        throw new BadJOSEException("Unexpected JWT type: " + jwtResponse.getClass());
    }

    private JWTClaimsSet validate(SignedJWT jwtResponse) throws BadJOSEException, JOSEException {
        if (this.getJWSKeySelector() == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWSKeySelector(this.getJWSKeySelector());
        jwtProcessor.setJWTClaimsSetVerifier(new JARMClaimsVerifier(this.getExpectedIssuer(), this.getClientID(), this.getMaxClockSkew()));
        return jwtProcessor.process(jwtResponse, null);
    }

    private JWTClaimsSet validate(EncryptedJWT jwtResponse) throws BadJOSEException, JOSEException {
        if (this.getJWEKeySelector() == null) {
            throw new BadJWTException("Decryption of JWTs not configured");
        }
        if (this.getJWSKeySelector() == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWSKeySelector(this.getJWSKeySelector());
        jwtProcessor.setJWEKeySelector(this.getJWEKeySelector());
        jwtProcessor.setJWTClaimsSetVerifier(new JARMClaimsVerifier(this.getExpectedIssuer(), this.getClientID(), this.getMaxClockSkew()));
        return jwtProcessor.process(jwtResponse, null);
    }

    protected static JWSKeySelector createJWSKeySelector(AuthorizationServerMetadata asMetadata, ClientInformation clientInfo) throws GeneralException {
        JWSAlgorithm expectedJWSAlg = clientInfo.getMetadata().getAuthorizationJWSAlg();
        if (asMetadata.getAuthorizationJWSAlgs() == null) {
            throw new GeneralException("Missing Authorization Server authorization_signing_alg_values_supported parameter");
        }
        if (!asMetadata.getAuthorizationJWSAlgs().contains(expectedJWSAlg)) {
            throw new GeneralException("The Authorization Server doesn't support " + expectedJWSAlg + " authorization responses");
        }
        if (Algorithm.NONE.equals(expectedJWSAlg)) {
            return null;
        }
        if (JWSAlgorithm.Family.RSA.contains(expectedJWSAlg) || JWSAlgorithm.Family.EC.contains(expectedJWSAlg)) {
            URL jwkSetURL;
            try {
                jwkSetURL = asMetadata.getJWKSetURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new GeneralException("Invalid jwk set URI: " + e.getMessage(), e);
            }
            RemoteJWKSet jwkSource = new RemoteJWKSet(jwkSetURL);
            return new JWSVerificationKeySelector(expectedJWSAlg, jwkSource);
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains(expectedJWSAlg)) {
            Secret clientSecret = clientInfo.getSecret();
            if (clientSecret == null) {
                throw new GeneralException("Missing client secret");
            }
            return new JWSVerificationKeySelector(expectedJWSAlg, new ImmutableSecret(clientSecret.getValueBytes()));
        }
        throw new GeneralException("Unsupported JWS algorithm: " + expectedJWSAlg);
    }

    protected static JWEKeySelector createJWEKeySelector(AuthorizationServerMetadata asMetadata, ClientInformation clientInfo, JWKSource clientJWKSource) throws GeneralException {
        JWEAlgorithm expectedJWEAlg = clientInfo.getMetadata().getAuthorizationJWEAlg();
        EncryptionMethod expectedJWEEnc = clientInfo.getMetadata().getAuthorizationJWEEnc();
        if (expectedJWEAlg == null) {
            return null;
        }
        if (expectedJWEEnc == null) {
            throw new GeneralException("Missing required authorization response JWE encryption method for " + expectedJWEAlg);
        }
        if (asMetadata.getAuthorizationJWEAlgs() == null || !asMetadata.getAuthorizationJWEAlgs().contains(expectedJWEAlg)) {
            throw new GeneralException("The Authorization Server doesn't support " + expectedJWEAlg + " authorization responses");
        }
        if (asMetadata.getAuthorizationJWEEncs() == null || !asMetadata.getAuthorizationJWEEncs().contains(expectedJWEEnc)) {
            throw new GeneralException("The Authorization Server doesn't support " + expectedJWEAlg + " / " + expectedJWEEnc + " authorization responses");
        }
        return new JWEDecryptionKeySelector(expectedJWEAlg, expectedJWEEnc, clientJWKSource);
    }

    public static JARMValidator create(AuthorizationServerMetadata asMetadata, ClientInformation clientInfo, JWKSource clientJWKSource) throws GeneralException {
        JWSKeySelector jwsKeySelector = JARMValidator.createJWSKeySelector(asMetadata, clientInfo);
        JWEKeySelector jweKeySelector = JARMValidator.createJWEKeySelector(asMetadata, clientInfo, clientJWKSource);
        return new JARMValidator(asMetadata.getIssuer(), clientInfo.getID(), jwsKeySelector, jweKeySelector);
    }

    public static JARMValidator create(AuthorizationServerMetadata asMetadata, ClientInformation clientInfo) throws GeneralException {
        return JARMValidator.create(asMetadata, clientInfo, null);
    }

    public static JARMValidator create(Issuer issuer, ClientInformation clientInfo) throws GeneralException, IOException {
        return JARMValidator.create(issuer, clientInfo, null, 0, 0);
    }

    public static JARMValidator create(Issuer issuer, ClientInformation clientInfo, JWKSource clientJWKSource, int connectTimeout, int readTimeout) throws GeneralException, IOException {
        AuthorizationServerMetadata asMetadata;
        try {
            asMetadata = OIDCProviderMetadata.resolve(issuer, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            asMetadata = AuthorizationServerMetadata.resolve(issuer, connectTimeout, readTimeout);
        }
        return JARMValidator.create(asMetadata, clientInfo, clientJWKSource);
    }
}

