/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.api;

import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.api.ResolveResponse;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.api.ResolveStatement;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;

@Immutable
public class ResolveSuccessResponse
extends ResolveResponse {
    private final ResolveStatement resolveStatement;

    public ResolveSuccessResponse(ResolveStatement resolveStatement) {
        if (resolveStatement == null) {
            throw new IllegalArgumentException("The resolve statement must not be null");
        }
        this.resolveStatement = resolveStatement;
    }

    public ResolveStatement getResolveStatement() {
        return this.resolveStatement;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setEntityContentType(ResolveStatement.CONTENT_TYPE);
        httpResponse.setContent(this.getResolveStatement().getSignedStatement().serialize());
        return httpResponse;
    }

    public static ResolveSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        httpResponse.ensureEntityContentType(ResolveStatement.CONTENT_TYPE);
        return new ResolveSuccessResponse(ResolveStatement.parse(httpResponse.getContent()));
    }
}

