/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.registration;

import com.dataiku.dss.shadelibazure.com.nimbusds.common.contenttype.ContentType;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.SignedJWT;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.AbstractRequest;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.SerializeException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.StringUtils;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;
import java.net.URI;

@Immutable
public class ExplicitClientRegistrationRequest
extends AbstractRequest {
    private final EntityStatement entityStatement;

    public ExplicitClientRegistrationRequest(URI uri, EntityStatement entityStatement) {
        super(uri);
        this.entityStatement = entityStatement;
    }

    public EntityStatement getEntityStatement() {
        return this.entityStatement;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        httpRequest.setEntityContentType(ContentType.APPLICATION_JOSE);
        httpRequest.setBody(this.getEntityStatement().getSignedStatement().serialize());
        return httpRequest;
    }

    public static ExplicitClientRegistrationRequest parse(HTTPRequest httpRequest) throws ParseException {
        SignedJWT signedJWT;
        URI uri = httpRequest.getURI();
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureEntityContentType(ContentType.APPLICATION_JOSE);
        String jwtString = httpRequest.getQuery();
        if (StringUtils.isBlank(jwtString)) {
            throw new ParseException("Missing entity body");
        }
        try {
            signedJWT = SignedJWT.parse(jwtString);
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Invalid entity statement: " + e.getMessage(), e);
        }
        return new ExplicitClientRegistrationRequest(uri, EntityStatement.parse(signedJWT));
    }
}

