/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Fuseable;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.SourceProducer;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.util.concurrent.Callable;

final class FluxCallable<T>
extends Flux<T>
implements Callable<T>,
Fuseable,
SourceProducer<T> {
    final Callable<T> callable;

    FluxCallable(Callable<T> callable) {
        this.callable = callable;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Operators.MonoSubscriber wrapper = new Operators.MonoSubscriber(actual);
        actual.onSubscribe(wrapper);
        try {
            T v = this.callable.call();
            if (v == null) {
                wrapper.onComplete();
            } else {
                wrapper.complete(v);
            }
        }
        catch (Throwable ex) {
            actual.onError(Operators.onOperatorError(ex, actual.currentContext()));
        }
    }

    @Override
    @Nullable
    public T call() throws Exception {
        return this.callable.call();
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

