/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBufAllocator;
import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBufInputStream;
import com.dataiku.dss.shadelibazure.io.netty.util.IllegalReferenceCountException;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Fuseable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoOperator;
import com.dataiku.dss.shadelibazure.reactor.netty.ByteBufFlux;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class ByteBufMono
extends MonoOperator<ByteBuf, ByteBuf> {
    public final Mono<ByteBuffer> asByteBuffer() {
        return this.handle((bb, sink2) -> {
            try {
                sink2.next(bb.nioBuffer());
            }
            catch (IllegalReferenceCountException e) {
                sink2.complete();
            }
        });
    }

    public final Mono<byte[]> asByteArray() {
        return this.handle((bb, sink2) -> {
            try {
                byte[] bytes = new byte[bb.readableBytes()];
                bb.readBytes(bytes);
                sink2.next(bytes);
            }
            catch (IllegalReferenceCountException e) {
                sink2.complete();
            }
        });
    }

    public final Mono<String> asString() {
        return this.asString(Charset.defaultCharset());
    }

    public final Mono<String> asString(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        return this.handle((bb, sink2) -> {
            try {
                sink2.next(bb.readCharSequence(bb.readableBytes(), charset).toString());
            }
            catch (IllegalReferenceCountException e) {
                sink2.complete();
            }
        });
    }

    public final Mono<InputStream> asInputStream() {
        return this.handle((bb, sink2) -> {
            try {
                sink2.next(new ReleasingInputStream((ByteBuf)bb));
            }
            catch (IllegalReferenceCountException e) {
                sink2.complete();
            }
        });
    }

    public static ByteBufMono fromString(Publisher<? extends String> source2) {
        return ByteBufMono.fromString(source2, Charset.defaultCharset(), ByteBufAllocator.DEFAULT);
    }

    public static ByteBufMono fromString(Publisher<? extends String> source2, Charset charset, ByteBufAllocator allocator) {
        Objects.requireNonNull(allocator, "allocator");
        Objects.requireNonNull(charset, "charset");
        return ByteBufMono.maybeFuse(Mono.from(ReactorNetty.publisherOrScalarMap(source2, s -> {
            ByteBuf buffer = allocator.buffer();
            buffer.writeCharSequence((CharSequence)s, charset);
            return buffer;
        }, l -> {
            ByteBuf buffer = allocator.buffer();
            for (String s : l) {
                buffer.writeCharSequence(s, charset);
            }
            return buffer;
        })));
    }

    public final ByteBufMono retain() {
        return ByteBufMono.maybeFuse(this.doOnNext(ByteBuf::retain));
    }

    @Override
    public void subscribe(CoreSubscriber<? super ByteBuf> actual) {
        this.source.subscribe(actual);
    }

    ByteBufMono(Mono<?> source2) {
        super(source2.map(ByteBufFlux.bytebufExtractor));
    }

    static ByteBufMono maybeFuse(Mono<?> source2) {
        if (source2 instanceof Fuseable) {
            return new ByteBufMonoFuseable(source2);
        }
        return new ByteBufMono(source2);
    }

    static final class ReleasingInputStream
    extends ByteBufInputStream {
        final ByteBuf bb;
        volatile int closed;
        static final AtomicIntegerFieldUpdater<ReleasingInputStream> CLOSE = AtomicIntegerFieldUpdater.newUpdater(ReleasingInputStream.class, "closed");

        ReleasingInputStream(ByteBuf bb) {
            super(bb.retain());
            this.bb = bb;
        }

        @Override
        public void close() throws IOException {
            if (CLOSE.compareAndSet(this, 0, 1)) {
                try {
                    super.close();
                }
                finally {
                    this.bb.release();
                }
            }
        }
    }

    static final class ByteBufMonoFuseable
    extends ByteBufMono
    implements Fuseable {
        ByteBufMonoFuseable(Mono<?> source2) {
            super(source2);
        }
    }
}

