/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.contextpropagation;

import com.dataiku.dss.shadelibazure.io.micrometer.context.ContextAccessor;
import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import com.dataiku.dss.shadelibazure.reactor.util.context.ContextView;
import java.util.Map;
import java.util.function.Predicate;

public final class ChannelContextAccessor
implements ContextAccessor<Channel, Channel> {
    public Class<? extends Channel> readableType() {
        return Channel.class;
    }

    public void readValues(Channel sourceContext, Predicate<Object> keyPredicate, Map<Object, Object> readValues) {
        ContextView contextView = ReactorNetty.getChannelContext(sourceContext);
        if (contextView != null) {
            contextView.forEach((k, v) -> {
                if (keyPredicate.test(k)) {
                    readValues.put(k, v);
                }
            });
        }
    }

    @Nullable
    public <T> T readValue(Channel sourceContext, Object key) {
        ContextView contextView = ReactorNetty.getChannelContext(sourceContext);
        if (contextView != null) {
            return contextView.getOrDefault(key, null);
        }
        return null;
    }

    public Class<? extends Channel> writeableType() {
        return Channel.class;
    }

    public Channel writeValues(Map<Object, Object> valuesToWrite, Channel targetContext) {
        if (!valuesToWrite.isEmpty()) {
            ContextView contextView = ReactorNetty.getChannelContext(targetContext);
            ReactorNetty.setChannelContext(targetContext, contextView != null ? Context.of(contextView).putAllMap(valuesToWrite) : Context.of(valuesToWrite));
        }
        return targetContext;
    }
}

