/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPipeline;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpServerCodec;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpServerUpgradeHandler;
import com.dataiku.dss.shadelibazure.io.netty.handler.timeout.IdleState;
import com.dataiku.dss.shadelibazure.io.netty.handler.timeout.IdleStateEvent;
import com.dataiku.dss.shadelibazure.io.netty.handler.timeout.IdleStateHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerOperations;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

final class IdleTimeoutHandler
extends IdleStateHandler {
    IdleTimeoutHandler(long idleTimeout) {
        super(idleTimeout, 0L, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) {
        if (evt.state() == IdleState.READER_IDLE) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Connection was idle for [{}ms], as per configuration the connection will be closed."), this.getReaderIdleTimeInMillis());
            }
            ctx.close();
        }
        ctx.fireUserEventTriggered(evt);
    }

    static void addIdleTimeoutHandler(ChannelPipeline pipeline, @Nullable Duration idleTimeout) {
        if (idleTimeout != null && pipeline.get("com.dataiku.dss.shadelibazure.reactor.left.idleTimeoutHandler") == null) {
            String baseName = null;
            if (pipeline.get("com.dataiku.dss.shadelibazure.reactor.left.httpCodec") != null) {
                baseName = "com.dataiku.dss.shadelibazure.reactor.left.httpCodec";
            } else {
                HttpServerUpgradeHandler httpServerUpgradeHandler = pipeline.get(HttpServerUpgradeHandler.class);
                if (httpServerUpgradeHandler != null) {
                    baseName = pipeline.context(httpServerUpgradeHandler).name();
                } else {
                    HttpServerCodec httpServerCodec = pipeline.get(HttpServerCodec.class);
                    if (httpServerCodec != null) {
                        baseName = pipeline.context(httpServerCodec).name();
                    }
                }
            }
            pipeline.addAfter(baseName, "com.dataiku.dss.shadelibazure.reactor.left.idleTimeoutHandler", new IdleTimeoutHandler(idleTimeout.toMillis()));
        }
    }

    static void removeIdleTimeoutHandler(ChannelPipeline pipeline) {
        if (pipeline.get("com.dataiku.dss.shadelibazure.reactor.left.idleTimeoutHandler") != null) {
            pipeline.remove("com.dataiku.dss.shadelibazure.reactor.left.idleTimeoutHandler");
        }
    }
}

