/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.resources;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInitializer;
import com.dataiku.dss.shadelibazure.io.netty.channel.unix.DomainSocketAddress;
import com.dataiku.dss.shadelibazure.io.netty.resolver.AddressResolverGroup;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoSink;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.netty.ChannelBindException;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.AddressUtils;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConnector;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Supplier;

final class NewConnectionProvider
implements ConnectionProvider {
    static final Logger log = Loggers.getLogger(NewConnectionProvider.class);
    static final NewConnectionProvider INSTANCE = new NewConnectionProvider();

    NewConnectionProvider() {
    }

    @Override
    public Mono<? extends Connection> acquire(TransportConfig config, ConnectionObserver observer, @Nullable Supplier<? extends SocketAddress> remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        return Mono.create((MonoSink<T> sink2) -> {
            SocketAddress remote = null;
            if (remoteAddress != null) {
                remote = Objects.requireNonNull((SocketAddress)remoteAddress.get(), "Remote Address supplier returned null");
            }
            NewConnectionObserver connectionObserver = new NewConnectionObserver((MonoSink<Connection>)sink2, observer);
            DisposableConnect disposableConnect = new DisposableConnect((MonoSink<Connection>)sink2, config.bindAddress());
            if (remote != null && resolverGroup != null) {
                ChannelInitializer<Channel> channelInitializer = config.channelInitializer(connectionObserver, remote, false);
                TransportConnector.connect(config, remote, resolverGroup, channelInitializer, sink2.contextView()).subscribe(disposableConnect);
            } else {
                InetSocketAddress localInet;
                Objects.requireNonNull(config.bindAddress(), "bindAddress");
                SocketAddress local = Objects.requireNonNull(config.bindAddress().get(), "Bind Address supplier returned null");
                if (local instanceof InetSocketAddress && (localInet = (InetSocketAddress)local).isUnresolved()) {
                    local = AddressUtils.createResolved(localInet.getHostName(), localInet.getPort());
                }
                ChannelInitializer<Channel> channelInitializer = config.channelInitializer(connectionObserver, null, true);
                TransportConnector.bind(config, channelInitializer, local, local instanceof DomainSocketAddress).subscribe(disposableConnect);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public int maxConnections() {
        return 1;
    }

    static final class NewConnectionObserver
    implements ConnectionObserver {
        final MonoSink<Connection> sink;
        final Context currentContext;
        final ConnectionObserver obs;

        NewConnectionObserver(MonoSink<Connection> sink2, ConnectionObserver obs) {
            this.sink = sink2;
            this.currentContext = Context.of(sink2.contextView());
            this.obs = obs;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(connection.channel(), "onStateChange({}, {})"), newState, connection);
            }
            if (newState == ConnectionObserver.State.CONFIGURED) {
                this.sink.success(connection);
            } else if (newState == ConnectionObserver.State.DISCONNECTING && connection.channel().isActive()) {
                connection.channel().close();
            }
            this.obs.onStateChange(connection, newState);
        }

        @Override
        public void onUncaughtException(Connection c, Throwable error) {
            this.sink.error(error);
            this.obs.onUncaughtException(c, error);
        }
    }

    static final class DisposableConnect
    implements CoreSubscriber<Channel>,
    Disposable {
        final MonoSink<Connection> sink;
        final Context currentContext;
        final Supplier<? extends SocketAddress> bindAddress;
        Subscription subscription;

        DisposableConnect(MonoSink<Connection> sink2, @Nullable Supplier<? extends SocketAddress> bindAddress) {
            this.sink = sink2;
            this.currentContext = Context.of(sink2.contextView());
            this.bindAddress = bindAddress;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void dispose() {
            this.subscription.cancel();
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable t) {
            if (this.bindAddress != null && (t instanceof BindException || t instanceof IOException && t.getMessage() != null && t.getMessage().contains("bind(..)"))) {
                this.sink.error(ChannelBindException.fail(this.bindAddress.get(), null));
            } else {
                this.sink.error(t);
            }
        }

        @Override
        public void onNext(Channel channel) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Connected new channel"));
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.subscription, s)) {
                this.subscription = s;
                this.sink.onCancel(this);
                s.request(Long.MAX_VALUE);
            }
        }
    }
}

