/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.transport;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFactory;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFuture;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInitializer;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.channel.DefaultChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoop;
import com.dataiku.dss.shadelibazure.io.netty.channel.unix.DomainSocketAddress;
import com.dataiku.dss.shadelibazure.io.netty.resolver.AddressResolver;
import com.dataiku.dss.shadelibazure.io.netty.resolver.AddressResolverGroup;
import com.dataiku.dss.shadelibazure.io.netty.util.AttributeKey;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.GenericFutureListener;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.ClientTransportConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.ServerTransport;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConfig;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import com.dataiku.dss.shadelibazure.reactor.util.context.ContextView;
import com.dataiku.dss.shadelibazure.reactor.util.retry.Retry;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class TransportConnector {
    static final Logger log = Loggers.getLogger(TransportConnector.class);
    static final Predicate<Throwable> RETRY_PREDICATE = t -> t instanceof RetryConnectException;

    TransportConnector() {
    }

    public static Mono<Channel> bind(TransportConfig config, ChannelInitializer<Channel> channelInitializer, SocketAddress bindAddress, boolean isDomainSocket) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(bindAddress, "bindAddress");
        Objects.requireNonNull(channelInitializer, "channelInitializer");
        return TransportConnector.doInitAndRegister(config, channelInitializer, isDomainSocket, config.eventLoopGroup().next()).flatMap(channel -> {
            MonoChannelPromise promise = new MonoChannelPromise((Channel)channel);
            channel.eventLoop().execute(() -> channel.bind(bindAddress, promise.unvoid()));
            return promise;
        });
    }

    public static Mono<Channel> connect(TransportConfig config, SocketAddress remoteAddress, AddressResolverGroup<?> resolverGroup, ChannelInitializer<Channel> channelInitializer) {
        return TransportConnector.connect(config, remoteAddress, resolverGroup, channelInitializer, config.eventLoopGroup().next(), Context.empty());
    }

    public static Mono<Channel> connect(TransportConfig config, SocketAddress remoteAddress, AddressResolverGroup<?> resolverGroup, ChannelInitializer<Channel> channelInitializer, ContextView contextView) {
        return TransportConnector.connect(config, remoteAddress, resolverGroup, channelInitializer, config.eventLoopGroup().next(), contextView);
    }

    public static Mono<Channel> connect(TransportConfig config, SocketAddress remoteAddress, AddressResolverGroup<?> resolverGroup, ChannelInitializer<Channel> channelInitializer, EventLoop eventLoop) {
        return TransportConnector.connect(config, remoteAddress, resolverGroup, channelInitializer, eventLoop, Context.empty());
    }

    public static Mono<Channel> connect(TransportConfig config, SocketAddress remoteAddress, AddressResolverGroup<?> resolverGroup, ChannelInitializer<Channel> channelInitializer, EventLoop eventLoop, ContextView contextView) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        Objects.requireNonNull(resolverGroup, "resolverGroup");
        Objects.requireNonNull(channelInitializer, "channelInitializer");
        Objects.requireNonNull(eventLoop, "eventLoop");
        Objects.requireNonNull(contextView, "contextView");
        boolean isDomainAddress = remoteAddress instanceof DomainSocketAddress;
        return TransportConnector.doInitAndRegister(config, channelInitializer, isDomainAddress, eventLoop).flatMap(channel -> TransportConnector.doResolveAndConnect(channel, config, remoteAddress, resolverGroup, contextView).onErrorResume(RetryConnectException.class, t -> {
            AtomicInteger index = new AtomicInteger(1);
            return Mono.defer(() -> TransportConnector.doInitAndRegister(config, channelInitializer, isDomainAddress, eventLoop).flatMap(ch -> {
                MonoChannelPromise mono = new MonoChannelPromise((Channel)ch);
                TransportConnector.doConnect(t.addresses, config.bindAddress(), mono, index.get());
                return mono;
            })).retryWhen(Retry.max(t.addresses.size() - 1).filter(RETRY_PREDICATE).doBeforeRetry(sig -> index.incrementAndGet()));
        }));
    }

    static void setAttributes(Channel channel, Map<AttributeKey<?>, ?> attrs) {
        for (Map.Entry<AttributeKey<?>, ?> e : attrs.entrySet()) {
            channel.attr(e.getKey()).set(e.getValue());
        }
    }

    static void setChannelOptions(Channel channel, Map<ChannelOption<?>, ?> options, boolean isDomainSocket) {
        for (Map.Entry<ChannelOption<?>, ?> e : options.entrySet()) {
            if (isDomainSocket && (ChannelOption.SO_REUSEADDR.equals(e.getKey()) || ChannelOption.TCP_NODELAY.equals(e.getKey()))) continue;
            try {
                if (channel.config().setOption(e.getKey(), e.getValue()) || !log.isWarnEnabled()) continue;
                log.warn(ReactorNetty.format(channel, "Unknown channel option '{}' for channel '{}'"), e.getKey(), channel);
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) continue;
                log.warn(ReactorNetty.format(channel, "Failed to set channel option '{}' with value '{}' for channel '{}'"), e.getKey(), e.getValue(), channel, t);
            }
        }
    }

    static void doConnect(List<SocketAddress> addresses, @Nullable Supplier<? extends SocketAddress> bindAddress, MonoChannelPromise connectPromise, int index) {
        Channel channel = connectPromise.channel();
        channel.eventLoop().execute(() -> {
            ChannelFuture f;
            SocketAddress remoteAddress = (SocketAddress)addresses.get(index);
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Connecting to [" + remoteAddress + "]."));
            }
            if (bindAddress == null) {
                f = channel.connect(remoteAddress);
            } else {
                SocketAddress local = Objects.requireNonNull((SocketAddress)bindAddress.get(), "bindAddress");
                f = channel.connect(remoteAddress, local);
            }
            f.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    connectPromise.setSuccess();
                } else {
                    int next;
                    Throwable cause = future.cause();
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format(channel, "Connect attempt to [" + remoteAddress + "] failed."), cause);
                    }
                    if ((next = index + 1) < addresses.size()) {
                        connectPromise.setFailure(new RetryConnectException(addresses));
                    } else {
                        connectPromise.setFailure(cause);
                    }
                }
            }));
        });
    }

    static Mono<Channel> doInitAndRegister(TransportConfig config, ChannelInitializer<Channel> channelInitializer, boolean isDomainSocket, EventLoop eventLoop) {
        ChannelFactory<? extends Channel> channelFactory = config.connectionFactory(config.eventLoopGroup(), isDomainSocket);
        Channel channel = null;
        try {
            channel = channelFactory.newChannel();
            if (channelInitializer instanceof ServerTransport.AcceptorInitializer) {
                ((ServerTransport.AcceptorInitializer)channelInitializer).acceptor.enableAutoReadTask(channel);
            }
            channel.pipeline().addLast(channelInitializer);
            TransportConnector.setChannelOptions(channel, config.options, isDomainSocket);
            TransportConnector.setAttributes(channel, config.attrs);
        }
        catch (Throwable t) {
            if (channel != null) {
                channel.unsafe().closeForcibly();
            }
            return Mono.error(t);
        }
        MonoChannelPromise monoChannelPromise = new MonoChannelPromise(channel);
        channel.unsafe().register(eventLoop, monoChannelPromise);
        return monoChannelPromise;
    }

    static Mono<Channel> doResolveAndConnect(Channel channel, TransportConfig config, SocketAddress remoteAddress, AddressResolverGroup<?> resolverGroup, ContextView contextView) {
        try {
            AddressResolver<?> resolver;
            try {
                resolver = resolverGroup.getResolver(channel.eventLoop());
            }
            catch (Throwable t) {
                channel.close();
                return Mono.error(t);
            }
            if (!contextView.isEmpty()) {
                ReactorNetty.setChannelContext(channel, contextView);
            }
            Supplier<? extends SocketAddress> bindAddress = config.bindAddress();
            if (!resolver.isSupported(remoteAddress) || resolver.isResolved(remoteAddress)) {
                MonoChannelPromise monoChannelPromise = new MonoChannelPromise(channel);
                TransportConnector.doConnect(Collections.singletonList(remoteAddress), bindAddress, monoChannelPromise, 0);
                return monoChannelPromise;
            }
            if (config instanceof ClientTransportConfig) {
                ClientTransportConfig clientTransportConfig = (ClientTransportConfig)config;
                if (clientTransportConfig.doOnResolve != null) {
                    clientTransportConfig.doOnResolve.accept(Connection.from(channel));
                }
            }
            Future<List<?>> resolveFuture = resolver.resolveAll(remoteAddress);
            if (config instanceof ClientTransportConfig) {
                ClientTransportConfig clientTransportConfig = (ClientTransportConfig)config;
                if (clientTransportConfig.doOnResolveError != null) {
                    resolveFuture.addListener(future -> {
                        if (future.cause() != null) {
                            clientTransportConfig.doOnResolveError.accept(Connection.from(channel), future.cause());
                        }
                    });
                }
                if (clientTransportConfig.doAfterResolve != null) {
                    resolveFuture.addListener(future -> {
                        if (future.isSuccess()) {
                            clientTransportConfig.doAfterResolve.accept(Connection.from(channel), (SocketAddress)((List)future.getNow()).get(0));
                        }
                    });
                }
            }
            if (resolveFuture.isDone()) {
                Throwable cause = resolveFuture.cause();
                if (cause != null) {
                    channel.close();
                    return Mono.error(cause);
                }
                MonoChannelPromise monoChannelPromise = new MonoChannelPromise(channel);
                TransportConnector.doConnect(resolveFuture.getNow(), bindAddress, monoChannelPromise, 0);
                return monoChannelPromise;
            }
            MonoChannelPromise monoChannelPromise = new MonoChannelPromise(channel);
            resolveFuture.addListener(future -> {
                if (future.cause() != null) {
                    monoChannelPromise.tryFailure(future.cause());
                } else {
                    TransportConnector.doConnect((List)future.getNow(), bindAddress, monoChannelPromise, 0);
                }
            });
            return monoChannelPromise;
        }
        catch (Throwable t) {
            return Mono.error(t);
        }
    }

    static final class RetryConnectException
    extends RuntimeException {
        final List<SocketAddress> addresses;
        private static final long serialVersionUID = -207274323623692199L;

        RetryConnectException(List<SocketAddress> addresses) {
            this.addresses = addresses;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class MonoChannelPromise
    extends Mono<Channel>
    implements ChannelPromise,
    Subscription {
        final Channel channel;
        CoreSubscriber<? super Channel> actual;
        static final Object SUCCESS = new Object();
        static final AtomicReferenceFieldUpdater<MonoChannelPromise, Object> RESULT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(MonoChannelPromise.class, Object.class, "result");
        volatile Object result;

        MonoChannelPromise(Channel channel) {
            this.channel = channel;
        }

        @Override
        public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise await() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean await(long timeoutMillis) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean await(long timeout2, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise awaitUninterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean awaitUninterruptibly(long timeoutMillis) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean awaitUninterruptibly(long timeout2, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void cancel() {
            this.channel.close();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public Throwable cause() {
            Object result = this.result;
            return result == SUCCESS ? null : (Throwable)result;
        }

        @Override
        public Channel channel() {
            return this.channel;
        }

        @Override
        public Void get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Void get(long timeout2, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Void getNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCancellable() {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            Object result = this.result;
            return result != null;
        }

        @Override
        public boolean isSuccess() {
            Object result = this.result;
            return result == SUCCESS;
        }

        @Override
        public boolean isVoid() {
            return false;
        }

        @Override
        public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            return this;
        }

        @Override
        public ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            return this;
        }

        @Override
        public void request(long n) {
        }

        @Override
        public ChannelPromise setFailure(Throwable cause) {
            this.tryFailure(cause);
            return this;
        }

        @Override
        public ChannelPromise setSuccess() {
            this.trySuccess(null);
            return this;
        }

        @Override
        public ChannelPromise setSuccess(Void result) {
            this.trySuccess(null);
            return this;
        }

        @Override
        public boolean setUncancellable() {
            return true;
        }

        @Override
        public void subscribe(CoreSubscriber<? super Channel> actual) {
            EventLoop eventLoop = this.channel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this._subscribe(actual);
            } else {
                eventLoop.execute(() -> this._subscribe(actual));
            }
        }

        @Override
        public ChannelPromise sync() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise syncUninterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryFailure(Throwable cause) {
            if (RESULT_UPDATER.compareAndSet(this, null, cause)) {
                if (this.channel.isRegistered()) {
                    this.channel.close();
                } else {
                    this.channel.unsafe().closeForcibly();
                }
                if (this.actual != null) {
                    this.actual.onError(cause);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean trySuccess() {
            return this.trySuccess(null);
        }

        @Override
        public boolean trySuccess(Void result) {
            if (RESULT_UPDATER.compareAndSet(this, null, SUCCESS)) {
                if (this.actual != null) {
                    this.actual.onNext(this.channel);
                    this.actual.onComplete();
                }
                return true;
            }
            return false;
        }

        @Override
        public ChannelPromise unvoid() {
            return new DefaultChannelPromise(this.channel){

                @Override
                public ChannelPromise setSuccess(Void result) {
                    super.trySuccess(null);
                    this.trySuccess(null);
                    return this;
                }

                @Override
                public boolean trySuccess(Void result) {
                    super.trySuccess(null);
                    return this.trySuccess(null);
                }

                @Override
                public ChannelPromise setFailure(Throwable cause) {
                    super.tryFailure(cause);
                    this.tryFailure(cause);
                    return this;
                }

                @Override
                public boolean tryFailure(Throwable cause) {
                    super.tryFailure(cause);
                    return this.tryFailure(cause);
                }
            };
        }

        void _subscribe(CoreSubscriber<? super Channel> actual) {
            this.actual = actual;
            actual.onSubscribe(this);
            if (this.isDone()) {
                if (this.isSuccess()) {
                    actual.onNext(this.channel);
                    actual.onComplete();
                } else {
                    actual.onError(this.cause());
                }
            }
        }
    }
}

