/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.udp;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFactory;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.group.ChannelGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.DatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.InternetProtocolFamily;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.nio.NioDatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.unix.DomainDatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LogLevel;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LoggingHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.ChannelPipelineConfigurer;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.MicrometerChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.LoopResources;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.logging.AdvancedByteBufFormat;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpResources;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpServer;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class UdpServerConfig
extends TransportConfig {
    Consumer<? super UdpServerConfig> doOnBind;
    Consumer<? super Connection> doOnBound;
    Consumer<? super Connection> doOnUnbound;
    InternetProtocolFamily family;
    static final ChannelOperations.OnSetup DEFAULT_OPS = (ch, c, msg) -> new UdpOperations(ch, c);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(UdpServer.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());

    @Override
    public ChannelOperations.OnSetup channelOperationsProvider() {
        return DEFAULT_OPS;
    }

    @Nullable
    public final Consumer<? super UdpServerConfig> doOnBind() {
        return this.doOnBind;
    }

    @Nullable
    public final Consumer<? super Connection> doOnBound() {
        return this.doOnBound;
    }

    @Nullable
    public final Consumer<? super Connection> doOnUnbound() {
        return this.doOnUnbound;
    }

    @Nullable
    public final InternetProtocolFamily family() {
        return this.family;
    }

    UdpServerConfig(Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> bindAddress) {
        super(options, bindAddress);
    }

    UdpServerConfig(UdpServerConfig parent) {
        super(parent);
        this.doOnBind = parent.doOnBind;
        this.doOnBound = parent.doOnBound;
        this.doOnUnbound = parent.doOnUnbound;
        this.family = parent.family;
    }

    @Override
    protected Class<? extends Channel> channelType(boolean isDomainSocket) {
        return isDomainSocket ? DomainDatagramChannel.class : DatagramChannel.class;
    }

    @Override
    protected ChannelFactory<? extends Channel> connectionFactory(EventLoopGroup elg, boolean isDomainSocket) {
        if (this.isPreferNative()) {
            return super.connectionFactory(elg, isDomainSocket);
        }
        return () -> new NioDatagramChannel(this.family());
    }

    @Override
    protected ConnectionObserver defaultConnectionObserver() {
        if (this.channelGroup() == null && this.doOnBound() == null && this.doOnUnbound() == null) {
            return ConnectionObserver.emptyListener();
        }
        return new UdpServerDoOn(this.channelGroup(), this.doOnBound(), this.doOnUnbound());
    }

    @Override
    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    @Override
    protected LoopResources defaultLoopResources() {
        return UdpResources.get();
    }

    @Override
    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerUdpServerMetricsRecorder.INSTANCE;
    }

    @Override
    protected ChannelPipelineConfigurer defaultOnChannelInit() {
        return ChannelPipelineConfigurer.emptyConfigurer();
    }

    @Override
    protected EventLoopGroup eventLoopGroup() {
        return this.loopResources().onClient(this.isPreferNative());
    }

    static final class UdpServerDoOn
    implements ConnectionObserver {
        final ChannelGroup channelGroup;
        final Consumer<? super Connection> doOnBound;
        final Consumer<? super Connection> doOnUnbound;

        UdpServerDoOn(@Nullable ChannelGroup channelGroup, @Nullable Consumer<? super Connection> doOnBound, @Nullable Consumer<? super Connection> doOnUnbound) {
            this.channelGroup = channelGroup;
            this.doOnBound = doOnBound;
            this.doOnUnbound = doOnUnbound;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (this.channelGroup != null && newState == ConnectionObserver.State.CONNECTED) {
                this.channelGroup.add(connection.channel());
                return;
            }
            if (this.doOnBound != null && newState == ConnectionObserver.State.CONFIGURED) {
                this.doOnBound.accept(connection);
                return;
            }
            if (this.doOnUnbound != null && newState == ConnectionObserver.State.DISCONNECTING) {
                connection.onDispose(() -> this.doOnUnbound.accept(connection));
            }
        }
    }

    static final class MicrometerUdpServerMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerUdpServerMetricsRecorder INSTANCE = new MicrometerUdpServerMetricsRecorder();

        MicrometerUdpServerMetricsRecorder() {
            super("com.dataiku.dss.shadelibazure.reactor.netty.udp.server", "udp");
        }
    }
}

