(function() {
'use strict';

const app = angular.module('dataiku.fm', [
    /* Imported modules */
    'dataiku.services',
    'dataiku.logger',

    'dataiku.directives.bootstrap',
    'dataiku.directives.dip',
    'dataiku.directives.styling',
    'dataiku.directives.widgets',
    'dataiku.directives.forms',
    'dataiku.directives.scope',
    'dataiku.widgets.futures',
    'dataiku.widgets.integrations',
    'dataiku.widgets.tageditfield',

    /* Imported but modified */
    "dataiku.fm.dialogs",
    "dataiku.opals",
    "dataiku.common.pictures",

    /* FM specific common modules */
    'dataiku.fm.api',
    'dataiku.fm.forms',

    /* FM App itself */
    'dataiku.fm.base',
    'dataiku.fm.nav',
    'dataiku.fm.login',
    'dataiku.fm.loggedOut',
    'dataiku.fm.instances',
    'dataiku.fm.loadbalancers',
    'dataiku.fm.instancesettingstemplates',
    'dataiku.fm.users',
    'dataiku.fm.tenant',
    'dataiku.fm.virtualnetworks',
    'dataiku.fm.topbar',
    'dataiku.fm.blueprints',
    'dataiku.fm.licensing',
    'dataiku.fm.sso',
    'dataiku.fm.security',
    'dataiku.fm.maintenance',
    'dataiku.fm.accounts',

    /* 3rd party */
    'angular-blocks',
    'ngRoute',
    'ngSanitize',
    'ui.sortable',
    'ui.tree',
    'ui.router',
    'ui.codemirror',
    'ui.keypress',
    'infinite-scroll',
    'platypus.utils',
    'ui-rangeSlider',
    'LocalStorageModule',
    'monospaced.elastic',
    'checklist-model',
    '$strap',
    'pascalprecht.translate'

]);


app.factory('dssInterceptor', function($location, $q, $rootScope) {
    return {
        'requestError': function(response) {
            const status = response.status;
            if (status === 401) {
                /*Don't redirect to login on failed login :D */
                if (response.config.url.indexOf("/api/login") >= 0) {
                    return $q.reject(response);
                }
                // It's not possible to inject $state here because of
                // Uncaught Error: Circular dependency: $templateFactory <- $state <- $http <- $compile
                // So we can't transition and have to refresh ...
                if ($location.path() !== '/login/' && $location.path() !== '/login') {
                    $rootScope.$evalAsync('appConfig.loggedIn = false');
                    $location.url("/login/?redirectTo=" + $location.path());
                } else {
                    return $q.reject(response);
                }
            } else {
                return $q.reject(response);
            }
        }
    };
});

// FM is not really going to support translation, translate is only imported as DSS components are re-used in FM but only EN would be supported
app.factory('translate', function($translate, $interpolate, $sanitize) {
    return function(translateID, defaultValue, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy = null) {
        let result = $translate.instant(translateID, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy);
        if (result === translateID && defaultValue !== undefined) {
            // This special "…" character gets escaped by the $sanitized, so we remove it before sanitization.
            if (defaultValue && defaultValue.endsWith("…")) {
                return $sanitize($interpolate(defaultValue.slice(0, -1))(interpolateParams)) + "…";
            }
            return $sanitize($interpolate(defaultValue)(interpolateParams));
        }
        return result;
    }
});

app.config(function($stateProvider, $locationProvider, $translateProvider, $urlRouterProvider, $httpProvider, $qProvider) {

    $qProvider.errorOnUnhandledRejections(false);
    $locationProvider.html5Mode(true);

    $translateProvider.preferredLanguage('en');
    $translateProvider.keepContent(true);
    $translateProvider.useSanitizeValueStrategy('escapeParameters');

    /* ************************* Top level routes ************************ */

    $stateProvider.state('root', {
        url: '/',
        controller: 'RootRouteDispatchController'
    });

    $stateProvider.state('login', {
        url: '/login/?redirectTo',
        templateUrl: '/app/login/login.html',
        controller: 'LoginController',
        pageTitle: function() {
            return "Login";
        }
    });
     
    $urlRouterProvider.when('/login', '/login/'); 

    $stateProvider.state('logged-out', {
        url: '/logged-out',
        templateUrl: '/app/logged-out/logged-out.html',
        controller: 'LoggedOutController',
        pageTitle: function() {
            return "Logged-out";
        }
    });

    $stateProvider.state("blackhole", {
        url: "/blackhole/"
    });

    /* Tenant setup */

    $stateProvider.state('tenant', {
        url: '/tenant',
        abstract: true,
        template: '<div ui-view class="h100"></div>'
    });

    $stateProvider.state('tenant.view', {
        url: '/',
        templateUrl: '/app/tenant/tenant-view.html',
        controller: "TenantViewController"
    });

    $stateProvider.state('tenant.edit', {
        url: '/edit',
        templateUrl: '/app/tenant/tenant-edit.html',
        controller: "TenantEditController"
    });

    /* Accounts */

    $stateProvider.state('accounts', {
        url: '/accounts',
        abstract: true,
        template: '<div ui-view class="h100"></div>'
    });

    $stateProvider.state('accounts.list', {
        url: '/',
        templateUrl: 'app/accounts/accounts-list.html',
        controller: "AccountsListController"
    });

    $stateProvider.state('accounts.edit', {
        url: '/:accountId',
        templateUrl: 'app/accounts/accounts-edit.html',
        controller: "AccountEditController"
    });


    /* Virtual networks */

    $stateProvider.state('virtualnetworks', {
        url: '/virtual-networks',
        abstract: true,
        template: '<div ui-view class="h100"></div>'
    });

    $stateProvider.state('virtualnetworks.list', {
        url: '/',
        templateUrl: '/app/virtual-networks/virtualnetwork-list.html',
        controller: 'VirtualNetworksListController'
    });

    $stateProvider.state('virtualnetworks.create', {
        url: '/new',
        templateUrl: '/app/virtual-networks/virtualnetwork-create.html',
        controller: 'VirtualNetworkCreationController'
    });

    $stateProvider.state('virtualnetworks.virtualnetwork', {
        url: '/:virtualNetworkId',
        abstract: true,
        templateUrl: '/app/virtual-networks/virtualnetwork-page.html',
        controller: "VirtualNetworkBaseController"
    });

    $stateProvider.state('virtualnetworks.virtualnetwork.dashboard', {
        url: '/dashboard',
        templateUrl: '/app/virtual-networks/virtualnetwork-dashboard.html',
        controller: "VirtualNetworkDashboardController"
    });

    $stateProvider.state('virtualnetworks.virtualnetwork.settings', {
        url: '/settings',
        templateUrl: '/app/virtual-networks/virtualnetwork-settings.html',
        controller: "VirtualNetworkSettingsController"
    });


    /* Instances */

    $stateProvider.state('instances', {
        url: '/instances',
        abstract: true,
        template: '<div ui-view class="h100"></div>',
        controller: 'InstancesBaseController'
    });

    $stateProvider.state('instances.list', {
        url: '/',
        templateUrl: '/app/instances/instance-list.html',
        controller: 'InstancesListController'
    });

    $stateProvider.state('instances.create', {
        url: '/new',
        templateUrl: '/app/instances/instance-create.html',
        controller: 'InstanceCreationController'
    });

    $stateProvider.state('instances.instance', {
        url: '/:instanceId',
        abstract: true,
        params: {
            startReprovision: null
        },
        templateUrl: '/app/instances/instance-page.html',
        controller: "InstanceController"
    });

    $stateProvider.state('instances.instance.dashboard', {
        url: '/dashboard',
        templateUrl: '/app/instances/instance-dashboard.html',
        controller: "InstanceDashboardController"
    });

    $stateProvider.state('instances.instance.settings', {
        url: '/settings',
        templateUrl: '/app/instances/instance-settings.html',
        controller: "InstanceSettingsController"
    });

    $stateProvider.state('instances.instance.snapshots', {
        url: '/snapshots',
        templateUrl: '/app/instances/instance-snapshots.html',
        controller: "InstanceSnapshotsController"
    });

    $stateProvider.state('instances.instance.eventslog', {
        url: '/events',
        templateUrl: '/app/instances/instance-events-log.html',
        controller: "InstanceEventsLogController"
    });

    /* Load balancers */

    $stateProvider.state('loadbalancers', {
        url: '/load-balancers',
        abstract: true,
        template: '<div ui-view class="h100"></div>',
        controller: 'LoadBalancersBaseController'
    });

    $stateProvider.state('loadbalancers.list', {
        url: '/',
        templateUrl: 'app/load-balancers/load-balancers-list.html',
        controller: 'LoadBalancersListController'
    });

    $stateProvider.state('loadbalancers.create', {
        url: '/new',
        templateUrl: 'app/load-balancers/load-balancers-create.html',
        controller: 'LoadBalancersCreationController'
    });

    $stateProvider.state('loadbalancers.loadbalancer', {
        url: '/:loadBalancerId',
        abstract: true,
        params: {
            startReprovision: null
        },
        templateUrl: 'app/load-balancers/load-balancers-page.html',
        controller: "LoadBalancersController"
    });

    $stateProvider.state('loadbalancers.loadbalancer.dashboard', {
        url: '/dashboard',
        templateUrl: 'app/load-balancers/load-balancers-dashboard.html',
        controller: "LoadBalancersDashboardController"
    });

    $stateProvider.state('loadbalancers.loadbalancer.settings', {
        url: '/settings',
        templateUrl: 'app/load-balancers/load-balancers-settings.html',
        controller: "LoadBalancersSettingsController"
    });

    /* Instance Templates */

    $stateProvider.state('instancetemplates', {
        url: '/instance-templates',
        abstract: true,
        template: '<div ui-view class="h100"></div>'
    });

    $stateProvider.state('instancetemplates.list', {
        url: '/',
        templateUrl: '/app/instance-templates/instance-template-list.html',
        controller: 'InstanceTemplateListController'
    });

    $stateProvider.state('instancetemplates.edit', {
        url: '/:instanceSettingsTemplateId',
        templateUrl: '/app/instance-templates/instance-template-edit.html',
        controller: "InstanceTemplateEditController"
    });

    $stateProvider.state('instancetemplates.copy', {
        url: '/:instanceSettingsTemplateId/:copyTarget',
        templateUrl: '/app/instance-templates/instance-template-edit.html',
        controller: "InstanceTemplateEditController"
    });

    /* Users */

    $stateProvider.state('users', {
        url: '/users',
        abstract: true,
        template: '<div ui-view class="h100"></div>'
    });

    $stateProvider.state('users.list', {
        url: '/',
        templateUrl: '/app/users/user-list.html',
        controller: 'UsersListController'
    });

    $stateProvider.state('users.create', {
        url: '/new',
        templateUrl: '/app/users/user-create.html',
        controller: 'UsersCreationController'
    });

    $stateProvider.state('users.edit', {
        url: '/edit/:emailAddress',
        templateUrl: '/app/users/user-edit.html',
        controller: "UsersEditController"
    });

    /* Blueprints */
    $stateProvider.state('blueprints', {
        url: '/blueprints',
        abstract: true,
        template: '<div ui-view class="h100"></div>'
    });

    $stateProvider.state('blueprints.welcome', {
        url: '/',
        templateUrl: '/app/blueprints/welcome.html',
    });

    $stateProvider.state('blueprints.deploy', {
        url: '/deploy/:blueprintType',
        templateUrl: '/app/blueprints/deploy.html',
        controller: 'BlueprintDeployController'
    })

    /* Licensing */
    $stateProvider.state('licensing', {
        url: '/licensing',
        abstract: true,
        template: '<div ui-view class="h100"></div>'
    });

    $stateProvider.state('licensing.welcome', {
        url: '/',
        templateUrl: '/app/licensing/welcome.html',
        controller: 'LicensingWelcomeController'
    });

    $stateProvider.state('licensing.sublicense', {
        url: '/sublicenses/:sublicenseId',
        abstract: true,
        templateUrl: '/app/licensing/sublicense-page.html',
        controller: "SublicenseBaseController"
    });


    $stateProvider.state('licensing.sublicense.summary', {
        url: '/summary',
        templateUrl: '/app/licensing/sublicense-summary.html',
    });

    $stateProvider.state('licensing.sublicense.settings', {
        url: '/settings',
        templateUrl: '/app/licensing/sublicense-settings.html',
    });

      $stateProvider.state('licensing.sublicenseCreate', {
        url: '/sublicenses/new',
        templateUrl: '/app/licensing/sublicense-create.html',
        controller: 'SublicenseCreationController'
    });


    /* Security */

    $stateProvider.state('security', {
        url: '/security',
        abstract: true,
        template: '<div ui-view class="h100"></div>'
    });
    $stateProvider.state('security.edit', {
        url: '/edit',
        templateUrl: '/app/security/security-edit.html',
        controller: "SecuritySettingsController"
    });

    /* SSO */

    $stateProvider.state('sso', {
        url: '/sso',
        abstract: true,
        template: '<div ui-view class="h100"></div>'
    });

    $stateProvider.state('sso.error', {
        url: '/error?error&errorDescription',
        templateUrl: '/app/sso/sso-error.html',
        controller: 'SSOErrorController',
        pageTitle: () => {
            return "SSO error";
        }
    });

    /* Maintenance */
    $stateProvider.state('maintenance', {
        url: '/maintenance',
        abstract: true,
        template: '<div ui-view class="h100"></div>'
    });

    $stateProvider.state('maintenance.diagnoses', {
        url: '/diagnoses',
        templateUrl: '/app/maintenance/diagnoses.html',
        controller: 'DiagnosesController'
    });


    // last but not the least : a route to catch everything that could not be routed

    $stateProvider.state("otherwise", {
        url: "*path",
        templateUrl: "templates/404.html",
        controller: function($scope, $stateParams) {
            $scope.$stateParams = $stateParams;
        }
    });

    $httpProvider.interceptors.push('dssInterceptor');
});

})();
