(function() {
    'use strict';

    const app = angular.module("dataiku.fm.blueprints", ["dataiku.services", "dataiku.filters", "dataiku.fm.dialogs"]);

    app.controller("BlueprintDeployController", function($scope, $rootScope, $stateParams, $state, FMAPI, Dialogs, FutureProgressModal, WT1) {

        FMAPI.blueprints.getNetworks().success(function(data) {
            $scope.creationData = data;
            $scope.creationData.virtualNetworksMap = {};
            data.virtualNetworks.forEach((vn) => {
                $scope.creationData.virtualNetworksMap[vn.id] = vn;
            });
        }).error(setErrorInScope.bind($scope));

        const NODES_PER_BLUEPRINT = {
            'MINIMAL_DESIGN': ['design'],
            'ELASTIC_DESIGN': ['design'],
            'ELASTIC_FLEET': ['design', 'automation', 'deployer'],
            'FULL_FEATURED': ['design', 'automation', 'deployer', 'admin']
        }

        $scope.$stateParams = $stateParams;
        //Scope is only sync with rootScope at the controller creation. Re-syncing it as license may have been updated
        $scope.appConfig = $rootScope.appConfig;

        $scope.newDeploy = {
            type: $stateParams.blueprintType,
            settings: {
                cloudTags: [],
                dnsStrategy: "NONE"
            }
        }
        $scope.dnsStrategies = [{id: "NONE", label: "Don't assign domain names (IP only)"}];
        if ($scope.appConfig.cloud === "AWS") {
            $scope.dnsStrategies.push({id: "VN_SPECIFIC_CLOUD_DNS_SERVICE", label: "Assign a Route53 domain name that you manage"});
            if ($scope.appConfig.tenancy === "MULTITENANT") {
                $scope.dnsStrategies.push({id: "FM_MANAGED_CLOUD_DNS_SERVICE", label: "Assign a Dataiku-managed domain name"});
            }
        } else if ($scope.appConfig.cloud === "AZURE") {
            $scope.dnsStrategies.push({id: "VN_SPECIFIC_CLOUD_DNS_SERVICE", label: "Assign a Azure DNS domain name that you manage"});
            if ($scope.appConfig.tenancy === "MULTITENANT") {
                $scope.dnsStrategies.push({id: "FM_MANAGED_CLOUD_DNS_SERVICE", label: "Assign a Dataiku-managed domain name"});
            }
        } else if ($scope.appConfig.cloud === "GCP") {
            $scope.dnsStrategies.push({id: "VN_SPECIFIC_CLOUD_DNS_SERVICE", label: "Assign a GCP DNS domain name that you manage"});
            if ($scope.appConfig.tenancy === "MULTITENANT") {
                $scope.dnsStrategies.push({id: "FM_MANAGED_CLOUD_DNS_SERVICE", label: "Assign a Dataiku-managed domain name"});
            }
        }

        $scope.deployBlueprint = function() {
            resetErrorInScope($scope);
            WT1.event("fm-blueprints-deploy", {
                blueprintType : $scope.newDeploy.type
            });
            if ($scope.newDeploy.settings.location === 'SAME_AS_FM') {
                $scope.newDeploy.settings.reuseVirtualNetwork = '';
            }
            FMAPI.blueprints.deploy($scope.newDeploy).success(function(response) {
                FutureProgressModal.show($scope, response, "Deploying your Fleet").then((res) => {
                    Dialogs.infoMessagesDisplayOnly($scope, "Deployment", res).then(function() {
                        Dialogs.ack($scope, "Fleet ready",
                                "Your fleet is ready for provisioning. You need to provision each DSS instance").then(()=>{
                            $state.go("instances.list");
                        });
                    });
                });
            }).error(setErrorInScope.bind($scope));
        }

        $scope.willDeploy = function(nodeType) {
            return (NODES_PER_BLUEPRINT[$stateParams.blueprintType] || []).includes(nodeType);
        }

    });
}());
