(function() {
    'use strict';

    const app = angular.module('dataiku.fm.security', []);

    app.controller('SecuritySettingsController', function($scope, $state, $location, FMAPI) {
        $scope.basicCodeMirrorSetting = function(lineWrapping, mode="text/xml") {
            return {
                mode: mode,
                lineNumbers: true,
                lineWrapping: lineWrapping,
                foldGutter: true,
                gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],
                autoCloseBrackets: false,
                autoCloseTags: false,
                matchBrackets: false,
                matchTags: false,
                highlightSelectionMatches: true,
                styleSelectedText: true,
                styleActiveLine: false
            }
        };
        FMAPI.security.getSettings().success(function(data) {
            $scope.securitySettings = data;
        }).error(setErrorInScope.bind($scope));

        $scope.save = function() {
            FMAPI.security.saveSettings($scope.securitySettings).success(function(data) {
                $scope.securitySettings = data;
                $scope.securitySettingsForm.$setPristine();
            }).error(setErrorInScope.bind($scope));
        };

        $scope.fetchOpenIDConfig = function(openIdWellKnown) {
            return FMAPI.sso.fetchOpenIDConfig(openIdWellKnown).success(function (config) {
                $scope.securitySettings.ssoSettings.openIDParams.issuer = config.issuer;
                $scope.securitySettings.ssoSettings.openIDParams.authorizationEndpoint = config.authorization_endpoint;
                $scope.securitySettings.ssoSettings.openIDParams.tokenEndpoint = config.token_endpoint;
                $scope.securitySettings.ssoSettings.openIDParams.jwksUri = config.jwks_uri;
            }).error(setErrorInScope.bind($scope));
        };

        $scope.computeWellKnowFromIssuer = function() {
            let issuer = $scope.securitySettings.ssoSettings.openIDParams.issuer;
            $scope.openIdWellKnown = issuer ?
                issuer + '/.well-known/openid-configuration' :
                "";
        }

        $scope.testLdapSettings = function() {
            $scope.ldapTesting = true;
            $scope.ldapTestResult = null;
            return FMAPI.security.testLdapSettings($scope.securitySettings.ldapSettings).success(function (data) {
                $scope.ldapTestResult = data;
            }).error(setErrorInScope.bind($scope)
            ).finally(
                $scope.ldapTesting = false
            );
        };

        $scope.testLdapGetUserDetails = function (userName) {
            $scope.ldapUserDetailsTesting = true;
            $scope.ldapTestUserDetails = null;
            FMAPI.security.testLdapGetUserDetails({
                settings:$scope.securitySettings.ldapSettings,
                username:userName
            }).success(function (data) {
                $scope.ldapTestUserDetails = data;
            }).error(
                setErrorInScope.bind($scope)
            ).finally(
                $scope.ldapUserDetailsTesting = false
            );
        };

        $scope.testAzureADSettings = function (login, email) {
            $scope.azureADTesting = true;
            $scope.azureADTestResult = null;
            FMAPI.security.testAzureADSettings(
            {
                "azureADSettings": $scope.securitySettings.azureADSettings,
                "userIdentity": {
                    "login": login || "",
                    "email": email || ""
                }
            }).success(function (data) {
                $scope.azureADTestResult = data;
                if ($scope.azureADTestResult.connectionOK) {
                    $scope.azureADTestResult.userAttributes = JSON.stringify($scope.azureADTestResult.userAttributes, null, 2);
                }
            }).error(setErrorInScope.bind($scope));
    
            $scope.azureADTesting = false;
        };
    });

}());