(function() {
    "use strict";

    function aiExplanationModalController(
        $scope,
        $rootScope,
        AI_EXPLANATION_MODAL_MODES,
        AIExplanationService
    ) {
        $scope.MODES = AI_EXPLANATION_MODAL_MODES;

        $scope.canCloseModal = function() {
            if (!$scope.explanationRequested) {
                return true;
            }
            if ($scope.lastJobId === null) {
                return false;
            }
            if (!$scope.abortRequested) {
                AIExplanationService.abortExplain($scope.lastJobId).catch(function(r) {
                    setErrorInScope.bind($rootScope)(r.data, r.status, r.headers);
                });
                $scope.abortRequested = true;
            }
            return true;
        };
    }

    angular.module("dataiku.aiExplanations")
        .controller("AIExplanationModalController", aiExplanationModalController);
})();
