(function() {
    'use strict';

    const myItemsContent = {
        templateUrl: 'static/dataiku/homepage/my-items-content/my-items-content.component.html',
        controller: function myItemsContentController(
            $scope,
            $state,
            homepageService,
            DataikuAPI,
            CatalogItemService
        ) {
            const $ctrl = this;
            $ctrl.$onInit = () => {
                $ctrl.myItems = [];
                $ctrl.displayedItems = {};
                $ctrl.orderedProjects = [];
                homepageService.registerMyItemsController($ctrl);
                homepageService.fetchMyItems();
                $ctrl.updateDisplayedItems();
                homepageService.broadcastRepaint();
            }

            $ctrl.updateDisplayedItems = () => {
                $ctrl.orderedProjects = [];
                $ctrl.displayedItems = {};
                if ($ctrl.myItems) {
                    for (const elt of $ctrl.myItems) {
                        if (elt.projectName && elt.projectKey) {
                            if (!($ctrl.orderedProjects.map(proj=>{return proj.key;}).includes(elt.projectKey))) {
                                $ctrl.orderedProjects.push(
                                    {"key": elt.projectKey,
                                    "name": elt.projectName,
                                    "link": $state.href('projects.project.home.regular',{projectKey : elt.projectKey})
                                    }
                                );
                            }
                            if (!(elt.projectKey in $ctrl.displayedItems)) {
                                $ctrl.displayedItems[elt.projectKey] = [elt];
                            } else {
                                $ctrl.displayedItems[elt.projectKey].push(elt);
                            }
                            elt.itemLink = CatalogItemService.getLink(elt.catalogItemType, elt);

                            elt.color = CatalogItemService.itemToColor(elt.catalogItemType, (elt.catalogItemType === 'saved_model' ? elt.data : elt) || {});
                            elt.icon = CatalogItemService.itemToIcon(elt.catalogItemType, (elt.catalogItemType === 'saved_model' ? elt.data : elt) || {}, false, 24);
                        }
                    }
                    if (Object.keys($ctrl.displayedItems).length > 0) {
                        $scope.$emit("standardizedSidePanelContentChanged");
                    }
                }
            };

            $ctrl.toggleStar = (item) => {
                const index = $ctrl.myItems.findIndex(elt => (elt.id === item.id) && (elt.type === item.type) && (elt.projectKey === item.projectKey));
                $ctrl.myItems[index].starred = !$ctrl.myItems[index].starred;
                DataikuAPI.interests.star([item], $ctrl.myItems[index].starred).error(setErrorInScope.bind($ctrl));
            }
        }
    }

    angular.module('dataiku.homepage').component('myItemsContent', myItemsContent);
})();
