(function() {
    'use strict';

    const app = angular.module('dataiku', [
        'angular-blocks',
        'dataiku.constants',
        'dataiku.credentials',
        'dataiku.controllers',
        'dataiku.constants',
        'dataiku.services',
        'dataiku.logger',
        'dataiku.charts',

        'dataiku.common.func',
        'dataiku.common.nav',
        'dataiku.common.build',
        'dataiku.common.datastructures',
        'dataiku.common.lists',
        'dataiku.common.pictures',
        'dataiku.common.sampling',

        'dataiku.shaker',
        'dataiku.shaker.analyse',
        'dataiku.shaker.table',
        'dataiku.shaker.misc',
        'dataiku.shaker.library',

        'dataiku.export.services',

        'dataiku.directives.bootstrap',
        'dataiku.directives.dip',
        'dataiku.directives.styling',
        'dataiku.directives.widgets',
        'dataiku.directives.forms',
        'dataiku.directives.snippetEditor',
        'dataiku.directives.scope',
        'dataiku.widgets.futures',
        'dataiku.widgets.integrations',
        'dataiku.widgets.drawers',
        'dataiku.widgets.tageditfield',

        'dataiku.filters',

        'dataiku.meanings',

        'dataiku.taggableobjects',

        'dataiku.notebooks.sql',
        'dataiku.notebooks.search',
        'dataiku.rstudioserverembed',

        'dataiku.llm',
        'dataiku.promptstudios',
        'dataiku.agents',
        'dataiku.agenttools',
        'dataiku.retrieval-augmented-llm',

        'dataiku.projects.settings',
        'dataiku.projects.actions',
        'dataiku.projects.directives',

        'dataiku.personal-home.directives',

        'dataiku.connections',

        'dataiku.datasets',
        'dataiku.datasets.custom',
        'dataiku.datasets.directives',
        'dataiku.datasets.foreign',
        'dataiku.datasets.partitioning',

        'dataiku.dashboards',
        'dataiku.dashboards.insights',

        'dataiku.webapps',
        'dataiku.report',

        'dataiku.admin.code-studios',
        'dataiku.code-studios',

        'dataiku.metrics.core',
        'dataiku.metrics.views',
        'dataiku.metrics.savedmodels.views',
        'dataiku.metrics.edit',

        'dataiku.flow.graph',
        'dataiku.flow.tools',
        'dataiku.flow.project',
        'dataiku.flow.runtime',

        'dataiku.recipes',
        'dataiku.recipes.customcode',
        'dataiku.directives.insights',
        'dataiku.directives.simple_report',
        'dataiku.filters',


        'dataiku.admin',
        'dataiku.admin.config',
        'dataiku.admin.codeenvs.common',
        'dataiku.admin.codeenvs.automation',
        'dataiku.admin.codeenvs.design',
        'dataiku.admin.security',
        'dataiku.admin.maintenance',
        'dataiku.admin.monitoring',
        'dataiku.admin.clusters',
        'dataiku.admin.alertMessageBanner',
        'dataiku.admin.globalApiKeyInput',
        'dataiku.admin.charts_dashboards',

        'dataiku.plugins',
        'dataiku.plugindev',
        'dataiku.folder_edit',
        'dataiku.catalog',
        'dataiku.deployer',
        'dataiku.apideployer',
        'dataiku.projectdeployer',

        'dataiku.unified-monitoring',

        /* ML (shared between analysis, saved model and insight) */
        'dataiku.ml.core',
        'dataiku.ml.predicted',
        'dataiku.ml.report',
        'dataiku.ml.explainability',
        'dataiku.ml.hyperparameters',
        'dataiku.ml.gpuexecution',

        'dataiku.analysis.core',
        'dataiku.analysis.script',
        'dataiku.analysis.mlcore',

        'dataiku.savedmodels',
        'dataiku.modelevaluationstores',
        'dataiku.modelcomparisons',
        'dataiku.experimenttracking',
        'dataiku.managedfolder',
        'dataiku.retrievableknowledge',

        'dataiku.labeling',

        /* Streaming endpoints */
        'dataiku.streaming-endpoints',

        'dataiku.scenarios',
        'dataiku.continuous-activities',
        'dataiku.monitoring',
        'dataiku.runnables',

        'dataiku.lambda',

        'dataiku.collab.timeline',
        'dataiku.collab.discussions',
        'dataiku.collab.wikis',
        'dataiku.git',

        'dataiku.bundles.common',
        'dataiku.bundles.design',
        'dataiku.bundles.automation',

        'dkuSanitize',

        'dataiku.integrations.alation',

        'dataiku.ngXmigration',

        'dataiku.featurestore',

        /* Consumer workspaces */
        'dataiku.workspaces',

        /* Designer new filters */
        'dataiku.nestedFilters',

        /* Designer surveys */
        'dataiku.surveys',

        /* Designer Opals */
        'dataiku.opals',

        /* Designer auto feature generation */
        'dataiku.autoFeatureGeneration',

        /* Homepage */
        'dataiku.homepage',

        /* Designer AI assistants */
        'dataiku.aiExplanations',
        'dataiku.aiSqlGeneration',
        'dataiku.aiDatasetDescriptions',

        /* Schedule Scenario Modal */
        'dataiku.scheduleScenario',

        /* Homepage */
        'dataiku.homepage',

        /* Add dataset Workflow */
        'dataiku.addDatasetWorkflow',

        /* Processors */
        'dataiku.processors',

        /* Designer inbox */
        'dataiku.inbox',

        /* Widgets */
        'dataiku.widgets',

        /* Coloring */
        'dataiku.coloring',

        'dataiku.shared',

        /* Search notebooks */
        'dataiku.searchNotebooks',

        /* 3rd party */
        'ngRoute',
        'ngSanitize',
        'ui.sortable',
        'ui.tree',
        'ui.router',
        'ui.codemirror',
        'ui.keypress',
        'infinite-scroll',
        'platypus.utils',
        'ui-rangeSlider',
        'colorContrast',
        'LocalStorageModule',
        'monospaced.elastic',
        'checklist-model',
    '$strap',
    'pascalprecht.translate'
    ]);


    app.factory('dssInterceptor', function($location, $q, $rootScope, $httpParamSerializer) {
        return {
            'requestError': function(response) {
                const status = response.status;
                if (status == 401) {
                    /*Don't redirect to login on failed login :D */
                    if (response.config.url.indexOf("/api/login") >= 0) {
                        return $q.reject(response);
                    }
                    // It's not possible to inject $state here because of
                    // Uncaught Error: Circular dependency: $templateFactory <- $state <- $http <- $compile
                    // So we can't transition and have to refresh ...
                    if ($location.path() !== '/login/' && $location.path() !== '/login') {
                        $rootScope.$evalAsync('appConfig.loggedIn = false');
                        $location.url("/login/?redirectTo=" + $location.path() + "&search=" + $httpParamSerializer($location.search()));
                    } else {
                        return $q.reject(response);
                    }
                } else {
                    return $q.reject(response);
                }
            }
        };
    });

    // Services cannot be injected into app.config, so create a variable instead
    const createMLRoutingService = () => {
        const clusteringDesignRoutes = [
            {route: "clustering-learning", templateUrl: "/templates/analysis/clustering/settings/learningtask.html"},
            {route: "clustering-debugging", templateUrl: "/templates/analysis/mlcommon/settings/debugging.html"},
            {route: "clustering-features", templateUrl: "/templates/analysis/mlcommon/settings/features.html"},
            {route: "clustering-reduction", templateUrl: "/templates/analysis/clustering/settings/reduction.html"},
            {route: "clustering-outliers", templateUrl: "/templates/analysis/clustering/settings/outliers.html"},
            {route: "clustering-algorithms", templateUrl: "/templates/analysis/mlcommon/settings/algorithms.html"},
            {route: "clustering-spark", templateUrl: "/templates/analysis/mlcommon/settings/spark.html"},
            {route: "clustering-runtime", templateUrl: "/templates/analysis/mlcommon/settings/python.html"}
        ];

        const causalDesignRoutes = [
            {route: "causal-learning", templateUrl: "/templates/analysis/prediction/causal/learningtask.html", controller: "CausalPMLTaskDesignController"},
            {route: "causal-debugging", templateUrl: "/templates/analysis/mlcommon/settings/debugging.html"},

            {route: "causal-features-handling", templateUrl: "/templates/analysis/mlcommon/settings/features.html"},
            {route: "causal-features-gen", templateUrl: "/templates/analysis/mlcommon/settings/features-generation.html"},

            {route: "causal-propensity", templateUrl: "/templates/analysis/prediction/causal/propensity.html"},
            {route: "causal-algorithms", templateUrl: "/templates/analysis/prediction/causal/algorithms.html"},
            {route: "causal-hyperparameters", templateUrl: "/templates/analysis/prediction/settings/hyperparameters.html"},

            {route: "causal-evaluation-metric", templateUrl: "/templates/analysis/prediction/settings/causal-evaluation-metric.html"},
            {route: "causal-evaluation-validation", templateUrl: "/templates/analysis/prediction/settings/evaluation-validation.html"},

            {route: "causal-features-select", templateUrl: "/templates/analysis/prediction/settings/features-selection.html"},
            {route: "causal-runtime", templateUrl: "/templates/analysis/mlcommon/settings/python.html"}
        ];

        const deephubDesignRoutes = [
            {route: "deephub-learning", templateUrl: "/templates/analysis/prediction/deephub/learningtask.html", controller: "DeepHubPMLTaskDesignController"},
            {route: "deephub-parameters", templateUrl: "/templates/analysis/prediction/deephub/parameters.html"},
            {route: "deephub-debugging", templateUrl: "/templates/analysis/mlcommon/settings/debugging.html"},
            {route: "deephub-image-augmentation", templateUrl: "/templates/analysis/prediction/deephub/image-augmentation.html"},
            {route: "deephub-evaluation-metric", templateUrl: "/templates/analysis/prediction/deephub/evaluation-metric.html"},
            {route: "deephub-evaluation-validation", templateUrl: "/templates/analysis/prediction/settings/evaluation-validation.html"},
            {route: "deephub-runtime", templateUrl: "/templates/analysis/mlcommon/settings/python.html"}
        ];

        const timeSeriesDesignRoutes = [
            {route: "timeseries-learning", templateUrl: "/templates/analysis/prediction/timeseries/learningtask.html", controller: "TimeseriesPMLTaskDesignController"},
            {route: "timeseries-evaluation-validation", templateUrl: "/templates/analysis/prediction/timeseries/evaluation-validation.html"},
            {route: "timeseries-evaluation-metric", templateUrl: "/templates/analysis/prediction/settings/evaluation-metric.html"},
            {route: "timeseries-debugging", templateUrl: "/templates/analysis/mlcommon/settings/debugging.html"},
            {route: "timeseries-external-features", templateUrl: "/templates/analysis/mlcommon/settings/features.html"},
            {route: "timeseries-algorithms", templateUrl: "/templates/analysis/mlcommon/settings/algorithms.html"},
            {route: "timeseries-hyperparameters", templateUrl: "/templates/analysis/prediction/settings/hyperparameters.html"},
            {route: "timeseries-runtime", templateUrl: "/templates/analysis/mlcommon/settings/python.html"}
        ];

        const classicalDesignRoutes = [
            {route: "classical-learning", templateUrl: "/templates/analysis/prediction/settings/learningtask.html", controller: "ClassicalPMLTaskDesignController"},
            {route: "classical-features-handling", templateUrl: "/templates/analysis/mlcommon/settings/features.html"},
            {route: "classical-features-gen", templateUrl: "/templates/analysis/mlcommon/settings/features-generation.html"},
            {route: "classical-keras-build", templateUrl: "/templates/analysis/prediction/settings/keras-build.html"},
            {route: "classical-keras-train", templateUrl: "/templates/analysis/prediction/settings/keras-train.html"},
            {route: "classical-algorithms", templateUrl: "/templates/analysis/mlcommon/settings/algorithms.html"},
            {route: "classical-hyperparameters", templateUrl: "/templates/analysis/prediction/settings/hyperparameters.html"},
            {route: "classical-evaluation-metric", templateUrl: "/templates/analysis/prediction/settings/evaluation-metric.html"},
            {route: "classical-evaluation-validation", templateUrl: "/templates/analysis/prediction/settings/evaluation-validation.html"},
            {route: "classical-debugging", templateUrl: "/templates/analysis/mlcommon/settings/debugging.html"},
            {route: "classical-features-select", templateUrl: "/templates/analysis/prediction/settings/features-selection.html"},
            {route: "classical-spark", templateUrl: "/templates/analysis/mlcommon/settings/spark.html"},
            {route: "classical-runtime", templateUrl: "/templates/analysis/mlcommon/settings/python.html"},
            {route: "classical-sample-weights", templateUrl: "/templates/analysis/mlcommon/settings/sample-weights.html"},
            {route: "classical-model-overrides", templateUrl: "/templates/analysis/mlcommon/settings/model-overrides.html"},
            {route: "classical-calibration", templateUrl: "/templates/analysis/mlcommon/settings/calibration.html"},
            {route: "classical-monotonic-constraints", templateUrl: "/templates/analysis/mlcommon/settings/monotonic-constraints.html"}
        ];

        const allResultsRoutes = [
            {route: "sessions", templateUrl: "/templates/analysis/models-list-view.html"},
            {route: "models", templateUrl: "/templates/analysis/models-snippets-view.html"},
            {route: "table", templateUrl: "/templates/analysis/models-table-view.html"}
        ];

        const clusteringReportRoutes = [
            {route: "summary", templateUrl: "/templates/ml/clustering-model/facts.html", tile: "summary"},
            {route: "feature_importance", templateUrl: "/templates/ml/clustering-model/feature_importance.html", tile: "feature_importance"},
            {route: "hierarchy", templateUrl: "/templates/ml/clustering-model/hierarchy.html", tile: "hierarchy"},
            {route: "anomalies", templateUrl: "/templates/ml/clustering-model/anomalies.html", tile: "anomalies"},
            {route: "heatmap", templateUrl: "/templates/ml/clustering-model/heatmap.html", tile: "heatmap"},
            {route: "cluster-profiling", templateUrl: "/templates/ml/clustering-model/cluster-profiling.html", tile: "cluster-profiling"},
            {route: "scatterplot-page", templateUrl: "/templates/ml/clustering-model/scatterplot-page.html", tile: "scatterplot-page"},
            {route: "detailed_metrics", templateUrl: "/templates/ml/clustering-model/detailed_metrics.html", tile: "detailed_metrics"},
            {route: "preparation", templateUrl: "/templates/ml/common/preparation.html", tile: "preparation"},
            {route: "features", templateUrl: "/templates/ml/common/features.html", tile: "features"},
            {route: "algorithm", templateUrl: "/templates/ml/clustering-model/algorithm.html", tile: "algorithm"},
            {route: "train", templateUrl: "/templates/ml/clustering-model/train.html", tile: "train"}
        ];

        const featureImportanceTileToRoute = function(tile) {
            const displayMode = (tile.tileParams.advancedOptions && tile.tileParams.advancedOptions.featureImportance || {}).importanceDisplayMode;
            return {
                route: "tabular-feature_importance", routeParams: { displayMode },
            };
        };
        const featureImportanceRouteToTile = function(pane, stateParams, tile) {
            const tileParams = { displayMode: tile };
            if (stateParams.displayMode) {
                tileParams.advancedOptions = { featureImportance: { importanceDisplayMode: stateParams.displayMode }}
            }
            return tileParams;
        };

        const tabularReportRoutes = [
            {route: "tabular-summary", templateUrl: "/templates/ml/prediction-model/summary.html", tile: "summary"},
            {route: "tabular-interactive_scoring", templateUrl: "/templates/ml/prediction-model/interactive_scoring.html", tile: "interactive_scoring"},

            {route: "tabular-ts_interactive-scoring-analysis", templateUrl: "/templates/ml/prediction-model/timeseries/ts_interactive-scoring-analysis.html", tile: "timeseries_interactive-scoring_analysis"},

            // report-summary-menu-items/interpretation.html
            {route: "tabular-tree_summary", templateUrl: "/templates/ml/prediction-model/tree_summary.html", tile: "tree_summary"},
            {route: "tabular-ensemble_summary", templateUrl: "/templates/ml/prediction-model/ensemble_summary.html", tile: "ensemble_summary"},
            {route: "tabular-feature_importance", templateUrl: "/templates/ml/prediction-model/feature-importance/feature_importance.html", tile: "feature_importance", routeOptions: {urlSuffix: "/:displayMode?", params: {displayMode: { squash: true, value: null }}}, tileToRoute: featureImportanceTileToRoute , routeToTile: featureImportanceRouteToTile },
            {route: "tabular-coefficients", templateUrl: "/templates/ml/prediction-model/coefficients.html", tile: "coefficients"},
            {route: "tabular-coef_path", templateUrl: "/templates/ml/prediction-model/coef_path.html", tile: null},
            {route: "tabular-pdp_plot", templateUrl: "/templates/ml/prediction-model/pdp_plot.html", tile: "pdp_plot"},
            {route: "tabular-subpopulation", templateUrl: "/templates/ml/prediction-model/subpopulation.html", tile: "subpopulation"},
            {route: "tabular-individual_explanations", templateUrl: "/templates/ml/prediction-model/individual_explanations.html", tile: "individual_explanations"},

            // report-summary-menu-itemsdrift_analysis.html
            {route: "tabular-input_data_drift", templateUrl: "/templates/ml/prediction-model/input_data_drift.html", tile: null},
            {route: "tabular-prediction_drift", templateUrl: "/templates/ml/prediction-model/prediction_drift.html", tile: null},
            {route: "tabular-performance_drift", templateUrl: "/templates/ml/prediction-model/performance_drift.html", tile: null},

            // report-summary-menu-items/model_information.html
            {route: "tabular-preparation", templateUrl: "/templates/ml/common/preparation.html", tile: "preparation"},
            {route: "tabular-resampling", templateUrl: "/templates/ml/prediction-model/resampling.html", tile: "resampling"},
            {route: "tabular-features", templateUrl: "/templates/ml/common/features.html", tile: "features"},
            {route: "tabular-algorithm", templateUrl: "/templates/ml/prediction-model/algorithm.html", tile: "algorithm"},
            {route: "tabular-grid_search", templateUrl: "/templates/ml/prediction-model/grid_search.html", tile: "grid_search"},
            {route: "tabular-overrides_metrics", templateUrl: "/templates/ml/prediction-model/overrides/metrics.html", tile: "overrides_metrics"},
            {route: "tabular-train", templateUrl: "/templates/ml/prediction-model/train.html", tile: "train"},

            // report-summary-menu-items/performance.html
            {route: "tabular-performance-metrics", templateUrl: "/templates/ml/prediction-model/performance-metrics.html", tile: "performance-metrics"},
        ];

        function rocPrCurvesTileToRoute(prefix, curveId) {
            return function(tile) {
                return {
                    route: prefix + "-c_roc_pr_curves",
                    routeParams: {curveId: curveId}
                }
            };
        }

        const rocPrCurvesRouteToTile = function(pane, stateParams) {
            return { displayMode: stateParams.curveId === 'pr' ? 'c_precision_recall' : 'c_roc' };
        };

        const upliftCurvesRouteToTile = function(pane, stateParams, tile) {
            if (stateParams.treatment) return { displayMode: 'summary' };

            const tileParams = { displayMode: tile };
            if (stateParams.curveId) {
                tileParams.advancedOptions = { upliftCurve: { displayMode: stateParams.curveId }}
            }
            return tileParams;
        };

        const unavailableForGlobalModelRouteToTile = function(pane, stateParams, tile) {
            if (stateParams.treatment) return { displayMode: 'summary' };

            return { displayMode: tile };
        };

        const upliftChartTileToRoute = function(tile) {
            const curveId = (tile.tileParams.advancedOptions && tile.tileParams.advancedOptions.upliftCurve || {}).displayMode;
            return {
                route: "tabular-uplift_curve", routeParams: { curveId },
            };
        };

        const staticModelViewIds = ['stress-test-center-view', 'error-analysis', 'model-fairness-view'];
        const staticModelViewRoutes = staticModelViewIds.map(skinId => ({ route: 'modelview-' + skinId, templateUrl: '/templates/savedmodels/version-skins.html', tile: skinId, routeOptions: { params: { skinId } } }));

        const classicalReportRoutes = [
            {route: "tabular-mc_confusion", templateUrl: "/templates/ml/prediction-model/mc_confusion.html", tile: "mc_confusion"},
            {route: "tabular-bc_confusion", templateUrl: "/templates/ml/prediction-model/bc_confusion.html", tile: "bc_confusion"},
            {route: "tabular-bc_decision_chart", templateUrl: "/templates/ml/prediction-model/bc_decision_chart.html", tile: "bc_decision_chart"},
            {route: "tabular-bc_lift", templateUrl: "/templates/ml/prediction-model/bc_lift.html", tile: "bc_lift"},
            {route: "tabular-c_calibration", templateUrl: "/templates/ml/prediction-model/c_calibration.html", tile: "c_calibration"},
            {route: "tabular-c_roc", templateUrl: "/templates/ml/prediction-model/c_roc.html", tile: "c_roc", tileToRoute: rocPrCurvesTileToRoute("tabular", "roc")},
            {route: "tabular-c_precision_recall", templateUrl: "/templates/ml/prediction-model/c_precision_recall.html", tile: "c_precision_recall", tileToRoute: rocPrCurvesTileToRoute("tabular", "pr")},
            {route: "tabular-c_roc_pr_curves", templateUrl: "/templates/ml/prediction-model/c_roc_pr_curves.html", tile: "c_roc_pr_curves", routeOptions: {urlSuffix: "/:curveId?", params: {curveId: { squash: true, value: null }}}, routeToTile: rocPrCurvesRouteToTile},
            {route: "tabular-c_density_chart", templateUrl: "/templates/ml/prediction-model/c_density_chart.html", tile: "c_density_chart"},
            {route: "tabular-r_scatter", templateUrl: "/templates/ml/prediction-model/r_scatter.html", tile: "r_scatter"},
            {route: "tabular-r_error", templateUrl: "/templates/ml/prediction-model/r_error.html", tile: "r_error"},
            ...staticModelViewRoutes
        ];

        const deephubReportRoutes = [
            {route: "deephub-summary", templateUrl: "/templates/ml/prediction-model/deephub/summary.html", tile: "summary"},
            {route: "deephub-interactive-scoring", templateUrl: "/templates/ml/prediction-model/deephub/interactive-scoring.html", tile: "deephub/interactive_scoring"},
            {route: "deephub-object-detection-confusion-matrix", templateUrl: "/templates/ml/prediction-model/deephub/object-detection-confusion-matrix.html", tile: "deephub/object-detection-confusion-matrix"},
            {route: "deephub-image-classification-confusion-matrix", templateUrl: "/templates/ml/prediction-model/deephub/image-classification-confusion-matrix.html", tile: "deephub/image-classification-confusion-matrix"},
            {route: "deephub-performance-metrics", templateUrl: "/templates/ml/prediction-model/deephub/performance-metrics.html", tile: "deephub/performance-metrics"},
            {route: "deephub-c_calibration", templateUrl: "/templates/ml/prediction-model/c_calibration.html", tile: "c_calibration"},
            {route: "deephub-c_roc", templateUrl: "/templates/ml/prediction-model/c_roc.html", tile: "c_roc", tileToRoute: rocPrCurvesTileToRoute("deephub", "roc")},
            {route: "deephub-c_precision_recall", templateUrl: "/templates/ml/prediction-model/c_precision_recall.html", tile: "c_precision_recall", tileToRoute: rocPrCurvesTileToRoute("deephub", "pr")},
            {route: "deephub-c_roc_pr_curves", templateUrl: "/templates/ml/prediction-model/c_roc_pr_curves.html", tile: "c_roc_pr_curves", routeOptions: {urlSuffix: "/:curveId?", params: {curveId: { squash: true, value: null }}}, routeToTile: rocPrCurvesRouteToTile},
            {route: "deephub-c_density_chart", templateUrl: "/templates/ml/prediction-model/c_density_chart.html", tile: "c_density_chart"},
            {route: "deephub-precision-recall", templateUrl: "/templates/ml/prediction-model/deephub/precision-recall.html", tile: "deephub/precision-recall"},
            {route: "deephub-train", templateUrl: "/templates/ml/prediction-model/deephub/train.html", tile: "train"},
        ];

        const timeseriesReportRoutes = [
            {route: "tabular-ts_forecast", templateUrl: "/templates/ml/prediction-model/ts_forecast.html", tile: "ts_forecast"},
            {route: "tabular-granular_time_series_metrics", templateUrl: "/templates/ml/prediction-model/timeseries/granular-time-series-metrics.html", tile: "granular_time_series_metrics"},
            {route: "tabular-autoarima_orders", templateUrl: "/templates/ml/prediction-model/timeseries/autoarima-orders.html", tile: "autoarima_orders"},
            {route: "tabular-timeseries_model_coefficients", templateUrl: "/templates/ml/prediction-model/timeseries/model-coefficients.html", tile: "timeseries_model_coefficients"},
            {route: "tabular-timeseries_information_criteria", templateUrl: "/templates/ml/prediction-model/timeseries/information-criteria.html", tile: "timeseries_information_criteria"},
            {route: "tabular-timeseries_residuals", templateUrl: "/templates/ml/prediction-model/timeseries/residuals.html", tile: "timeseries_residuals"},
            // others links are the same as classical
        ];

        const causalReportRoutes = [
            {route: "tabular-uplift_curve", templateUrl: "/templates/ml/prediction-model/causal/uplift_curve.html", tile: "uplift_curve", routeOptions: { urlSuffix: "/:curveId?", params: { curveId: { squash: true, value: null } } }, routeToTile: upliftCurvesRouteToTile, tileToRoute: upliftChartTileToRoute},
            {route: "tabular-cate_distribution", templateUrl: "/templates/ml/prediction-model/causal/cate_distribution.html", tile: "cate_distribution", routeToTile: unavailableForGlobalModelRouteToTile},
            {route: "tabular-propensity_randomness", templateUrl: "/templates/ml/prediction-model/causal/propensity_randomness.html", tile: "propensity_randomness", routeToTile: unavailableForGlobalModelRouteToTile},
            {route: "tabular-propensity_positivity", templateUrl: "/templates/ml/prediction-model/causal/propensity_positivity.html", tile: "propensity_positivity", routeToTile: unavailableForGlobalModelRouteToTile},
            // others links are the same as classical
        ];

        // For saved models
        const llmReportRoutes = [
            {route: "summary", templateUrl: "/templates/ml/llm-generic/summary.html", tile: "summary"},
            {route: "training-information", templateUrl: "/templates/ml/llm-generic/training-information.html", tile: "training-information"},
            {route: "deployment", templateUrl: "/templates/ml/llm-generic/deployment.html"}
        ];

        // For ME created by LLM evaluation recipe
        const llmEvaluationReportRoutes = [
            {route: "llm-evaluation-summary", templateUrl: "/templates/modelevaluationstores/llm-evaluation-summary.html", tile: "summary"},
            {route: "llm-row-by-row-analysis", templateUrl: "/templates/modelevaluationstores/llm-row-by-row-analysis.html", tile: "llm-row-by-row-analysis"},
        ];


        // Keep in sync with MDG in DomElementsExportService.getReportTabPrefix
        const getPredictionReportTabPrefix = (isDeepHubPrediction, isLLMEvaluation) => {
            if (isDeepHubPrediction) {
                return "deephub";
            }
            if (isLLMEvaluation) {
                return "llm-evaluation";
            }
            return "tabular";
        }

        const allPredictionReportRoutes = tabularReportRoutes.concat(classicalReportRoutes, deephubReportRoutes, timeseriesReportRoutes, causalReportRoutes);

        return {
            classicalDesignRoutes,
            clusteringDesignRoutes,
            causalDesignRoutes,
            deephubDesignRoutes,
            timeSeriesDesignRoutes,
            allResultsRoutes,
            clusteringReportRoutes,
            classicalReportRoutes,
            tabularReportRoutes,
            llmReportRoutes,
            timeseriesReportRoutes,
            llmEvaluationReportRoutes,
            allPredictionReportRoutes,
            // Keep in sync with MDG in DomElementsExportService.getDesignTabPrefix
            getPredictionDesignTabPrefix: ({isDeepHubPrediction, isCausalPrediction, isTimeseriesPrediction}) => {
                let prefix = "classical";
                if (isDeepHubPrediction()) {
                    prefix = "deephub";
                } else if (isTimeseriesPrediction()) {
                    prefix = "timeseries";
                } else if (isCausalPrediction()) {
                    prefix = "causal";
                }
                return prefix;
            },
            getPredictionReportSummaryTab: (isDeepHubPrediction, isLLMEvaluation) => `${getPredictionReportTabPrefix(isDeepHubPrediction, isLLMEvaluation)}-summary`,
            getPredictionReportTrainTab: (isDeepHubPrediction) => `${getPredictionReportTabPrefix(isDeepHubPrediction, false)}-train`,
            getPredictionReportOverridesMetricsTab: () => `${getPredictionReportTabPrefix(false)}-overrides_metrics`,
            // allowed transitions are to prevent the "check if dirty" popup when editing a design and changing tab
            getAllowedTransitions: () => {
                // Design
                let routes = [];
                routes.push("projects.project.analyses.analysis.ml.predmltask.list.design");
                routes.push("projects.project.analyses.analysis.ml.clustmltask.list.design");

                routes = routes.concat(classicalDesignRoutes.map(r => "projects.project.analyses.analysis.ml.predmltask.list.design." + r.route));
                routes = routes.concat(clusteringDesignRoutes.map(r => "projects.project.analyses.analysis.ml.clustmltask.list.design." + r.route));
                routes = routes.concat(causalDesignRoutes.map(r => "projects.project.analyses.analysis.ml.predmltask.list.design." + r.route));
                routes = routes.concat(deephubDesignRoutes.map(r => "projects.project.analyses.analysis.ml.predmltask.list.design." + r.route));
                routes = routes.concat(timeSeriesDesignRoutes.map(r => "projects.project.analyses.analysis.ml.predmltask.list.design." + r.route));

                // Sessions
                routes.push("projects.project.analyses.analysis.ml.predmltask.list.results");
                routes.push("projects.project.analyses.analysis.ml.clustmltask.list.results");
                for (const {route} of allResultsRoutes) {
                    routes.push("projects.project.analyses.analysis.ml.predmltask.list.results." + route);
                    routes.push("projects.project.analyses.analysis.ml.clustmltask.list.results." + route);
                }
                return routes;
            },
            savedModelPaneToDashboardTile: (pane, stateParams) => {
                if (pane.startsWith("modelview")) {
                    let params = {displayMode: "skins"};
                    if (stateParams.skinId) {
                        params.advancedOptions = { customViews: { viewId: stateParams.skinId}};
                    }
                    return params;
                }

                // assume route names are unique between all reports, clustering has no "prefix" for reports
                for (const routes of [clusteringReportRoutes, allPredictionReportRoutes]) {
                    for (const {route, tile, routeToTile} of routes) {
                        if (route === pane) {
                            if (routeToTile) {
                                return routeToTile(pane, stateParams, tile);
                            }
                            return { displayMode: tile || "summary" };  // default to summary if no tile
                        }
                    }
                }
                return {displayMode: "summary"}
            },
            dashboardTileToSavedModelPane: (fullTile, isClustering, {isDeepHubPrediction, isCausalPrediction, isTimeseriesPrediction}) => {
                let routes;
                let defaultRoute;
                const tileName = fullTile.tileParams.displayMode;
                if (isClustering) {
                    routes = clusteringReportRoutes;
                    defaultRoute = "summary";
                } else if (isDeepHubPrediction()) {
                    routes = deephubReportRoutes;
                    defaultRoute = "deephub-summary";
                } else {
                    routes = tabularReportRoutes;
                    defaultRoute = "tabular-summary";
                    if (isTimeseriesPrediction()) {
                        routes = routes.concat(timeseriesReportRoutes);
                    } else if (isCausalPrediction()) {
                        routes = routes.concat(causalReportRoutes);
                    } else {
                        routes = routes.concat(classicalReportRoutes);  // classical is the "default"
                    }
                }

                let routeDef = {route: defaultRoute, routeParams: null}
                for (const {route, tile, tileToRoute} of routes) {
                    if (tileName === tile) {
                        if (tileToRoute) {
                            return tileToRoute(fullTile);
                        }
                        routeDef.route =  route || defaultRoute;  // default to summary if no route (should not happen...)
                        break;
                    }
                }
                return routeDef;
            },
            goToRouteSuffixIfBase: ($state, toState, toParams, fromState, fromParams, baseRoute, suffix, event) => {
                if (toState.name === baseRoute) {
                    event.preventDefault();
                    const toRoute = `${baseRoute}.${suffix}`;
                    if ($state.current.name !== toRoute || ($state.current.name === toRoute && !angular.equals(toParams, fromParams))) {
                        $state.go(toRoute, toParams, {location: 'replace'});
                    }
                }
            }
        };
    };

    // Needs a constant to be injected into app.config
    angular.module("dataiku").constant("MLRoutingService", createMLRoutingService());

    function createMLSubRoute($stateProvider, baseRoute, templateUrl, routeSuffix, controller, {urlSuffix = "", params = ""} = {}) {
        $stateProvider.state(baseRoute + '.' + routeSuffix, {
            url: "/" + routeSuffix + urlSuffix,
            params: params || "",
            templateUrl: templateUrl,
            controller: function($scope, $controller) {
                if (params && params.skinId) { // for static model views
                    $scope.setSettingsPane("modelview", params.skinId);
                } else {
                    $scope.setSettingsPane(routeSuffix, null);
                }
                if (controller) {
                    $controller(controller, {$scope: $scope});
                }
            }
        });
    }

    function createMLModelViewRoute($stateProvider, baseRoute) {
        $stateProvider.state(baseRoute + '.modelview', {
            url: "/modelview/:skinId",
            templateUrl: "/templates/savedmodels/version-skins.html",
            controller: function($scope, $state, $stateParams) {
                $scope.setSettingsPane("modelview", $stateParams.skinId);
            },
        });
    }


    function redirectState($stateProvider, fromState, toState, fromUrl, passStateParams = false) {
        $stateProvider.state(fromState, {
            url: fromUrl,
            template: '<div ui-view></div>',
            controller: function($state, $stateParams, $timeout) {
                if ($state.current.name === fromState) {
                    // timeout() is needed so that the final state appears in the browser history
                    $timeout(() => $state.go(toState, passStateParams ? $stateParams : null, {location: 'replace'}));
                }
            }
        });
    }

    function declareRoutes($stateProvider,$urlRouterProvider, MLRoutingService, WorkspacesRoutes) {
        /* ************************* Top level routes ************************ */

        $stateProvider.state('root', {
            url: '/',
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home";
            }
        });
        $stateProvider.state('profile.ngx', {
            url: '/ngx-hello',
            template: '<ng2-downgrade-example></ng2-downgrade-example>'
        });
        $stateProvider.state('home', {
            url: '/home/',
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home";
            }
        });

        $stateProvider.state('wikis', {
            url: '/wikis/',
            params: {
                filterBy: undefined,
                standalone: true,
                row: 'wikis'
            },
            templateUrl: '/templates/wikis-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Wikis";
            }
        });

        $stateProvider.state('wikis.list', {
            url: 'list/',
            params: {
                filterBy: undefined,
                standalone: true,
                row: 'wikis'
            },
            templateUrl: '/templates/wikis-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Wikis";
            }
        });

        $stateProvider.state('home.expandedlist', {
            url: ':row/expandedlist',
            params: {
                filterBy: undefined
            },
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home expanded";
            }
        });

        $stateProvider.state('home.expandedmosaic', {
            url: ':row/expandedmosaic',
            params: {
                filterBy: undefined,
                standalone: undefined
            },
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home expanded mosaic";
            }
        });

        $stateProvider.state('project-list', {
            url: '/project-list/:folderId?forceDisplayMode',
            controller: 'ProjectsListController',
            templateUrl: '/templates/projects-list/projects-list.html',
            pageTitle: () => {
                return "Projects";
            }
        });

        $stateProvider.state('login', {
            url: '/login/?redirectTo&search',
            templateUrl: '/templates/login.html',
            controller: 'LoginController',
            pageTitle: () => {
                return "Login";
            }
        });

        $urlRouterProvider.when('/login', '/login/');

        $stateProvider.state('sso-error', {
            url: '/sso-error?error&errorDescription',
            templateUrl: '/templates/sso-error.html',
            controller: 'SSOErrorController',
            pageTitle: () => {
                return "SSO error";
            }
        });

        $stateProvider.state('logged-out', {
            url: '/logged-out',
            templateUrl: '/templates/logged-out.html',
            pageTitle: () => {
                return "Logged out";
            }
        });

        $stateProvider.state('feedback', {
            url: '/feedback/',
            templateUrl: '/templates/feedback.html'
        });

        $stateProvider.state("blackhole", {
            url: "/blackhole/"
        });

        $stateProvider.state('projects', {
            url: '/projects',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('dataquality', {
            url: '/data-quality',
            abstract: true,
            template: '<ng2-instance-data-quality-nav></ng2-instance-data-quality-nav><ui-view class="dss-page"></ui-view>',
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.DSS_HOME, "dataquality");
            }
        });

        $stateProvider.state('dataquality.current-status', {
            url: '/',
            template: '<ng2-instance-status-panel></ng2-instance-status-panel>',
            pageTitle: () => {
                return "Instance - Data Quality";
            }
        });

        const dataQualityTemplatesPageTitle = () => "Data Quality Templates";

        $stateProvider.state('dataquality.templates', {
            url: '/templates',
            abstract: true,
            template: '<ui-view></ui-view>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.list', {
            url: '/',
            template: '<ng2-data-quality-templates></ng2-data-quality-templates>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.template', {
            url: '/:templateId',
            template: '<ng2-data-quality-template-edit-view [template-id]="$state.params.templateId"></ng2-data-quality-template-edit-view>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.template.new-rule', {
            url: '/new-rule',
            template: '<ng2-new-rule-panel id="new-rule-panel"></ng2-new-rule-panel>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.template.rule', {
            url: '/:ruleId',
            template: '<ng2-rule-edit [can-edit]="addToScope.canEdit" [rule-id]="$root.$state.params.ruleId"></ng2-rule-edit>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('jambon', {
            url: '/admin/jambon/',
            templateUrl: '/templates/widgets/image-uploader-dialog.html'
        });

        /* ************************** Home v2  ********************** */

        $stateProvider.state('homeV2', {
            url: '/home',
            abstract: true,
            template: '<div ui-view class="h100"></div>',
            controller: function(TopNav, $scope, $rootScope, $state) {
                TopNav.setLocation(TopNav.DSS_HOME);

                $scope.redirectForNoneProfile = $rootScope.appConfig.userProfile.profile === 'NONE' && $state.current.name !== 'homeV2.homepage';
                if ($scope.redirectForNoneProfile) {
                    $state.go('homeV2.homepage', null, {location: 'replace'});
                }
            }
        })

        $stateProvider.state('homeV2.homepage', {
            url: '/',
            templateUrl: '/templates/personal-home.html',
            pageTitle: () => {
                return "Home";
            }
        });

        $stateProvider.state('homeV2.projects', {
            url: '/projects/',
            template: '<ng2-projects-page [folder-id]="$root.$stateParams.folderId"></ng2-projects-page>',
            abstract: true,
        });

        $stateProvider.state('homeV2.projects.folder', {
            url: ':folderId',
            template: '',
            pageTitle: () => {
                return "Projects";
            }
        });

        $stateProvider.state('homeV2.applications', {
            url: '/applications',
            template: '<ng2-applications-page></ng2-applications-page>',
            pageTitle: () => {
                return "Applications"
            }
        });

        $stateProvider.state('homeV2.data-catalog', {
            url: '/data-catalog',
            template: '<ng2-data-catalog-page></ng2-data-catalog-page>',
            pageTitle: () => {
                return "Data Catalog"
            }
        });

        $stateProvider.state('homeV2.workspaces', {
            url: '/workspaces',
            template: '<ng2-workspaces-page></ng2-workspaces-page>',
            pageTitle: () => {
                return "Workspaces"
            }
        });

        /* ************************** Project Apps ********************** */

        $stateProvider.state('apps', {
            url: '/apps',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('apps.list', {
            url: '/',
            controller: 'AppsListController',
            templateUrl: '/templates/apps/apps-list.html',
            params: {
                preSetQuery: '' // optional: fill in the search field on load
            },
            pageTitle: () => {
                return "Applications";
            }
        });

        $stateProvider.state('apps.app', {
            url: '/:appId',
            templateUrl: '/templates/apps/app-page.html',
            pageTitle: () => {
                return "App";
            }
        });

        /* ************************** Project ********************** */

        $stateProvider.state('projects.project', {
            url: '/:projectKey',
            abstract: true,
            controller: 'ProjectBaseController',
            templateUrl: '/templates/projects/project.html'
        });

        $stateProvider.state('projects.project.project-standards-report', {
            url: '/project-standards-report',
            template: '<ng2-project-standards-report-page [project-key]="$root.$state.params.projectKey"></ng2-project-standards-report-page>',
            pageTitle: () => {
                return "Project Standards Report";
            }
        });

        $stateProvider.state('projects.project.home', {
            abstract: true,
            url: '',
            templateUrl: '/templates/projects/home/index.html',
            controller: 'ProjectHomeTabController',
        });

        $stateProvider.state('projects.project.home.summary', {
            url: '/?discussionId&testInstance',
            templateUrl: '/templates/projects/home/project-home.html',
            controller: 'ProjectHomeController',
            pageTitle: () => {
                return "Summary";
            }
        });

        $stateProvider.state('projects.project.home.regular', {
            url: '?discussionId&testInstance',
            controller: 'ContextualProjectHomeController',
        });

        $stateProvider.state('projects.project.home.setup', {
            url: '/setup',
            templateUrl : '/templates/projects/home/setup-home.html',
            pageTitle: () => {
                return "Project setup"
            }
        });

        $stateProvider.state('projects.project.home.activity', {
            url: '/activity/',
            templateUrl: '/templates/projects/home/activity.html',
            controller: 'ProjectHomeController',
            pageTitle: () => {
                return "Summary";
            }
        });

        $stateProvider.state('projects.project.home.status', {
            url: '/status',
            abstract: true,
            templateUrl: '/templates/projects/home/status.html',
            controller: 'ProjectMetricsController',
            pageTitle: () => {
                return " Summary";
            }
        });

        $stateProvider.state('projects.project.home.status.settings', {
            url: '/settings',
            templateUrl: '/templates/projects/home/status-settings.html'
        });

        $stateProvider.state('projects.project.home.status.metrics', {
            url: '',
            templateUrl: '/templates/projects/home/status-metrics.html'
        });

        $stateProvider.state('projects.project.home.status.checks', {
            url: '/checks',
            templateUrl: '/templates/projects/home/status-checks.html'
        });

        /* Temporary redirect state */

        $stateProvider.state('projects.project.settings.tmp', {
            url: '/',
            controller: 'ProjectSettingsTmpController',
        });

        $stateProvider.state('projects.project.variables', {
            url: '/variables/',
            templateUrl: '/templates/projects/variables/variables.html'
        });

        $stateProvider.state('projects.project.appdesigner', {
            url: '/app-designer/',
            templateUrl: '/templates/apps/app-designer.html',
            controller: "AppDesignerController",
            pageTitle: () => {
                return "Application designer";
            }
        });

        $stateProvider.state('projects.project.statisticsWorksheet', {
            url: '/statistics/worksheet/:worksheetId',
            template: '<ng2-eda-worksheet-redirection-page></ng2-eda-worksheet-redirection-page>'
        });

        $stateProvider.state('projects.project.settings', {
            url: '/settings/:selectedTab',
            templateUrl: '/templates/projects/settings/settings.html'
        });

        $stateProvider.state('projects.project.integrations', {
            url: '/settings/integrations',
            templateUrl: '/templates/projects/integrations/messaging-like-selection.html'
        });

        $stateProvider.state('projects.project.security', {
            url: '/security/:selectedTab',
            templateUrl: '/templates/projects/security/security.html'
        });

        $stateProvider.state('projects.project.libedition', {
            url: '/libedition',
            abstract: true,
            templateUrl: '/templates/plugins/development/lib-edition-project.html'
        });

        $stateProvider.state("projects.project.libedition.versioned", {
            url: '/versioned',
            templateUrl: '/templates/plugins/development/lib-versioned-edition-project.html',
            controller: 'ProjectFolderVersionedEditionController',
            params: {
                initialPath: ''
            },
            pageTitle: () => "Library Editor"
        });

        $stateProvider.state("projects.project.libedition.history", {
            url: '/history',
            templateUrl: '/templates/plugins/development/lib-versioned-history-project.html',
            controller: 'ProjectFolderVersionedHistoryController',
            pageTitle: () => "Library Editor"
        });

        $stateProvider.state("projects.project.libedition.resources", {
            url: '/resources',
            templateUrl: '/templates/plugins/development/lib-resources-edition-project.html',
            controller: 'ProjectFolderResourcesEditionController',
            pageTitle: () => "Library Editor"
        });

        $stateProvider.state('projects.project.libedition.libpython', {
            url: '/libpython',
            redirectTo: 'projects.project.libedition.versioned'
        });

        $stateProvider.state('projects.project.libedition.localstatic', {
            url: '/localstatic',
            redirectTo: 'projects.project.libedition.versioned'
        });

        $stateProvider.state('projects.project.flow', {
            url: '/flow/?id&?zoneId',
            templateUrl: '/templates/flow-editor/flow-editor.html',
            pageTitle: () => {
                return "Flow";
            }
        });

        $stateProvider.state('projects.project.version-control', {
            url: '/version-control/?commitId?branch',
            templateUrl: '/templates/projects/git/project-git.html',
            controller: "ProjectVersionControlController",
            pageTitle: () => {
                return "Version control";
            }
        });

        $stateProvider.state('projects.project.version-control-merge', {
            url: '/version-control-merge/:mergeRequestId',
            templateUrl: '/templates/git/merge-request.html',
            controller: "GitMergeRequestController",
            pageTitle: () => "Merge request"
        });

        /* ************************** Dataset ********************** */

        $stateProvider.state('projects.project.datasets', {
            url: '/datasets',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.datasets.list', {
            url: '/',
            templateUrl: '/templates/datasets/list.html',
            controller: 'DatasetsListController',
            pageTitle: () => {
                return "Datasets";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset', {
            url: '/:datasetName?discussionId',
            abstract: true,
            controller: 'DatasetCommonController',
            templateUrl: '/templates/datasets/dataset.html'
        });

        $stateProvider.state('projects.project.datasets.dataset.settings', {
            url: '/settings/',
            templateUrl: '/templates/datasets/settings.html',
            controller: 'DatasetSettingsController',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Settings";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.history', {
            url: '/history/',
            templateUrl: '/templates/datasets/history.html',
            controller: 'DatasetHistoryController',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - History";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.statistics', {
            url: '/statistics',
            template: `<ng2-eda
                dataset-name="{{$state.params.datasetName}}"
                project-key="{{$state.params.projectKey}}"
                worksheet-id="{{$state.params.worksheetId}}"></ng2-eda>`,
            controller: 'DatasetStatisticsController',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.statistics.worksheet', {
            url: '/worksheet/:worksheetId',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        /* *********************** Data Quality ******************** */

        const dataQualityPageTitle = function(stateParams) {
            return stateParams.datasetName + " - Data quality";
        };

        $stateProvider.state('projects.project.datasets.dataset.data-quality', {
            url: '/data-quality',
            template: '<div block-api-error></div><div ui-view></div>',
            controller: 'DatasetDataQualityController',
            abstract: true
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view', {
            url: '',
            template: `<ng2-dataset-quality-tab-view
                ng-if="datasetFullInfo"
                class="dataset__data-quality-panel-container"
                [can-edit]="projectSummary.canWriteProjectContent"
                [can-publish-to-dashboards]="projectSummary.canWriteDashboards"
                [is-foreign]="false"
                [is-partitioned]="datasetFullInfo.partitioned"
                [context-project-key]="$stateParams.projectKey"
                [project-key]="$root.$state.params.projectKey"
                [dataset-name]="$root.$state.params.datasetName"
                [(data-steward)]="datasetFullInfo.dataSteward"
                [default-data-steward]="datasetFullInfo.defaultDataSteward"
                [last-build-time]="datasetFullInfo.lastBuild ? datasetFullInfo.lastBuild.buildEndTime : -1"
                [partitioning-scheme]="datasetFullInfo.dataset.partitioning"
                [is-input-dataset]="!datasetFullInfo.upstreamBuildable"
            ></ng2-dataset-quality-tab-view>
            `,
            abstract: true
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view.current-status', {
            url: '/current-status',
            template: `<ng2-current-values-panel
                [can-edit]="addToScope.canEdit"
                [can-publish-to-dashboards]="addToScope.canPublishToDashboards"
                [dataset-name]="addToScope.datasetName"
                [context-project-key]="addToScope.contextProjectKey"
                [project-key]="addToScope.projectKey"
                [is-foreign]="false"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [data-steward]="addToScope.dataSteward"
                (data-steward-change)="addToScope.dataStewardChange($event)"
                [default-data-steward]="addToScope.defaultDataSteward"
                [last-build-time]="addToScope.lastBuildTime"
                [is-input-dataset]="addToScope.isInputDataset"
            ></ng2-current-values-panel>`,
            pageTitle: dataQualityPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view.timeline', {
            url: '/timeline',
            template: `<ng2-timeline-panel
                [can-edit]="addToScope.canEdit"
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [is-foreign]="false"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
            ></ng2-timeline-panel>`,
            pageTitle: dataQualityPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view.history', {
            url: '/history?ruleIds?status?startDate?endDate',
            template: `<ng2-rule-history
                [dataset-name]="$root.$state.params.datasetName"
                [project-key]="$root.$state.params.projectKey"
                [context-project-key]="$root.$state.params.projectKey"
                [rule-ids]="$root.$state.params.ruleIds"
                [status]="$root.$state.params.status"
                [start-date]="$root.$state.params.startDate"
                [end-date]="$root.$state.params.endDate"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [can-edit]="addToScope.canEdit"
            ></ng2-rule-history>`,
            pageTitle: dataQualityPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.edit', {
            url: '/edit',
            templateUrl: '/templates/datasets/data-quality-edit.html',
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.edit.new-rule', {
            url: '/new-rule',
            templateUrl: '/templates/datasets/data-quality-new-rule.html',
            params: {
                openTemplateModal: undefined
            },
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Data quality (new rule)";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.edit.rule', {
            url: '/:ruleId',
            template: '<ng2-rule-edit [can-edit]="addToScope.canEdit" [rule-id]="$root.$state.params.ruleId" [project-key]="$root.$state.params.projectKey"></ng2-rule-edit>',
            pageTitle: dataQualityPageTitle
        });

        /* ************************** Metrics ********************** */

        const metricsPageTitle = function(stateParams) {
            return stateParams.datasetName + " - Metrics";
        };

        $stateProvider.state('projects.project.datasets.dataset.metrics', {
            url: '/metrics',
            template: `
            <div block-api-error></div>
            <div class= "h100" object-metrics metrics-partition-selection dataset-metrics-main>
                <div ng-if="datasetFullInfo" class="h100" ng-controller="DatasetMetricsController">
                    <ui-view class="h100"></ui-view>
                </div>
            </div>`,
            abstract: true
        });

        $stateProvider.state('projects.project.datasets.dataset.metrics.view', {
            url: '',
            template:`
                <div class="h100" ng-if="datasetFullInfo" ng-controller="DatasetMetricsController">
                    <div class="h100" display-metrics ng-show="views.selected === 'Last value' || views.selected === 'History'" can-compute="true" metrics-tab="true"></div>
                    <div class="h100" display-metrics-per-partition ng-show="views.selected === 'Partitions' || views.selected === 'Table'" can-compute="true" metrics-tab="true"></div>
                    <div class="h100" display-metrics-per-column ng-show="views.selected === 'Columns'" can-compute="true" metrics-tab="true"></div>
                </div>`,
            pageTitle: metricsPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.metrics.edit', {
            url: '/edit',
            template:`
                <div class="h100 boxed-next-to-sidebar no-padding">
                    <div ng-if="datasetFullInfo" class="h100 oa">
                        <form class="dkuform-modal-horizontal dkuform-modal-wrapper h100" name="theform" edit-probes-settings metrics-tab="true" novalidate >
                        </form>
                    </div>
                </div>
                `,
            pageTitle: metricsPageTitle
        });

        /* ***************** Dataiku Answers ********************* */

        $stateProvider.state("projects.project.dataikuanswers", {
            url : '/answers',
            template: '<div ui-view></div>',
            abstract: true
        });

        $stateProvider.state("projects.project.dataikuanswers.list", {
            url : '/',
            templateUrl: '/templates/dataiku-answers/list.html',
            controller: 'DataikuAnswersListController',
            pageTitle: () => {
                return "Dataiku Answers";
            }
        });

        /* ***************** Experiment tracking ********************* */

        $stateProvider.state('projects.project.experiment-tracking', {
            url: '/experiment-tracking',
            template: '<div ui-view></div>',
            controller: 'ExperimentTrackingController',
            reloadOnSearch: false,
            abstract: true
        });

        $stateProvider.state('projects.project.experiment-tracking.list', {
            url: '/list?viewAllExperiments',
            params: {
                viewAllExperiments: "false"
            },
            template: `<ng2-experiment-tracking></ng2-experiment-tracking>`,
            reloadOnSearch: false,
            pageTitle: function() {
                return " Experiment Tracking - Runs";
            }
        });

        $stateProvider.state('projects.project.experiment-tracking.runs-list', {
            url: '/list-runs?experimentIds&viewAllExperiments&viewAllRuns',
            params: {
                experimentIds: undefined,
                viewAllExperiments: undefined,
                viewAllRuns: undefined
            },
            template: `<ng2-experiment-tracking-runs-list></ng2-experiment-tracking-runs-list>`,
            reloadOnSearch: false,
            pageTitle: function() {
                return " Experiment Tracking - Runs";
            }
        });

        $stateProvider.state('projects.project.experiment-tracking.run-details', {
            url: '/run/:runId/details?experimentIds&viewAllExperiments&viewAllRuns',
            params: {
                experimentIds: undefined,
                viewAllExperiments: undefined,
                viewAllRuns: undefined
            },
            template: `<ng2-experiment-tracking-run></ng2-experiment-tracking-run>`,
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return " Experiment Tracking - Run";
            }
        });

        $stateProvider.state('projects.project.experiment-tracking.run-artifacts', {
            url: '/run/:runId/artifacts?experimentIds&viewAllExperiments&viewAllRuns&subfolder',
            params: {
                experimentIds: undefined,
                subfolder: undefined,
                viewAllExperiments: undefined,
                viewAllRuns: undefined
            },
            template: `<ng2-experiment-tracking-run></ng2-experiment-tracking-run>`,
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return " Experiment Tracking - Run";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.edit', {
            url: '/edit/',
            templateUrl: '/templates/datasets/edit-dataset.html',
            controller: 'DatasetEditController',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Edit";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.explore', {
            url: '/explore/',
            templateUrl: '/templates/datasets/explore.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Explore";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.status', {
            url: '/status',
            abstract: true,
            template: '<ui-view />'
        });

        $stateProvider.state('projects.project.datasets.dataset.status.settings', {
            url: '/settings/:selectedTab',
            params: { selectedTab: null },
            controller: function($state, $stateParams) {
                if ($stateParams.selectedTab === 'checks') {
                    $state.go('projects.project.datasets.dataset.data-quality.edit', $stateParams, {location: 'replace'})
                } else {
                    $state.go('projects.project.datasets.dataset.metrics.edit', $stateParams, {location: 'replace'})
                }
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.status.metrics', {
            url: '',
            controller: function($state, $stateParams) {
                $state.go('projects.project.datasets.dataset.metrics.view', $stateParams, {location: 'replace'})
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.status.checks', {
            url: '/checks',
            controller: function($state, $stateParams) {
                $state.go('projects.project.datasets.dataset.data-quality.view.current-status', $stateParams, {location: 'replace'})
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.visualize', {
            url: '/visualize/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/datasets/visualize.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Visualize";
            }
        });

        $stateProvider.state('projects.project.datasets.new_with_type', {
            url: '/new/:type?fromOdbSmartId?fromOdbItemPath?fromOdbItemDirectory?zoneId',
            abstract: true,
            templateUrl: '/templates/datasets/dataset.html',
            controller: 'DatasetNewController',
        });

        $stateProvider.state('projects.project.datasets.new_with_type.settings', {
            url: '/?prefillParams',
            templateUrl: '/templates/datasets/new-settings.html',
            controller: 'DatasetSettingsController',
            pageTitle: function(stateParams) {
                return "New " + stateParams.type + " dataset";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.search', {
            url: '/search/',
            templateUrl: '/templates/datasets/search.html',
            params: {
                queryString: null,
            },
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Search";
            }
        });

        /* ************************** Foreign view of datasets ********************** */

        $stateProvider.state('projects.project.foreigndatasets', {
            url: '/foreigndatasets',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset', {
            url: '/:datasetFullName',
            abstract: true,
            controller: 'ForeignDatasetCommonController',
            templateUrl: '/templates/foreigndatasets/dataset.html'
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.explore', {
            url: '/explore/',
            templateUrl: '/templates/foreigndatasets/explore.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetFullName + " - Explore";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.search', {
            url: '/search/',
            templateUrl: '/templates/foreigndatasets/search.html',
            params: {
                queryString: null,
            },
            pageTitle: function(stateParams) {
                return stateParams.datasetFullName + " - Search";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.visualize', {
            url: '/visualize/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/foreigndatasets/visualize.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetFullName + " - Visualize";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.statistics', {
            url: '/statistics',
            template: `<ng2-eda
                dataset-name="{{$state.params.datasetFullName}}"
                project-key="{{$state.params.projectKey}}"
                worksheet-id="{{$state.params.worksheetId}}"></ng2-eda>`,
            controller: 'DatasetStatisticsController',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.statistics.worksheet', {
            url: '/worksheet/:worksheetId',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        const dataQualityPageTitleForeign = function(stateParams) {
            return stateParams.datasetFullName + " - Data quality";
        };

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality', {
            url: '/data-quality',
            template: '<div block-api-error></div><div ui-view></div>',
            controller: 'DatasetDataQualityController',
            abstract: true
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view', {
            url: '',
            template: `<ng2-dataset-quality-tab-view
                ng-if="datasetLoc && datasetFullInfo"
                class="dataset__data-quality-panel-container"
                [can-edit]="false"
                [is-foreign]="true"
                [is-partitioned]="datasetFullInfo.partitioned"
                [context-project-key]="$stateParams.projectKey"
                [project-key]="datasetLoc.projectKey"
                [dataset-name]="datasetLoc.name"
                [data-steward]="datasetFullInfo.dataSteward"
                [default-data-steward]="datasetFullInfo.defaultDataSteward"
                [last-build-time]="datasetFullInfo.lastBuild.buildEndTime"
                [partitioning-scheme]="datasetFullInfo.dataset.partitioning"
                [is-input-dataset]="!datasetFullInfo.upstreamBuildable"
            ></ng2-dataset-quality-tab-view>`,
            abstract: true
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view.current-status', {
            url: '/current-status',
            template: `<ng2-current-values-panel
                [can-edit]="addToScope.canEdit"
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [is-foreign]="true"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [data-steward]="addToScope.dataSteward"
                [default-data-steward]="addToScope.defaultDataSteward"
                [last-build-time]="addToScope.lastBuildTime"
                [is-input-dataset]="addToScope.isInputDataset"
            ></ng2-current-values-panel>`,
            pageTitle: dataQualityPageTitleForeign
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view.timeline', {
            url: '/timeline',
            template: `<ng2-timeline-panel
                [can-edit]="addToScope.canEdit"
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [is-foreign]="true"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
            ></ng2-timeline-panel>`,
            pageTitle: dataQualityPageTitleForeign
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view.history', {
            url: '/history?ruleIds?status?startDate?endDate',
            template: `<ng2-rule-history
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [project-key]="addToScope.projectKey"
                [rule-ids]="$root.$state.params.ruleIds"
                [status]="$root.$state.params.status"
                [start-date]="$root.$state.params.startDate"
                [end-date]="$root.$state.params.endDate"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [can-edit]="addToScope.canEdit"
            ></ng2-rule-history>`,
            pageTitle: dataQualityPageTitleForeign
        });

        /* ************************** Streaming enpdoints ********************** */

        $stateProvider.state('projects.project.streaming-endpoints', {
            url: '/streaming-endpoints',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.streaming-endpoints.list', {
            url: '/',
            templateUrl: '/templates/streaming-endpoints/list.html',
            controller: 'StreamingEndpointsListController',
            pageTitle: () => {
                return "Streaming endpoints";
            }
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint', {
            url: '/:streamingEndpointId?discussionId',
            abstract: true,
            controller: 'StreamingEndpointPageController',
            templateUrl: '/templates/streaming-endpoints/streaming-endpoint.html'
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint.settings', {
            url: '/settings/',
            templateUrl: '/templates/streaming-endpoints/settings.html',
            controller: 'StreamingEndpointSettingsController',
            pageTitle: function(stateParams) {
                return stateParams.streamingEndpointId + " - Settings";
            }
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint.history', {
            url: '/history/',
            templateUrl: '/templates/streaming-endpoints/history.html',
            controller: 'StreamingEndpointHistoryController',
            pageTitle: function(stateParams) {
                return stateParams.streamingEndpointId + " - History";
            }
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint.explore', {
            url: '/explore/',
            templateUrl: '/templates/streaming-endpoints/explore.html',
            controller: 'StreamingEndpointExploreController',
            pageTitle: function(stateParams) {
                return stateParams.streamingEndpointId + " - Explore";
            }
        });

        /* ************************** Analysis ********************** */

        $stateProvider.state('projects.project.analyses', {
            url: '/analysis',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.list', {
            url: '/?datasetId',
            templateUrl: '/templates/analysis/list.html',
            controller: "AnalysesListController",
            pageTitle: () => {
                return " Analyses";
            }
        });

        $stateProvider.state('projects.project.analyses.analysis', {
            url: '/:analysisId?discussionId',
            abstract: true,
            templateUrl: '/templates/analysis/analysis.html',
            controller: "AnalysisCoreController",
            pageTitle: () => {
                return " Analysis";
            }
        });

        $stateProvider.state('projects.project.analyses.analysis.script', {
            url: '/script/',
            templateUrl: '/templates/analysis/script.html',
        });

        $stateProvider.state('projects.project.analyses.analysis.charts', {
            url: '/visualize/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/analysis/charts.html',
        });

        $stateProvider.state('projects.project.analyses.analysis.ml', {
            url: '/ml',
            abstract: true,
            template: '<div ui-view></div>'
        });

        // You never stay on this state except if no mltask
        $stateProvider.state('projects.project.analyses.analysis.ml.list', {
            url: '/',
            templateUrl: '/templates/analysis/mltasks.html',
            controller: "AnalysisMLTasksController"
        });

        /* ******************** Analysis/ML/Prediction **************** */

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask', {
            url: '/p/:mlTaskId',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.list', {
            url: '/list',
            abstract: true,
            templateUrl: '/templates/analysis/prediction/models.html',
            controller: 'PMLTaskBaseController'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.list.design', {
            url: '/design',
            templateUrl: '/templates/analysis/prediction/models-design.html',
            controller: function($scope, $state) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane) => {
                    $scope.uiState.settingsPane = pane;
                }

                const baseRoute = "projects.project.analyses.analysis.ml.predmltask.list.design";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    const suffix = MLRoutingService.getPredictionDesignTabPrefix($scope) + "-learning";
                    MLRoutingService.goToRouteSuffixIfBase($state, toState, toParams, fromState, fromParams, baseRoute, suffix, event);
                });

                if ($state.current.name === baseRoute) {
                    const deregister = $scope.$watch("mlTaskDesign", (nv, ov) => {
                        if (!nv) {
                            return;
                        }
                        // redirect to learning page when arriving on "design", need to have mlTaskDesign to know the backend type...
                        const prefix = MLRoutingService.getPredictionDesignTabPrefix($scope);
                        $state.go(`.${prefix}-learning`, null, {location: 'replace'});
                        deregister();
                    });
                }
            }
        });

        for (const designRoutes of [MLRoutingService.classicalDesignRoutes, MLRoutingService.deephubDesignRoutes, MLRoutingService.causalDesignRoutes, MLRoutingService.timeSeriesDesignRoutes]) {
            for (const {route, templateUrl, controller, routeOptions} of designRoutes) {
                createMLSubRoute($stateProvider, 'projects.project.analyses.analysis.ml.predmltask.list.design', templateUrl, route, controller, routeOptions);
            }
        }

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.list.results', {
            url: '/results',
            templateUrl: '/templates/analysis/prediction/models-results.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setViewMode = (pane) => {
                    $scope.uiState.viewMode = pane;
                }

                const baseRoute = "projects.project.analyses.analysis.ml.predmltask.list.results";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    MLRoutingService.goToRouteSuffixIfBase($state, toState, toParams, fromState, fromParams, baseRoute, "sessions", event);
                });

                if ($state.current.name === baseRoute) {
                    $timeout(() => $state.go(".sessions", null, {location: 'replace'}));
                }
            }
        });

        for (const {route, templateUrl} of MLRoutingService.allResultsRoutes) {
            $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.list.results.' + route, {
                url: "/" + route,
                templateUrl: templateUrl,
                controller: function($scope) {
                    $scope.setViewMode(route);
                },
            });
        }

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model', {
            url: '/:fullModelId',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model.predictedtable', {
            url: '/table/',
            templateUrl: '/templates/analysis/prediction/model/model-predicted-table.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model.predictedcharts', {
            url: '/charts/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/analysis/prediction/model/model-predicted-charts.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model.report', {
            url: '/report?exportMode?treatment',
            templateUrl: '/templates/analysis/prediction/model/model-report.html',
            controller: "MLBaseRouteReportController"
        });

        for (const {route, templateUrl, routeOptions} of MLRoutingService.allPredictionReportRoutes) {
            createMLSubRoute($stateProvider, 'projects.project.analyses.analysis.ml.predmltask.model.report', templateUrl, route, null, routeOptions);
        }

        createMLModelViewRoute($stateProvider, "projects.project.analyses.analysis.ml.predmltask.model.report");

        /* ******************** Analysis/ML/Clustering **************** */

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask', {
            url: '/c/:mlTaskId',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.list', {
            url: '/list',
            abstract: true,
            templateUrl: '/templates/analysis/models.html',
            controller: 'CMLTaskBaseController'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.list.design', {
            url: '/design',
            templateUrl: '/templates/analysis/clustering/models-design.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane) => {
                    $scope.uiState.settingsPane = pane;
                }

                const baseRoute = "projects.project.analyses.analysis.ml.clustmltask.list.design";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    MLRoutingService.goToRouteSuffixIfBase($state, toState, toParams, fromState, fromParams, baseRoute, "clustering-learning", event);
                });

                if ($state.current.name === baseRoute) {
                    $timeout(() => $state.go(".clustering-learning", null, {location: 'replace'}));
                }
            }
        });

        for (const {route, templateUrl, routeOptions} of MLRoutingService.clusteringDesignRoutes) {
            createMLSubRoute($stateProvider, 'projects.project.analyses.analysis.ml.clustmltask.list.design', templateUrl, route, null, routeOptions);
        }


        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.list.results', {
            url: '/results',
            templateUrl: '/templates/analysis/clustering/models-results.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setViewMode = (pane) => {
                    $scope.uiState.viewMode = pane;
                }

                const baseRoute = "projects.project.analyses.analysis.ml.clustmltask.list.results";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    MLRoutingService.goToRouteSuffixIfBase($state, toState, toParams, fromState, fromParams, baseRoute, "sessions", event);
                });

                if ($state.current.name === baseRoute) {
                    $timeout(() => $state.go(".sessions", null, {location: 'replace'}));
                }
            }
        });

        for (const {route, templateUrl} of MLRoutingService.allResultsRoutes) {
            $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.list.results.' + route, {
                url: "/" + route,
                templateUrl: templateUrl,
                controller: function($scope) {
                    $scope.setViewMode(route);
                },
            });
        }

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model', {
            url: '/:fullModelId',
            abstract: true,
            template: '<div ui-view></div>'
        });
        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model.predictedtable', {
            url: '/table/',
            templateUrl: '/templates/analysis/clustering/model/c-model-predicted-table.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model.predictedcharts', {
            url: '/charts/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/analysis/clustering/model/c-model-predicted-charts.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model.report', {
            url: '/report',
            templateUrl: '/templates/analysis/clustering/model/c-model-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseRoute = "projects.project.analyses.analysis.ml.clustmltask.model.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    MLRoutingService.goToRouteSuffixIfBase($state, toState, toParams, fromState, fromParams, baseRoute, "summary", event);
                });

                if ($state.current.name === baseRoute) {
                    $timeout(() => $state.go(".summary", null, {location: 'replace'}));
                }
            }
        });

        for (const {route, templateUrl, routeOptions} of MLRoutingService.clusteringReportRoutes) {
            createMLSubRoute($stateProvider, 'projects.project.analyses.analysis.ml.clustmltask.model.report', templateUrl, route, null, routeOptions);
        }

        createMLModelViewRoute($stateProvider, "projects.project.analyses.analysis.ml.clustmltask.model.report");

        /* ************************** Saved Model (Flow) ********************** */

        $stateProvider.state('projects.project.savedmodels', {
            url: '/savedmodels',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.list', {
            url: '/',
            templateUrl: '/templates/savedmodels/list.html',
            controller: "SavedModelListController",
            pageTitle: () => {
                return " Saved Models"
            }
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel', {
            url: '/:smId?discussionId',
            abstract: true,
            controller: "SavedModelController",
            templateUrl: '/templates/savedmodels/savedmodel.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.settings', {
            url: '/settings/',
            controller: "SavedModelSettingsController",
            templateUrl: '/templates/savedmodels/settings.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.status', {
            url: '/status',
            templateUrl: '/templates/savedmodels/status.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.status.metrics', {
            url: '/metrics/',
            templateUrl: '/templates/savedmodels/status-metrics.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.status.checks', {
            url: '/checks/',
            templateUrl: '/templates/savedmodels/status-checks.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.versions', {
            url: '/versions/?redirectToActiveVersion',
            controller: "SavedModelVersionsController",
            templateUrl: '/templates/savedmodels/versions.html'
        });

        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.prediction', '.report', '/p/:fullModelId?exportMode?treatment');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.prediction.legacysummary', '^.report', '/tabular-summary');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.prediction.trailingslash', '^.report', '/');

        $stateProvider.state('projects.project.savedmodels.savedmodel.prediction.report', {
            url: '/report',
            templateUrl: '/templates/savedmodels/prediction-report.html',
            controller: "MLBaseRouteReportController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.prediction.predictedtable', {
            url: '/table',
            templateUrl: '/templates/savedmodels/prediction-saved-model-predicted-table.html'
        });

        for (const {route, templateUrl, routeOptions} of MLRoutingService.allPredictionReportRoutes) {
            createMLSubRoute($stateProvider, 'projects.project.savedmodels.savedmodel.prediction.report', templateUrl, route, null, routeOptions);
        }

        createMLModelViewRoute($stateProvider, "projects.project.savedmodels.savedmodel.prediction.report");

        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.clustering', '.report', '/c/:fullModelId');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.clustering.legacysummary', '^.report', '/summary');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.clustering.trailingslash', '^.report', '/');

        $stateProvider.state('projects.project.savedmodels.savedmodel.clustering.report', {
            url: '/report',
            templateUrl: '/templates/savedmodels/clustering-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseRoute = "projects.project.savedmodels.savedmodel.clustering.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    MLRoutingService.goToRouteSuffixIfBase($state, toState, toParams, fromState, fromParams, baseRoute, "summary", event);
                });

                if ($state.current.name === baseRoute) {
                    $timeout(() => $state.go(".summary", null, {location: 'replace'}));
                }
            }
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.clustering.predictedtable', {
            url: '/table',
            templateUrl: '/templates/savedmodels/clustering-saved-model-predicted-table.html'
        });

        for (const {route, templateUrl, routeOptions} of MLRoutingService.clusteringReportRoutes) {
            createMLSubRoute($stateProvider, 'projects.project.savedmodels.savedmodel.clustering.report', templateUrl, route, null, routeOptions);
        }

        createMLModelViewRoute($stateProvider, "projects.project.savedmodels.savedmodel.clustering.report");

        $stateProvider.state('projects.project.savedmodels.savedmodel.llmGeneric', {
            url: '/llm-generic',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.llmGeneric.report', {
            url: '/:fullModelId',
            templateUrl: '/templates/savedmodels/llm-generic-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseRoute = "projects.project.savedmodels.savedmodel.llmGeneric.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    MLRoutingService.goToRouteSuffixIfBase($state, toState, toParams, fromState, fromParams, baseRoute, "summary", event);
                });

                if ($state.current.name === baseRoute) {
                    $timeout(() => $state.go(".summary", null, {location: 'replace'}));
                }
            }
        });

        for (const {route, templateUrl, routeOptions} of MLRoutingService.llmReportRoutes) {
            createMLSubRoute($stateProvider, 'projects.project.savedmodels.savedmodel.llmGeneric.report', templateUrl, route, null, routeOptions);
        }

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent', {
            url: '/agent',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.design', {
            url: '/:fullModelId',
            templateUrl: '/templates/savedmodels/agents/agent-version-design.html',
            controller: "AgentSavedModelDesignController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.settings', {
            url: '/:fullModelId/settings',
            templateUrl: '/templates/savedmodels/agents/agent-version-settings.html',
            controller: "AgentSavedModelSettingsController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.logs', {
            url: '/:fullModelId/logs',
            templateUrl: '/templates/savedmodels/agents/agent-version-logs.html',
            controller: "AgentSavedModelLogsController"
        });
        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.history', {
            url: '/:fullModelId/history',
            controller: "AgentVersionHistoryController",
            templateUrl: '/templates/savedmodels/saved-model-git-log.html'
        });
        $stateProvider.state('projects.project.savedmodels.savedmodel.history', {
            url: '/history',
            controller: "AgentSavedModelHistoryController",
            templateUrl: '/templates/savedmodels/saved-model-git-log.html'
        });


        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm', {
            url: '/retrieval-augmented-llm',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm.design', {
            url: '/:fullModelId',
            templateUrl: '/templates/savedmodels/retrieval-augmented-llm/retrieval-augmented-llm-version-design.html',
            controller: "RetrievalAugmentedLLMSavedModelDesignController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm.settings', {
            url: '/:fullModelId/settings',
            templateUrl: '/templates/savedmodels/retrieval-augmented-llm/retrieval-augmented-llm-version-settings.html',
            controller: "RetrievalAugmentedLLMSavedModelSettingsController"
        });
        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm.history', {
            url: '/:fullModelId/history',
            templateUrl: '/templates/savedmodels/saved-model-git-log.html',
            controller: "RetrievalAugmentedLLMSavedModelHistoryController"
        });

        /* ************************** GenAI Models and Agents ********************** */

        $stateProvider.state('projects.project.genai', {
            url: '/genai',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.genai.list', {
            url: '/',
            templateUrl: '/templates/genai/list.html',
            controller: "GenAIListController",
            pageTitle: () => {
                return " GenAI Models and Agents"
            }
        });

        /* **************************  Model Comparisons (Flow) ********************** */

        $stateProvider.state('projects.project.modelcomparisons', {
            url: '/modelcomparisons',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.modelcomparisons.list', {
            url: '/',
            templateUrl: '/templates/modelcomparisons/list.html',
            controller: "modelComparisonListController",
            pageTitle: () => {
                return " Model Comparisons"
            }
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison', {
            url: '/:modelComparisonId?discussionId',
            templateUrl: '/templates/modelcomparisons/modelcomparison.html',
            controller: "modelComparisonController"
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.summary', {
            url: '/summary',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.feature_importance', {
            url: '/feature_importance',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.decision_chart', {
            url: '/decision_chart',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.lift_chart', {
            url: '/lift_chart',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.calibration_curve', {
            url: '/calibration_curve',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.roc_curve', {
            url: '/roc_curve',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.pr_curve', {
            url: '/pr_curve',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.density_chart', {
            url: '/density_chart',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.scatter_plot', {
            url: '/scatter_plot',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.uplift_charts', {
            url: '/uplift_charts',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.features', {
            url: '/features',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });


        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.training_information', {
            url: '/training_information',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.algorithm', {
            url: '/algorithm',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.ts_resampling', {
            url: '/timeseries_resampling',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.row_by_row_analysis', {
            url:'/row_by_row_analysis',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        })

        /* **************************  Model Evaluation Store (Flow) ********************** */

        $stateProvider.state('projects.project.modelevaluationstores', {
            url: '/modelevaluationstores',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.modelevaluationstores.list', {
            url: '/',
            templateUrl: '/templates/modelevaluationstores/list.html',
            controller: "ModelEvaluationStoreListController",
            pageTitle: () => {
                return " Model Evaluation Stores"
            }
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore', {
            url: '/:mesId?discussionId',
            abstract: true,
            controller: "ModelEvaluationStoreController",
            templateUrl: '/templates/modelevaluationstores/modelevaluationstore.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.evaluations', {
            url: '/evaluations/',
            controller: "ModelEvaluationStoreEvaluationsController",
            templateUrl: '/templates/modelevaluationstores/evaluations.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.llmevaluation', {
            url: '/llmevaluations/:evaluationId',
            abstract: true,
            controller: "ModelEvaluationStoreLlmEvaluationController",
            template: '<div class="h100 vertical-flex model-evaluation__page"><div block-api-error /><div ui-view class="flex"></div></div>'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.evaluation', {
            url: '/evaluations/:evaluationId',
            abstract: true,
            controller: "ModelEvaluationStoreBaseEvaluationController",
            templateUrl: '/templates/modelevaluationstores/evaluation.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.evaluation.report', {
            url: '/report?driftReference',
            reloadOnSearch: false,
            templateUrl: '/templates/modelevaluationstores/evaluation-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseRoute = "projects.project.modelevaluationstores.modelevaluationstore.evaluation.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    MLRoutingService.goToRouteSuffixIfBase($state, toState, toParams, fromState, fromParams, baseRoute, "tabular-summary", event);
                });

                if ($state.current.name === baseRoute) {
                    $timeout(() => $state.go(".tabular-summary", null, {location: 'replace'}));
                }
            }
        });

        for (const routes of [MLRoutingService.tabularReportRoutes, MLRoutingService.classicalReportRoutes, MLRoutingService.llmEvaluationReportRoutes, MLRoutingService.timeseriesReportRoutes]) {
            for (const {route, templateUrl, routeOptions} of routes) {
                createMLSubRoute($stateProvider, 'projects.project.modelevaluationstores.modelevaluationstore.evaluation.report', templateUrl, route, null, routeOptions);
            }
        }

        createMLModelViewRoute($stateProvider, "projects.project.modelevaluationstores.modelevaluationstore.evaluation.report");

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.status', {
            url: '/status',
            templateUrl: '/templates/modelevaluationstores/status.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.status.metrics', {
            url: '/metrics/',
            templateUrl: '/templates/modelevaluationstores/status-metrics.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.status.checks', {
            url: '/checks/',
            templateUrl: '/templates/modelevaluationstores/status-checks.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.settings', {
            url: '/settings/',
            controller: "ModelEvaluationStoreSettingsController",
            templateUrl: '/templates/modelevaluationstores/settings.html'
        });

        /* ************************** Retrievable Knowledge (flow) ********************** */

        $stateProvider.state('projects.project.retrievableknowledges', {
            url: '/knowledge-bank',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.retrievableknowledges.list', {
            url: '/',
            templateUrl: '/templates/retrievable-knowledge/list.html',
            controller: "RetrievableKnowledgeListController",
            pageTitle: () => {
                return " Knowledge Banks"
            }
        });

        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge', {
            url: '/:retrievableKnowledgeId',
            abstract: true,
            controller: "RetrievableKnowledgeController",
            templateUrl: '/templates/retrievable-knowledge/retrievable-knowledge.html'
        });

        // TODO @llm rag: add query tab
        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge.query', {
            url: '/query/',
            controller: "RetrievableKnowledgeQueryController",
            templateUrl: '/templates/retrievable-knowledge/query.html'
        });

        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge.usage', {
            url: '/usage/',
            controller: "RetrievableKnowledgeUsageController",
            templateUrl: '/templates/retrievable-knowledge/usage.html'
        });

        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge.settings', {
            url: '/settings/',
            controller: "RetrievableKnowledgeSettingsController",
            templateUrl: '/templates/retrievable-knowledge/settings.html'
        });

        /* ************************** Labeling Task (Flow) ********************** */
        $stateProvider.state('projects.project.labelingtasks', {
            url: '/labelingtasks',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.labelingtasks.list', {
            url: '/',
            controller: "LabelingTasksListController",
            templateUrl: '/templates/labelingtasks/list.html',
            pageTitle: () => {
                return "Labeling tasks";
            }
        });

        $stateProvider.state('projects.project.labelingtasks.labelingtask', {
            url: '/:labelingTaskId?discussionId&identifier',
            controller: "LabelingTaskController",
            templateUrl: '/templates/labelingtasks/labelingtask.html',
            pageTitle: () => {
                return "Labeling task";
            }
        });

        $stateProvider.state('projects.project.labelingtasks.labelingtask.annotate', {
            url: '/annotate/',
            controller: 'LabelingTaskAnnotateController'
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.review', {
            url: '/review/',
            controller: "LabelingTaskReviewController",
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.overview', {
            url: '/overview/',
            controller: "LabelingTaskOverviewController",
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.io', {
            url: '/io/',
            controller: "LabelingTaskIOController",
            templateUrl: '/templates/labelingtasks/labeling-task-io-tab.html'
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.settings', {
            url: '/settings/:selectedTab',
            controller: "LabelingTaskSettingsController",
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.history', {
            url: '/history/',
            controller: 'LabelingTaskHistoryController',
            templateUrl: '/templates/labelingtasks/labeling-task-history.html',
        });


        /* ************************** Managed folder (Flow) ********************** */

        $stateProvider.state('projects.project.managedfolders', {
            url: '/managedfolder',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder', {
            url: '/:odbId?discussionId',
            abstract: true,
            controller: "ManagedFolderBaseController",
            templateUrl: '/templates/managedfolder/managedfolder.html'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.view', {
            url: '/view/',
            params: {
                preUploadedFiles: null,
            },
            controller: "ManagedFolderViewController",
            templateUrl: '/templates/managedfolder/view.html',
            pageTitle: () => {
                return " Folder";
            }
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.settings', {
            url: '/settings/',
            controller: "ManagedFolderSettingsController",
            templateUrl: '/templates/managedfolder/settings.html',
            pageTitle: () => {
                return " Folder";
            }
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status', {
            url: '/status',
            abstract: true,
            templateUrl: '/templates/managedfolder/status.html',
            controller: 'ManagedFolderStatusController',
            pageTitle: () => {
                return " Folder";
            }
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status.settings', {
            url: '/settings',
            templateUrl: '/templates/managedfolder/status-settings.html'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status.metrics', {
            url: '',
            templateUrl: '/templates/managedfolder/status-metrics.html'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status.checks', {
            url: '/checks',
            templateUrl: '/templates/managedfolder/status-checks.html'
        });

        /* ************************** Foreign view of managed folders ********************** */

        $stateProvider.state('projects.project.foreignmanagedfolders', {
            url: '/foreignmanagedfolder',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.foreignmanagedfolders.managedfolder', {
            url: '/:odbId?discussionId?sourceProjectKey',
            abstract: true,
            controller: "ManagedFolderBaseController",
            templateUrl: '/templates/foreignmanagedfolder/managedfolder.html'
        });
        $stateProvider.state('projects.project.foreignmanagedfolders.managedfolder.view', {
            url: '/view/',
            controller: "ManagedFolderViewController",
            templateUrl: '/templates/managedfolder/view.html',
            pageTitle: () => {
                return " Folder";
            }
        });
        /* ************************** Recipes ********************** */

        $stateProvider.state('projects.project.recipes', {
            url: '/recipes',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.recipes.list', {
            url: '/',
            templateUrl: '/templates/recipes/list.html',
            controller: 'RecipesListController',
            pageTitle: () => {
                return "Recipes";
            }
        });

        $stateProvider.state('projects.project.recipes.new', {
            url: '/new/:type/?prefill&input&output',
            templateUrl: '/templates/recipes/recipe-editor.html',
            controller: 'RecipeEditorController',
            pageTitle: function(stateParams) {
                return "New " + stateParams.type + " recipe";
            }
        });

        $stateProvider.state('projects.project.recipes.recipe', {
            url: '/:recipeName/?newlyCreated?discussionId',
            templateUrl: '/templates/recipes/recipe-editor.html',
            controller: 'RecipeEditorController',
            pageTitle: function(stateParams) {
                return stateParams.recipeName + " - Recipe";
            },
            params: { isAIGenerated: false }
        });

        /* ************************** Flow jobs / monitoring  ********************** */

        $stateProvider.state('projects.project.jobs', {
            url: '/jobs',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.jobs.list', {
            url: '/',
            templateUrl: '/templates/jobs/list.html',
            controller: 'FlowJobsBrowserController',
            pageTitle: () => {
                return "Jobs";
            }
        });

        $stateProvider.state('projects.project.jobs.job', {
            url: '/:jobId/?hideFlow',
            templateUrl: '/templates/jobs/job-status.html',
            pageTitle: function(stateParams) {
                return "Job " + stateParams.jobId + "";
            },
        });

        $stateProvider.state('projects.project.datasets.new', {
            url: '/new/?zoneId',
            templateUrl: '/templates/datasets/new-dataset.html',
            controller: function($scope, CreateModalFromTemplate, TopNav, GlobalProjectActions) {
                TopNav.setItem(null);
                TopNav.setLocation(TopNav.TOP_FLOW, "new-dataset", TopNav.TABS_NONE, null);
                $scope.newManagedDataset = function() {
                    CreateModalFromTemplate("/templates/flow-editor/new-managed-dataset.html",
                        $scope, "NewManagedDatasetController");
                };

                GlobalProjectActions.getAllDatasetsByTiles($scope).then(val => $scope.datasetTiles = val);
                GlobalProjectActions.getHighlightedDatasets($scope).then(val => $scope.highlightedDatasets = val);
                $scope.startDatasetCreation = GlobalProjectActions.startDatasetCreation;

                // similar to what's done for the new dataset menu. Instead of a submenu, we show a tile
                const pluginSections = {};
                // get connectors, grouped by ownerPluginId
                $scope.appConfig.customDatasets.forEach(function(x) {
                    let pluginSection = pluginSections[x.ownerPluginId];
                    if (pluginSection == null) {
                        pluginSection = {
                            pluginId: x.ownerPluginId,
                            items: []
                        };
                        pluginSections[x.ownerPluginId] = pluginSection;
                    }

                    pluginSection.items.push({
                        type: x.datasetType,
                        label: x.desc.meta != null && x.desc.meta.label != null ? x.desc.meta.label : x.ownerPluginId,
                        icon: x.desc.meta != null ? x.desc.meta.icon : null
                    });
                });
                // get fs providers, grouped by ownerPluginId
                $scope.appConfig.customFSProviders.forEach(function(x) {
                    let pluginSection = pluginSections[x.ownerPluginId];
                    if (pluginSection == null) {
                        pluginSection = {
                            pluginId: x.ownerPluginId,
                            items: []
                        };
                        pluginSections[x.ownerPluginId] = pluginSection;
                    }

                    pluginSection.items.push({
                        type: x.fsProviderType,
                        label: x.desc.meta != null && x.desc.meta.label != null ? x.desc.meta.label : x.ownerPluginId,
                        icon: x.desc.meta != null ? x.desc.meta.icon : null
                    });
                });
                // fetch plugin label for each ownerPluginId
                $scope.customConnectorPlugins = [];
                $.each(pluginSections, function(pluginId, pluginData) {
                    const plugin = Array.dkuFindFn($scope.appConfig.loadedPlugins, function(n) {
                        return n.id == pluginId
                    });
                    if (plugin == null || plugin.hideComponents) {
                        return;
                    }
                    pluginData.items.forEach(function(dtype) {
                        if (!dtype.icon) dtype.icon = plugin.icon;
                    });
                    $scope.customConnectorPlugins.push({
                        isSection: true,
                        id: "plugin_" + plugin.id,
                        icon: plugin.icon,
                        label: plugin.label || plugin.id,
                        connectors: pluginData.items,
                        plugin: plugin
                    });
                });
            },
            pageTitle: () => {
                return "New dataset";
            }
        });

        /* ************************** Notebooks (SQL and jupyter) ********************** */

        $stateProvider.state('projects.project.notebooks', {
            url: '/notebooks',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projects.project.notebooks.list', {
            url: '/?datasetId',
            templateUrl: '/templates/notebooks/list.html',
            controller: 'NotebooksController',
            pageTitle: () => {
                return "Notebooks";
            }
        });

        $stateProvider.state('projects.project.notebooks.jupyter_notebook', {
            url: '/jupyter/:notebookId/?discussionId&kernel_name',
            templateUrl: '/templates/notebooks/jupyter_notebook.html',
            controller: 'IPythonController',
            pageTitle: function(stateParams) {
                return stateParams.notebookId + " | Jupyter notebook";
            }
        });

        $stateProvider.state('projects.project.notebooks.jupyter_notebook_copied', {
            url: '/jupyter/:notebookId/copy/',
            templateUrl: '/templates/notebooks/jupyter_notebook.html',
            controller: function($scope, $stateParams, $sce) {
                $scope.$stateParams = $stateParams;
                $scope.notebookURL = $sce.getTrustedResourceUrl("/jupyter/notebooks/" + $stateParams.projectKey + "/" + $stateParams.notebookId + '/copy');
            },
            pageTitle: () => {
                return "Jupyter notebook";
            }
        });

        $stateProvider.state('projects.project.notebooks.sql_notebook', {
            url: '/sql/:notebookId/?discussionId',
            templateUrl: '/templates/notebooks/sql_notebook.html',
            controller: 'SQLNotebookController',
            // The user-friendly name is not in the stateParams, so the controller overrides the title
            pageTitle: () => {
                return "SQL notebook";
            },
            params: { cellId: null }
        });

        $stateProvider.state('projects.project.notebooks.search_notebook', {
            url: '/search/:notebookId/?discussionId',
            templateUrl: '/templates/notebooks/search-notebook.html',
            controller: 'SearchNotebookController',
            // The user-friendly name is not in the stateParams, so the controller overrides the title
            pageTitle: () => {
                return "Search notebook";
            }
        });

        $stateProvider.state('projects.project.promptstudios', {
            url: '/prompt-studios',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projects.project.promptstudios.list', {
            url: '/',
            templateUrl: '/templates/promptstudios/list.html',
            controller: 'PromptStudiosListController',
            pageTitle: () => {
                return "Prompt Studios";
            }
        });

        $stateProvider.state('projects.project.promptstudios.promptstudio', {
            url: '/:promptStudioId',
            params: { promptId: null},
            templateUrl: '/templates/promptstudios/prompt-studio.html',
            controller: 'PromptStudioController'
        });

        $stateProvider.state('projects.project.promptstudios.promptstudio.prompt', {
            url: '/prompt/:promptId'
        });


        $stateProvider.state('projects.project.agenttools', {
            url: '/agent-tools',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projects.project.agenttools.list', {
            url: '/?createTool',
            templateUrl: '/templates/agent-tools/list.html',
            controller: 'AgentToolsListController',
            params: {
                createTool: { value: null }
            },
            pageTitle: () => {
                return "Agent Tools";
            }
        });

        $stateProvider.state('projects.project.agenttools.agenttool', {
            url: '/:agentToolId',
            templateUrl: '/templates/agent-tools/agent-tool.html',
            controller: 'AgentToolController'
        });


        /* ************************** RStudio Server ********************** */

        $stateProvider.state('projects.project.rstudioserver', {
            url: '/rstudio-server',
            abstract: true,
            template: "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.rstudioserver.embed', {
            url: '/',
            templateUrl: '/templates/rstudio-server/embed.html',
            controller: "RStudioServerEmbedController",
            pageTitle: () => {
                return "RStudio Server"
            }
        });

        /* ***************** Webapps ********************** */

        $stateProvider.state('projects.project.webapps', {
            url : "/webapps",
            abstract : true,
            template : "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.webapps.list', {
            url : "/",
            templateUrl: '/templates/webapps/list.html',
            controller: 'WebAppsListController',
            pageTitle: () => {
                return "Webapps";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp', {
            url : "/{webAppId}_{webAppName}?discussionId",
            templateUrl: '/templates/webapps/webapp.html',
            controller: 'WebAppCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.webapps.webapp.edit', {
            url : "/edit?{safe-mode}",
            templateUrl: '/templates/webapps/edit.html',
            pageTitle: () => {
                return "Webapp";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp.view', {
            url : "/view",
            templateUrl: '/templates/webapps/view.html',
            pageTitle: () => {
                return "Webapp";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp.history', {
            url : "/history",
            templateUrl: '/templates/webapps/history.html',
            controller : "WebAppHistoryController",
            pageTitle: () => {
                return "Webapp";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp.logs', {
            url : "/logs",
            templateUrl: '/templates/webapps/logs.html',
            pageTitle: () => {
                return "Webapp";
            }
        });

        /* ***************** CodeStudios ********************** */

        $stateProvider.state('projects.project.code-studios', {
            url : "/code-studios",
            abstract : true,
            template : "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.code-studios.list', {
            url : "/",
            templateUrl: ' /templates/code-studios/list.html',
            controller: 'CodeStudiosListController',
            pageTitle: () => "Code Studios"
        });

        $stateProvider.state('projects.project.code-studios.code-studio', {
            url : "/{codeStudioObjectId}?discussionId",
            templateUrl: ' /templates/code-studios/code-studio.html',
            controller: 'CodeStudioCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.code-studios.code-studio.view', {
        url : "/view?zone&file",
            templateUrl: ' /templates/code-studios/view.html',
            controller: 'CodeStudioViewController'
        });

        $stateProvider.state('projects.project.code-studios.code-studio.actions', {
            url : "/actions",
            templateUrl: ' /templates/code-studios/actions.html',
            controller: 'CodeStudioActionsController'
        });

        $stateProvider.state('projects.project.code-studios.code-studio.logs', {
            url : "/logs",
            templateUrl: ' /templates/code-studios/logs.html',
            controller: 'CodeStudioLogsController',
            params: {
                tab: ''
            }
        });

        $stateProvider.state('projects.project.code-studios.code-studio.files', {
            url : "/files",
            templateUrl: ' /templates/code-studios/files.html',
            controller: 'CodeStudioFilesController'
        });


        /* ***************** Reports ********************** */

        $stateProvider.state('projects.project.reports', {
            url : "/report",
            abstract : true,
            template : "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.reports.list', {
            url : "/",
            templateUrl: '/templates/code-reports/list.html',
            controller: 'ReportsListController',
            pageTitle: () => {
                return "Report";
            }
        });

        $stateProvider.state('projects.project.reports.report', {
            url : "/{reportId}?discussionId",
            templateUrl: '/templates/code-reports/report.html',
            controller: 'ReportCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.reports.report.edit', {
            url : "/edit",
            templateUrl: '/templates/code-reports/edit.html',
            controller: 'ReportEditController',
            pageTitle: () => {
                return "Report";
            }
        });

        $stateProvider.state('projects.project.reports.report.view', {
            url : "/view",
            templateUrl: '/templates/code-reports/view.html',
            controller: 'ReportViewController',
            pageTitle: () => {
                return "Report";
            }
        });

        $stateProvider.state('projects.project.reports.report.history', {
            url : "/history",
            templateUrl: '/templates/code-reports/history.html',
            controller : "ReportHistoryController",
            pageTitle: () => {
                return "Report";
            }
        });

        /* ***************** Dashboards ********************** */

        $stateProvider.state('projects.project.dashboards', {
            url: "/dashboards",
            abstract: true,
            template: "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.dashboards.list', {
            url: "/",
            templateUrl: '/templates/dashboards/list.html',
            controller: 'DashboardsListController',
            pageTitle: () => {
                return "Dashboards";
            }
        });

        $stateProvider.state('projects.project.dashboards.dashboard', {
            // eslint-disable-next-line no-useless-escape
            url: "/{dashboardId:[0-9a-zA-Z]*}{separator:\_{0,1}}{dashboardName}?discussionId",
            templateUrl: '/templates/dashboards/dashboard.html',
            controller: 'DashboardCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.dashboards.dashboard.edit', {
            url: "/edit/:pageId",
            templateUrl: '/templates/dashboards/edit.html',
            controller: "DashboardEditController",
            pageTitle: () => {
                return "Dashboard";
            }
        });

        $stateProvider.state('projects.project.dashboards.dashboard.view', {
            // to avoid the tilde character to be doubled by angular-ui, we specify the type of the query params as any
            // https://github.com/angular-ui/ui-router/issues/3790
            url: "/view/:pageId?fullScreen&embedded&{filters:any}&{pageFilters:any}",
            reloadOnSearch: false, // Do not reload page on filters param change
            templateUrl: '/templates/dashboards/view.html',
            controller: function($scope, TopNav) {
                TopNav.setLocation(TopNav.TOP_DASHBOARD, 'dashboards', null, 'view');
                if ($scope.dashboard) {
                    TopNav.setPageTitle($scope.dashboard.name + " - Dashboard");
                }
            },
            pageTitle: () => {
                return "Dashboard";
            }
        });

        $stateProvider.state('projects.project.dashboards.insights', {
            url: "/insights",
            abstract: true,
            template: "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.dashboards.insights.list', {
            url: "/",
            templateUrl: '/templates/dashboards/insights/list.html',
            controller: 'InsightsListController',
            pageTitle: () => {
                return "Insights";
            }
        });

        $stateProvider.state('projects.project.dashboards.insights.insight', {
            url: "/{insightId:[0-9a-zA-Z_-]*}_{insightName}?discussionId&{originDashboard:json}",
            templateUrl: '/templates/dashboards/insights/insight.html',
            controller: 'InsightCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.dashboards.insights.insight.edit', {
            url: "/edit?tabSelect&sections",
            templateUrl: '/templates/dashboards/insights/edit.html',
            controller: "InsightEditController",
            pageTitle: () => {
                return "Insight";
            }
        });

        $stateProvider.state('projects.project.dashboards.insights.insight.view', {
            url: "/view?fullScreen",
            templateUrl: '/templates/dashboards/insights/view.html',
            controller: "InsightViewController",
            pageTitle: () => {
                return "Insight";
            }
        });

        $stateProvider.state('projects.project.dashboards.insights.insight.view.savedmodels', {
            url: "/savedmodels",
            templateUrl: '/templates/dashboards/insights/saved-model_report/saved-model_report_view.html',
            controller: "SavedModelReportInsightController"
        });

        $stateProvider.state('projects.project.dashboards.insights.insight.view.modelevaluations', {
            url: "/modelevaluations",
            templateUrl: '/templates/dashboards/insights/model-evaluation_report/model-evaluation_report_view.html',
            controller: "ModelEvaluationReportInsightController"
        });

        $stateProvider.state('projects.project.dashboards.insights.insight.view.savedmodels.clustering', {
            url: "/clustering",
            templateUrl: '/templates/ml/clustering-model/clustering-model-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseRoute = "projects.project.dashboards.insights.insight.view.savedmodels.clustering";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    MLRoutingService.goToRouteSuffixIfBase($state, toState, toParams, fromState, fromParams, baseRoute, "summary", event);
                });

                if ($state.current.name === baseRoute) {
                    $timeout(() => $state.go(".summary", null, {location: 'replace'}));
                }
            }
        });

        for (const {route, templateUrl, routeOptions} of MLRoutingService.clusteringReportRoutes) {
            createMLSubRoute($stateProvider, 'projects.project.dashboards.insights.insight.view.savedmodels.clustering', templateUrl, route, null, routeOptions);
        }

        createMLModelViewRoute($stateProvider, "projects.project.dashboards.insights.insight.view.savedmodels.clustering");

        $stateProvider.state('projects.project.dashboards.insights.insight.view.savedmodels.prediction', {
            url: "/prediction?treatment",
            templateUrl: '/templates/ml/prediction-model/prediction-model-report.html',
            abstract: true,
            controller: function($scope) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }
            }
        });

        for (const {route, templateUrl, routeOptions} of MLRoutingService.allPredictionReportRoutes) {
            createMLSubRoute($stateProvider, 'projects.project.dashboards.insights.insight.view.savedmodels.prediction', templateUrl, route, null, routeOptions);
        }

        createMLModelViewRoute($stateProvider, "projects.project.dashboards.insights.insight.view.savedmodels.prediction");

        $stateProvider.state('projects.project.dashboards.insights.insight.view.modelevaluations.prediction', {
            url: "/prediction?treatment",
            templateUrl: '/templates/ml/prediction-model/prediction-model-report.html',
            abstract: true,
            controller: function($scope) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }
            }
        });

        for (const routes of [MLRoutingService.tabularReportRoutes, MLRoutingService.classicalReportRoutes, MLRoutingService.llmEvaluationReportRoutes, MLRoutingService.timeseriesReportRoutes]) {
            for (const {route, templateUrl, routeOptions} of routes) {
                createMLSubRoute($stateProvider, 'projects.project.dashboards.insights.insight.view.modelevaluations.prediction', templateUrl, route, null, routeOptions);
            }
        }
        createMLModelViewRoute($stateProvider, "projects.project.dashboards.insights.insight.view.modelevaluations.prediction");

        /* ************************** Bundles ********************** */

        // DSS Design node

        $stateProvider.state('projects.project.bundlesdesign', {
            url: '/bundles-design',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.bundlesdesign.list', {
            url: '/?showProgressModalFor&bundleId&bundleTab',
            templateUrl: '/templates/bundles/design/list.html',
            controller: "DesignBundlesListController",
            pageTitle: () => {
                return "Bundles export";
            }
        });

        $stateProvider.state('projects.project.bundlesdesign.new', {
            url: '/new/',
            templateUrl: '/templates/bundles/design/new.html',
            controller: "DesignBundlesNewController",
            pageTitle: () => {
                return "Create bundle";
            }
        });

        // DSS Automation node

        $stateProvider.state('projects.project.bundlesautomation', {
            url: '/bundles-automation',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.bundlesautomation.list', {
            url: '/',
            templateUrl: '/templates/bundles/automation/list.html',
            controller: "AutomationBundlesListController",
            pageTitle: () => {
                return "Bundles management";
            }
        });

        $stateProvider.state('projects.project.bundlesautomation.settings', {
            url: '/settings/',
            templateUrl: '/templates/bundles/automation/activation-settings.html',
            controller: "AutomationBundlesSettingsController",
            pageTitle: () => {
                return "Bundles settings";
            }
        });

        /* ************************** Mass import           ********************** */
        $stateProvider.state('projects.project.tablesimport', {
            url: '/import-tables?zoneId',
            templateUrl: '/templates/datasets/project-tables-import.html',
            controller: 'ProjectMassTableToDatasetController',
            params: {
                importData: null
            },
            pageTitle: () => {
                return "Import tables";
            }
        });

        $stateProvider.state('alationOpen', {
            url: '/alation-open/:alationOpenId',
            templateUrl: '/templates/datasets/alation-open.html',
            controller: "AlationOpenController",
            pageTitle: () => {
                return "Mass import";
            }
        });

        /* ************************** API Services (Lambda) ********************** */

        $stateProvider.state('projects.project.lambdaservices', {
            url: '/api-designer',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.lambdaservices.list', {
            url: '/',
            templateUrl: '/templates/lambda/list.html',
            controller: "LambdaServicesListController",
            pageTitle: () => {
                return "API Services";
            }
        });

        $stateProvider.state('projects.project.lambdaservices.service', {
            url: '/:serviceId?discussionId',
            abstract: true,
            controller: "LambdaServiceBaseController",
            templateUrl: '/templates/lambda/lambda-service.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.summary', {
            url: '/summary/',
            controller: "LambdaServiceSummaryController",
            templateUrl: '/templates/lambda/summary.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.endpoints', {
            url: '/endpoints/',
            controller: "LambdaServiceEndpointsController",
            templateUrl: '/templates/lambda/endpoints.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.config', {
            url: '/config/',
            controller: "LambdaServiceConfigController",
            templateUrl: '/templates/lambda/lambda-service-config.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.packages', {
            url: '/packages/',
            controller: "LambdaServicePackagesController",
            templateUrl: '/templates/lambda/packages.html'
        });

        /* ************************** Wiki ********************** */

        $stateProvider.state('projects.project.wiki', {
            url: '/wiki',
            controller: "WikiController",
            templateUrl: '/templates/wikis/wiki.html'
        });

        $stateProvider.state('projects.project.wiki.article', {
            url: '/:articleId/:articleName?fullScreen',
            abstract: true,
            controller: "ArticleController",
            params: {
                // When no articleName is given through the URL, the router will act as if it didn't exist
                // (aka having url:'/:articleId')
                articleName: {squash: true, value: null}
            },
            templateUrl: '/templates/wikis/article.html'
        });

        // templates for the 3 sub-routes for wiki are handled through ng-show and ng-if instead of ui-view because we need to keep the editor state when switching tabs
        // note that history template is kept at the top in order to trigger infinite-scroll directive when switching tabs
        $stateProvider.state('projects.project.wiki.article.view', {
            url: '?discussionId'
        });

        $stateProvider.state('projects.project.wiki.article.edit', {
            url: '/edit'
        });

        $stateProvider.state('projects.project.wiki.article.history', {
            url: '/history'
        });

        $stateProvider.state('projects.wikis', { //mjt placeholder for the page PC is writing
            url: '/wikis',
            templateUrl: '/templates/wikis/article-history.html'
        });

        /* ************************** Scenarios ********************** */

        $stateProvider.state('projects.project.scenarios', {
            url: '/scenarios',
            abstract: true,
            controller: "ScenarioCoreController",
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.scenarios.list', {
            url: '/',
            templateUrl: '/templates/scenarios/list.html',
            controller: "ScenariosListController",
            pageTitle: () => {
                return "Scenarios";
            }
        });

        $stateProvider.state('projects.project.scenarios.scenario', {
            url: '/:scenarioId?discussionId',
            templateUrl: '/templates/scenarios/scenario.html',
            controller: "ScenarioController",
            pageTitle: () => {
                return "Scenario";
            }
        });

        $stateProvider.state('projects.project.scenarios.scenario.settings', {
            url: '/settings',
            templateUrl: '/templates/scenarios/fragments/scenario-settings.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.runs', {
            url: '/runs',
            abstract: true,
            templateUrl: '/templates/scenarios/fragments/scenario-runs-timeline.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.runs.list', {
            url: '/list',
            templateUrl: '/templates/scenarios/fragments/scenario-runs.html'
        });
        // same as above, but go directly to a run
        $stateProvider.state('projects.project.scenarios.scenario.runs.list.run', {
            url: '/:runId',
            templateUrl: '/templates/scenarios/scenario.html',
            controller: "ScenarioRunController",
            pageTitle: () => {
                return "Scenario";
            }
        });

        $stateProvider.state('projects.project.scenarios.scenario.runs.timeline', {
            url: '/timeline',
            templateUrl: '/templates/scenarios/fragments/scenario-timeline.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.history', {
            url: '/history',
            controller: "ScenarioHistoryController",
            templateUrl: '/templates/scenarios/fragments/scenario-git-log.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.steps', {
            url: '/steps',
            templateUrl: '/templates/scenarios/fragments/scenario-steps.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.script', {
            url: '/script',
            templateUrl: '/templates/scenarios/fragments/scenario-script.html'
        });

        $stateProvider.state('projects.project.data-quality', {
            url: '/data-quality',
            abstract: true,
            template: `<ng2-project-quality-tab-view
                [can-edit]="projectSummary.canWriteProjectContent"
                [can-publish-to-dashboards]="projectSummary.canWriteDashboards"
            ></ng2-project-quality-tabview>`
        });

        $stateProvider.state('projects.project.data-quality.current-status', {
            url: '/current-status',
            template: `
                <ng2-current-status-panel
                    [project-key]="$root.$state.params.projectKey"
                    [can-edit]="addToScope.canEdit"
                    [can-publish-to-dashboards]="addToScope.canPublishToDashboards"
                >
                </ng2-current-status-panel>
            `
        });

        $stateProvider.state('projects.project.data-quality.timeline', {
            url: '/timeline',
            template: '<ng2-project-quality-timeline-panel [project-key]="$root.$state.params.projectKey"></ng2-project-quality-timeline-panel>'
        });

        $stateProvider.state('projects.project.automation', {
            url: '/automation',
            abstract: true,
            template: '<div ui-view></div>',
            controller: "ScenariosMonitoringController",
        });

        const projectMonitoringParams = {
            templateUrl: '/templates/scenarios/scenarios-monitoring.html',
            pageTitle: () => {
                return "Monitoring";
            },
        };

        $stateProvider.state('projects.project.automation.test-dashboard', {
            url: '/test-dashboard',
            ...projectMonitoringParams,
            params: {
                activeTab: 'testDashboard',
                scopeToDay: null
            }
        });

        const projectMonitoringStates = [
            { name: 'timeline', route:'timeline', url: '/timeline' },
            { name: 'outcomes', route:'outcomes', url: '' },
            { name: 'timeline', route:'timeline.scoped', url: '/:scopeToDay' },
            { name: 'outcomes', route:'outcomes.scoped', url: '/:scopeToDay' }
        ];

        projectMonitoringStates.forEach(state => {
            $stateProvider.state(`projects.project.automation.${state.route}`, {
                url: state.url,
                ...projectMonitoringParams,
                params: {
                    activeTab: state.name,
                    scenarioQuery: null
                }
            });
        });

        /* ************************** Continuous Activities ********************** */
        $stateProvider.state('projects.project.continuous-activities', {
            url: '/continuous-activities',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.continuous-activities.list', {
            url: '/',
            templateUrl: '/templates/continuous-activities/list.html',
            controller: "ContinuousActivitiesListController",
            pageTitle: () => {
                return "Continuous Activities";
            }
        });

        $stateProvider.state('projects.project.continuous-activities.continuous-activity', {
            url: '/:continuousActivityId',
            templateUrl: '/templates/continuous-activities/continuous-activity.html',
            controller: "ContinuousActivityController",
            pageTitle: () => {
                return "Continuous Activity";
            }
        });

        $stateProvider.state('projects.project.continuous-activities.continuous-activity.runs', {
            url: '/runs?runId&attemptId',
            templateUrl: '/templates/continuous-activities/runs.html'
        });

        /* ************************** Macros ********************** */

        $stateProvider.state('projects.project.runnables', {
            url: '/macros',
            abstract: true,
            controller: "RunnableCoreController",
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.runnables.list', {
            url: '/',
            templateUrl: '/templates/macros/runnables.html',
            controller: "RunnablesListController",
            pageTitle: () => {
                return "Macros";
            }
        });

        /* ************************** Dataiku Workspaces ********************** */

        WorkspacesRoutes.forEach(route => {
            $stateProvider.state(route.path, route.options);
        });

        /* ************************** User profile pages ********************** */

        $stateProvider.state('profile', {
            abstract: true,
            url: '/profile',
            template: '<div ui-view></div>'
        });

        $stateProvider.state('profile.my', {
            url: '/',
            abstract: true,
            templateUrl: '/templates/profile/index.html',
            controller: 'ProfileController'
        });

        /* Default */
        $stateProvider.state('profile.my.settings', {
            url: '',
            templateUrl: '/templates/profile/settings.html',
            pageTitle: () => {
                return "Profile settings";
            },
            controller: 'MyProfileAccountController',
            params: { scrollTo: undefined },
            data: {selectedTab: 'settings'}
        });

        $stateProvider.state('profile.my.achievements', {
            url: 'achievements/',
            templateUrl: '/templates/profile/achievements.html',
            pageTitle: () => {
                return "My profile";
            },
            controller: 'MyProfileAchievementsController',
            data: {selectedTab: 'achievements'}
        });

        $stateProvider.state('profile.my.exports', {
            url: 'exports/',
            templateUrl: '/templates/profile/exports.html',
            pageTitle: () => {
                return "My exports";
            },
            controller: 'MyProfileExportController',
            data: {selectedTab: 'exports'}
        });

        $stateProvider.state('profile.my.stars', {
            url: 'stars/',
            templateUrl: '/templates/profile/stars.html',
            pageTitle: () => {
                return "My stars";
            },
            controller: 'MyProfileStarsController',
            data: {selectedTab: 'stars'}
        });

        $stateProvider.state('profile.my.credentials', {
            url: 'credentials/',
            templateUrl: '/templates/profile/credentials.html',
            pageTitle: () => {
                return "Personal credentials";
            },
            controller: 'MyProfileConnectionCredentialsController',
            data: {selectedTab: 'credentials'}
        });


        $stateProvider.state('profile.my.apikeys', {
            url: 'apikeys/',
            templateUrl: '/templates/profile/personal-api-keys.html',
            pageTitle: () => {
                return "Personal API Keys";
            },
            controller: 'MyProfilePersonalAPIKeysController',
            data: {selectedTab: 'apikeys'}
        });

        $stateProvider.state('profile.my.account', {
            url: 'account/',
            templateUrl: '/templates/profile/account.html',
            pageTitle: () => {
                return "Account";
            },
            controller: 'MyProfileEditController',
            data: {selectedTab: 'account'}
        });

        $stateProvider.state('profile.my.files', {
            url: 'files/',
            templateUrl: '/templates/profile/files.html',
            pageTitle: () => {
                return "Files";
            },
            controller: 'MyFilesEditController',
            data: {selectedTab: 'files'}
        });

        $stateProvider.state('profile.my.notifications', {
            url: 'notifications/',
            templateUrl: '/templates/profile/notifications.html',
            pageTitle: () => {
                return "My notifications";
            },
            data: {selectedTab: 'notifications'}
        });

        $stateProvider.state('oauth2-callback', {
            url: '/oauth2-callback',
            pageTitle: () => {
                return "OAuth2 callback";
            },
            controller: 'OAuth2CallbackController'
        });

        $stateProvider.state('profile.user', {
            url: '/:userLogin/',
            abstract: true,
            templateUrl: '/templates/profile/index.html',
            controller: 'ProfileController'
        });

        $stateProvider.state('profile.user.view', {
            url: '',
            templateUrl: '/templates/profile/achievements.html',
            controller: 'MyProfileAchievementsController',
            pageTitle: () => {
                return "Profile";
            }
        });

        /* ************************** Plugins ********************** */

        $stateProvider.state('plugins', {
            url: '/plugins-explore',
            controller: 'PluginsExploreController',
            templateUrl: '/templates/plugins/index.html',
            pageTitle: () => {
                return 'Plugins';
            }
        });

        $stateProvider.state('plugins.store', {
            url: '/store/:pluginid',
            templateUrl: '/templates/plugins/store-list.html',
            controller: 'PluginsStoreController',
            pageTitle: () => {
                return 'Plugins store';
            }
        });

        $stateProvider.state('plugins.installed', {
            url: '/installed/',
            templateUrl: '/templates/plugins/installed-list.html',
            pageTitle: () => {
                return 'Installed plugins';
            }
        });

        $stateProvider.state('plugins.development', {
            url: '/development/',
            templateUrl: '/templates/plugins/development-list.html',
            pageTitle: () => {
                return 'Plugins Development';
            }
        });

        /* ************************** Plugin page ********************** */

        $stateProvider.state('plugin', {
            url: '/plugins/:pluginId?pluginVersion',
            controller: 'PluginController',
            abstract: true,
            templateUrl: '/templates/plugins/plugin-details/index.html'
        });

        $stateProvider.state('plugin.installation', {
            url: '/installation/',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: function($stateParams) {
                return 'Installing ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.update', {
            url: '/update/',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: function($stateParams) {
                return 'Updating ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.upload', {
            url: '/upload',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            params: { uploadedPluginFile: null },
            pageTitle: function($stateParams) {
                return 'Uploading ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.upload.update', {
            url: '/update/',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            params: { uploadedPluginFile: null },
            pageTitle: function($stateParams) {
                return 'Updating ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.installationfromgit', {
            url: '/install-from-git/?uri&checkout&path&pluginName',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: () => {
                return 'Installing from Git'
            }
        });

        $stateProvider.state('plugin.updatefromgit', {
            url: '/update-from-git/?uri&checkout&path&pluginName',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: () => {
                return 'Updating from Git'
            }
        });


        $stateProvider.state('plugin.summary', {
            url: '/summary/',
            templateUrl: '/templates/plugins/plugin-details/summary.html',
            controller: 'PluginSummaryController',
            pageTitle: function($stateParams) {
                return 'Plugin - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugin.settings', {
            url: '/settings/:selectedTab',
            templateUrl: '/templates/plugins/plugin-details/settings.html',
            controller: 'PluginSettingsController',
            pageTitle: function($stateParams) {
                return 'Plugin settings - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugin.usages', {
            url: '/usages/',
            templateUrl: '/templates/plugins/plugin-details/usages.html',
            controller: 'PluginUsagesController',
            pageTitle: function($stateParams) {
                return 'Plugin usages - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugindev', {
            url: '/plugins/development/:pluginId',
            abstract: true,
            templateUrl: '/templates/plugins/development/plugin-details/index.html',
            controller: 'PlugindevEditionController'
        });

        $stateProvider.state('plugindev.definition', {
            url: '/definition/',
            templateUrl: '/templates/plugins/development/plugin-details/definition.html',
            controller: 'PlugindevDefinitionController',
            pageTitle: function($stateParams) {
                return 'Plugin - ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugindev.settings', {
            url: '/settings/:selectedTab',
            templateUrl: '/templates/plugins/development/plugin-details/settings.html',
            controller: 'PluginSettingsController',
            pageTitle: function($stateParams) {
                return 'Plugin settings - ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugindev.usages', {
            url: '/usages/',
            templateUrl: '/templates/plugins/plugin-details/usages.html',
            controller: 'PluginUsagesController',
            pageTitle: function($stateParams) {
                return 'Plugin usages - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugindev.editor', {
            url: '/editor/',
            templateUrl: '/templates/plugins/development/plugin-details/editor.html',
            controller: 'PlugindevEditorController',
            // to pass a param without putting it into the url
            resolve: {
                filePath: function($stateParams){
                    return $stateParams.filePath;
                }
            },
            params: {
                filePath: null
            },
            pageTitle: function($stateParams) {
                return 'Plugin Editor - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugindev.history', {
            url: '/development/history/',
            templateUrl: '/templates/plugins/development/plugin-details/history.html',
            controller: 'PlugindevHistoryController',
            pageTitle: function($stateParams) {
                return 'Plugin History - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state("libedition", {
            url: '/libedition',
            abstract: true,
            templateUrl: '/templates/plugins/development/lib-edition.html',
            controller: 'TopLevelFolderEditionController'
        });

        $stateProvider.state('libedition.libpython', {
            url: '/libpython',
            templateUrl: '/templates/plugins/development/lib-python-editor.html'
        });

        $stateProvider.state('libedition.libr', {
            url: '/libr',
            templateUrl: '/templates/plugins/development/lib-r-editor.html'
        });

        $stateProvider.state('libedition.localstatic', {
            url: '/localstatic',
            templateUrl: '/templates/plugins/development/local-static-editor.html',
            controller: 'TopLevelLocalStaticEditorController'
        });
        /* ************************** Feature Store ********************** */
        $stateProvider.state('featurestore', {
            url: '/feature-store',
            template: '<ng2-feature-store></ng2-feature-store>',
            pageTitle: () => {
                return "Feature Store";
            }
        });

        $stateProvider.state('projects.project.featurestore', {
            url: '/feature-store?zoneId',
            template: '<ng2-feature-store project-key="{{$state.params.projectKey}}" [zone-id]="$state.params.zoneId"></ng2-feature-store>',
            pageTitle: () => {
                return "Feature Store";
            }
        });

        /* ************************** Catalog ********************** */

        $stateProvider.state("catalog", {
            url: '/search-dss-items',
            abstract: true,
            templateUrl: '/templates/catalog/index.html',
            controller: function(TopNav) {
                TopNav.setLocation("DSS_HOME", "catalog", "items", null);
            }
        });

        const catalogItems = {
            url: '/:hash',
            templateUrl: '/templates/catalog/search.html',
            controller: "CatalogItemsController",
            params: {
                scope: null,
                _type: null
            },
            pageTitle: () => {
                return "Search DSS Items";
            }
        };

        const catalogMeanings = {
            url: '/meanings/:hash',
            templateUrl: '/templates/catalog/search.html',
            controller: "CatalogMeaningsController",
            pageTitle: () => {
                return "Meanings";
            }
        };

        $stateProvider.state('meanings', {
            url: '/meanings',
            templateUrl: '/templates/meanings/index.html',
            controller: "CatalogMeaningsController",
            pageTitle: () => {
                return "Meanings";
            }
        });

        $stateProvider.state('projects.project.catalog', {
            url: '/search-dss-items',
            abstract: true,
            templateUrl: '/templates/catalog/index.html',
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.TOP_FLOW, "datasets", TopNav.TABS_NONE, null);
                TopNav.setNoItem();
            }
        });

        $stateProvider.state("catalog.items", $.extend({}, catalogItems));
        $stateProvider.state("projects.project.catalog.items", $.extend({}, catalogItems, { url:catalogItems.url+'?zoneId' }));
        $stateProvider.state("projects.project.catalog.meanings", $.extend({}, catalogMeanings));

        /* ************************** DATA CATALOG ********************** */
        const datacatalogParams = {
            url: '/data-catalog',
            abstract: true,
            template: '<ui-view></ui-view>',
            controller: function(TopNav, $state) {
                if($state.includes('projects.project')){
                    TopNav.setLocation(TopNav.TOP_FLOW, "catalog");
                } else {
                    TopNav.setLocation(TopNav.DSS_HOME, "catalog");
                }
            },
            pageTitle: () => "Data Catalog"
        };
        $stateProvider.state("datacatalog", {...datacatalogParams});
        $stateProvider.state("projects.project.datacatalog", { ...datacatalogParams, url: datacatalogParams.url + '?zoneId' });

        const datacatalogHome = {
            url: '/',
            template: '<ng2-data-catalog-home-page></ng2-data-catalog-home-page>',
            pageTitle: () => "Data Catalog"
        };
        $stateProvider.state("projects.project.datacatalog.home", {...datacatalogHome});

        const datacatalogDatacollections = {
            url: '/data-collections',
            abstract: true,
            template: '<ui-view></ui-view>'
        };
        $stateProvider.state("datacatalog.datacollections", {...datacatalogDatacollections});
        $stateProvider.state("projects.project.datacatalog.datacollections", {...datacatalogDatacollections});

        $stateProvider.state('datalineage', {
            url: '/data-lineage',
            abstract: true,
            template: '<ui-view></ui-view>',
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.DSS_HOME);
            },
        });

        $stateProvider.state("datalineage.export", {
            url: '/export/:contextProjectKey/:smartName/:columnName',
            template: `<ng2-data-lineage-home-page
                [context-project-key]="$stateParams.contextProjectKey"
                [smart-name]="$stateParams.smartName"
                [column-name]="$stateParams.columnName"
                [lineage-export]="true"
            ></ng2-data-lineage-home-page>`
        })

        const dataLineageHome = {
            url: '/',
            template: `<ng2-data-lineage-home-page></ng2-data-lineage-home-page>`,
            pageTitle: () => "Data Lineage"
        };
        $stateProvider.state("datalineage.home", {...dataLineageHome});

        const dataLineageHomeWithParams = {
            url: '/:contextProjectKey/:smartName/',
            template: `<ng2-data-lineage-home-page
                [context-project-key]="$stateParams.contextProjectKey"
                [smart-name]="$stateParams.smartName"
            ></ng2-data-lineage-home-page>`,
            pageTitle: () => "Data Lineage"
        };
        $stateProvider.state("datalineage.homeWithParams", {...dataLineageHomeWithParams});

        const dataLineageGraph = {
            url: '/:contextProjectKey/:smartName/:columnName',
            template: `<ng2-data-lineage-home-page
                [context-project-key]="$stateParams.contextProjectKey"
                [smart-name]="$stateParams.smartName"
                [column-name]="$stateParams.columnName"
            ></ng2-data-lineage-home-page>`,
            pageTitle: () => "Data Lineage"
        };
        $stateProvider.state("datalineage.graph", {...dataLineageGraph});


        // --- Redirect from old data-lineage URLs (when it was inside Data catalog) to the new ones
        $stateProvider.state("datacatalog.datalineage", {
            url: '/data-lineage',
            abstract: true,
            template: '<ui-view></ui-view>'
        });
        redirectState($stateProvider, "datacatalog.datalineage.home", "datalineage.home", "/");
        redirectState($stateProvider, "datacatalog.datalineage.graph", "datalineage.graph", "/:contextProjectKey/:smartName/:columnName", true);
        redirectState($stateProvider, "datacatalog.datalineage.homeWithParams", "datalineage.homeWithParams", "/:contextProjectKey/:smartName/", true);
        redirectState($stateProvider, "datacatalog.datalineage.export", "datalineage.export", "/export/:contextProjectKey/:smartName/:columnName", true);

        const datacatalogDatacollectionHome = {
            url: '/',
            template: '<ng2-data-collections-home-page></ng2-data-collections-home-page>',
            pageTitle: () => "Data Catalog"
        };
        $stateProvider.state("datacatalog.datacollections.home", {...datacatalogDatacollectionHome});
        $stateProvider.state("projects.project.datacatalog.datacollections.home", {...datacatalogDatacollectionHome});

        const datacatalogDatacollectionPage = {
            url: '/:dataCollectionId/',
            template: '<ng2-data-collection-page [id]="$root.$stateParams.dataCollectionId"></ng2-data-collection-page>',
            pageTitle: () => "Data Catalog"
        }
        $stateProvider.state("datacatalog.datacollections.datacollection", {...datacatalogDatacollectionPage});
        $stateProvider.state("projects.project.datacatalog.datacollections.datacollection", {...datacatalogDatacollectionPage});

        const connectionExplorer = {
            url: '/connection-explorer?connectionName?schemaName?catalogName',
            templateUrl: '/templates/datasets/connection-explorer.html',
            controller: "ConnectionsExplorerController",
            pageTitle: () => {
                return "Database explorer";
            }
        };
        $stateProvider.state('projects.project.datacatalog.connectionexplorer', { ...connectionExplorer });
        $stateProvider.state('datacatalog.connectionexplorer', { ...connectionExplorer });

        // Data Catalog > Data Sources - keep last to no override other data-catalog/xxx routes
        const datacatalogDataSources = {
            url: '/:selectedTab',
            template: '<ng2-data-sources [query-on-load]="$root.$stateParams.queryOnLoad" [preselected-item]="$root.$stateParams.preselectedItem"></ng2-data-sources>',
            params: {
                queryOnLoad: null, // optionally set the query after load
                preselectedItem: undefined // optionally select an item (if it's in the results of the first query)
            },
            pageTitle: () => "Datasets & Indexed Tables"
        }
        $stateProvider.state('datacatalog.datasources', {...datacatalogDataSources});
        $stateProvider.state('projects.project.datacatalog.datasources', {...datacatalogDataSources});

        // Redirection from the old catalog URLs to their new equivalent
        $stateProvider.state('oldcatalog', {
            abstract: true,
            url: '/catalog',
            template:'<ui-view/>'
        });

        $stateProvider.state('oldcatalog.items', { // old catalog to the new search-dss page or data-catalog
            url: '/search/:hash',
            controller: function($state, $stateParams) {
                if($stateParams.hash.includes('scope=external') || $stateParams.hash.includes('_type=table')) {
                    $state.go('datacatalog.datasources', { selectedTab: 'external-tables' }, {location: 'replace'});
                } else {
                    // scope=all isn't reachable in search-dss, so we replace it by dss.
                    const hash = $stateParams.hash.replace('scope=all', 'scope=dss');
                    $state.go('catalog.items', { hash }, {location: 'replace'});
                }
            }
        });

        $stateProvider.state('oldcatalog.connection-explorer', { // old catalog connection explorer to the new database explorer location
            url: '/connection-explorer?connectionName?schemaName?catalogName',
            controller: function($state, $stateParams) {
                $state.go('datacatalog.connectionexplorer', $stateParams, {location: 'replace'})
            }
        });
        /* ************************** EXTERNAL TABLES ********************** */
        $stateProvider.state("external-table", {
            url: '/external-table/:connection/:catalog/:schema/:table',
            abstract: true,
            templateUrl: '/templates/catalog/external-table/index.html',
            controller: "ExternalTableController"
        });

        $stateProvider.state("external-table.summary", {
            url: '',
            template: '<external-table-summary class="h100"></external-table-summary>'
        });

        $stateProvider.state("external-table.schema", {
            url: '/schema/',
            templateUrl: '/templates/catalog/external-table/schema.html'
        });
        $stateProvider.state("external-table.sample", {
            url: '/sample/',
            templateUrl: '/templates/catalog/external-table/sample.html'
        });
        $stateProvider.state("external-table.items", {
            url: '/items/',
            templateUrl: '/templates/catalog/external-table/items.html'
        });

        /* ************************** INBOX ********************** */

        $stateProvider.state("inbox", {
            url: "/inbox",
            template: "<inbox></inbox>",
            abstract: true,
        });

        /* ************************** NOTIFICATION CENTER ********************** */

        $stateProvider.state("inbox.requests", {
            url: "/requests/",
            template: "<request-center></request-center>" ,
            pageTitle: () => {
                return "Inbox - Requests center";
            },
        });

        $stateProvider.state("inbox.requests.selected", {
            url: ":requestId",
            template: '<request></request>', // note: request requires to be included in the request-center component
            pageTitle: () => {
                return "Inbox - Requests center";
            },
        });

        /* ************************** CONVERSATION CENTER ********************** */

        $stateProvider.state("inbox.conversations", {
            url: '/conversations/',
            templateUrl: '/templates/catalog/inbox.html',
            controller: 'DiscussionsInboxController',
            pageTitle: () => {
                return "Inbox - Conversations center";
            }
        });

        /* ************************** Deployer ********************** */

        $stateProvider.state('deployer', {
            url: '/deployer/',
            controller: 'DeployerHomeController',
            templateUrl: '/templates/deployer/index.html',
            pageTitle: () => "Deployer"
        });

        /* ************************** Unified Monitoring ********************** */

        $stateProvider.state('unified-monitoring', {
            url: '/unified-monitoring',
            controller: 'UnifiedMonitoringController',
            abstract: true,
            templateUrl: '/templates/unified-monitoring/index.html'
        });

        $stateProvider.state('unified-monitoring.overview', {
            url: '/',
            template: `<ng2-unified-monitoring-overview-page></ng2-unified-monitoring-overview-page>`,
            pageTitle: () => "Unified Monitoring Overview"
        });

        $stateProvider.state('unified-monitoring.projects', {
            url: '/projects',
            template: `<ng2-unified-monitoring-projects-page></ng2-unified-monitoring-projects-page>`,
            pageTitle: () => "Unified Monitoring Projects"
        });

        $stateProvider.state('unified-monitoring.endpoints', {
            url: '/endpoints',
            template: `<ng2-unified-monitoring-endpoints-page></ng2-unified-monitoring-endpoints-page>`,
            pageTitle: () => "Unified Monitoring Endpoints"
        });

        $stateProvider.state('unified-monitoring.alerting', {
            url: '/alerting',
            template: `<ng2-unified-monitoring-alerting-page></ng2-unified-monitoring-alerting-page>`,
            pageTitle: () => "Unified Monitoring Alerting"
        });

        $stateProvider.state('unified-monitoring.settings', {
            url: '/settings',
            template: `<ng2-unified-monitoring-settings-page></ng2-unified-monitoring-settings-page>`,
            pageTitle: () => "Unified Monitoring Settings"
        });

        $stateProvider.state('unified-monitoring.logs', {
            url: '/logs',
            template: `<ng2-unified-monitoring-logs-page></ng2-unified-monitoring-logs-page>`,
            pageTitle: () => "Unified Monitoring Logs"
        });

        /* ************************** API Deployer ********************** */

        $stateProvider.state('apideployer', {
            url: '/api-deployer/',
            controller: 'APIDeployerController',
            abstract: true,
            templateUrl: '/templates/api-deployer/index.html'
        });


        $stateProvider.state('apideployer.deployments', {
            url: 'deployments',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('apideployer.deployments.dashboard', {
            url: '/',
            controller: 'APIDeployerDeploymentsDashboardController',
            templateUrl: '/templates/api-deployer/deployment-dashboard.html',
            pageTitle: () => {
                return 'Deployments';
            }
        });
        $stateProvider.state('apideployer.deployments.deployment', {
            url: '/:deploymentId',
            abstract: true,
            controller: 'APIDeployerDeploymentController',
            templateUrl: '/templates/api-deployer/deployment.html'
        });
        $stateProvider.state('apideployer.deployments.deployment.status', {
            url: '/',
            controller: 'APIDeployerDeploymentStatusController',
            templateUrl: '/templates/api-deployer/deployment-status.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.updates', {
            url: '/last-updates/',
            controller: 'APIDeployerDeploymentUpdatesController',
            templateUrl: '/templates/api-deployer/deployment-updates.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.logs', {
            url: '/logs',
            controller: 'APIDeployerDeploymentLogsController',
            templateUrl: '/templates/api-deployer/deployment-logs.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.history', {
            url: '/history/',
            controller: 'APIDeployerDeploymentHistoryController',
            templateUrl: '/templates/api-deployer/deployment-history.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.settings', {
            url: '/settings/',
            controller: 'APIDeployerDeploymentSettingsController',
            templateUrl: '/templates/api-deployer/deployment-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });


        $stateProvider.state('apideployer.services', {
            url: 'services',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('apideployer.services.list', {
            url: '/',
            controller: 'APIDeployerServicesListController',
            templateUrl: '/templates/api-deployer/published-services-list.html',
            pageTitle: () => {
                return 'Published API services';
            }
        });
        $stateProvider.state('apideployer.services.service', {
            url: '/:serviceId',
            abstract: true,
            controller: 'APIDeployerServiceController',
            templateUrl: '/templates/api-deployer/published-service.html'
        });
        $stateProvider.state('apideployer.services.service.status', {
            url: '/?versions',
            controller: 'APIDeployerServiceStatusController',
            params: {
                versions: { array: true }
            },
            templateUrl: '/templates/api-deployer/published-service-status.html',
            pageTitle: function(stateParams) {
                return stateParams.serviceId + ' - Published API services';
            }
        });
        $stateProvider.state('apideployer.services.service.history', {
            url: '/history/',
            controller: 'APIDeployerServiceHistoryController',
            templateUrl: '/templates/api-deployer/published-service-history.html',
            pageTitle: function(stateParams) {
                return stateParams.serviceId + ' - Published API services';
            }
        });
        $stateProvider.state('apideployer.services.service.settings', {
            url: '/settings/',
            controller: 'APIDeployerServiceSettingsController',
            templateUrl: '/templates/api-deployer/published-service-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.serviceId + ' - Published API services';
            }
        });


        $stateProvider.state('apideployer.infras', {
            url: 'infras',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('apideployer.infras.list', {
            url: '/',
            controller: 'APIDeployerInfrasListController',
            templateUrl: '/templates/api-deployer/infras-list.html',
            pageTitle: () => {
                return 'API Infrastructures';
            }
        });
        $stateProvider.state('apideployer.infras.infra', {
            url: '/:infraId',
            controller: 'APIDeployerInfraController',
            abstract: true,
            templateUrl: '/templates/api-deployer/infra.html'
        });
        $stateProvider.state('apideployer.infras.infra.status', {
            url: '/',
            controller: 'APIDeployerInfraStatusController',
            templateUrl: '/templates/api-deployer/infra-status.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - API Infrastructures';
            }
        });
        $stateProvider.state('apideployer.infras.infra.history', {
            url: '/history/',
            controller: 'APIDeployerInfraHistoryController',
            templateUrl: '/templates/api-deployer/infra-history.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - API Infrastructures';
            }
        });
        $stateProvider.state('apideployer.infras.infra.settings', {
            url: '/settings/',
            controller: 'APIDeployerInfraSettingsController',
            templateUrl: '/templates/api-deployer/infra-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - API Infrastructures';
            }
        });

        /* ************************** Project Deployer ********************** */
        $stateProvider.state('projectdeployer', {
            url: '/project-deployer/',
            controller: 'ProjectDeployerController',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projectdeployer.deployments', {
            url: 'deployments',
            abstract: true,
            controller: 'ProjectDeployerDeploymentsController',
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.deployments.dashboard', {
            url: '/',
            controller: 'ProjectDeployerDeploymentDashboardController',
            templateUrl: '/templates/project-deployer/deployment-dashboard.html',
            pageTitle: () => {
                return 'Deployments';
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment', {
            url: '/:deploymentId',
            abstract: true,
            controller: 'ProjectDeployerDeploymentController',
            templateUrl: '/templates/project-deployer/deployment.html'
        });
        $stateProvider.state('projectdeployer.deployments.deployment.status', {
            url: '/',
            controller: 'ProjectDeployerDeploymentStatusController',
            templateUrl: '/templates/project-deployer/deployment-status.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.settings', {
            url: '/settings/',
            controller: 'ProjectDeployerDeploymentSettingsController',
            templateUrl: '/templates/project-deployer/deployment-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.updates', {
            url: '/last-updates/',
            controller: 'ProjectDeployerDeploymentUpdatesController',
            templateUrl: '/templates/project-deployer/deployment-updates.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.logs', {
            url: '/logs/',
            controller: 'ProjectDeployerDeploymentLogsController',
            templateUrl: '/templates/project-deployer/deployment-logs.html',
            pageTitle: function(stateParams) {
                return stateParams.publishedProjectKey + ' - Published Projects';
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.history', {
            url: '/history/',
            controller: 'ProjectDeployerDeploymentHistoryController',
            templateUrl: '/templates/project-deployer/deployment-history.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });

        $stateProvider.state('projectdeployer.projects', {
            url: 'projects',
            abstract: true,
            controller: 'ProjectDeployerProjectsController',
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.projects.list', {
            url: '/',
            controller: 'ProjectDeployerProjectListController',
            templateUrl: '/templates/project-deployer/published-projects-list.html',
            pageTitle: () => {
                return 'Projects';
            },
            params: {
                selectedProjectKey: null // open specified project accordion table on load
            }
        });
        $stateProvider.state('projectdeployer.projects.project', {
            url: '/:publishedProjectKey',
            abstract: true,
            controller: 'ProjectDeployerProjectController',
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.projects.project.home', {
            url: '',
            abstract: true,
            templateUrl: '/templates/project-deployer/published-project.html'
        });
        $stateProvider.state('projectdeployer.projects.project.home.status', {
            url: '/',
            controller: 'ProjectDeployerProjectStatusController',
            templateUrl: '/templates/project-deployer/published-project-status.html',
            pageTitle: function(stateParams) {
                return stateParams.publishedProjectKey + ' - Published Projects';
            }
        });
        $stateProvider.state('projectdeployer.projects.project.home.settings', {
            url: '/settings/',
            controller: 'ProjectDeployerProjectSettingsController',
            templateUrl: '/templates/project-deployer/published-project-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.publishedProjectKey + ' - Published Projects';
            }
        });
        $stateProvider.state('projectdeployer.projects.project.home.history', {
            url: '/history/',
            controller: 'ProjectDeployerProjectHistoryController',
            templateUrl: '/templates/project-deployer/published-project-history.html',
            pageTitle: function(stateParams) {
                return stateParams.publishedProjectKey + ' - Published Projects';
            }
        });
        $stateProvider.state('projectdeployer.projects.project.bundle', {
            url: '/bundle/:bundleId',
            controller: 'ProjectDeployerBundleController',
            abstract: true,
            templateUrl: '/templates/project-deployer/published-bundle.html'
        });
        $stateProvider.state('projectdeployer.projects.project.bundle.status', {
            url: '/',
            controller: 'ProjectDeployerBundleStatusController',
            templateUrl: '/templates/project-deployer/published-bundle-status.html',
            pageTitle: function(stateParams) {
                return stateParams.bundleId + ' - Published Bundles';
            }
        });

        $stateProvider.state('projectdeployer.infras', {
            url: 'infras',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.infras.list', {
            url: '/',
            controller: 'ProjectDeployerInfrasListController',
            templateUrl: '/templates/project-deployer/infras-list.html',
            pageTitle: () => {
                return 'Infrastructures';
            }
        });
        $stateProvider.state('projectdeployer.infras.infra', {
            url: '/:infraId',
            controller: 'ProjectDeployerInfraController',
            abstract: true,
            templateUrl: '/templates/project-deployer/infra.html'
        });
        $stateProvider.state('projectdeployer.infras.infra.status', {
            url: '/',
            controller: 'ProjectDeployerInfraStatusController',
            templateUrl: '/templates/project-deployer/infra-status.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - Automation Node Infrastructures';
            }
        });
        $stateProvider.state('projectdeployer.infras.infra.settings', {
            url: '/settings/',
            controller: 'ProjectDeployerInfraSettingsController',
            templateUrl: '/templates/project-deployer/infra-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - Automation Node Infrastructures';
            }
        });
        $stateProvider.state('projectdeployer.infras.infra.history', {
            url: '/history/',
            controller: 'ProjectDeployerInfraHistoryController',
            templateUrl: '/templates/project-deployer/infra-history.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - Automation Node Infrastructures';
            }
        });

        /* ************************** Automation  ********************** */

        $stateProvider.state("automation", {
            url: '/automation',
            abstract: true,
            templateUrl: '/templates/scenarios/instance-monitoring.html',
            pageTitle: () => "Automation",
        });

        $stateProvider.state("automation.outcomes", {
            url: '/',
            templateUrl: '/templates/scenarios/outcomes-instance-view.html',
        });

        $stateProvider.state("automation.timeline", {
            url: '/timeline',
            templateUrl: '/templates/scenarios/timeline.html',
        });

        $stateProvider.state("automation.triggers", {
            url: '/triggers',
            templateUrl: '/templates/scenarios/triggers-instance-view.html',
        });

        $stateProvider.state("automation.reporters", {
            url: '/reporters',
            templateUrl: '/templates/scenarios/reporters-instance-view.html',
        });

        /* ************************** Administration ********************** */

        $stateProvider.state('admin', {
            url: '/admin/',
            abstract: true,
            templateUrl: '/templates/admin/index.html',
            controller: function(Breadcrumb) {
                Breadcrumb.set([{type: "admin"}]);
            }
        });

        $stateProvider.state('admin.home', {
            url: '',
            templateUrl: '/templates/admin/home.html',
            controller: "AdminLicensingController",
            pageTitle: () => {
                return "Administration";
            }
        });

        $stateProvider.state('admin.general', {
            url: 'general/',
            templateUrl: '/templates/admin/general/index.html',
            controller: "AdminGeneralSettingsController",
            params: {
                scrollTo: undefined,
            },
        });

        $stateProvider.state('admin.general.themes', {
            url: 'themes/',
            controller: "AdminThemeController" ,
            templateUrl: '/templates/admin/general/themes.html',
            pageTitle: () => {
                return "Themes";
            },
        });

        $stateProvider.state('admin.general.help', {
            url: 'help/',
            templateUrl: '/templates/admin/general/help.html',
            pageTitle: () => {
                return "Help";
            },
        });

        $stateProvider.state('admin.general.homepage', {
            url: 'homepage/',
            templateUrl: '/templates/admin/general/homepage.html',
            pageTitle: () => {
                return "Homepage";
            },
        });

        $stateProvider.state('admin.general.globaltags', {
            url: 'global-tags/',
            templateUrl: '/templates/admin/general/global-tags.html',
            pageTitle: () => {
                return "Global tag categories";
            },
        });

        $stateProvider.state('admin.general.notifications', {
            url: 'notifications/',
            templateUrl: '/templates/admin/general/notifications.html',
            pageTitle: () => {
                return "Notifications";
            },
        });

        $stateProvider.state('admin.general.charts_dashboards', {
            url: 'charts-and-dashboards/',
            templateUrl: '/templates/admin/general/charts-and-dashboards.html',
            controller: 'ChartsAndDashboardsController',
            pageTitle: () => {
                return "Charts & Dashboards";
            },
        });

        $stateProvider.state('admin.general.engines', {
            url: 'engines/',
            templateUrl: '/templates/admin/general/engines.html',
            pageTitle: () => {
                return "Engines";
            },
        });

        $stateProvider.state('admin.general.variables', {
            url: 'variables/',
            controller: 'AdminVariablesController',
            templateUrl: '/templates/admin/general/variables.html',
            pageTitle: () => {
                return "Variables";
            },
        });

        $stateProvider.state('admin.general.hadoop', {
            url: 'hadoop/',
            templateUrl: '/templates/admin/general/hadoop.html',
            pageTitle: () => {
                return "Hadoop";
            },
        });

        $stateProvider.state('admin.general.hive', {
            url: 'hive/',
            templateUrl: '/templates/admin/general/hive.html',
            pageTitle: () => {
                return "Hive";
            },
        });

        $stateProvider.state('admin.general.impala', {
            url: 'impala/',
            templateUrl: '/templates/admin/general/impala.html',
            pageTitle: () => {
                return "Impala";
            },
        });

        $stateProvider.state('admin.general.spark', {
            url: 'spark/',
            templateUrl: '/templates/admin/general/spark.html',
            pageTitle: () => {
                return "Spark";
            },
        });

        $stateProvider.state('admin.general.metastores', {
            url: 'metastores/',
            templateUrl: '/templates/admin/general/metastores.html',
            pageTitle: () => {
                return "Metastore catalogs";
            },
        });


        $stateProvider.state('admin.general.containers', {
            url: 'containers/',
            templateUrl: '/templates/admin/general/containers.html',
            pageTitle: () => {
                return "Containers";
            },
        });

        $stateProvider.state('admin.general.security', {
            url: 'security/',
            templateUrl: '/templates/admin/general/security.html',
            pageTitle: () => {
                return "Security";
            },
        });

        $stateProvider.state('admin.general.security_other', {
            url: 'security-other/',
            controller: 'AdminOtherSecurityController',
            templateUrl: '/templates/admin/general/security-other.html',
            pageTitle: () => {
                return "Security";
            },
        });


        $stateProvider.state('admin.general.limits', {
            url: 'limits/',
            templateUrl: '/templates/admin/general/limits.html',
            pageTitle: () => {
                return "Resources control";
            },
        });

        $stateProvider.state('admin.general.git', {
            url: 'git/',
            templateUrl: '/templates/admin/general/git.html',
            pageTitle: () => {
                return "Git";
            },
        });

        $stateProvider.state('admin.general.deployer', {
            url: 'deployer/',
            templateUrl: '/templates/admin/general/deployer.html',
            pageTitle: () => {
                return "Deployer";
            },
        });

        $stateProvider.state('admin.general.govern', {
            url: 'govern/',
            templateUrl: '/templates/admin/general/govern.html',
            pageTitle: () => {
                return "Govern";
            },
        });

        $stateProvider.state('admin.general.audit', {
            url: 'audit/',
            templateUrl: '/templates/admin/general/audit.html',
            pageTitle: () => {
                return "Audit";
            },
        });

        $stateProvider.state('admin.general.eventserver', {
            url: 'eventserver/',
            templateUrl: '/templates/admin/general/eventserver.html',
            pageTitle: () => {
                return "Event Server";
            },
        });

        $stateProvider.state('admin.general.genai', {
            url: 'genai/',
            controller: 'AdminGenAIController',
            templateUrl: '/templates/admin/general/genai.html',
            pageTitle: () => {
                return "Generative AI";
            },
        });

        $stateProvider.state('admin.general.aiservices', {
            url: 'aiservices/',
            controller: "AdminAiServicesSettingsController",
            templateUrl: '/templates/admin/general/aiservices.html',
            pageTitle: () => {
                return "AI Services";
            },
        });

        $stateProvider.state('admin.general.access', {
            url: 'access/',
            templateUrl: '/templates/admin/general/access.html',
            pageTitle: () => {
                return "Access & requests";
            },
        });

        $stateProvider.state('admin.general.misc', {
            url: 'misc/',
            templateUrl: '/templates/admin/general/misc.html',
            pageTitle: () => {
                return "Misc";
            },
        });

        $stateProvider.state('admin.general.stories', {
            url: 'stories/',
            templateUrl: '/templates/admin/general/datastory.html',
            pageTitle: () => {
                return "Dataiky Stories";
            },
        });

        /********************
         * Admin / Code envs
         ********************/

        $stateProvider.state('admin.codeenvs-design', {
            url: 'code-envs/design',
            abstract: true,
            templateUrl: '/templates/admin/code-envs/design/index.html'
        });

        $stateProvider.state('admin.codeenvs-design.list', {
            url: '/',
            controller: "AdminCodeEnvsDesignListController",
            templateUrl: '/templates/admin/code-envs/design/list.html',
            pageTitle: () => { return "Code envs"; }
        });

        $stateProvider.state('admin.codeenvs-design.internal', {
            url: '/internal',
            templateUrl: '/templates/admin/code-envs/common/internal-code-envs.html',
            pageTitle: () => { return "Internal code envs"; }
        });

        $stateProvider.state('admin.codeenvs-design.create', {
            url: '/:draftId',
            controller: "AdminCodeEnvsDesignCreateFromDraftController",
            templateUrl: '/templates/admin/code-envs/design/list.html',
            pageTitle: () => { return "Code env creation"; }
        });

        $stateProvider.state('admin.codeenvs-design.python-edit', {
            url: '/python/:envName/',
            controller: "AdminCodeEnvsDesignPythonEditController",
            templateUrl: '/templates/admin/code-envs/design/python-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (Python) - Code Envs"; }
        });

        $stateProvider.state('admin.codeenvs-design.r-edit', {
            url: '/r/:envName/',
            controller: "AdminCodeEnvsDesignREditController",
            templateUrl: '/templates/admin/code-envs/design/R-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (R) - Code Envs";  }
        });

        $stateProvider.state('admin.codeenvs-automation', {
            url: 'code-envs/automation',
            abstract: true,
            templateUrl: '/templates/admin/code-envs/automation/index.html'
        });

        $stateProvider.state('admin.codeenvs-automation.list', {
            url: '/',
            controller: "AdminCodeEnvsAutomationListController",
            templateUrl: '/templates/admin/code-envs/automation/list.html',
            pageTitle: () => { return "Code Envs"; }
        });

        $stateProvider.state('admin.codeenvs-automation.internal', {
            url: '/internal',
            templateUrl: '/templates/admin/code-envs/common/internal-code-envs.html',
            pageTitle: () => { return "Internal code envs"; }
        });

        $stateProvider.state('admin.codeenvs-automation.python-edit', {
            url: '/python/:envName/',
            controller: "AdminCodeEnvsAutomationPythonEditController",
            templateUrl: '/templates/admin/code-envs/automation/python-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (Python) - Code Envs"; }
        });

        $stateProvider.state('admin.codeenvs-automation.r-edit', {
            url: '/r/:envName/',
            controller: "AdminCodeEnvsAutomationREditController",
            templateUrl: '/templates/admin/code-envs/automation/R-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (R) - Code Envs"; }
        });

        /********************
         * Admin / Project Standards
         ********************/

        $stateProvider.state('admin.projectstandards', {
            url: 'project-standards/',
            abstract: true,
            templateUrl: '/templates/admin/project-standards/index.html'
        });

        $stateProvider.state('admin.projectstandards.checks', {
            url: 'checks-library/:checkId',
            template: `<ng2-project-standards-settings-checks [check-id]="$state.params.checkId"></ng2-project-standards-settings-checks>`,
            pageTitle: () => "Project Standards Checks Library"
        });

        $stateProvider.state('admin.projectstandards.scopes', {
            url: 'scopes/:scopeName',
            template: `<ng2-project-standards-settings-scopes [name]="$state.params.scopeName"></ng2-project-standards-settings-scopes>`,
            pageTitle: () => "Project Standards Scopes"
        });

        $stateProvider.state('admin.projectstandards.general', {
            url: 'general/',
            template: `<ng2-project-standards-settings-general-parameters></ng2-project-standards-settings-general-parameters>`,
            pageTitle: () => "General Parameters of Project Standards"
        });

        /********************
         * Admin / Maintenance
         ********************/

        $stateProvider.state('admin.maintenance', {
            url: 'maintenance/',
            templateUrl: '/templates/admin/maintenance/index.html'
        });

        $stateProvider.state('admin.maintenance.info', {
            url: 'info/',
            templateUrl: '/templates/admin/maintenance/info.html',
            pageTitle: () => {
                return "System info";
            },
            controller: "AdminMaintenanceInfoController"
        });

        $stateProvider.state('admin.maintenance.logs', {
            url: 'logs/',
            templateUrl: '/templates/admin/maintenance/logs.html',
            pageTitle: () => {
                return "Logs";
            },
            controller: "AdminLogsController"
        });

        $stateProvider.state('admin.maintenance.profiling', {
            url: 'profiling/',
            templateUrl: '/templates/admin/maintenance/profiling.html',
            pageTitle: () => {
                return "Performance profiling";
            },
            controller: "AdminProfilingController"
        });

        $stateProvider.state('admin.maintenance.diagnosis', {
            url: 'diagnosis/',
            templateUrl: '/templates/admin/maintenance/diagnosis.html',
            pageTitle: () => {
                return "Diagnosis";
            },
            controller: "AdminDiagnosticsController"
        });

        $stateProvider.state('admin.maintenance.scheduledtasks', {
            url: 'scheduled/',
            templateUrl: '/templates/admin/maintenance/scheduled-tasks.html',
            pageTitle: () => {
                return "Scheduled Tasks";
            },
            controller: "AdminScheduledTasksController" // Ugly ....
        });

        $stateProvider.state('admin.maintenance.sanitycheck', {
            url: 'sanitycheck/',
            templateUrl: '/templates/admin/maintenance/sanity-check.html',
            pageTitle: () => {
                return "Instance Sanity Check";
            },
            controller: "AdminSanityCheckController"
        });

        /********************
         * Admin / Monitoring
         ********************/

        $stateProvider.state('admin.monitoring', {
            url: 'monitoring',
            abstract: true,
            templateUrl: '/templates/admin/monitoring/index.html'
        });

        $stateProvider.state('admin.monitoring.summary', {
            url: '/',
            controller: "AdminMonitoringSummaryController",
            templateUrl: '/templates/admin/monitoring/global-summary.html',
            pageTitle: () => { return "Summary"; }
        });

        $stateProvider.state('admin.monitoring.clustertasks', {
            url: '/cluster-tasks/',
            controller: "AdminMonitoringClusterTasksController",
            templateUrl: '/templates/admin/monitoring/cluster-tasks.html',
            pageTitle: () => { return "Cluster & DB tasks"; }
        });

        $stateProvider.state('admin.monitoring.connectiondata', {
            url: '/connection-data/',
            controller: "AdminMonitoringConnectionDataController",
            templateUrl: '/templates/admin/monitoring/connection-data.html',
            pageTitle: () => { return "Per-connection data"; }
        });

        $stateProvider.state('admin.monitoring.bgtasks', {
            url: '/background-tasks/',
            controller: "AdminMonitoringBackgroundTasksController",
            templateUrl: '/templates/admin/monitoring/background-tasks.html',
            pageTitle: () => { return "Running background tasks"; }
        });

        $stateProvider.state('admin.monitoring.webapps', {
            url: '/webapp-backends/',
            controller: "AdminMonitoringWebAppBackendsController",
            templateUrl: '/templates/admin/monitoring/webapp-backends.html',
            pageTitle: () => { return "Webapp backends"; }
        });

        $stateProvider.state('admin.monitoring.integrations', {
            url: '/integrations/',
            controller: "AdminMonitoringIntegrationsController",
            templateUrl: '/templates/admin/monitoring/integrations.html',
            pageTitle : () => { return "Integrations"; }
        });

        /********************
         * Admin / Security
         ********************/

        $stateProvider.state('admin.security', {
            url: 'security/',
            abstract: true,
            templateUrl: '/templates/admin/security/index.html',
            controller: "AdminSecurityController"
        });

        $stateProvider.state('admin.security.users', {
            url: 'users/',
            abstract: true,
            template: '<div ui-view class="h100"></div>',
        });

        $stateProvider.state('admin.security.users.list', {
            url:'',
            templateUrl: '/templates/admin/security/users.html',
            controller: 'UsersController',
            pageTitle: () => {
                return "Users";
            }
        });

        $stateProvider.state('admin.security.users.new', {
            url: 'new/',
            templateUrl: '/templates/admin/security/user.html',
            controller: 'UserController',
            pageTitle: () => {
                return "New user";
            }
        });

        $stateProvider.state('admin.security.users.edit', {
            url: 'edit/:login/',
            templateUrl: '/templates/admin/security/user.html',
            controller: 'UserController',
            pageTitle: function(stateParams) {
                return "Edit "+stateParams.login+"";
            }
        });

        $stateProvider.state('admin.security.groups', {
            url: 'groups/',
            abstract: true,
            template: '<div ui-view class="h100"></div>',
        });

        $stateProvider.state('admin.security.groups.list', {
            url: '',
            templateUrl: '/templates/admin/security/groups.html',
            pageTitle: () => {
                return "Groups";
            },
            controller: "GroupsController"
        });

        $stateProvider.state('admin.security.groups.new', {
            url: 'new/',
            templateUrl: '/templates/admin/security/group.html',
            controller: 'GroupController',
            pageTitle: () => {
                return "New group";
            }
        });

        $stateProvider.state('admin.security.groups.edit', {
            url: 'edit/:name/',
            templateUrl: '/templates/admin/security/group.html',
            controller: 'GroupController',
            pageTitle: function(stateParams) {
                return "Edit "+stateParams.name+"";
            }
        });

        $stateProvider.state('admin.security.users.external', {
            url:'external/',
            templateUrl: '/templates/admin/security/external-users.html',
            controller: 'ExternalUsersController',
            pageTitle: () => {
                return "Import from external sources";
            }
        });

        $stateProvider.state('admin.security.globalapi', {
            url: 'apikeys/',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('admin.security.globalapi.list', {
            url: '',
            templateUrl: '/templates/admin/security/global-api-keys.html',
            pageTitle: () => {
                return "API";
            },
            controller: "GlobalPublicAPIKeysController"
        });

        $stateProvider.state('admin.security.globalapi.new', {
            url: 'new/',
            templateUrl: '/templates/admin/security/global-api-key.html',
            pageTitle: () => {
                return "API";
            },
            controller: "EditGlobalPublicAPIKeyController"
        });

        $stateProvider.state('admin.security.globalapi.edit', {
            url: 'edit/:id/',
            templateUrl: '/templates/admin/security/global-api-key.html',
            controller: 'EditGlobalPublicAPIKeyController',
            pageTitle: () => {
                return "API";
            }
        });

        $stateProvider.state('admin.security.personalapi', {
            url: 'personalapikeys/',
            templateUrl: '/templates/admin/security/personal-api-keys.html',
            pageTitle: () => {
                return "API";
            },
            controller: "AdminPersonalPublicAPIKeysController"
        });

        $stateProvider.state('admin.security.authorizationmatrix', {
            url: 'authorization-matrix/',
            templateUrl: '/templates/admin/security/authorization-matrix.html',
            controller: "AdminSecurityAuthorizationMatrixController",
            pageTitle: () => { return "Authorization Matrix"; }
        });

        $stateProvider.state('admin.security.auditbuffer', {
            url: 'audit-buffer/',
            templateUrl: '/templates/admin/security/audit-buffer.html',
            controller: "AdminSecurityAuditBufferController",
            pageTitle: () => { return "Audit trail"; }
        });

        // Connections management

        $stateProvider.state('admin.connections', {
            url: 'connections/',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('admin.connections.list', {
            url: 'list/',
            templateUrl: '/templates/admin/connections.html',
            controller: 'ConnectionsController',
            pageTitle: () => {
                return "Overview";
            }
        });

        $stateProvider.state('admin.connections.hiveindexing', {
            url: 'hive-indexing/',
            templateUrl: '/templates/admin/connections.html', // Reuses the same template
            controller: 'ConnectionsHiveIndexingController',
            pageTitle: () => {
                return "Hive indexing";
            }
        });

        $stateProvider.state('admin.connections.new', {
            url: 'new/:type/',
            templateUrl: '/templates/admin/connection.html',
            controller: 'ConnectionController',
            pageTitle: function(stateParams) {
                return "New " + stateParams.type + " connection";
            }
        });

        $stateProvider.state('admin.connections.edit', {
            url: ':connectionName/',
            templateUrl: '/templates/admin/connection.html',
            controller: 'ConnectionController',
            pageTitle: function(stateParams) {
                return stateParams.connectionName + " - Connection";
            }
        });

        // Clusters admin
        $stateProvider.state('admin.clusters', {
            url: 'clusters',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('admin.clusters.list', {
            url: '/',
            templateUrl: '/templates/admin/clusters/clusters.html',
            controller: "ClustersController",
            pageTitle: () => {
                return "Clusters";
            }
        });

        $stateProvider.state('admin.clusters.cluster', {
            url: '/:clusterId',
            templateUrl: '/templates/admin/clusters/cluster.html',
            controller: "ClusterController",
            pageTitle: () => {
                return "Cluster";
            }
        });

        // CodeStudios admin
        $stateProvider.state('admin.code-studios', {
            url: 'code-studios',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('admin.code-studios.list', {
            url: '/',
            templateUrl: '/templates/admin/code-studios/code-studio-templates.html',
            controller: "CodeStudioTemplatesListController",
            pageTitle: () => "Code Studio templates"
        });

        $stateProvider.state('admin.code-studios.code-studio', {
            url: '/:codeStudioTemplateId',
            templateUrl: '/templates/admin/code-studios/code-studio-template.html',
            controller: "CodeStudioTemplateController",
            pageTitle: (stateParams) => stateParams.codeStudioTemplateId ? stateParams.codeStudioTemplateId : 'Code Studio template'
        });

        //last but not the least : a route to cach everything that could not be routed

        $stateProvider.state("otherwise", {
            url: "*path",
            templateUrl: "/templates/404.html",
            controller: function($scope, $stateParams) {
                $scope.$stateParams = $stateParams;
            }
        });
    };

    app.provider('routes', function($stateProvider, $urlRouterProvider, MLRoutingService, WorkspacesRoutes) {
        this.$get = function() {
            declareRoutes($stateProvider, $urlRouterProvider, MLRoutingService, WorkspacesRoutes);
            return {};
        }
    });

    app.factory('translate', function($translate, $interpolate, $translateSanitization) {
        return function(translateID, defaultValue, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy = null) {
            let result = $translate.instant(translateID, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy);
            if (result === translateID && defaultValue !== undefined) {
                // sanitize translation for the default value using the same strategy as for a non-default value
                const sanitizedInterpolateParams = $translateSanitization.sanitize(interpolateParams, 'params', sanitizeStrategy);
                const rawResult = $interpolate(defaultValue)(sanitizedInterpolateParams);
                return $translateSanitization.sanitize(rawResult, 'text', sanitizeStrategy);
            }
            return result;
        }
    });

    // Service holding the translation tables preloaded by the UI via the /get-configuation call
    // They are temporarily stored in this service until requested by dssTranslationLoader.
    // This allow to correctly bootstrap the first screens of the UI with translations already loaded.
    app.service("PreloadedTranslationTables", () => {
        const svc = {};
        svc.add = function(language, translations) {
            svc.translationTables[language] = translations;
        };
        svc.getAndRemove = function(language) {
            const result = svc.translationTables[language];
            delete svc.translationTables[language];
            return result;
        };
        svc.translationTables = {};
        return svc;
    });

    app.factory('dssTranslationLoader', function($q, $http, DataikuAPI, PreloadedTranslationTables) {
        return function(options) {
            // First look whether this language was preloaded, if not load it asynchronously
            const preloadedTranslations = PreloadedTranslationTables.getAndRemove(options.key);
            if (preloadedTranslations !== undefined) {
                return $q.resolve(preloadedTranslations);
            } else {
                const deferred = $q.defer();
                DataikuAPI.translations.get("frontend", options.key)
                    .success(function(data) {
                        return deferred.resolve(data.translations);
                    })
                    .catch(() => deferred.resolve({})); // Use an empty dictionary in case of error so that we use the fallbacks
                return deferred.promise;
            }
        }
    });


    app.config(function($locationProvider, $httpProvider, $compileProvider, $translateProvider, $provide, routesProvider) {
        $locationProvider.html5Mode(true);
        routesProvider.$get();
        $httpProvider.interceptors.push('dssInterceptor');

        $translateProvider.preferredLanguage('en');
        $translateProvider.keepContent(true);
        $translateProvider.useLoader('dssTranslationLoader');
        $translateProvider.useSanitizeValueStrategy('escapeParameters');
    });
})();
