(function() {
    'use strict';

    angular.module('dataiku.dashboards').component('dashboardFilterPanelCacheLoader', {
        bindings: {
            filterFacetsLoadingState: '<',
            direction: '<', // FiltersPanelDirection,
            raiseError: '&' // ({ $errorData }) => void,
        },
        templateUrl:
      '/static/dataiku/js/dashboards/components/dashboard-filter-panel-cache-loader/dashboard-filter-panel-cache-loader.component.html',
        controller: function(DataikuAPI, ProgressStackMessageBuilder, FiltersPanelDirection) {
            const ctrl = this;
            ctrl.FiltersPanelDirection = FiltersPanelDirection;
            ctrl.percentage = 0;
            ctrl.started = false;
            ctrl.$onChanges = function(changes) {
                if(changes.filterFacetsLoadingState && ctrl.filterFacetsLoadingState != null && !ctrl.filterFacetsLoadingState.hasResult) {
                    ctrl.percentage = ProgressStackMessageBuilder.getPercentage(ctrl.filterFacetsLoadingState.progress);
                    ctrl.started = ctrl.filterFacetsLoadingState.progress && ctrl.filterFacetsLoadingState.progress.states && ctrl.filterFacetsLoadingState.progress.states.length;
                    ctrl.stackMessage = ProgressStackMessageBuilder.build(ctrl.filterFacetsLoadingState.progress, false, ctrl.direction === FiltersPanelDirection.Vertical);
                }
            };

            ctrl.abort = function() {
                if (ctrl.filterFacetsLoadingState && ctrl.filterFacetsLoadingState.jobId) {
                    DataikuAPI.futures.abort(ctrl.filterFacetsLoadingState.jobId).catch(({ data, status, headers, config, statusText }) => {
                        ctrl.raiseError({ $errorData: { data, status, headers, config, statusText } });
                    });
                }
            };
        }
    });
})();
