(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/edit.js
     */
    app.controller('ExportDashboardModalController', function($scope, DataikuAPI, ActivityIndicator, FutureProgressModal, WT1, DashboardFilters, DashboardFiltersUrlParams) {
        $scope.init = function(selection, massExport, fromDashboardEdit = false) {
            // Selection can correspond to multiple dashboards or a single dashboard
            $scope.params = {};

            let filtersBySlide = [];
            // If we export from the dashboard edit page, we cannot take into account filters that may not have been saved
            if (!fromDashboardEdit) {
                filtersBySlide = selection.pages.map(page => DashboardFiltersUrlParams.getFiltersQueryStringValue(DashboardFilters.getActiveGlobalFilters(page.id) || []));
            }

            if (massExport == true) {
                if ($scope.selection.selectedObjects.length > 0) {
                    $scope.projectKey = $scope.selection.selectedObjects[0].projectKey;
                } else {
                    $scope.projectKey = null;
                }
                $scope.params.dashboards = $scope.selection.selectedObjects.map(function(dashboard) {
                    return { dashboardId: dashboard.id, filtersBySlide, slideIndex: undefined };
                });
                if ($scope.selection.selectedObjects.length == 1) {
                    $scope.projectKey = $scope.dashboard.projectKey;
                    $scope.modalTitle = 'Export dashboard : ' + $scope.dashboard.name;
                } else {
                    $scope.projectKey = $scope.selection.selectedObjects.length == 0 ? null : $scope.selection.selectedObjects[0].projectKey;
                    $scope.modalTitle = 'Export a list of ' + $scope.selection.selectedObjects.length + ' dashboards';
                }
            } else {
                $scope.projectKey = $scope.dashboard.projectKey;
                $scope.params.dashboards = [ { dashboardId: $scope.dashboard.id, filtersBySlide, slideIndex: undefined } ];
                $scope.modalTitle = 'Export dashboard : ' + $scope.dashboard.name;
            }
        };

        $scope.exportDashboard = function() {
            WT1.event('dashboard-exported-from-dashboard-universe', {
                format: $scope.params.exportFormat
            });

            if ($scope.params.exportOnlyCurrentSlide && $scope.params.dashboards.length == 1) {
                $scope.params.dashboards[0].slideIndex = $scope.pageIdx;
            }
            DataikuAPI.dashboards.export($scope.projectKey, $scope.params.exportFormat, $scope.params.dashboards)
                .error(setErrorInScope.bind($scope))
                .success(function(resp) {
                    FutureProgressModal.show($scope, resp, 'Export dashboard').then(function(result) {
                        if (result) { // undefined in case of abort
                            downloadURL(DataikuAPI.dashboards.getExportURL(result.projectKey, result.exportId));
                            ActivityIndicator.success('Dashboard export(s) downloaded!', 5000);
                        } else {
                            ActivityIndicator.error('Export dashboard failed', 5000);
                        }
                        $scope.resolveModal();
                    });
                });
        };
    });
})();
