(function() {

const app = angular.module('dataiku.ngXmigration', []);

// This is a wrapper on dku-bs-select because in angularJS it has to be an attribute directive on <select>
// and upgraded components cannot be attribute directives
app.directive('ng1DkuBsSelect', ['$compile', function($compile) {
    return {
        scope: {
            params: '<',
            list: '<',
            model: '<',
            ngOptions: '<',
            modelChange: '&',
            required: '<',
            optionsDescriptions: '<',
            optionsAnnotations: '<',
            layout: '<',
            dataActionsBox: '<',
            dataLiveSearch: '<',
            dkuMultiple: '<',
            disabled: '<',
            styleClasses : '<'
        },
        // directive breaks if optionsDescriptions is empty and passed to the select
        template: '',
        link: {
            pre: function($scope, $el) {
                $scope.$watch('model', () => {
                    $scope.modelChange($scope.model);
                });

                // 1) adding multiple and optionsDescriptions using setAttribute doesn't work properly
                // and we cannot bind to neither multiple attribute in the template (angularjs limitation w/ ng model)
                // nor can be we bind to optionsDescriptions nor optionsAnnotations (throws an error if null)
                // without using ng-show/ng-if (which gets messy with several non-bindable attributes).
                let select = `
                    <select dku-bs-select="params" class="{{styleClasses}}" data-qa-smid="select-params" ng-model="model" ng-options="{{ngOptions}}"
                    ng-required="required" layout="{{layout}}" data-actions-box="{{dataActionsBox}}" data-live-search="{{dataLiveSearch}}"
                `;

                if ($scope.optionsDescriptions) {
                    select += ' options-descriptions="{{ optionsDescriptions }}" ';
                }

                if ($scope.optionsAnnotations) {
                    select += ' options-annotations="{{ optionsAnnotations }}" ';
                }

                if ($scope.dkuMultiple) {
                    select += ' multiple="multiple" ';
                }

                if ($scope.disabled) {
                    select += ' disabled ';
                }

                select += '></select>'

                const $select = $compile(select)($scope);
                $el.append($select);

            }
        }
    };
}]);

app.directive('ng1DatasetSelectionOrderingDirective', [ function() {
    return {
        scope: {
            selection: '=',
            datasetSupportsReadOrdering: '<',
            shakerState: '<'
        },
        template: `<div dataset-selection-ordering-fields selection="selection"
            dataset-supports-read-ordering="datasetSupportsReadOrdering"
            shaker-state="shakerState" />`,
    };
}]);

app.directive('ng1DatasetSelectorDirective', [ function() {
    return {
        scope: {
            dataset: '<',
            datasetChange: '<',
            availableDatasets: '<',
            required: '<',
        },
        template: `<div dataset-selector="dataset" available-datasets="availableDatasets" required="{{required}}"></div>`,
        link: function($scope) {
            $scope.$watch('dataset', () => {
                if ($scope.datasetChange) {
                    $scope.datasetChange.emit($scope.dataset)
                }
            });
        }
    };
}]);

app.directive('ng1Markdown', function() {
    return {
        scope: {
            from: '<',
            targetBlank: '<?',
            mdCallback: '&?'
        },
        template: `<div from-markdown="from" target-blank="targetBlank" md-callback="mdCallback"></div>`,
    }
});

app.directive('ng1ManagedFolderContentsView', function() {
    return {
        scope: {
            odb: '<',
            subFolderStartingPoint: '<?',
            initialSubFolder: '<?',
        },
        template: `<div class="h100" managed-folder-contents-view odb="odb" read-only="true" can-download="true" sub-folder-starting-point="subFolderStartingPoint" initial-sub-folder="initialSubFolder"></div>`,
    }
});

app.directive('ng1Lottie', function() {
    return {
        scope: {
            animationData: '@',
        },
        template: `<lottie animation-data="{{animationData}}"></lottie>`
    }
});

app.directive('ng1AutocompletableTextarea', function($compile) {
    return {
        scope: {
            model: '<',
            modelChange: '<',
            options: '<?',
            textarea: '<?',
            fromAngularContext: '<?',
        },
        template: '',
        link: function($scope, $el) {
            $scope.$watch('model', () => {
                $scope.modelChange.emit($scope.model);
            });

            const divAttrs = $scope.options ? ` options="${$scope.options}"` : '';
            let textareaAttrs = '';

            if ($scope.textarea) {
                Object.entries($scope.textarea).forEach(([key, value]) => textareaAttrs += ` ${key}="${value}"`);
            }

            const template = `
                <div autocompletable-textarea${divAttrs} from-angular-context="{{true}}">
                    <textarea ng-model="model" ui-codemirror="editorOptions"${textareaAttrs}></textarea>
                </div>`;

            $el.append($compile(template)($scope));
        }
    }
});

app.directive('ng1StarInterest', function() {
    return {
        scope: {
            status: '<',
            toggle: '&',
            tooltipPosition: '@?',
        },
        template: '<star-interest status="status" on-toggle="toggle(nextStatus)" tooltipPosition="tooltipPosition"></star-interest>',
    }
});

app.directive('ng1RelatedByType', function() {
    return {
        scope: {
            elementsByType: '<',
            baseString: '<',
            baseItemProjectKey: '<'
        },
        template: `<related-by-type elements-by-type="elementsByType" base-string="baseString" base-item-project-key="baseItemProjectKey"></related-by-type>`
    }

})

app.directive('ng1UiGlobalTag', function() {
    return {
        scope: {
            tag: '=uiGlobalTag',
            objectType: '<?'
        },
        template: `<span ui-global-tag="tag" object-type="objectType"/>`,
    }
});

app.directive('ng1DatasetStatus', function() {
    return {
        scope: {
            objectName: '<',
            checklists: '<',
            data: '<',
            context: '<',
            readOnly: '<'
        },
        template: `<dataset-status objectName="objectName" checklists="checklists" data="data" context="context" readOnly="readOnly"></dataset-status>`,
    }
});

app.directive('ng1UiView', function() {
    return {
        scope: {
            addToScope: '<',
            cssClass: '<'
        },
        template: `<ui-view ng-class="cssClass" addToScope="addToScope"></ui-view>`,
    }
});

app.directive('ng1UiSref', function() {
    return {
        scope: {
            route: '<',
            linkClass: '<',
        },
        transclude: true,
        template: `<a ui-sref="{{route}}" ng-transclude></a>`,
        link: function($scope, element) {
            // Add the CSS class directly on the DOM element instead of 
            // using ng-class because there is a synchronization issue between
            // angularjs and angular.
            const getLinkElement = () => element[0].querySelector('a');
            const parseLinkClasses = (_linkClass) => _linkClass ? _linkClass.split(" ") : [];

            getLinkElement().classList.add(...parseLinkClasses($scope.linkClass || 'a--no-style'));

            $scope.$watch('linkClass', function (newClass, oldClass) {
                if (oldClass) {
                    getLinkElement().classList.remove(...parseLinkClasses(oldClass));
                }

                getLinkElement().classList.add(...parseLinkClasses(newClass || 'a--no-style'));
            });
        }
    }
});

app.directive('ng1StandardizedSidePanel', ['$timeout', 'MigrationStoreService', function($timeout, MigrationStoreService) {
    return {
        scope: {
            objectType: '<',
            page: '<',
            closeOnClickOutside: '<',
            toggleTab: '<',
            singleType: '<'
        },
        template: '<standardized-side-panel object-type="{{objectType}}" page="{{page}}" close-on-click-outside="{{closeOnClickOutside}}" toggle-tab="{{toggleTab}}" single-type="singleType"></standardized-side-panel>',
        link: function($scope) {
            const updateOptions = (options) => {
                if (options) {
                    Object.entries(options).forEach(([key, value]) => $scope[key] = value);

                    $timeout(() => {
                        $scope.$apply();
                    });
                }
            };

            const subId = MigrationStoreService.subscribe('standardizedSidePanelOptions', updateOptions);

            $scope.$on('$destroy', function() {
                MigrationStoreService.unsubscribe(subId);
            });
        }
    }
}]);

app.directive('ng1InsightPage', function() {
    return {
        scope: {},
        template: `<div ng-controller="InsightCoreController" ng-include="'/templates/dashboards/insights/view.html'"></div>`
    }
});

app.directive('ng1AppPage', function() {
    return {
        scope: {},
        template: `<div class="workspace-app-viewer" ng-include="'/templates/apps/app-page.html'"></div>`
    }
});

app.directive('ng1DashboardPage', function() {
    return {
        scope: {
            options: '<'
        },
        template: `<div ng-include="'/templates/dashboards/view.html'"></div>`,
        link: function($scope) {
            const updateOptions = () => {
                if ($scope.options) {
                    Object.entries($scope.options).forEach(([key, value]) => $scope[key] = value);
                }
            };
            $scope.$watch('options', updateOptions, true);
            updateOptions();
        }
    }
});

app.directive('ng1DatasetTableInsightEdit', function() {
    return {
        scope: {
            insight: '<',
            projectKey: '<',
            datasetOptions: '<',
            appConfig: '<'
        },
        template: '<div dataset-table-insight-edit></div>',
        link: function($scope) {
            const updateProjectKey = () => {
                if ($scope.projectKey) {
                    $scope.$stateParams = { projectKey: $scope.projectKey };
                }
            };
            $scope.displayApiErrorBlock = true;
            $scope.$watch('projectKey', updateProjectKey, true);
            updateProjectKey();

            const updateDatasetOptions = () => {
                if ($scope.datasetOptions) {
                    Object.entries($scope.datasetOptions).forEach(([key, value]) => $scope[key] = value);
                }
            };
            $scope.$watch('datasetOptions', updateDatasetOptions, true);
            updateDatasetOptions();
        }
    }
});

app.directive('ng1ArticleInsightView', function() {
    return {
        scope: {
            insight: '=',
            onError: '&',
        },
        template: '<div article-insight-view insight="insight" on-error="onError({ data: error })"></div>'
    }
});

app.directive('ng1WebAppInsightView', function() {
    return {
        scope: {
            insight: '=',
            onError: '&',
        },
        template: '<span web-app-insight-view insight="insight" on-error="onError({ data: error })"></span>'
    }
});

app.directive('ng1TextOverflowTooltip', function() {
    return {
        scope: {
            textTooltip: '<',
            tooltipDirection: '<?',
            allowHtml: '<?',
            alwaysShowTooltip: '<?'
        },
        template: `
            <div
                class="w100"
                show-tooltip-on-text-overflow
                text-tooltip="textTooltip"
                tooltip-direction="tooltipDirection"
                allow-html="allowHtml"
                always-show-tooltip="alwaysShowTooltip"
            ></div>
        `
    }
});

// AngularJS wrapper on top of the downgraded Angular 2+ <basic-select>
app.directive('basicSelect', function ($timeout) {
    return {
        scope: {
            // items: '<*'       <----- One-way collection binding is not available in AngularJS 1.6 (only >= AngularJS 1.7.1)
            bindLabel: '@',
            searchable: '<',
            clearable: '<',
            groupBy: '@',
            placeholder: '@',
            bindValue: '@',
            bindAnnotation: '@',
            trackBy: '@',
            titlePrefix: '@',
            summarizedSelectionItemsType: '@',
            multiple: '<',
            actionsBox: '<',
            invalidateOnGhosts: '<',
            bindGhostLabel: '@',
            ghostSectionTitle: '@',
            ghostItemsTooltip: '@',
            bindDisabled: '@',
            bindTooltip: '@',
            defaultOpened: '<',
            dropdownPosition: '@',
            customNgSelectClass: '@',
            labelForId: '@',
            annotationLayout: '@?',

            // AngularJS only: alternative bindings accepting expressions (eg. useful to pass a function instead of a property name)
            trackByFn: '<',
            bindValueFn: '<',
            bindLabelFn: '<',
            bindAnnotationFn: '<',
            groupByFn: '<',
            bindGhostLabelFn: '<',
            bindDisabledFn: '<',
            bindTooltipFn: '<',
            searchFn: '<'
        },
        require: 'ngModel',
        template: `
            <ng2-basic-select
                [items]="items"
                [bind-label]="bindLabel || bindLabelFn"
                [bind-tooltip]="bindTooltip || bindTooltipFn"
                [searchable]="searchable"
                [clearable]="clearable"
                [title-prefix]="titlePrefix"
                [summarized-selection-items-type]="summarizedSelectionItemsType"
                [placeholder]="placeholder"
                [multiple]="multiple"
                [actions-box]="actionsBox"
                [bind-value]="bindValue || bindValueFn"
                [bind-annotation]="bindAnnotation || bindAnnotationFn"
                [annotation-layout]="annotationLayout || 'annotation'" // to make sure a value is passed else it's undefined
                [group-by]="groupBy || groupByFn"
                [track-by]="trackBy || trackByFn"
                [search-fn]="searchFn"
                [bind-ghost-label]="bindGhostLabel || bindGhostLabelFn"
                [bind-disabled]="bindDisabled || bindDisabledFn"
                [ghost-section-title]="ghostSectionTitle"
                [ghost-items-tooltip]="ghostItemsTooltip"
                [ng1-disabled]="ng1Disabled"
                [label-for-id]="labelForId"
                [invalidate-on-ghosts]="invalidateOnGhosts"
                ng-model="selectedValue"
                ng-change="valueChanged()"
                [default-opened]="defaultOpened"
                [dropdown-position]="dropdownPosition"
                [custom-ng-select-class]="customNgSelectClass"
            ></ng2-basic-select>`,
        link: function ($scope, _element, attrs, ngModelController) {
            // Emulate one-way collection binding for AngularJS 1.6
            //
            // The goal is to allow:
            //
            //     <basic-select items="items | orderBy">
            //
            // ...which otherwise fails with infinite $digest, see https://github.com/angular/angular.js/issues/15874
            $scope.ng1Disabled = false;
            $scope.items = [];
            const unregisterFn = $scope.$parent.$watchCollection(attrs.items, (items) => {
                $scope.items = items;
            });
            $scope.$on('$destroy', () => unregisterFn());

            // Value is '' when doing <basic-select [...] disabled> and boolean when doing <basic-select [...] ng-disabled="expresion">
            attrs.$observe('disabled', value => $scope.ng1Disabled = value === '' || !!value);

            ngModelController.$render = () => {
                $scope.selectedValue = ngModelController.$modelValue;
            }

            $scope.valueChanged = () => {
                $timeout(() => ngModelController.$setViewValue($scope.selectedValue));
            }
        }
    }
});

app.directive('ng1DatasetPreview', ['MigrationStoreService', function(MigrationStoreService){
    return {
        scope: {
            projectKey: '<',
            datasetName: '<',
            embeddedLoadingDisplay: '<?',
            showName: '<?',
            showMeaning: '<?',
            showStorageType: '<?',
            showDescription: '<?',
            showCustomFields: '<?',
            showProgressBar: '<?',
            showHeaderSeparator: '<?',
            disableHeaderMenu: '<?',
            shakerOrigin: '<?',
            shakerColoringScheme: '<?'
        },
        template:
        `<dataset-preview-table 
            project-key="projectKey" 
            dataset-name="datasetName"
            embedded-loading-display="embeddedLoadingDisplay"
            show-name="showName"
            show-meaning="showMeaning"
            show-storage-type="showStorageType"
            show-description="showDescription"
            show-custom-fields="showCustomField"
            show-progress-bar="showProgressBar"
            show-header-separator="showHeaderSeparator"
            disable-header-menu="disableHeaderMenu"
            shaker-origin="shakerOrigin"
            shaker-coloring-scheme="shakerColoringScheme"
        ></dataset-preview-table>`,
        link: function ($scope) {
            const subId = MigrationStoreService.subscribe('refreshDatasetPreview', () => $scope.$broadcast('refresh-preview-table-without-cache'));

            $scope.$on('$destroy', () => MigrationStoreService.unsubscribe(subId));
        }
    }
}]);

app.directive('ng1SimpleDetectionPreviewTable', function() {
    return {
        scope: {
            headers: '<',
            table: '<',
            dataset: '<',
            setSchemaUserModified: '<?',
            schemaIsUserEditable: '<?'
        },
        template:
        `<div simple-detection-preview-table
            headers="headers"
            table="table"
            dataset="dataset"
            set-schema-user-modified="setSchemaUserModified"
            schema-is-user-editable="schemaIsUserEditable"
        />`
    }
});

app.directive('ng1DkuMdPopover', ['$compile', function($compile) {
    return {
        scope: {
            dkuMdPopover: '<',
            dkuMdTitle: '<'
        },
        template: '',
        link: {
            pre: function($scope, $el) {
                $el.attr("dku-md-popover", $scope.dkuMdPopover);
                $el.attr("dku-md-title", $scope.dkuMdTitle);
                $compile($el)($scope);
            }
        }
    };
}]);

app.directive('ng1TagEditPopover', function(TaggingService, $timeout) {
    return {
        scope: {
            tags: '<',
            tagsChange: '&',
            getAllTags: '<',
            objectType: '<?',
            manageLink: "<",
            noTagIcon: '<',
            editable: '<?',
            responsive: '<?'

        },
        template: `
        <tag-edit-popover
            ng-if="show"
            ng-model="tagsCopy"
            get-all-tags="getAllTags()"
            object-type="objectType"
            manage-link="manageLink"
            no-tag-icon="noTagIcon"
            editable="editable"
            responsive="responsive"
        ></tag-edit-popover>`,
        link(scope) {
            // in order to ensure the tag-edit-popover correctly finds the global tags, we only render it once those are fetched
            scope.show = false;
            TaggingService.fetchGlobalTags().then(() => scope.show = true);

            scope.$watch('tags', () => {
                if(!scope.tags) return;
                // we work on a copy so that the side-effect behavior of ng1 doesn't leak on ngX
                scope.tagsCopy = [...scope.tags]
            });

            scope.$watch('editable', () => {
                $timeout(() => {
                    scope.$apply(); // sometimes the ng1 component doesn't detect the change to editable immediately, so we force a cycle
                }, 50);
            });

            // we replace the edition detection via scope event by a classic Angular @Output emit
            scope.$on('objectSummaryEdited', () => {
                scope.tagsChange(scope.tagsCopy);
                scope.tagsCopy = [...scope.tags]; // simulate a pure @Output with no internal state (useful in case of error in the event handler)
            });
        }
    }
});

/**
 * A directive that allows to display tags.
 * This is not a full upgrade of the angularjs component, which is more complex and has more options.
 * This only contains what is required to displaying the tags.
 */
app.directive('ng1ResponsiveTagsList', function(TaggingService) {
    return {
        scope:{
            objectType: '<',
            tags: '<',
            highlighted: '<',
            displayPopoverOnHover: '<'
        },
        template: `<responsive-tags-list
            style="position:relative"
            object-type="objectType"
            items="tags"
            highlighted="highlighted"
            display-popover-on-hover="displayPopoverOnHover"
            tags-map="tagsMap">
        </responsive-tags-list>`,
        link(scope) {
            scope.tagsMap = {};
            scope.$watch('tags', (nv) => scope.tagsMap = TaggingService.fillTagsMapFromArray(nv || []))
        }
    }
});

app.directive('ng1DkuSlider', function() {
    return {
        scope: {
            min: '<',
            max: '<',
            nbDecimalPlaces: '<?',
            value: '=',
            valueChange: '&'
        },
        template: '<div class="oh padleft4 padright4" dku-slider min="min" max="max" nb-decimal-places="nbDecimalPlaces" value="value"></div>',
        link: function ($scope) {
            $scope.$watch('value', (newValue, oldValue) => {
                if (newValue !== oldValue) {
                    $scope.valueChange(newValue);
                }
            });
        }
    }
});

app.directive('ng1ContinuousColorLegend', function() {
    return {
        scope: {
            legend: '=',
            $index: '='
        },
        template: '<div continuous-color-legend legend="legend" />'
    }
});

app.directive('ng1DiscreteColorMenu', function() {
    // TTODO: check if is still used
    return {
        scope: {
            chartDef: '=',
            legends: '='
        },
        template: '<discrete-color-menu chart-def="chartDef" legends="legends"></discrete-color-menu>'
    }
});

app.directive('ng1ColorPaletteSelector', function() {
    return {
        scope: {
            colorPaletteSelectorId: '<',
            colorDimension: '<?',
            isDiscrete: '<',
            colorOptionsChange: '&',
            usableColumns: '<',
            theme: '<',
            enableReset: '<'
        },
        template: '<color-palette-selector enable-reset="enableReset" color-palette-selector-id="colorPaletteSelectorId" color-dimension="colorDimension" is-discrete="isDiscrete" usable-columns"usableColumns" theme="theme"></color-palette-selector>',
        link: function ($scope) {
            $scope.$on('colorOptionsChange', (_, value) => {
                $scope.colorOptionsChange(value);
            });
        }
    }
});

app.directive('ng1DkuColorPicker', function() {
    return {
        scope: {
            color: '=',
            colorChange: '&'
        },
        template: '<div colorpicker ng-model="color" style="background-color:{{color}}">&#8203;</div>',
        link: function ($scope) {
            $scope.$watch('color', (newValue, oldValue) => {
                if (newValue !== oldValue) {
                    $scope.colorChange(newValue);
                }
            });
        }
    }
});

app.directive('ng1FilterEditor', function() {
    return {
        scope: {
            filterDesc: '<',
            schema: '<',
            dataset: '<',
            mustRunInDatabase: '<?',
            filterUpdateCallback: '<?',
            recipeAdditionalParams: '<?',
            mainRecipeInput: '<?',
            modelLabel: '<?',
            filterDescChange: '&'
        },
        template: `
            <filter-editor
                filter-desc="filterDesc"
                schema="schema"
                dataset="dataset"
                must-run-in-database="mustRunInDatabase"
                filter-update-callback="filterUpdateCallback"
                recipe-additional-params="recipeAdditionalParams"
                main-recipe-input="mainRecipeInput"
                model-label="{{modelLabel}}"
            />
        `,
        link: function ($scope) {
            $scope.filterUpdateCallback = (filterDesc) => $scope.filterDescChange(angular.copy(filterDesc));

        }
    }
});


app.directive('ng1SamplingForm', function() {
    return {
        scope: {
            selection : '<',
            selectionChange : '&',
            datasetSmartName : '<',
            showPartitionsSelector: '<',
            disabled : '<',
        },
        template: '<div sampling-form selection="selection" dataset-smart-name="datasetSmartName" show-partitions-selector="showPartitionsSelector" disabled="disabled"/>',
        link: function ($scope) {
            $scope.$watch('selection', (newValue, oldValue) => {
                if (newValue !== oldValue) {
                    $scope.selectionChange(newValue);
                }
            }, true);
        }
    }
});

app.directive('ng1PivotFilterFacet', function() {
    return {
        scope: {
            filterTmpData: '<', // FilterTmpData
            filterFacet: '<', // FilterFacet
            facetUiState: '<', // FacetUiState
            filters: '<', // FrontendChartFilter[]
            index: '<', // number
            getFiltersRequestOptions: '<', // () => FiltersRequestOptions
            dateFilterTypeChange: '&', // ({ $dateFilterType }) => void
            filterFacetChange: '&', // ({ $filterFacet }) => void
            filterTmpDataChange: '&', // ({ $filterTmpData }) => void
        },
        template: `
            <pivot-filter-facet filter-tmp-data="filterTmpData"
                filter-facet="filterFacet"
                facet-ui-state="facetUiState"
                filters="filters"
                index="index"
                get-filters-request-options="getFiltersRequestOptions"
                date-filter-type-change="dateFilterTypeChange({dateFilterType: $dateFilterType})"
                filter-facet-change="filterFacetChange({filterFacet: $filterFacet})"
                filter-tmp-data-change="filterTmpDataChange({filterTmpData: $filterTmpData})">
            </pivot-filter-facet>
        `,
        link: function () { }
    }
});

app.directive('ng1DashboardFilterDatasetColumnPicker', function() {
    return {
        scope: {
            // inputs
            datasetSmartName: '<', // string
            columns: '<', // UsableColumn[]
            enableDatasetSelection: '<', // boolean
            // outputs
            selectColumns: '&', // (columns: string[]) => void
            selectDataset: '&', // ({ sourceObject, sourceType, selectedTile }) => void
            cancelSelection: '&' // () => void
        },
        template: `
        <dashboard-filter-dataset-column-picker columns="columns"
            dataset-smart-name="datasetSmartName"
            enable-dataset-selection="enableDatasetSelection"
            select-dataset="selectDataset({ sourceObject: $sourceObject, sourceType: $sourceType, selectedTile: $selectedTile })"
            select-columns="selectColumns($columns)"
            cancel-selection="cancelSelection()">
        </dashboard-filter-dataset-column-picker>
        `,
        link: function () { }
    }
});

app.directive('ng1CodeMirrorEditor', function() {
    return {
        scope: {
            code: '=',
            codeChange: '&',
            options: '=',
            codeMirrorElementChanged: '&'
        },
        template: '<textarea on-change="codeChange($event)" ng-model="code" ui-codemirror="options"></textarea>',
        link: function ($scope, $element) {
            $scope.$watch('code', (newValue) => {
                $scope.codeChange(newValue);
            });

            $scope.codeMirrorElementChanged($('.CodeMirror', $element).get(0).CodeMirror);
        }
    }
});

app.directive('ng1CustomParamsForm', function() {
    return {
        scope: {
            pluginDesc: '<',
            componentId: '<',
            paramsDesc: '<',
            config: '<',
            configChanged: '&',
            isValid: '&',
            viewMode: '<',
        },
        template: `<div custom-params-form desc="paramsDesc" plugin-desc="pluginDesc" component-id="componentId" config="configInternal" view-mode="viewMode"/>`,
        link: function ($scope) {
            $scope.configInternal = angular.copy($scope.config);

            $scope.$watch(() => $scope.config, (config, prev) => {
                // we use this strange copy method because we absolutely must not change the configInternal reference
                // otherwise, it messes up the way customTemplateWithCallPythonDo is initialized & all calls to the python backend would use the initial config
                // we also don't do anything if new value is same as internal value in order to avoid losing focus on edit for nested forms
                if (!angular.equals(config, $scope.configInternal)) {
                    Object.keys($scope.configInternal).forEach(key => delete $scope.configInternal[key]);
                    Object.keys(config).forEach(key => $scope.configInternal[key] = angular.copy(config[key]));
                }
            });

            $scope.$watch(() => $scope.configInternal, (newValue) => {
                $scope.configChanged(angular.copy(newValue));
            }, true);
        }
    }
});


app.directive('ng1DateRangePicker', function() {
    return {
        scope: {
            disabled: '<',
            format: '<',
            start: '<',
            end: '<',
            startChange: '&?',
            endChange: '&?',
        },
        template: `<div daterangepicker
            disabled="disabled"
            start-date="startInternal"
            end-date="endInternal"
            format="{{ format }}"
        ></div>`,
        link: function ($scope) {
            twoWayBingingPrimitive($scope, 'start', {transform: (val) => val || ''});
            twoWayBingingPrimitive($scope, 'end', {transform: (val) => val || ''});
        }
    }
});

app.directive('ng1MeaningSelector', function($rootScope, CreateModalFromTemplate, ContextualMenu) {
    return {
        scope: {
            columnName: '<',
            specialMeaningLabel: '<',
            specialMeaningValue: '<',
            meaning: '<',
            disabled: '<',
            meaningChange: '&?',
        },
        template: `
            <button class="has-caret" ng-click="!disabled && openMeaningMenu()" ng-class="{disabled: disabled}">
                <span ng-if="meaning == specialMeaningValue">{{ specialMeaningLabel }}</span>
                <span ng-if="meaning != specialMeaningValue">{{ meaning | meaningLabel }}</span>
                <span class="caret"></span>
            </button>
        `,
        link: function ($scope, $element) {
            $scope.appConfig = $rootScope.appConfig;

            $scope.openMeaningMenu = function() {
                $scope.meaningMenu.openAlignedWithElement($element.find('button'), () => {}, true, true);
            };

            $scope.setColumnMeaning = function(meaningId) {
                $scope.meaningChange && $scope.meaningChange(meaningId);
            };

            $scope.editColumnUDM = function() {
                CreateModalFromTemplate("/templates/meanings/column-edit-udm.html", $scope, null, function(newScope) {
                    newScope.initModal($scope.columnName, $scope.setColumnMeaning);
                });
            };

            $scope.meaningMenu = new ContextualMenu({
                template: "/templates/shaker/edit-meaning-contextual-menu.html",
                cssClass : "column-header-meanings-menu meaning-selector",
                scope: $scope,
                contextual: false,
                onOpen: function() {},
                onClose: function() {}
            });
        }
    }
});


app.directive('ng1DataLineageFlowExport', function() {
    return {
        scope: {
            svg: '<'
        },
        template: `
            <div lineage-flow-export>
                <div id="flow-export-toolbox-anchor"></div>
            </div>
        `,
        link: function () {}
    }
});

app.directive('ng1DashboardTileContent', function() {
    return {
        scope: {
            tile: '<',
            insight: '<',
            editable: '<',
            hook: '<',
            activeFilters: '<',
            filters: '<',
            page: '<',
            dashboardTheme: '<',
            showGrid: '<',
            selected: '<',
            currentGroupTileIdInEditMode: '<',
            tileSpacing: '<',
            preselectedTile: '<',
            insightsMap: '<',
            accessMap: '<',
            canExportDatasets: '<',
            filtersChange: '&', // ({ $filters }) => void
            filtersParamsChange: '&', // ({ $filtersParams }) => void,
            isDeactivatedChange: '&', // ({ $isDeactivated }) => void
            preselectedTileChange: '&', // ({ $preselectedTile }) => void
            raiseError: '&', // ({ $errorData }) => void
            isTileLockedChange: '&' // ({ $isTileLocked }) => void
        },
        template: `
            <dashboard-tile tile="tile"
                editable="editable"
                insight="insight"
                hook="hook"
                active-filters="activeFilters"
                filters="filters"
                page="page"
                dashboard-theme="dashboardTheme"
                show-grid="showGrid"
                selected="selected"
                current-group-tile-id-in-edit-mode="currentGroupTileIdInEditMode"
                tile-spacing="tileSpacing"
                preselected-tile="preselectedTile"
                insights-map="insightsMap"
                access-map="accessMap"
                can-export-datasets="canExportDatasets"
                filters-change="filtersChange($filters)"
                filters-params-change="filtersParamsChange($filtersParams)"
                raise-error="raiseError($errorData)"
                is-deactivated-change="isDeactivatedChange($isDeactivated)"
                preselected-tile-change="preselectedTileChange($preselectedTile)"
                is-tile-locked-change="isTileLockedChange($isTileLocked)" />`,
        link: function () { }
    }
});

app.directive('ng1StdAggrMeasureDropzone', ['ChartTypeChangeHandler', function(ChartTypeChangeHandler) {
    return {
        scope: {
            placeholder: '<',
            qaDropzoneId: '<',
            measures: '<',
            chartDefKey: '<',
            contextualMenuMeasureType: '<',
            mono: '<',
            iconClass: '<',
            measuresChanged: '&'
        },
        template: `
            <div class="noflex chartdef-dropzone"
                ng-class="{
                    'empty': measures.length == 0,
                    'notempty': measures.length != 0,
                    'chartdef-dropzone-vertical': !mono,
                    'chartdef-dropzone-mono': !!mono
                }"
            >
                <div ng-if="!!iconClass" class="chartdef-dropzone-header header-btn">
                    <i class="{{ iconClass }}" style="float: none; vertical-align: middle;"></i>
                </div>
                <div class="empty-placeholder no-icon">
                    {{ placeholder }}
                </div>
                <div ng-if="!mono"
                    class="chartdef-dropzone-main"
                    id="{{ qaDropzoneId }}"
                    ng-init="contextualMenuMeasureType = contextualMenuMeasureType"
                    multivalued-std-aggr-measure-zone
                    direction='vertical'
                    list="measuresList"
                    chart-def-key="{{ chartDefKey }}"
                    contextualMenuMeasureType="contextualMenuMeasureType"
                    accept-callback="acceptMeasure">
                </div>
                <div ng-if="!!mono" class="chartdef-dropzone-main {{ qaDropzoneId }}"
                    contextualMenuMeasureType="contextualMenuMeasureType"
                    monovalued-std-aggr-measure-zone
                    direction='vertical'
                    list="measuresList"
                    chart-def-key="{{ chartDefKey }}"
                    accept-callback="acceptMeasure">
                </div>
            </div>
        `,
        link: function ($scope) {
            const reassignScopeProperty = (propertyName) => {
                let scope = $scope;
                let foundKey = false;
                while (scope && !foundKey) {
                    foundKey = Object.keys(scope).includes(propertyName);
                    if (foundKey) {
                        $scope[propertyName] = scope[propertyName];
                        scope.$watch(propertyName, (newVal) => {
                            $scope[propertyName] = newVal;
                        });
                    } else {
                        scope = scope.$parent;
                    }
                }
            }

            $scope.measuresList = _.cloneDeep($scope.measures);

            // re inject scope from parents
            ['activeDragDrop', 'validity', 'addClassHereAndThere',
                'removeClassHereAndThere', 'onDragEnd', 'chart',
                'onPercentileChoice', 'customMeasures', 'editEntity', 
                'openSection', 'toggleContextualMenu', 'globallyOpenContextualMenu'].map(reassignScopeProperty);
            $scope.acceptMeasure = function(data) {
                return ChartTypeChangeHandler.stdAggregatedAcceptMeasureWithAlphanumResults(data);
            };


            // subscribe to changes in the dropzone
            const registerToMeasuresListChanges = () => $scope.$watch('measuresList', (newVal) => {
                $scope.measuresChanged(newVal);
            }, true);

            let unregisterMeasuresListWatch = registerToMeasuresListChanges();
            $scope.$watch('measures', (newVal) => {
                // To avoid infinite loop, unregister the watch before setting the list
                unregisterMeasuresListWatch();
                $scope.measuresList = _.cloneDeep(newVal);
                unregisterMeasuresListWatch = registerToMeasuresListChanges();
            }, true);
        }
    }
}]);

app.directive('ng1LlmEvalRowByRowSources', function() {
    return {
        scope: {
            sources: '<'
        },
        template: `<llm-eval-row-by-row-sources sources="sources"></llm-eval-row-by-row-sources>`
    }
});

app.directive('ng1ProjectActivityHeatmap', function() {
    return {
        scope: {
            commits: '<'
        },
        template: `<svg week-day-heatmap data="commits" light="true" svg-titles formatter="commits === 'presenceHours' ? niceHours : null"></svg>`,
    }
});

app.directive('ng1ProjectScenariosRuns', function() {
    return {
        scope: {
            scenariosDays: '<',
            activeScenarios: '<',
            totalScenarios: '<',
            projectKey: '<'
        },
        template: `<project-scenarios-runs
            total-scenarios="totalScenarios"
            active-scenarios="activeScenarios"
            scenarios-days="scenariosDays"
            project-key="projectKey">
        </project-scenarios-runs>`,
    }
});



app.directive('ng1NestedFilter', function() {
    return {
        scope: {
            nestedFilters: '<',
            filterDesc: '=',
            schema: '<',
            filterHeader: '<',
            fromPrepare: '<',
            columnName: '<',
            onEnterKeydown:'<?',
            enumValuesProvider:'<?',
        },
        template: `
    <nested-filter 
        nested-filters="nestedFilters"
        filter-desc="filterDesc"
        schema="schema"
        filter-header="filterHeader"
        from-prepare="fromPrepare"
        column-name="columnName"
        on-enter-keydown="onEnterKeydown"
        enum-values-provider="enumValuesProvider"
    >
    </nested-filter>
    `,
        link: function () { }
    }
});

/**
 * Mostly the schema editor from the dataset settings, with some caveats:
 * - in angularjs, the schema is changed in-place, this is converted into an immutable change pattern - to maintain decent perf with big schema, the change detection is debounced by 50ms
 * - conversely, this component expects any change of the input coming from Angular to be done in an immutable way. Failing to do so will result in changes not be taken into account by the angularjs part
 * - the infer data button & everything it implies is disabled
 * - the export button is enabled
 * - disable works, but doesn't look to good as the component wasn't designed for it (quick & dirty patch)
 * - this component is sized using the class 'fh'. This means you MUST explicitly control its size by wrapping it in a 'position: relative' explicitly sized.
 * - if the available width is not enough the schema column rows will overflow. Make sure to test it on small screens, and if required tweak the row elements css (see span.name and span.comment selectors in .mx-schema-edition in dataset.less)
 *  - same for the header: it could wrap & you'll probably prefer to reduce the width of the search input
 *
 * Example:
 *  <ng1-schema-editor
        style="display: block; position: relative; height: 600px;"
        [(schema)]="schema"
        specialMeaningLabel="Doesn't matter"
        [alwaysHideCommentTab]="true"
        [datasetName]="dataset.name"
    />
 * */
app.directive('ng1SchemaEditor', function($rootScope) {
    return {
        scope: {
            schema: '<',                // the schema to edit
            // schemaChange: '&?',      // for performance, we are not emitting the changes from here, but it behaves as if (almost) from the Angular point of view
            disabled: '<?',             // disabled the edition in the component. doesn't look super-great
            specialMeaningLabel: '<?',  // the 'null' value meaning label (default: Auto-detect)
            alwaysHideCommentTab: '<?', // if true, the description tab will always be hidden
            datasetName:'<?',           // the dataset name (used by the export modal, to name the file "Schema of " + datasetName - it doesn't HAVE TO be a real dataset name, but if unset, the export will create a file named "Schema of undefined.something")
            hideExport: '<?',           // if true, the export button will be hidden (default: false)
        },
        template: `
            <div ng-if="schema" include-no-scope="/templates/datasets/schema-edition.html"></div>
        `,
        link: function ($scope) {
            const angularObjectScope = $scope.$parent; // to access stuff managed by the angular side

            // shallow watch of the input, when changed, update the angularjs internal variable.
            $scope.$watch('schema', (schema) => {
                // only rewrite schema if it's not the same cleanup version we just emitted
                if(schema !== angularObjectScope.lastEmittedValue) {
                    $scope.dataset.schema = angularObjectScope.copyAndCleanupSchema(schema); // we use copyAndCleanupSchema here because it's faster than angular.copy (the cleanup part here doesn't do anything, it's already clean)
                }
            });

            // on each digest cycle, we emit the current schema. Doing so instead of a deep compare will allow us to easily debounce the schema change detection, because it's costly to deep-compare too often with many columns (and a deep watch would do a deep compare on each digest cycle)
            $scope.$watch(() => {
                angularObjectScope.schemaChangeSubject.next($scope.dataset.schema);
            }, () => {});

            $scope.$watch('disabled', (disabled) => $scope.disableSchemaEditor = disabled);
            $scope.$watch('datasetName', (datasetName) => $scope.dataset.name = datasetName);
            $scope.$watch('hideExport', (hideExport) => $scope.hideExportButton = hideExport == null ? false : hideExport);

            // init everything the angularjs code requires
            $scope.dataset = {};
            $scope.appConfig = $rootScope.appConfig; // used by the meaning selectors to get the list of meanings
            $scope.setSchemaUserModified = function() {
                $scope.dataset.schema.userModified = true;
            };
        }
    }
});

/* A helper around watches to make the upgraded component more Angular-behaved with emission when value changes from the angularjs side only
 * Won't work with objects in most case as deep compare & deep copies would be required to properly handle in-place mutations & immutability
 * example:
app.directive('ng1Wrapped', function() {
    return {
        scope: {
            param: '<',
            paramChange: '&?',
        },
        template: `<wrapped param="paramInternal"></wrapped>`,
        link: function ($scope) {
            twoWayBingingPrimitive($scope, 'param');
        }
    }
});
* optionally you can apply transformations from / to Angular
*/

function twoWayBingingPrimitive($scope, name, opts) {
    const internalName = opts.internalName || name + 'Internal';
    const eventEmitterName = opts.eventEmitterName || name + 'Change';
    const ngx2ng = opts.ngx2ng || ((x) => x);
    const ng2ngx = opts.ng2ngx || ((x) => x);

    $scope.$watch(name, (val) => {
        $scope[internalName] = ng2ngx(val);
    });
    $scope.$watch(internalName, (val) => {
        val = ngx2ng(val)
        if($scope[name] != val) {
            $scope[name] = val;
            $scope[eventEmitterName] && $scope[eventEmitterName](val);
        }
    });
}

function retrieveScopeProperty(propertyName, $scope) {
    let scope = $scope;
    let res = null;
    let foundKey = false;
    while (scope && !foundKey) {
        foundKey = Object.keys(scope).includes(propertyName);
        if (foundKey) {
            res = scope[propertyName];
        } else {
            scope = scope.$parent;
        }
    }
    return res;
}

})();
