import * as AgGrid from '../../../../../../../server/src/frontend/node_modules/ag-grid-enterprise/';
import * as GeneratedSources from '../../../../../../../server/src/frontend/src/generated-sources';
import { MeasureDef } from '../../../../../../../server/src/frontend/src/generated-sources';

export { GeneratedSources };


// ChartDef properties won't be available depending on the context. In particular valued properties depend on the chart type. 
// Please check ChartDef.java and the wiki for more.
export interface ChartDef extends GeneratedSources.ChartDef {
    $chartStoreId?: number;
}
declare enum FilterChartType {
    filters = 'filters',
}
export type ChartType = GeneratedSources.ChartType | FilterChartType;
declare global {
    interface Window {
        agGrid:     typeof AgGrid;
        sanitize:   (value: string | number) => string;
        _: {
            isNil: (element: unknown) => boolean;
        }
    }
}

export interface Legend {
    hideLegend: boolean;
    items: Object[];
    maxValue: number | undefined;
    minValue: number | undefined;
    numValues: number;
    numberFormattingOptions: Object | null;
    type: string;
    formatter?: any;
}

export interface AgGridRow {
    id:                string;
    group:             boolean;
    expanded:          boolean; 
    [columnId: string]: PivotTableCellContent | PivotTableRowTreeCellContent | string | string[] | boolean;
}
export interface AGGridConverterDFSRowData {
    parent?:        AGGridConverterDFSRowData,
    children?:      AGGridConverterDFSRowData[],
    isEmpty:        boolean;
    agGridRow?:     AgGridRow, 
    rowPath:        string[] | undefined[], 
    yCoordDict:     Record<string, number> | {}, 
    head?:          GeneratedSources.DimensionDef,
    tail?:          GeneratedSources.DimensionDef[],
    headIndex?:     number,
    headerName:     string,
    isFirstChild?:  boolean,
    depth?:         number
}

export interface AGGridConverterDFSColumnData {
    parent?:        AGGridConverterDFSColumnData,
    children?:      AGGridConverterDFSColumnData[],
    agGridColumn:   AgGrid.ColDef & {groupId?: string},
    isEmpty:        boolean;
    value?:         string;
    xCoordDict?:    Record<string, number>,
    head?:          GeneratedSources.DimensionDef,
    tail?:          GeneratedSources.DimensionDef[],
    headIndex?:     number
}

export interface EndColumnData {
    id:                 string; 
    dimensionId?:       string; 
    aggregationIndex?:  number;
    xCoordDict:         Record<string, number>; 
    columnData:         AGGridConverterDFSColumnData;
}

export interface SubTotalColumnData {
    id:                 string;
    dimensionId:        string;
    aggregationIndex?:  number;
    measure?:            MeasureDef;
    xCoordDict:         Record<string, number>;
    columnData:         AGGridConverterDFSColumnData;
}
export declare interface AxisSpec {
    type:         string;
    mode:         string;
    padding:      number;
    dimension:    Dimension;
    name:         string;
    customExtent: CustomExtent;
}

export interface CustomExtent {
    editMode:     string;
    manualExtent: null[];
    $autoExtent:  number[];
}

export interface Dimension {
    column:                 string;
    type:                   string;
    numParams:              NumParams;
    maxValues:              number;
    generateOthersCategory: boolean;
    oneTickPerBin:          boolean;
    filters:                any[];
    isA:                    string;
    possibleSorts:          Sort[];
    sort:                   Sort;
}

export interface NumParams {
    mode:          string;
    nbBins:        number;
    binSize:       number;
    emptyBinsMode: string;
}

export interface Sort {
    type:          string;
    label:         string;
    sortAscending: boolean;
}

export declare interface AxisSpecs {
    xSpec?:     AxisSpec;
    ySpec?:     AxisSpec;
    y2Spec?:    AxisSpec;
}
export interface PivotTableCellMeasure {
    value:                     number | string;
    originalValue:             number | string;
    colorMeasureValue:         number | string;
    colorMeasureOriginalValue: number | string;
    cellCoords?:    Record<string, number> | null;
    hasTooltipAndContextualMenu:     boolean;
}

export interface PivotTableRowTreeCellContent {
    label: string;
    depth: number;
    hasOffset?: boolean
}

export type colorScale = (number) => string

export interface PivotTableCellContent {
    measures?:          PivotTableCellMeasure[];
    measure?:           PivotTableCellMeasure;
    hidden?:            boolean;
    isMeasureColumn?:   boolean;
    colorProperties?:   { getColorScale: () => colorScale, measure: number, bin: number };
    coordsDict?:        Record<string, number>;
}

export interface PivotTableMeasureCellContent {
    measures:           { value: string }[]; 
    isMeasureColumn:    boolean;
}

export interface ExpandCollapseToolPanelSection {
    label:      string;
    id:         string;
    actions:    ExpandCollapseToolPanelAction[];
}

export interface ExpandCollapseToolPanelAction {
    label:      string;
    id:         string;
    callback:   (params: ExpandCollapseToolPanelParams) => void;
}

export interface ExpandCollapseToolPanelParams extends AgGrid.IToolPanelParams {
    columnApi: any;
    api: any;
    $rootElement: JQuery<HTMLElement>;
    chartDef: ChartDef;
}

export interface DisplayTotalsToolPanelParams extends AgGrid.IToolPanelParams {
    $rootElement:           JQuery<HTMLElement>;
    pivotDisplayTotals:     GeneratedSources.ChartDef.PivotTableDisplayTotals;
    subtotalColumnType:     string;
    rowData:                AgGridRow[];
    subtotalRowData:        AgGridRow[];
    grandTotalRowData:      AgGridRow
    grandTotalColumnDef:    AgGrid.ColDef & AgGrid.ColGroupDef;
    hasSubtotalRows:        boolean;
    hasSubtotalColumns:     boolean; 
    hasGrandTotalRow:       boolean; 
    hasGrandTotalColumn:    boolean;
    recomputeColorScale:    () => void;
}

export interface CellWithChevronParams extends AgGrid.ICellRendererParams {
    chartDef: ChartDef;
}

// Treemap

export interface TreemapBFSNodeData {
    name: string;
    originalName: string;
    children: TreemapBFSNodeData[];
    coord: Record<string, number | Record<string, string | number>>;
    itemStyle: { color?: string | null, value?: string, measure?: number };
    parent: TreemapBFSNodeData | null;
    yCoordDict: Record<string, number> | {};
    head: Record<string, number>;
    tail: Record<string, number>;
    position?: number;
    value?: number;
    label: { color?: string };
    depth: number;
}

export interface ColorSpec {
    binsToInclude: Set<number> | null;
    extent?: number[];
    measureIdx: number;
    type: string;
    values?: number[];
    withRgba: boolean;
}
