(function(){
    'use strict';

    const alertDismissible = {
        transclude: true,
        bindings: {
            severity: "@",
            dismissButtonSize: "@?",
            localStorageKey: "@?",
            onDismiss: "&?",
        },
        templateUrl: "/static/dataiku/shared/components/alert-dismissible/alert-dismissible.component.html",
        controller: function(LocalStorage) {
            const $ctrl = this;

            $ctrl.$onInit = function() {
                $ctrl.isShown = $ctrl.localStorageKey ? !LocalStorage.get($ctrl.localStorageKey) : true;
            }

            $ctrl.dismiss = function() {
                $ctrl.isShown = false;
                if ($ctrl.localStorageKey) {
                    LocalStorage.set($ctrl.localStorageKey, true);
                }
                if ($ctrl.onDismiss) {
                    $ctrl.onDismiss();
                }
            };
        }
    }

    angular.module('dataiku.shared').component('alertDismissible', alertDismissible);
})();
