(function() {
    'use strict';

    angular.module('dataiku.shared').component('chartAlphanumFacet', {
        templateUrl: '/static/dataiku/shared/components/chart-alphanum-facet/chart-alphanum-facet.component.html',
        bindings: {
            values:'<',                 // { id: string, label: string, included: boolean }[]
            folded:'<',                 // boolean
            filterSelectionType: '<',   // CHART_FILTERS.SELECTION_TYPE
            uniqueRowCount:'<?',        // number
            disableCount: '<?',         // boolean
            hideZeroCountValues: '<?',  // boolean
            onChange:'&?'               // (values) => void,
        },
        controller : function($rootScope, Debounce, ChartFormatting) {
            const ctrl = this;

            ctrl.filteredValues = [];
            // selectedValue holds the radio button state in SINGLE_SELECT mode
            ctrl.selectedValue = '';
            ctrl.query = '';

            ctrl.$onChanges = (changes) => {
                if (changes.values) {
                    if (!ctrl.values) {
                        return;
                    }
                    reloadValues();
                    updateWidgetHeight(Math.min(Math.max(50,22 * ctrl.values.length), 220)+ 5);
                }
                if (changes.folded) {
                    $rootScope.$broadcast('reflow');
                }
            };

            ctrl.setAll = function(val) {
                for(let k in ctrl.filteredValues) {
                    let item = ctrl.filteredValues[k];
                    item.included = val;
                }
                ctrl.changed();
            };

            ctrl.changed = function() {
                ctrl.allSelected = true;
                ctrl.someSelected = false;
                for(let k in ctrl.filteredValues) {
                    let item = ctrl.filteredValues[k];
                    ctrl.allSelected = ctrl.allSelected && item.included;
                    ctrl.someSelected = ctrl.someSelected || item.included;
                }

                if (ctrl.onChange) {
                    ctrl.onChange({ $values: ctrl.values });
                }
            };

            ctrl.formatLabel = function(label) {
                return ChartFormatting.getFormattedSpecialLabel(label);
            };

            ctrl.singleSelectChanged = function(id) {
                for (let item of ctrl.filteredValues) {
                    item.included = item.id === id;
                }
                if (ctrl.onChange) {
                    ctrl.onChange({ $values: ctrl.values });
                }
            };

            ctrl.onQueryChange = Debounce().withDelay(50,200).wrap(() => reloadValues());

            function updateWidgetHeight(widgetHeight) {
                ctrl.widgetHeight = widgetHeight;
                $rootScope.$broadcast('reflow');
            }

            function reloadValues() {
                ctrl.selectedValue = undefined;
                ctrl.filteredValues = [];
                let q = (ctrl.query || '').toLowerCase();
                if (ctrl.values) {
                    for(const k in ctrl.values) {
                        const v = ctrl.values[k];
                        if (ctrl.hideZeroCountValues && v.count === 0) {
                            continue;
                        }
                        if (!v.label) {
                            v.label = '';
                        }
                        if (v.label.toLowerCase().indexOf(q) !== -1) {
                            ctrl.filteredValues.push(v);
                        }
                    }
                    ctrl.allSelected = true;
                    ctrl.someSelected = false;
                    for (const k in ctrl.filteredValues) {
                        const item = ctrl.filteredValues[k];
                        ctrl.allSelected = ctrl.allSelected && item.included;
                        ctrl.someSelected = ctrl.someSelected || item.included;
                        // If not already set, set the selected value to the first item.
                        if (item.included && !ctrl.selectedValue) {
                            ctrl.selectedValue = item.id;
                        }
                    }

                    if (ctrl.uniqueRowCount) {
                        const unusedCount =  ctrl.uniqueRowCount - ctrl.values.length;
                        if (unusedCount > 0) {
                            ctrl.filteredValues.push({
                                unusedCount: unusedCount
                            });
                        }
                    }
                }
            }
        }
    });
})();
