/* global spyOn, inject, expect */

const ChartTestUtils = chartTestUtils(); // eslint-disable-line no-unused-vars

/**
 * ChartTestUtils : global helpers used in charts tests
 */

function chartTestUtils() {

    let $compile, $rootScope, $templateCache, $httpBackend;

    return {
        silenceAppConsoleLogs,
        initAngularJSTemplatingResource,
        getScope,
        renderTemplate,
        getTemplate,
        renderElement,
        expectElementToBeVisible,
        expectElementToBeHidden,
        expectIdToBeVisible,
        expectIdToBeHidden,
        expectClassToBeVisible,
        expectClassToBeHidden,
        getHttpBackend,
        expectElementWithAttributeToBeVisible,
        expectElementWithAttributeToBeHidden
    }

    //////////

    function silenceAppConsoleLogs() {
        spyOn(console, 'warn');
        spyOn(console, 'info');
    }

    function initAngularJSTemplatingResource() {
        inject(function (_$compile_, _$rootScope_, _$templateCache_, _$httpBackend_) {
            $compile = _$compile_;
            $rootScope = _$rootScope_.$new();
            $templateCache = _$templateCache_;
            $httpBackend = _$httpBackend_;
        })
    }

    function renderTemplate(templatePath, $rootScope) {
        const template = getTemplate(templatePath, $rootScope);
        const newElement = $compile(template)($rootScope);
        angular.element(document.body).append(newElement);
        $rootScope.$digest();
    }

    function getTemplate(templatePath) {
        return $templateCache.get(templatePath);
    }

    function renderElement(element, $rootScope) {
        const newElement = $compile(angular.element(element))($rootScope);
        angular.element(document.body).append(newElement);
        $rootScope.$digest();
    }

    function getScope() {
        return $rootScope;
    }

    /**
     * 
     * @param {string} route 
     * @param {{code: number, payload: unknown}} response 
     */
    function getHttpBackend() {
        return $httpBackend;
    }

    function expectElementToBeVisible(element) {
        if (typeof element === 'string') {
            element = $(element);
        }
        expect(element.length).toBeGreaterThanOrEqual(1);
        expect(element.is(':visible')).toBe(true);
    }

    function expectElementToBeHidden(element) {
        if (typeof element === 'string') {
            element = $(element);
        }
        if (element.length) {
            expect(element.is(':hidden')).toBe(true);
        }
    }

    function expectIdToBeVisible(id) {
        expectElementToBeVisible($(`#${id}`));
    }

    function expectIdToBeHidden(id) {
        expectElementToBeHidden($(`#${id}`));
    }

    function expectClassToBeVisible(className) {
        expectElementToBeVisible($(`.${className}`));
    }

    function expectClassToBeHidden(className) {
        expectElementToBeHidden($(`.${className}`));
    }

    function expectElementWithAttributeToBeVisible(elementTag, attribute, attributeValue) {
        expectElementToBeVisible($(`${elementTag}[${attribute}='${attributeValue}']`));
    }

    function expectElementWithAttributeToBeHidden(elementTag, attribute, attributeValue) {
        expectElementToBeHidden($(`${elementTag}[${attribute}='${attributeValue}']`));
    }
}
