/* global describe, it, beforeEach, ChartFeaturesTestUtils */

describe('chart features kpi', function () {

    const chartType = 'kpi';
    const chartVariant = 'normal';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, expectClassToBeVisible, renderTemplate } = ChartFeaturesTestUtils;

    /* Initialize each test */
    beforeEach(() => {
        ChartFeaturesTestUtils.initEachTest();
        ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
    });

    it('has left menu filters dropzone', function () {
        renderTemplate('/templates/simple_report/left-column/left-column.html');

        expectIdToBeVisible('qa_charts_filter-submenu-header');
        expectIdToBeVisible('qa_charts_filters-dropzone');
    });

    it('has measure dropzone available', function () {
        ChartFeaturesTestUtils.setXYGenericFromNumericalColumns();
        renderTemplate(`/templates/simple_report/types/definition-${chartType}.html`);

        expectClassToBeVisible('qa_charts_measure-dropzone');
    })

    it('doesn\'t have along dimension option', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'NORMAL', false);
    })

    it('doesn\'t have regression line options', function () {
        renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
        expectIdToBeHidden('qa_charts_regression-line-form');
    })

});
