from statsmodels.stats.stattools import durbin_watson
from dataiku.eda.types import Literal

from dataiku.eda.computations.timeseries.time_series_computation import TimeSeriesComputation
from dataiku.eda.exceptions import NotEnoughDataError


class DurbinWatson(TimeSeriesComputation):
    def __init__(self, series_column, time_column):
        super(DurbinWatson, self).__init__(series_column, time_column)

    @staticmethod
    def get_type() -> Literal["durbin_watson"]:
        return "durbin_watson"

    def describe(self):
        return "{}(series_column={}, time_column={})".format(
            self.__class__.__name__,
            self.series_column,
            self.time_column,
        )

    @staticmethod
    def build(params):
        return DurbinWatson(
            params["seriesColumn"],
            params["timeColumn"],
        )

    def apply(self, idf, ctx):
        series, timestamps = self._get_time_series(idf)

        if len(series) < 2:
            raise NotEnoughDataError("At least 2 values are required in the series (current size: {})".format(len(series)))

        statistic = durbin_watson(series)

        return {
            "type": self.get_type(),
            "statistic": statistic,
        }
