import requests
import json
import pandas as pd

from dataiku.external_ml.proxy_model.common import ProxyModel

import logging

logger = logging.getLogger(__name__)


class KServeProxyModel(ProxyModel):

    def __init__(self, root_url, model_id, headers, **kwargs):
        self.root_url = root_url
        self.model_id = model_id
        self.headers = headers

    def predict(self, input_df):
        logger.info("Predicting using {} on input_df with shape {}".format(self.__class__.__name__, input_df.shape))
        response = requests.post("{}/models/{}:predict".format(self.root_url, self.model_id),
                                 json={"instances": input_df.values.tolist()},
                                 headers=self.headers)

        return pd.DataFrame({"prediction": json.loads(response.content)["predictions"]})
