import os, os.path as osp, json, logging, time, string, re
from random import SystemRandom
import requests
import dataikuapi

def json_dumpf(path, obj):
    tmp_folder = os.path.join(os.environ['DIP_HOME'], 'tmp')
    filename = os.path.basename(path)
    tmp_filename = '%s.tmp.%s' % (filename, generate_secure_random_string(8)) # add randomness in case of concurrent use of the method
    tmp_path = os.path.join(tmp_folder, tmp_filename)
    logging.info("Atomic write to " + tmp_path)
    try:
        with open(tmp_path, "w") as f:
            json.dump(obj, f, indent=4)
        os.rename(tmp_path, path)
    finally:
        if os.path.exists(tmp_path):
            try:
                os.remove(tmp_path)
            except Exception as e:
                logging.warning("Unable to cleanup tmp file " + tmp_path)

def json_loadf(path):
    with open(path, "r") as f:
        return json.load(f)

def generate_secure_random_string(N):
    cryptogen = SystemRandom()
    return ''.join(cryptogen.choice(string.ascii_uppercase + string.digits) for _ in range(N))

def get_or_create_admin_api_key(macro_id, runner_auth_info):
    key_created_by = "macro-%s-for-%s" % (macro_id, runner_auth_info["authIdentifier"])
    key_label = "Admin key generated for run of macro %s by %s" % (macro_id, runner_auth_info["authIdentifier"])

    logging.info("Creating an admin key for use by macro: %s" % key_created_by)

    with open('%s/run/shared-secret.txt' % os.getenv("DIP_HOME"), 'r') as fp:
        secret = fp.read()
        secret = secret.strip()
    port = int(os.environ["DKU_BACKEND_PORT"])
    http_res = requests.request("GET",
                        "http://127.0.0.1:%s/dip/api/pintercom/api-keys/get-temporary-admin-key" % port,
                        headers={
                            "X-DKU-IPythonSharedSecret": secret,
                        },
                        params={
                            "requestedBy": key_created_by,
                            "label": key_label
                        })
    http_res.raise_for_status()

    return http_res.json()["key"]

def get_admin_dss_client(macro_id, runner_auth_info):
    key = get_or_create_admin_api_key(macro_id, runner_auth_info)
    port = int(os.environ["DKU_BACKEND_PORT"])
    client = dataikuapi.DSSClient("http://127.0.0.1:%s" % port, key)
    return client

def make_unique_project_key(admin_client, base_name):
    base_project_key = base_name.upper()
    base_project_key = re.sub(r'[^A-Z0-9]+', '_', base_project_key)
        
    existing_keys = admin_client.list_project_keys()
    project_key = base_project_key
    i = 0
    while True:
        if project_key in existing_keys:
            i = i+1
            project_key = "%s_%d" % (base_project_key , i)
        else:
            break

    return project_key