from __future__ import print_function
from os import path as osp
import os
import sys
import logging
import base
import envfiles
import requests
import install_config
import migration_base

def initial_install(dip_home_path, base_port, cloud):
    base._sanity_check()

    dip_home = base.DipHome(dip_home_path)

    print("[+] Performing initial install")

    migration_base.write_version(dip_home)

    print("[+] Writing default install config file")
    install_config.initConfig(dip_home, base_port, "fm", "auto")

    print("[+] Writing default env file")
    envfiles.write_envdefault(dip_home)

    base.link_fm_binaries(dip_home, os.environ["DKUINSTALLDIR"])
    base.generate_supervisor_key(dip_home)

    for folder in ["config/", "tmp"]:
        tgt = osp.join(dip_home.path, folder)
        if not osp.isdir(tgt):
            os.makedirs(tgt)

    with open(osp.join(dip_home.path, "config", "dip.properties"), "w") as f:
        f.write("# Internal FM properties\n")

    if cloud == "AWS":
        try:
            imds_token = requests.put("http://169.254.169.254/latest/api/token", headers = {'X-aws-ec2-metadata-token-ttl-seconds': '2160'}).text
            imds_header = { 'X-aws-ec2-metadata-token': imds_token}
            identity_doc = requests.get("http://169.254.169.254/latest/dynamic/instance-identity/document", headers = imds_header).json()
            mac = requests.get("http://169.254.169.254/latest/meta-data/mac", headers = imds_header).text
            vpc = requests.get("http://169.254.169.254/latest/meta-data/network/interfaces/macs/%s/vpc-id" % mac, headers = imds_header).text
            fm_cidr = requests.get("http://169.254.169.254/latest/meta-data/network/interfaces/macs/%s/subnet-ipv4-cidr-block" % mac, headers = imds_header).text
            region = identity_doc["region"]
            ip = identity_doc["privateIp"]
        except Exception:
            logging.exception("Failed to infer AWS settings, maybe not an AWS machine")
            vpc = "XXX"
            fm_cidr="XXX"
            region = "XXX"
            ip = "XXX"

        base.json_dumpf(osp.join(dip_home.path, "config", "user-data.json"),
            {
                "databaseSettings" : {
                    "dbDialect" : "org.hibernate.dialect.PostgreSQLDialect",
                    "dbDriver" : "org.postgresql.Driver",
                    "dbURL" : "jdbc:postgresql://#HOST#:#PORT#/#DB#?user=#DBUSER#&password=#DBPASSWORD#"
                },
                "cloud" : "AWS",
                "awsSettings" : {
                    "regionId": region,
                    "vpcId" : vpc,
                    "fmServerCIDR": fm_cidr
                },
                "instanceVisibleURL" : "http://%s:%s" % (ip, base_port)
            }
        )  
    elif cloud == "GCP":
        try:
            project_id = requests.get("http://metadata.google.internal/computeMetadata/v1/project/project-id", headers={"Metadata-Flavor" : "Google"}).text
            zone = requests.get("http://metadata.google.internal/computeMetadata/v1/instance/zone", headers={"Metadata-Flavor" : "Google"}).text.split('/')[-1]
            ip = requests.get("http://metadata.google.internal/computeMetadata/v1/instance/network-interfaces/0/ip", headers={"Metadata-Flavor" : "Google"}).text
            network = requests.get("http://metadata.google.internal/computeMetadata/v1/instance/network-interfaces/0/network", headers={"Metadata-Flavor" : "Google"}).text.split('/')[-1]
        except Exception:
            logging.exception("Failed to infer GCP settings, maybe not a GCP machine")
            ip = "127.0.0.1"
            project_id = "XXX"
            zone="XXX"
            network = "XXX"

        base.json_dumpf(osp.join(dip_home.path, "config", "user-data.json"),
            {
                "databaseSettings" : {
                    "dbDialect" : "org.hibernate.dialect.PostgreSQLDialect",
                    "dbDriver" : "org.postgresql.Driver",
                    "dbURL" : "jdbc:postgresql://#HOST#:#PORT#/#DB#?user=#DBUSER#&password=#DBPASSWORD#"
                },
                "cloud" : "GCP",
                "gcpSettings" : {
                    "projectId": project_id,
                    "zone" : zone,
                    "network": network
                },
                "instanceVisibleURL" : "http://%s:%s" % (ip, base_port)
            }
        )  
    else:
        ip = "XXX"
        base.json_dumpf(osp.join(dip_home.path, "config", "user-data.json"),
            {
                "databaseSettings" : {
                    "dbDialect" : "org.hibernate.dialect.PostgreSQLDialect",
                    "dbDriver" : "org.postgresql.Driver",
                    "dbURL" : "jdbc:postgresql://#HOST#:#PORT#/#DB#?user=#DBUSER#&password=#DBPASSWORD#"
                },
                "cloud" : "AZURE",
                "azureSettings" : {
                    "TODO": "TODO"
                },
                "instanceVisibleURL" : "http://%s:%s" % (ip, base_port)
            }
        )  
    base.json_dumpf(osp.join(dip_home.path, "config", "settings.json"),
        {
            "tenancy": "MONOTENANT",
        }
    )  

if __name__ == "__main__":
    if len(sys.argv) < 3:
        print("""
        Usage:
            install_fm.py <dip_home> <port> <cloud>
        """, file=sys.stderr)
        sys.exit(1)

    initial_install(sys.argv[1], int(sys.argv[2]), sys.argv[3])
