#!/bin/bash -e
# Helper script to install the packages required by DSS in an externally-managed Python installation
# Call with the PIP_COMMAND as first argument
#
# The actual packages are in $DKUINSTALLDIR/resources/builtin-python-env/dss-server
#
# This is not actually used in normal operation, and is only for guidance. In normal operation, the 
# builtin env packages are provided as part of the kit and are only referenced by the builtin env.

Usage() {
  echo "Usage: $0 PIP_COMMAND" >&2
  exit 1
}

if [ $# -ne 1 ]; then
  Usage
fi
pip="$1"

# Grab Python version from "pip -V" output
pipVersion=$($pip -V)
pythonVersion=$(sed -n 's/^pip .* (python \([0-9]\.[0-9]*\))$/\1/p' <<<"$pipVersion")
if [ -z "$pythonVersion" ]; then
	echo >&2 "*** Error: could not retrieve python version"
	exit 1
fi

if [ -z "$DKUINSTALLDIR" ]; then
  # Fall back to location-base detection if not specified by the environment
  MYDIR=$(cd "$(dirname "$0")" && pwd -P)
  DKUINSTALLDIR=$(dirname "$(dirname "$MYDIR")")
fi

case "$pythonVersion" in
   "3.9")
    requirementsFile="$DKUINSTALLDIR/resources/builtin-python-env/dss-server/requirements-py39.txt"
    ;;
  *)
    echo >&2 "*** Error: python version not supported: $pythonVersion"
    exit 1
esac

echo "+ Upgrading pip"
$pip install --upgrade pip wheel

echo "+ Installing required Python packages ..."
$pip install -r "$requirementsFile"

# Remove stuff installed only temporarily
echo "+ Cleaning up ..."
$pip uninstall -y notebook jupyterlab-widgets
