import setuptools

VERSION = "{VERSION}"

with open("README", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="dataiku-internal-client",
    version=VERSION,
    license="Proprietary",
    packages=[
        "dataiku",
        "dataiku.core",
        "dataiku.core.vector_stores",
        "dataiku.core.vector_stores.data",
        "dataiku.core.vector_stores.lifecycle",
        "dataiku.base",
        "dataiku.insights",
        "dataiku.customwebapp",
        "dataiku.customrecipe",
        "dataiku.cluster",
        "dataiku.container",
        "dataiku.langchain",
        "dataiku.llm",
    ],
    long_description=long_description,
    author="Dataiku",
    author_email="support@dataiku.com",
    url="https://www.dataiku.com",
    classifiers = [
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Libraries',
        'Programming Language :: Python',
        'Operating System :: OS Independent'
    ],
    install_requires = [
        "urllib3",
        "requests>=2",
        "python-dateutil",
        "numpy>=1.14"
    ]
)
