/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.internal;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.Expected;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.Item;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.PutItemOutcome;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.Table;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.api.PutItemApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.internal.AbstractImpl;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.spec.PutItemSpec;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.model.PutItemResult;
import java.util.Map;

public class PutItemImpl
extends AbstractImpl
implements PutItemApi {
    public PutItemImpl(AmazonDynamoDB client, Table table) {
        super(client, table);
    }

    @Override
    public PutItemOutcome putItem(Item item) {
        return this.doPutItem(new PutItemSpec().withItem(item));
    }

    @Override
    public PutItemOutcome putItem(Item item, Expected ... expected) {
        return this.doPutItem(new PutItemSpec().withItem(item).withExpected(expected));
    }

    @Override
    public PutItemOutcome putItem(Item item, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doPutItem(new PutItemSpec().withItem(item).withConditionExpression(conditionExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public PutItemOutcome putItem(PutItemSpec spec) {
        return this.doPutItem(spec);
    }

    private PutItemOutcome doPutItem(PutItemSpec spec) {
        String tableName = this.getTable().getTableName();
        PutItemRequest req = ((PutItemRequest)spec.getRequest()).withTableName(tableName);
        Item item = spec.getItem();
        Map<String, AttributeValue> attributes = InternalUtils.toAttributeValues(item);
        Map<String, ExpectedAttributeValue> expectedMap = InternalUtils.toExpectedAttributeValueMap(spec.getExpected());
        Map<String, AttributeValue> attrValMap = InternalUtils.fromSimpleMap(spec.getValueMap());
        req.withItem(attributes).withExpected(expectedMap).withExpressionAttributeNames(spec.getNameMap()).withExpressionAttributeValues(attrValMap);
        PutItemResult result = this.getClient().putItem(req);
        return new PutItemOutcome(result);
    }
}

