/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ConnectionTrackingSpecificationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.EnaSrdSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.EnaSrdUdpSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ModifyNetworkInterfaceAttributeRequestMarshaller
implements Marshaller<Request<ModifyNetworkInterfaceAttributeRequest>, ModifyNetworkInterfaceAttributeRequest> {
    @Override
    public Request<ModifyNetworkInterfaceAttributeRequest> marshall(ModifyNetworkInterfaceAttributeRequest modifyNetworkInterfaceAttributeRequest) {
        ConnectionTrackingSpecificationRequest connectionTrackingSpecification;
        EnaSrdSpecification enaSrdSpecification;
        SdkInternalList modifyNetworkInterfaceAttributeRequestGroupsList;
        if (modifyNetworkInterfaceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyNetworkInterfaceAttributeRequest> request = new DefaultRequest<ModifyNetworkInterfaceAttributeRequest>(modifyNetworkInterfaceAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyNetworkInterfaceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        NetworkInterfaceAttachmentChanges attachment = modifyNetworkInterfaceAttributeRequest.getAttachment();
        if (attachment != null) {
            if (attachment.getAttachmentId() != null) {
                request.addParameter("Attachment.AttachmentId", StringUtils.fromString(attachment.getAttachmentId()));
            }
            if (attachment.getDeleteOnTermination() != null) {
                request.addParameter("Attachment.DeleteOnTermination", StringUtils.fromBoolean(attachment.getDeleteOnTermination()));
            }
        }
        if (modifyNetworkInterfaceAttributeRequest.getDescription() != null) {
            request.addParameter("Description.Value", StringUtils.fromString(modifyNetworkInterfaceAttributeRequest.getDescription()));
        }
        if (!(modifyNetworkInterfaceAttributeRequestGroupsList = (SdkInternalList)modifyNetworkInterfaceAttributeRequest.getGroups()).isEmpty() || !modifyNetworkInterfaceAttributeRequestGroupsList.isAutoConstruct()) {
            int groupsListIndex = 1;
            for (String modifyNetworkInterfaceAttributeRequestGroupsListValue : modifyNetworkInterfaceAttributeRequestGroupsList) {
                if (modifyNetworkInterfaceAttributeRequestGroupsListValue != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString(modifyNetworkInterfaceAttributeRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (modifyNetworkInterfaceAttributeRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(modifyNetworkInterfaceAttributeRequest.getNetworkInterfaceId()));
        }
        if (modifyNetworkInterfaceAttributeRequest.getSourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value", StringUtils.fromBoolean(modifyNetworkInterfaceAttributeRequest.getSourceDestCheck()));
        }
        if ((enaSrdSpecification = modifyNetworkInterfaceAttributeRequest.getEnaSrdSpecification()) != null) {
            EnaSrdUdpSpecification enaSrdUdpSpecification;
            if (enaSrdSpecification.getEnaSrdEnabled() != null) {
                request.addParameter("EnaSrdSpecification.EnaSrdEnabled", StringUtils.fromBoolean(enaSrdSpecification.getEnaSrdEnabled()));
            }
            if ((enaSrdUdpSpecification = enaSrdSpecification.getEnaSrdUdpSpecification()) != null && enaSrdUdpSpecification.getEnaSrdUdpEnabled() != null) {
                request.addParameter("EnaSrdSpecification.EnaSrdUdpSpecification.EnaSrdUdpEnabled", StringUtils.fromBoolean(enaSrdUdpSpecification.getEnaSrdUdpEnabled()));
            }
        }
        if (modifyNetworkInterfaceAttributeRequest.getEnablePrimaryIpv6() != null) {
            request.addParameter("EnablePrimaryIpv6", StringUtils.fromBoolean(modifyNetworkInterfaceAttributeRequest.getEnablePrimaryIpv6()));
        }
        if ((connectionTrackingSpecification = modifyNetworkInterfaceAttributeRequest.getConnectionTrackingSpecification()) != null) {
            if (connectionTrackingSpecification.getTcpEstablishedTimeout() != null) {
                request.addParameter("ConnectionTrackingSpecification.TcpEstablishedTimeout", StringUtils.fromInteger(connectionTrackingSpecification.getTcpEstablishedTimeout()));
            }
            if (connectionTrackingSpecification.getUdpStreamTimeout() != null) {
                request.addParameter("ConnectionTrackingSpecification.UdpStreamTimeout", StringUtils.fromInteger(connectionTrackingSpecification.getUdpStreamTimeout()));
            }
            if (connectionTrackingSpecification.getUdpTimeout() != null) {
                request.addParameter("ConnectionTrackingSpecification.UdpTimeout", StringUtils.fromInteger(connectionTrackingSpecification.getUdpTimeout()));
            }
        }
        if (modifyNetworkInterfaceAttributeRequest.getAssociatePublicIpAddress() != null) {
            request.addParameter("AssociatePublicIpAddress", StringUtils.fromBoolean(modifyNetworkInterfaceAttributeRequest.getAssociatePublicIpAddress()));
        }
        return request;
    }
}

