/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.CreatePolicyRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreatePolicyRequestMarshaller
implements Marshaller<Request<CreatePolicyRequest>, CreatePolicyRequest> {
    @Override
    public Request<CreatePolicyRequest> marshall(CreatePolicyRequest createPolicyRequest) {
        if (createPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePolicyRequest> request = new DefaultRequest<CreatePolicyRequest>(createPolicyRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreatePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPolicyRequest.getPolicyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(createPolicyRequest.getPolicyName()));
        }
        if (createPolicyRequest.getPath() != null) {
            request.addParameter("Path", StringUtils.fromString(createPolicyRequest.getPath()));
        }
        if (createPolicyRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(createPolicyRequest.getPolicyDocument()));
        }
        if (createPolicyRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createPolicyRequest.getDescription()));
        }
        if (!createPolicyRequest.getTags().isEmpty() || !((SdkInternalList)createPolicyRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createPolicyRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

