/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.TagPolicyRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class TagPolicyRequestMarshaller
implements Marshaller<Request<TagPolicyRequest>, TagPolicyRequest> {
    @Override
    public Request<TagPolicyRequest> marshall(TagPolicyRequest tagPolicyRequest) {
        if (tagPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TagPolicyRequest> request = new DefaultRequest<TagPolicyRequest>(tagPolicyRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "TagPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (tagPolicyRequest.getPolicyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString(tagPolicyRequest.getPolicyArn()));
        }
        if (!tagPolicyRequest.getTags().isEmpty() || !((SdkInternalList)tagPolicyRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)tagPolicyRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

