/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallLocation;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingType;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DeployedImage;
import java.util.Date;

@SdkInternalApi
public class DeployedImageMarshaller {
    private static final MarshallingInfo<String> SPECIFIEDIMAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpecifiedImage").build();
    private static final MarshallingInfo<String> RESOLVEDIMAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResolvedImage").build();
    private static final MarshallingInfo<Date> RESOLUTIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResolutionTime").timestampFormat("unixTimestamp").build();
    private static final DeployedImageMarshaller instance = new DeployedImageMarshaller();

    public static DeployedImageMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeployedImage deployedImage, ProtocolMarshaller protocolMarshaller) {
        if (deployedImage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(deployedImage.getSpecifiedImage(), SPECIFIEDIMAGE_BINDING);
            protocolMarshaller.marshall(deployedImage.getResolvedImage(), RESOLVEDIMAGE_BINDING);
            protocolMarshaller.marshall(deployedImage.getResolutionTime(), RESOLUTIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

