/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.PasswordUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.util.SecureKeyGenerator;
import com.dataiku.fm.cli.ApiKeyFileWriter;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.model.db.FMPersonalAPIKey;
import com.dataiku.fm.model.db.FMUser;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.Date;
import java.util.Map;
import org.apache.commons.cli.CommandLine;

public class CreatePersonalKeyCommand
extends FMInternalCLICommand {
    private static final String[] ARG_NAMES = new String[]{"TENANT_ID", "USER_ID", "[OUTPUT_FILENAME]"};

    @Override
    public String getUsageCommandName() {
        return "create-personal-api-key";
    }

    @Override
    public String description() {
        return "Create a personal API key for a user with a random key name. This command is deprecated. Instead, for easier key management, use create-named-personal-api-key command.\nIf OUTPUT_FILENAME is provided, the details of the API key are written as JSON into this file.";
    }

    @Override
    public String[] getUsageCommandArgs() {
        return ARG_NAMES;
    }

    @Override
    public int executeCommand(CommandLine commandLine) {
        Map<String, String> args = this.parseCmdArgs(commandLine, ARG_NAMES);
        String tenantId = args.get("TENANT_ID");
        String emailAddress = args.get("USER_ID");
        String outputFileName = args.get("OUTPUT_FILENAME");
        DatabaseAccessService dbService = (DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class);
        try (DatabaseAccessService.ReadWriteTransaction t = dbService.rwTransaction();){
            FMUser user = dbService.getSingleResult(FMUser.class, "SELECT u from fmuser u where u.tenant.id=?1 AND u.emailAddress = ?2", tenantId, emailAddress);
            if (user == null) {
                throw new IllegalStateException(String.format("Unknown user '%s' on tenant.", emailAddress));
            }
            String keyName = SecretKeyGenerator.generate((int)16);
            String keySecret = SecureKeyGenerator.generate((int)32);
            FMPersonalAPIKey pak = new FMPersonalAPIKey();
            pak.setUser(user);
            pak.setKeyId(keyName);
            pak.setSecretHash(PasswordUtils.encryptPassword((String)keySecret));
            pak.setCreationDate(new Date());
            t.getThreadEM().persist((Object)pak);
            t.commit();
            System.out.println("This command is deprecated. Instead, for easier key management, use create-named-personal-api-key command.");
            System.out.println("Key id: " + keyName);
            System.out.println("Key secret: " + keySecret);
            boolean success = outputFileName == null || ApiKeyFileWriter.writeOutputFile(outputFileName, keyName, keySecret);
            int n = success ? 0 : 1;
            return n;
        }
    }
}

