/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CloudTag;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.FMTenancy;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;

public class CreateSingleTenantCommand
extends FMInternalCLICommand {
    private static final String[] ARG_NAMES = new String[]{"[TAGS]"};

    @Override
    public String getUsageCommandName() {
        return "create-single-tenant";
    }

    @Override
    public String description() {
        return "Creates the single tenant object of a monotenant Fleet Manager instance";
    }

    @Override
    public int executeCommand(CommandLine commandLine) throws IOException {
        Map<String, String> args;
        String tagsString;
        if (this.fmSettings.tenancy != FMTenancy.MONOTENANT) {
            throw new IllegalStateException("This function can only be called on monotenant Fleet Manager instances. Use 'create-tenant' command instead.\nYou can provide tags in the form \"Tag1Key=Tag1Value;Tag2Key=Tag2Value\"");
        }
        CloudTagList ctl = null;
        if (commandLine != null && !StringUtils.isEmpty((String)(tagsString = (args = this.parseCmdArgs(commandLine, ARG_NAMES)).get("TAGS")))) {
            String[] tags = tagsString.split(";");
            ctl = new CloudTagList();
            for (int i = 0; i < tags.length; ++i) {
                String[] tag = tags[i].split("=", 2);
                CloudTag ct = new CloudTag(tag[0], tag[1]);
                ctl.add(ct);
            }
        }
        try (DatabaseAccessService.ReadWriteTransaction t = ((DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class)).rwTransaction();){
            Tenant existingTenant = (Tenant)t.getThreadEM().find(Tenant.class, (Object)"main");
            if (existingTenant != null) {
                throw new IllegalStateException("The tenant has already been created.");
            }
            FMSettings settings = FMApp.getFMSettingsUnsafe();
            Tenant tenant = new Tenant();
            tenant.setId("main");
            tenant.setLabel("Fleet Manager Tenant");
            tenant.setDescription("This tenant is the one used by Fleet Manager.");
            CloudAccount cloudAccount = new CloudAccount();
            cloudAccount.setId("main");
            cloudAccount.setLabel("Fleet Manager Account");
            cloudAccount.setDescription("This account is the one used by Fleet Manager.");
            cloudAccount.setTenant(tenant);
            if (settings.cloud == Cloud.AWS) {
                cloudAccount.setAwsAuthenticationMode(CloudAccount.AWSAuthenticationMode.DEFAULT_INSTANCE_CREDENTIALS);
            }
            if (settings.cloud == Cloud.AZURE) {
                cloudAccount.setAzureAuthenticationMode(CloudAccount.AzureAuthenticationMode.DEFAULT_INSTANCE_CREDENTIALS);
                cloudAccount.setAzureTenantId(FMApp.getFMSettingsUnsafe().azureSettings.tenantId);
                cloudAccount.setAzureManagedIdentityId(FMApp.getFMSettingsUnsafe().azureSettings.managedIdentityId);
                cloudAccount.setAzureSubscription(FMApp.getFMSettingsUnsafe().azureSettings.subscription);
            }
            if (settings.cloud == Cloud.GCP) {
                cloudAccount.setGcpAuthenticationMode(CloudAccount.GCPAuthenticationMode.DEFAULT_INSTANCE_CREDENTIALS);
                cloudAccount.setGcpProjectId(FMApp.getFMSettingsUnsafe().gcpSettings.projectId);
            }
            tenant.setAuthenticationFromVirtualCloudAccount(cloudAccount);
            if (ctl != null) {
                tenant.setCloudTags(CloudTagList.toJSON(ctl));
            }
            InstanceSettingsTemplate ist = new InstanceSettingsTemplate();
            ist.setGcpBlockProjectWideKeys(true);
            ist.setId("ist-default");
            ist.setLabel("Default template");
            ist.setTenant(tenant);
            t.getThreadEM().persist((Object)tenant);
            t.getThreadEM().persist((Object)ist);
            t.commit();
            System.out.println("Created new tenant: " + tenant.getId());
            System.out.println("Created settings template: " + ist.getLabel() + " (" + ist.getId() + ")");
            int n = 0;
            return n;
        }
    }
}

