/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.settings.FMTenancy;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import org.apache.commons.cli.CommandLine;

public class CreateTenantCommand
extends FMInternalCLICommand {
    public String createdTenantId;

    @Override
    public String getUsageCommandName() {
        return "create-tenant";
    }

    @Override
    public String description() {
        return "Creates a new tenant";
    }

    @Override
    public int executeCommand(CommandLine commandLine) {
        if (FMApp.getFMSettingsUnsafe().tenancy == FMTenancy.MONOTENANT) {
            throw new IllegalStateException("This function can only be called on multitenant FM instances. Use 'create-single-tenant' instead.");
        }
        try (DatabaseAccessService.ReadWriteTransaction t = ((DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class)).rwTransaction();){
            Tenant tenant = new Tenant();
            tenant.setId("dt-" + SecretKeyGenerator.generate((int)12));
            tenant.setLabel("Fleet Manager Tenant");
            tenant.setDescription("This tenant is the one used by Fleet Manager.");
            CloudAccount cloudAccount = new CloudAccount();
            cloudAccount.setTenant(tenant);
            cloudAccount.setId("account-" + SecretKeyGenerator.generate((int)12));
            cloudAccount.setLabel("Fleet Manager Account");
            cloudAccount.setDescription("This account is the one used by Fleet Manager.");
            cloudAccount.setAwsAuthenticationMode(CloudAccount.AWSAuthenticationMode.DEFAULT_INSTANCE_CREDENTIALS);
            tenant.setAuthenticationFromVirtualCloudAccount(cloudAccount);
            InstanceSettingsTemplate ist = new InstanceSettingsTemplate();
            ist.setId("ist-" + SecretKeyGenerator.generate((int)12));
            ist.setLabel("Default");
            ist.setTenant(tenant);
            t.getThreadEM().persist((Object)tenant);
            t.getThreadEM().persist((Object)ist);
            t.commit();
            System.out.println("Created new tenant: " + tenant.getId());
            System.out.println("Created settings template: " + ist.getLabel() + " (" + ist.getId() + ")");
            this.createdTenantId = tenant.getId();
            int n = 0;
            return n;
        }
    }
}

