/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.fm.cli.CacheAzureVHDImages;
import com.dataiku.fm.cli.CreateNamedPersonalKeyCommand;
import com.dataiku.fm.cli.CreatePersonalKeyCommand;
import com.dataiku.fm.cli.CreateSingleTenantCommand;
import com.dataiku.fm.cli.CreateTenantCommand;
import com.dataiku.fm.cli.CreateUserCommand;
import com.dataiku.fm.cli.DeletePersonalKeyCommand;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.cli.InitialSetupCommand;
import com.dataiku.fm.cli.ListPersonalsKeyCommand;
import com.dataiku.fm.cli.ListUsersCommand;
import com.dataiku.fm.cli.RegisterAWSVPC;
import com.dataiku.fm.cli.RegisterAzureVNet;
import com.dataiku.fm.cli.RegisterGcpVpc;
import com.dataiku.fm.cli.SetUserPasswordCommand;
import com.dataiku.fm.server.FMApp;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class FMInternalCLI {
    private static final Map<String, FMInternalCLICommand> commands = Stream.of(new InitialSetupCommand(), new CreateTenantCommand(), new CreateSingleTenantCommand(), new CreateUserCommand(), new ListUsersCommand(), new ListPersonalsKeyCommand(), new CreatePersonalKeyCommand(), new CreateNamedPersonalKeyCommand(), new DeletePersonalKeyCommand(), new SetUserPasswordCommand(), new RegisterAWSVPC(), new RegisterAzureVNet(), new RegisterGcpVpc(), new CacheAzureVHDImages()).collect(Collectors.toMap(FMInternalCLICommand::getUsageCommandName, i -> i));

    public static void addGlobalOptions(Options opts) {
        opts.addOption("h", false, "Help");
        opts.addOption("v", false, "Verbose mode (enable debug logs)");
    }

    private static int dispatchOnCommand(String command, String[] args) throws Exception {
        FMInternalCLICommand cmd = commands.get(command.toLowerCase());
        if (cmd != null) {
            try {
                return cmd.execute(args);
            }
            catch (EndOfCommandException e) {
                return 0;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return 1;
            }
        }
        System.err.println("Unrecognized command : " + command);
        FMInternalCLI.usage();
        return 1;
    }

    private static void usage() throws Exception {
        System.err.println("FM internal command-line");
        Options gopts = new Options();
        FMInternalCLI.addGlobalOptions(gopts);
        new HelpFormatter().printHelp("fmcli [-h] [-v] command args", gopts);
        System.err.println();
        System.err.println("Available commands: ");
        for (String key : commands.keySet()) {
            System.err.println("  " + key);
        }
        System.err.println();
        System.err.println("Fore more information about a command, type 'dku command -h'");
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        FMApp.autoconfigure();
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        if (System.getenv("DKU_SILENT") != null) {
            Logger.getRootLogger().setLevel(Level.WARN);
        }
        if (System.getenv("DKU_NOTDEBUG") != null) {
            Logger.getRootLogger().setLevel(Level.INFO);
        }
        if (System.getenv("DKU_DEBUG") != null) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        }
        Options opts = new Options();
        FMInternalCLI.addGlobalOptions(opts);
        CommandLine cmdLine = new DefaultParser().parse(opts, args, true);
        if (cmdLine.getArgs().length == 0) {
            FMInternalCLI.usage();
        } else {
            String command = cmdLine.getArgs()[0];
            System.exit(FMInternalCLI.dispatchOnCommand(command, args));
        }
    }

    static class EndOfCommandException
    extends IOException {
        EndOfCommandException() {
        }
    }
}

