/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.fm.cli.CreateSingleTenantCommand;
import com.dataiku.fm.cli.CreateTenantCommand;
import com.dataiku.fm.cli.CreateUserCommand;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.cli.SetUserPasswordCommand;
import com.dataiku.fm.model.settings.FMTenancy;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;

public class InitialSetupCommand
extends FMInternalCLICommand {
    private static final String USER_ID = "USER_ID";
    private static final String PASSWORD = "PASSWORD";
    private static final String[] ARG_NAMES = new String[]{"USER_ID", "PASSWORD", "[TAGS]"};

    @Override
    public String getUsageCommandName() {
        return "initial-setup";
    }

    @Override
    public String description() {
        return "Do the initial setup by creating a new tenant, a user and set its password";
    }

    @Override
    public String[] getUsageCommandArgs() {
        return ARG_NAMES;
    }

    @Override
    public int executeCommand(CommandLine commandLine) throws Exception {
        Map<String, String> args = this.parseCmdArgs(commandLine, ARG_NAMES);
        String tenantId = "main";
        String userId = args.get(USER_ID);
        String password = args.get(PASSWORD);
        String tags = args.get("TAGS");
        if (this.fmSettings.tenancy == FMTenancy.MULTITENANT) {
            CreateTenantCommand createTenantCommand = new CreateTenantCommand();
            createTenantCommand.fmSettings = this.fmSettings;
            createTenantCommand.executeCommand(null);
            tenantId = createTenantCommand.createdTenantId;
        } else {
            CreateSingleTenantCommand createSingleTenantCommand = new CreateSingleTenantCommand();
            createSingleTenantCommand.fmSettings = this.fmSettings;
            if (!StringUtils.isEmpty((String)tags)) {
                createSingleTenantCommand.executeCommand(this.parseAndMiniSetup(new String[]{"create-single-tenant", tags}));
            } else {
                createSingleTenantCommand.executeCommand(null);
            }
        }
        CreateUserCommand createUserCommand = new CreateUserCommand();
        createUserCommand.fmSettings = this.fmSettings;
        createUserCommand.executeCommand(this.parseAndMiniSetup(new String[]{tenantId, userId}));
        SetUserPasswordCommand setUserPasswordCommand = new SetUserPasswordCommand();
        setUserPasswordCommand.fmSettings = this.fmSettings;
        setUserPasswordCommand.executeCommand(this.parseAndMiniSetup(new String[]{tenantId, userId, password}));
        System.out.println(String.format("Initial setup of tenant:%s done with user:%s", tenantId, userId));
        return 0;
    }
}

