/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.com.google.common.base.Joiner;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.Ec2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.AvailabilityZone;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateInternetGatewayRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateRouteRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateSecurityGroupResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateSubnetRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateSubnetResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateVpcRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateVpcResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DeleteRouteRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Ec2Exception;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Filter;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.IpPermission;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.IpRange;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.ResourceType;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.RouteTable;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.SecurityGroup;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Subnet;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.TagSpecification;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.UserIdGroupPair;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Vpc;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.VpcPeeringConnection;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.CloudNetworkServiceInterface;
import com.dataiku.fm.cloud.CloudNetworkServiceUtils;
import com.dataiku.fm.cloud.VirtualNetworkMetadata;
import com.dataiku.fm.cloud.aws.AWSClientService;
import com.dataiku.fm.cloud.aws.AWSDNSService;
import com.dataiku.fm.cloud.aws.AWSInstanceMetadataReader;
import com.dataiku.fm.cloud.aws.AWSUtils;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.ProtoVirtualNetworkDTO;
import com.dataiku.fm.model.published.VirtualNetworkSettingsDTO;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.dataiku.fm.server.core.VirtualNetworksService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.annotation.Autowired;

public class AWSCloudNetworkService
implements CloudNetworkServiceInterface {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private AWSClientService clientService;
    @Autowired
    private CloudAccountsService cloudAccountsService;
    @Autowired
    private CloudCryptoService cloudCryptoService;
    @Autowired
    private AWSDNSService awsdnsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.network");

    @Override
    public VirtualNetwork createManagedVirtualNetwork(String tenantId, ProtoVirtualNetworkDTO input, DKUtils.SmartLogTailBuilder smartLogTail) throws Exception {
        VirtualNetwork newVN;
        String cidr = CloudNetworkServiceUtils.findUniqueCIDR(this.dbService);
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", tenantId);
        assert (tenant != null);
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        CloudAccount cloudAccount = StringUtils.isNotEmpty((String)input.accountId) ? this.cloudAccountsService.getAccountMandatory(tenant, input.accountId) : tenant.getVirtualCloudAccount(settings);
        String id = "vn-" + SecretKeyGenerator.generate((int)12);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            newVN = new VirtualNetwork();
            newVN.setId(id);
            newVN.setManagedCidr(cidr);
            newVN.setCloudTags(CloudTagList.toJSON(input.cloudTags));
            newVN.setTenant(tenant);
            if (StringUtils.isNotEmpty((String)input.accountId)) {
                newVN.setCloudAccount(cloudAccount);
            }
            rwt.getThreadEM().persist((Object)newVN);
            rwt.commit();
        }
        rwt = this.dbService.rwTransaction();
        try {
            String tenantRouteTableId;
            AutoCreatedSecurityGroups asg;
            newVN = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)id);
            newVN.setLabel(input.label);
            newVN.setDescription(input.description);
            Ec2Client client = this.clientService.getEC2Client(AWSUtils.buildAWSAccount(newVN, this.cloudCryptoService));
            try (FutureProgress.AutocloseableFutureProgressState createVPCStep = FutureProgress.pushAutoCloseableState((String)"Creating VPC");){
                CreateVpcResponse result = client.createVpc((CreateVpcRequest)CreateVpcRequest.builder().cidrBlock(cidr).tagSpecifications(new TagSpecification[]{AWSUtils.getTagsWithName(ResourceType.VPC, id, newVN.getCloudApplicableTags(settings))}).build());
                newVN.setAwsVpcId(result.vpc().vpcId());
            }
            DescribeAvailabilityZonesResponse azs = client.describeAvailabilityZones();
            for (AvailabilityZone az : azs.availabilityZones()) {
                if (!az.regionName().equals(settings.awsSettings.regionId)) continue;
                newVN.setAwsAvailabilityZone(az.zoneName());
                break;
            }
            assert (newVN.getAwsAvailabilityZone() != null);
            logger.infoV("Will create subnet in zone %s", new Object[]{newVN.getAwsAvailabilityZone()});
            try (FutureProgress.AutocloseableFutureProgressState createFirstSubnetStep = FutureProgress.pushAutoCloseableState((String)"Creating first Subnet");){
                CreateSubnetResponse csr = client.createSubnet((CreateSubnetRequest)CreateSubnetRequest.builder().vpcId(newVN.getAwsVpcId()).availabilityZone(newVN.getAwsAvailabilityZone()).cidrBlock(cidr).tagSpecifications(new TagSpecification[]{AWSUtils.getTags(ResourceType.SUBNET, newVN.getCloudApplicableTags(settings))}).build());
                logger.infoV("Created subnet %s", new Object[]{csr.subnet().subnetId()});
                newVN.setAwsSubnetId(csr.subnet().subnetId());
            }
            logger.infoV("Will create second subnet in zone %s", new Object[]{newVN.getAwsAvailabilityZone()});
            try (FutureProgress.AutocloseableFutureProgressState createSecondSubnetStep = FutureProgress.pushAutoCloseableState((String)"Creating second Subnet");){
                CreateSubnetResponse createSecondSubnetResponse = client.createSubnet((CreateSubnetRequest)CreateSubnetRequest.builder().vpcId(newVN.getAwsVpcId()).availabilityZone(newVN.getAwsAvailabilityZone()).cidrBlock(cidr).tagSpecifications(new TagSpecification[]{AWSUtils.getTags(ResourceType.SUBNET, newVN.getCloudApplicableTags(settings))}).build());
                logger.infoV("Created second subnet %s", new Object[]{createSecondSubnetResponse.subnet().subnetId()});
                newVN.setAwsSecondSubnetId(createSecondSubnetResponse.subnet().subnetId());
            }
            FutureProgress.updateState((double)1.0);
            try (FutureProgress.AutocloseableFutureProgressState createSecurityGroupStep = FutureProgress.pushAutoCloseableState((String)"Creating security group");){
                asg = this.createAWSSecurityGroups(settings, tenant, newVN, input, client, newVN.getAwsVpcId(), settings.awsSettings.regionId);
            }
            FutureProgress.updateState((double)2.0);
            newVN.setAwsDefaultSecurityGroup(asg.awsDefaultSecurityGroup);
            newVN.setAwsSecurityGroups(StringUtils.join(asg.awsSecurityGroups, (String)","));
            newVN.setAutoCreatedAwsSecurityGroups(newVN.getAwsSecurityGroups());
            String tenantAccountId = this.clientService.getTenantAccountId(AWSUtils.buildAWSAuthenticationInfo(newVN.getCloudAccountOrVirtualCloudAccount(), this.cloudCryptoService));
            logger.info((Object)("Tenant account id is " + tenantAccountId));
            try (FutureProgress.AutocloseableFutureProgressState createPeeringStep = FutureProgress.pushAutoCloseableState((String)"Creating peering");){
                tenantRouteTableId = this.createPeering(newVN, settings.awsSettings.regionId);
            }
            FutureProgress.updateState((double)3.0);
            switch (input.internetAccessMode) {
                case NO: {
                    break;
                }
                case EGRESS_ONLY: {
                    throw new NotImplementedException("Egress only internet not implemented");
                }
                case YES: {
                    CreateInternetGatewayResponse cir = client.createInternetGateway((CreateInternetGatewayRequest)CreateInternetGatewayRequest.builder().tagSpecifications(new TagSpecification[]{AWSUtils.getTags(ResourceType.INTERNET_GATEWAY, newVN.getCloudApplicableTags(settings))}).build());
                    String igwId = cir.internetGateway().internetGatewayId();
                    smartLogTail.appendLine("Attaching internet gateway...", logger, Priority.INFO);
                    client.attachInternetGateway((AttachInternetGatewayRequest)AttachInternetGatewayRequest.builder().internetGatewayId(igwId).vpcId(newVN.getAwsVpcId()).build());
                    smartLogTail.replaceLastLine("Internet gateway created", logger, Priority.INFO);
                    CreateRouteRequest crq = (CreateRouteRequest)CreateRouteRequest.builder().routeTableId(tenantRouteTableId).destinationCidrBlock("0.0.0.0/0").gatewayId(igwId).build();
                    smartLogTail.appendLine("Create default route...", logger, Priority.INFO);
                    client.createRoute(crq);
                    smartLogTail.replaceLastLine("Default route created", logger, Priority.INFO);
                }
            }
            newVN.setMode(VirtualNetwork.VirtualNetworkMode.FM_MANAGED);
            rwt.getThreadEM().persist((Object)newVN);
            rwt.commit();
            VirtualNetwork virtualNetwork = newVN;
            return virtualNetwork;
        }
        finally {
            if (rwt != null) {
                rwt.close();
            }
        }
    }

    @Override
    public VirtualNetwork createUnmanagedVirtualNetwork(String tenantId, ProtoVirtualNetworkDTO input, DKUtils.SmartLogTailBuilder smartLogTail) throws Exception {
        String awsSecurityGroups;
        Object id = StringUtils.isNotEmpty((String)input.forcedID) ? input.forcedID : "vn-" + SecretKeyGenerator.generate((int)12);
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", tenantId);
        assert (tenant != null);
        CloudAccount cloudAccount = StringUtils.isNotEmpty((String)input.accountId) ? this.cloudAccountsService.getAccountMandatory(tenant, input.accountId) : tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe());
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String region = StringUtils.isNotEmpty((String)input.awsRegion) ? input.awsRegion : settings.awsSettings.regionId;
        Ec2Client client = this.clientService.getEC2Client(AWSUtils.buildAWSAccount(cloudAccount, region, this.cloudCryptoService));
        DescribeVpcsResponse dvr = client.describeVpcs((DescribeVpcsRequest)DescribeVpcsRequest.builder().vpcIds(new String[]{input.awsVpcId}).build());
        if (dvr.vpcs().size() != 1) {
            throw new IllegalArgumentException("VPC not found: " + input.awsVpcId);
        }
        DescribeSubnetsResponse dsr = client.describeSubnets((DescribeSubnetsRequest)DescribeSubnetsRequest.builder().subnetIds(new String[]{input.awsSubnetId}).build());
        if (dsr.subnets().size() != 1) {
            throw new IllegalArgumentException("Subnet not found: " + input.awsSubnetId);
        }
        if (StringUtils.isNotEmpty((String)input.awsSecondSubnetId) && !input.awsSecondSubnetId.isEmpty()) {
            String secondarySubnetAvailabilityZone;
            DescribeSubnetsResponse dsrSecondSubnet = client.describeSubnets((DescribeSubnetsRequest)DescribeSubnetsRequest.builder().subnetIds(new String[]{input.awsSecondSubnetId}).build());
            if (dsr.subnets().size() != 1) {
                throw new IllegalArgumentException("Secondary subnet not found: " + input.awsSecondSubnetId);
            }
            String primarySubnetAvailabilityZone = ((Subnet)dsr.subnets().get(0)).availabilityZoneId();
            if (primarySubnetAvailabilityZone.equals(secondarySubnetAvailabilityZone = ((Subnet)dsrSecondSubnet.subnets().get(0)).availabilityZoneId())) {
                throw new IllegalArgumentException("Primary subnet '" + input.awsSubnetId + "' and secondary subnet '" + input.awsSecondSubnetId + "' are in the same availability zone '" + primarySubnetAvailabilityZone + "'");
            }
        }
        VirtualNetwork newVN = new VirtualNetwork();
        newVN.setId((String)id);
        newVN.setTenant(tenant);
        if (StringUtils.isNotEmpty((String)input.accountId)) {
            newVN.setCloudAccount(cloudAccount);
        }
        newVN.setMode(input.mode);
        newVN.setLabel(input.label);
        newVN.setDescription(input.description);
        newVN.setCloudTags(CloudTagList.toJSON(input.cloudTags));
        newVN.setManagedCidr(((Vpc)dvr.vpcs().get(0)).cidrBlock());
        String awsDefaultSecurityGroup = null;
        String autoCreatedAwsSecurityGroups = null;
        if (input.awsAutoCreateSecurityGroups) {
            AutoCreatedSecurityGroups asg;
            try (FutureProgress.AutocloseableFutureProgressState createSecurityGroup = FutureProgress.pushAutoCloseableState((String)"Creating security group");){
                asg = this.createAWSSecurityGroups(settings, tenant, newVN, input, client, input.awsVpcId, region);
            }
            awsSecurityGroups = StringUtils.join(asg.awsSecurityGroups, (String)",");
            awsDefaultSecurityGroup = asg.awsDefaultSecurityGroup;
            autoCreatedAwsSecurityGroups = awsSecurityGroups;
        } else {
            awsSecurityGroups = input.awsSecurityGroups != null ? Joiner.on((String)",").join(input.awsSecurityGroups) : "";
        }
        FutureProgress.updateState((double)1.0);
        newVN.setAwsVpcId(input.awsVpcId);
        newVN.setAwsSubnetId(input.awsSubnetId);
        newVN.setAwsRegion(region);
        newVN.setAwsSecondSubnetId(input.awsSecondSubnetId);
        newVN.setAwsAvailabilityZone(((Subnet)dsr.subnets().get(0)).availabilityZone());
        newVN.setAwsSecurityGroups(awsSecurityGroups);
        newVN.setAwsDefaultSecurityGroup(awsDefaultSecurityGroup);
        newVN.setAwsAssignPublicIP(true);
        newVN.setFMVisibleURL(input.fmVisibleURL);
        newVN.setAutoCreatedAwsSecurityGroups(autoCreatedAwsSecurityGroups);
        String fmVPC = settings.awsSettings.vpcId;
        newVN.setPeeringState(VirtualNetwork.PeeringState.NONE);
        if (!input.awsVpcId.equals(fmVPC)) {
            if (input.autoCreatePeerings) {
                smartLogTail.appendLine("Creating peering ...", logger, Priority.INFO);
                try (FutureProgress.AutocloseableFutureProgressState createPeering = FutureProgress.pushAutoCloseableState((String)"Creating peering");){
                    this.createPeering(newVN, region);
                    smartLogTail.replaceLastLine("Peering created", logger, Priority.INFO);
                }
                catch (IllegalArgumentException e) {
                    logger.warnV((Throwable)e, "Peering in region '%s' could not be created", new Object[]{region});
                    throw e;
                }
                catch (Exception e) {
                    smartLogTail.appendLine("Peering in region '" + region + "' could not be created. As the network is unmanaged by FM, skipping it.");
                    logger.warnV((Throwable)e, "Peering in region '%s' could not be created. As the network is unmanaged by FM, skipping it.", new Object[]{region});
                }
            } else {
                smartLogTail.appendLine("No peering auto creation, peering should be defined externally.");
                if (this.detectPeering(tenant, newVN, region)) {
                    smartLogTail.appendLine("Existing peering detected");
                } else {
                    smartLogTail.appendLine("No existing peering detected");
                }
            }
        }
        FutureProgress.updateState((double)2.0);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            rwt.getThreadEM().persist((Object)newVN);
            rwt.commit();
            VirtualNetwork virtualNetwork = newVN;
            return virtualNetwork;
        }
    }

    @Override
    public InfoMessage.InfoMessages deleteVirtualNetwork(VirtualNetwork vn, boolean deletePeering) {
        InfoMessage.InfoMessages result = new InfoMessage.InfoMessages();
        if (vn.getAwsPeeringConnectionId() == null || !deletePeering || vn.getPeeringState() != VirtualNetwork.PeeringState.INTERNAL) {
            return result;
        }
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", vn.getTenant().getId());
        try {
            this.deletePeering(tenant, vn, vn.getAwsRegion());
        }
        catch (Exception e) {
            logger.warn((Object)"Error during peering deletion", (Throwable)e);
            result.withWarning((InfoMessage.MessageCode)FMServerCodes.WARN_PEERING_NOT_DELETED, e.getMessage());
        }
        return result;
    }

    @Override
    public InfoMessage.InfoMessages deleteVirtualNetworkSecurityGroups(VirtualNetwork vn) {
        InfoMessage.InfoMessages result = new InfoMessage.InfoMessages();
        switch (vn.getMode()) {
            case EXISTING_MULTITENANT_PUBLIC_IP: {
                throw new NotImplementedException();
            }
            case FM_MANAGED: 
            case EXISTING_MONOTENANT: {
                if (StringUtils.isBlank((String)vn.getAutoCreatedAwsSecurityGroups())) break;
                Ec2Client client = this.clientService.getEC2Client(AWSUtils.buildAWSAccount(vn, this.cloudCryptoService));
                HashSet<String> groups = new HashSet<String>(Arrays.asList(vn.getAutoCreatedAwsSecurityGroups().split(",")));
                DescribeSecurityGroupsResponse describeResult = client.describeSecurityGroups((DescribeSecurityGroupsRequest)DescribeSecurityGroupsRequest.builder().groupIds(groups).build());
                for (SecurityGroup securityGroup : describeResult.securityGroups()) {
                    String groupId = securityGroup.groupId();
                    groups.remove(groupId);
                    try {
                        client.deleteSecurityGroup((DeleteSecurityGroupRequest)DeleteSecurityGroupRequest.builder().groupId(groupId).build());
                    }
                    catch (Ec2Exception e) {
                        if (e.statusCode() == 400 && e.awsErrorDetails().errorCode().equals("InvalidGroup.NotFound")) {
                            logger.warnV((Throwable)e, "Ignoring delete operation on a non-existing security group: %s", new Object[]{groupId});
                            continue;
                        }
                        logger.warnV((Throwable)e, "Unable to delete security group %s", new Object[]{groupId});
                        result.withWarning((InfoMessage.MessageCode)FMServerCodes.WARN_SECURITY_GROUP_NOT_DELETED, e.awsErrorDetails().errorMessage());
                    }
                }
                for (String groupId : groups) {
                    logger.warnV("Ignoring delete operation on a non-existing security group: %s", new Object[]{groupId});
                }
                break;
            }
        }
        return result;
    }

    @Override
    public boolean needsPeering(String tenantId, VirtualNetwork vn) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String fmVpc = settings.awsSettings.vpcId;
        return !vn.getAwsVpcId().equals(fmVpc);
    }

    @Override
    public Optional<String> getPeeringId(String tenantId, VirtualNetwork vn) {
        return StringUtils.isEmpty((String)vn.getAwsPeeringConnectionId()) ? Optional.empty() : Optional.of(vn.getAwsPeeringConnectionId());
    }

    @Override
    public VirtualNetworkMetadata getDefaultCreationValues(String tenantId) {
        return new AWSInstanceMetadataReader().getVirtualNetworkMetadata();
    }

    @Override
    public void validateSettings(VirtualNetwork vn, VirtualNetworkSettingsDTO dto) {
        if (dto.dnsStrategy == VirtualNetwork.DNSStrategy.VN_SPECIFIC_CLOUD_DNS_SERVICE) {
            if (!StringUtils.isEmpty((String)dto.awsRoute53PublicIPZoneId)) {
                this.awsdnsService.checkIfZoneExist(vn, dto.awsRoute53PublicIPZoneId);
            }
            if (!StringUtils.isEmpty((String)dto.awsRoute53PrivateIPZoneId)) {
                this.awsdnsService.checkIfZoneExist(vn, dto.awsRoute53PrivateIPZoneId);
            }
        }
        if (StringUtils.isNotEmpty((String)dto.awsSecondSubnetId) && !dto.awsSecondSubnetId.equals(vn.getAwsSecondSubnetId())) {
            String secondarySubnetAvailabilityZone;
            Ec2Client client = this.clientService.getEC2Client(AWSUtils.buildAWSAccount(vn, this.cloudCryptoService));
            DescribeSubnetsResponse dsrSecondSubnet = client.describeSubnets((DescribeSubnetsRequest)DescribeSubnetsRequest.builder().subnetIds(new String[]{dto.awsSecondSubnetId}).build());
            if (dsrSecondSubnet.subnets().size() != 1) {
                throw new IllegalArgumentException("Secondary subnet not found: " + dto.awsSecondSubnetId);
            }
            DescribeSubnetsResponse dsr = client.describeSubnets((DescribeSubnetsRequest)DescribeSubnetsRequest.builder().subnetIds(new String[]{dto.awsSubnetId}).build());
            String primarySubnetAvailabilityZone = ((Subnet)dsr.subnets().get(0)).availabilityZoneId();
            if (primarySubnetAvailabilityZone.equals(secondarySubnetAvailabilityZone = ((Subnet)dsrSecondSubnet.subnets().get(0)).availabilityZoneId())) {
                throw new IllegalArgumentException("Primary subnet '" + dto.awsSubnetId + "' and secondary subnet '" + dto.awsSecondSubnetId + "' are in the same availability zone '" + primarySubnetAvailabilityZone + "'");
            }
        }
    }

    private boolean detectPeering(Tenant tenant, VirtualNetwork newVN, String region) {
        String peeringId = this.checkPeeringExist(newVN, region);
        if (StringUtils.isNotEmpty((String)peeringId)) {
            logger.info((Object)("Reusing existing peering connection " + peeringId));
            newVN.setAwsPeeringConnectionId(peeringId);
            newVN.setPeeringState(VirtualNetwork.PeeringState.EXTERNAL);
            for (VirtualNetwork vn : VirtualNetworksService.getNetworks(tenant, this.dbService)) {
                if (vn.getPeeringState() != VirtualNetwork.PeeringState.INTERNAL || !peeringId.equals(vn.getAwsPeeringConnectionId())) continue;
                newVN.setPeeringState(VirtualNetwork.PeeringState.INTERNAL);
            }
            return true;
        }
        return false;
    }

    private String createPeering(VirtualNetwork newVN, String region) throws IllegalStateException {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String tenantAccountId = this.clientService.getTenantAccountId(AWSUtils.buildAWSAuthenticationInfo(newVN.getCloudAccountOrVirtualCloudAccount(), this.cloudCryptoService));
        logger.info((Object)("Creating the peering on " + newVN.getId()));
        if (this.detectPeering(newVN.getTenant(), newVN, region)) {
            return null;
        }
        Ec2Client fmClient = this.clientService.getEC2Client(AWSUtils.buildAWSAccount(newVN.getTenant().getVirtualCloudAccount(settings), settings.awsSettings.regionId, this.cloudCryptoService));
        Ec2Client client = this.clientService.getEC2Client(AWSUtils.buildAWSAccount(newVN.getCloudAccountOrVirtualCloudAccount(), region, this.cloudCryptoService));
        CreateVpcPeeringConnectionResponse cvpcr = fmClient.createVpcPeeringConnection((CreateVpcPeeringConnectionRequest)CreateVpcPeeringConnectionRequest.builder().vpcId(settings.awsSettings.vpcId).peerOwnerId(tenantAccountId).peerRegion(region).peerVpcId(newVN.getAwsVpcId()).tagSpecifications(new TagSpecification[]{AWSUtils.getTags(ResourceType.VPC_PEERING_CONNECTION, newVN.getCloudApplicableTags(settings))}).build());
        int retry = 20;
        Ec2Exception exception = null;
        while (retry > 0) {
            try {
                DescribeVpcPeeringConnectionsResponse describeVpcPeeringConnectionsResponse = fmClient.describeVpcPeeringConnections((DescribeVpcPeeringConnectionsRequest)DescribeVpcPeeringConnectionsRequest.builder().vpcPeeringConnectionIds(new String[]{cvpcr.vpcPeeringConnection().vpcPeeringConnectionId()}).build());
                if (describeVpcPeeringConnectionsResponse.vpcPeeringConnections().isEmpty()) {
                    throw new IllegalArgumentException("Peering not found: " + cvpcr.vpcPeeringConnection().vpcPeeringConnectionId());
                }
                VpcPeeringConnection vpcPeeringConnection = (VpcPeeringConnection)describeVpcPeeringConnectionsResponse.vpcPeeringConnections().get(0);
                if ("failed".equals(vpcPeeringConnection.status().codeAsString())) {
                    throw new IllegalArgumentException("Peering creation failed: " + vpcPeeringConnection.status().message());
                }
                client.acceptVpcPeeringConnection((AcceptVpcPeeringConnectionRequest)AcceptVpcPeeringConnectionRequest.builder().vpcPeeringConnectionId(cvpcr.vpcPeeringConnection().vpcPeeringConnectionId()).build());
                retry = 0;
                exception = null;
            }
            catch (Ec2Exception exc) {
                exception = exc;
                --retry;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw exc;
                }
            }
        }
        if (exception != null) {
            logger.error((Object)"Fail to accept peering.", (Throwable)exception);
            throw exception;
        }
        newVN.setAwsPeeringConnectionId(cvpcr.vpcPeeringConnection().vpcPeeringConnectionId());
        newVN.setPeeringState(VirtualNetwork.PeeringState.INTERNAL);
        VirtualNetworkMetadata creationValues = this.getDefaultCreationValues(newVN.getTenant().getId());
        RouteTable rtFMTenant = this.getRouteTable(fmClient, settings.awsSettings.vpcId, creationValues.awsSubnetId);
        RouteTable rtTenantFm = this.getRouteTable(client, newVN.getAwsVpcId(), newVN.getAwsSubnetId());
        if (rtFMTenant == null || rtTenantFm == null) {
            this.removePeeringConnection(fmClient, newVN);
            if (rtFMTenant == null) {
                throw new IllegalStateException("Subnetwork " + creationValues.awsSubnetId + " is not associated with a route table, and no main route table found.");
            }
            if (rtTenantFm == null) {
                throw new IllegalStateException("Subnetwork " + newVN.getAwsSubnetId() + " is not associated with a route table, and no main route table found.");
            }
        }
        try {
            fmClient.createRoute((CreateRouteRequest)CreateRouteRequest.builder().routeTableId(rtFMTenant.routeTableId()).destinationCidrBlock(newVN.getManagedCidr()).vpcPeeringConnectionId(cvpcr.vpcPeeringConnection().vpcPeeringConnectionId()).build());
            String tenantRouteTableId = rtTenantFm.routeTableId();
            client.createRoute((CreateRouteRequest)CreateRouteRequest.builder().routeTableId(tenantRouteTableId).destinationCidrBlock(settings.awsSettings.fmServerCIDR).vpcPeeringConnectionId(cvpcr.vpcPeeringConnection().vpcPeeringConnectionId()).build());
            return tenantRouteTableId;
        }
        catch (Exception exc) {
            this.removePeeringConnection(fmClient, newVN);
            throw exc;
        }
    }

    @Nullable
    private RouteTable getRouteTable(Ec2Client client, String vpcId, String subnetId) {
        DescribeRouteTablesResponse result = client.describeRouteTables((DescribeRouteTablesRequest)DescribeRouteTablesRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("vpc-id").values(new String[]{vpcId}).build()}).build());
        RouteTable rt = result.routeTables().stream().filter(table -> table.associations().stream().anyMatch(a -> subnetId.equals(a.subnetId()))).findFirst().orElse(null);
        if (rt == null) {
            rt = result.routeTables().stream().filter(table -> table.associations().stream().anyMatch(a -> a.main() != null && a.main() != false)).findFirst().orElse(null);
        }
        return rt;
    }

    public String checkPeeringExist(VirtualNetwork newVN, String region) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        Ec2Client fmClient = this.clientService.getEC2Client(AWSUtils.buildAWSAccount(newVN.getTenant().getVirtualCloudAccount(settings), region, this.cloudCryptoService));
        DescribeVpcPeeringConnectionsResponse cvpcr = fmClient.describeVpcPeeringConnections((DescribeVpcPeeringConnectionsRequest)DescribeVpcPeeringConnectionsRequest.builder().build());
        return cvpcr.vpcPeeringConnections().stream().filter(p -> p.requesterVpcInfo().vpcId().equals(settings.awsSettings.vpcId) && p.accepterVpcInfo().vpcId().equals(newVN.getAwsVpcId()) && p.status().codeAsString().equalsIgnoreCase("active")).map(VpcPeeringConnection::vpcPeeringConnectionId).findFirst().orElse(null);
    }

    public long countPeering(Tenant tenant, VirtualNetwork newVN, String peeringId) {
        return this.dbService.getSingleResult(Long.class, "SELECT count(*) from virtualnetwork vn where vn.tenant=?1 and vn.awsPeeringConnectionId=?2", tenant, peeringId);
    }

    private void deletePeering(Tenant tenant, VirtualNetwork dssVnet, String region) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        long count = this.countPeering(tenant, dssVnet, dssVnet.getAwsPeeringConnectionId());
        if (count > 1L) {
            logger.info((Object)"Peering is not deleted, as it's still in use.");
            return;
        }
        logger.info((Object)("Deleting peering for " + dssVnet.getAwsVpcId()));
        Ec2Client fmClient = this.clientService.getEC2Client(AWSUtils.buildAWSAccount(tenant.getVirtualCloudAccount(settings), settings.awsSettings.regionId, this.cloudCryptoService));
        Ec2Client client = this.clientService.getEC2Client(AWSUtils.buildAWSAccount(dssVnet.getCloudAccountOrVirtualCloudAccount(), region, this.cloudCryptoService));
        VirtualNetworkMetadata creationValues = this.getDefaultCreationValues(tenant.getId());
        this.removeRoute(fmClient, settings.awsSettings.vpcId, creationValues.awsSubnetId, dssVnet.getManagedCidr());
        this.removeRoute(client, dssVnet.getAwsVpcId(), dssVnet.getAwsSubnetId(), settings.awsSettings.fmServerCIDR);
        this.removePeeringConnection(fmClient, dssVnet);
    }

    private void removeRoute(Ec2Client client, String vpcId, String subnetId, String cidr) {
        RouteTable rt = this.getRouteTable(client, vpcId, subnetId);
        if (rt != null) {
            client.deleteRoute((DeleteRouteRequest)DeleteRouteRequest.builder().routeTableId(rt.routeTableId()).destinationCidrBlock(cidr).build());
        }
    }

    private void removePeeringConnection(Ec2Client client, VirtualNetwork vn) {
        client.deleteVpcPeeringConnection((DeleteVpcPeeringConnectionRequest)DeleteVpcPeeringConnectionRequest.builder().vpcPeeringConnectionId(vn.getAwsPeeringConnectionId()).build());
    }

    private AutoCreatedSecurityGroups createAWSSecurityGroups(FMSettings settings, Tenant tenant, VirtualNetwork newVN, ProtoVirtualNetworkDTO input, Ec2Client client, String vpcId, String region) {
        IpPermission ingressPerm1;
        CreateSecurityGroupResponse csgr;
        String cgName;
        AutoCreatedSecurityGroups ret = new AutoCreatedSecurityGroups();
        switch (input.mode) {
            case EXISTING_MONOTENANT: {
                break;
            }
            case FM_MANAGED: {
                if (!input.allowIngressSSH) break;
                cgName = "fm-vn-" + this.sanitizeForSecurityGroupName(input.label) + "-fm-to-instances-" + SecretKeyGenerator.generate((int)4);
                csgr = client.createSecurityGroup((CreateSecurityGroupRequest)CreateSecurityGroupRequest.builder().vpcId(vpcId).description("Security group to authorize Fleet Manager to SSH to deployed instances in Fleet Manager Virtual Network " + this.sanitizeForSecurityGroupName(input.label)).groupName(cgName).tagSpecifications(new TagSpecification[]{AWSUtils.getTags(ResourceType.SECURITY_GROUP, newVN.getCloudApplicableTags(FMApp.getFMSettingsUnsafe()))}).build());
                ret.awsSecurityGroups.add(csgr.groupId());
                ingressPerm1 = (IpPermission)IpPermission.builder().fromPort(Integer.valueOf(22)).toPort(Integer.valueOf(22)).ipProtocol("tcp").ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(settings.awsSettings.fmServerCIDR).build()}).build();
                client.authorizeSecurityGroupIngress((AuthorizeSecurityGroupIngressRequest)AuthorizeSecurityGroupIngressRequest.builder().groupId(csgr.groupId()).ipPermissions(new IpPermission[]{ingressPerm1}).build());
                break;
            }
            case EXISTING_MULTITENANT_PUBLIC_IP: {
                cgName = "fm-vn-" + this.sanitizeForSecurityGroupName(input.label) + "-instances-to-fm-server-" + SecretKeyGenerator.generate((int)4);
                csgr = client.createSecurityGroup((CreateSecurityGroupRequest)CreateSecurityGroupRequest.builder().vpcId(vpcId).description("Security group allowing deployed instances to connect to Fleet Manager Server in Fleet Manager Virtual Network " + this.sanitizeForSecurityGroupName(input.label)).groupName(cgName).tagSpecifications(new TagSpecification[]{AWSUtils.getTags(ResourceType.SECURITY_GROUP, newVN.getCloudApplicableTags(FMApp.getFMSettingsUnsafe()))}).build());
                ret.awsSecurityGroups.add(csgr.groupId());
                if (input.allowIngressSSH) {
                    ingressPerm1 = (IpPermission)IpPermission.builder().fromPort(Integer.valueOf(22)).toPort(Integer.valueOf(22)).ipProtocol("tcp").ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(settings.awsSettings.fmServerPublicCIDR).build()}).build();
                    client.authorizeSecurityGroupIngress((AuthorizeSecurityGroupIngressRequest)AuthorizeSecurityGroupIngressRequest.builder().groupId(csgr.groupId()).ipPermissions(new IpPermission[]{ingressPerm1}).build());
                }
                IpPermission egressPerm1 = (IpPermission)IpPermission.builder().fromPort(Integer.valueOf(0)).toPort(Integer.valueOf(65535)).ipProtocol("tcp").ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(settings.awsSettings.fmServerPublicCIDR).build()}).build();
                client.authorizeSecurityGroupEgress((AuthorizeSecurityGroupEgressRequest)AuthorizeSecurityGroupEgressRequest.builder().groupId(csgr.groupId()).ipPermissions(new IpPermission[]{egressPerm1}).build());
                break;
            }
        }
        cgName = "fm-vn-" + this.sanitizeForSecurityGroupName(input.label) + "-instances-external-connectivity-" + SecretKeyGenerator.generate((int)4);
        csgr = client.createSecurityGroup((CreateSecurityGroupRequest)CreateSecurityGroupRequest.builder().vpcId(vpcId).description("Security group to authorize connectivity to deployed instances on HTTP(S) and SSH ports in Fleet Manager Virtual Network " + this.sanitizeForSecurityGroupName(input.label)).groupName(cgName).tagSpecifications(new TagSpecification[]{AWSUtils.getTags(ResourceType.SECURITY_GROUP, newVN.getCloudApplicableTags(FMApp.getFMSettingsUnsafe()))}).build());
        ret.awsSecurityGroups.add(csgr.groupId());
        ingressPerm1 = (IpPermission)IpPermission.builder().fromPort(Integer.valueOf(22)).toPort(Integer.valueOf(22)).ipProtocol("tcp").ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").build()}).build();
        IpPermission ingressPerm2 = (IpPermission)IpPermission.builder().fromPort(Integer.valueOf(80)).toPort(Integer.valueOf(80)).ipProtocol("tcp").ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").build()}).build();
        IpPermission ingressPerm3 = (IpPermission)IpPermission.builder().fromPort(Integer.valueOf(443)).toPort(Integer.valueOf(443)).ipProtocol("tcp").ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").build()}).build();
        client.authorizeSecurityGroupIngress((AuthorizeSecurityGroupIngressRequest)AuthorizeSecurityGroupIngressRequest.builder().groupId(csgr.groupId()).ipPermissions(new IpPermission[]{ingressPerm1, ingressPerm2, ingressPerm3}).build());
        cgName = "fm-vn-" + this.sanitizeForSecurityGroupName(input.label) + "-default-" + SecretKeyGenerator.generate((int)12);
        csgr = client.createSecurityGroup((CreateSecurityGroupRequest)CreateSecurityGroupRequest.builder().vpcId(vpcId).description("default-like security group for inter-instances communication and instances/EKS communication in Fleet Manager Virtual Network " + this.sanitizeForSecurityGroupName(input.label)).groupName(cgName).tagSpecifications(new TagSpecification[]{AWSUtils.getTags(ResourceType.SECURITY_GROUP, newVN.getCloudApplicableTags(FMApp.getFMSettingsUnsafe()))}).build());
        ret.awsDefaultSecurityGroup = csgr.groupId();
        ret.awsSecurityGroups.add(csgr.groupId());
        UserIdGroupPair userIdGroupPair = (UserIdGroupPair)UserIdGroupPair.builder().groupId(csgr.groupId()).userId(this.clientService.getTenantAccountId(AWSUtils.buildAWSAuthenticationInfo(newVN.getCloudAccountOrVirtualCloudAccount(), this.cloudCryptoService))).build();
        IpPermission ipPermission = (IpPermission)IpPermission.builder().ipProtocol("-1").userIdGroupPairs(new UserIdGroupPair[]{userIdGroupPair}).build();
        client.authorizeSecurityGroupIngress((AuthorizeSecurityGroupIngressRequest)AuthorizeSecurityGroupIngressRequest.builder().groupId(csgr.groupId()).ipPermissions(new IpPermission[]{ipPermission}).build());
        return ret;
    }

    private String sanitizeForSecurityGroupName(String input) {
        return input.replaceAll("[^A-Za-z0-9]", "_");
    }

    static class AutoCreatedSecurityGroups {
        List<String> awsSecurityGroups = new ArrayList<String>();
        String awsDefaultSecurityGroup;

        AutoCreatedSecurityGroups() {
        }
    }
}

