/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws;

import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.ResourceType;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Tag;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.TagSpecification;
import com.dataiku.fm.cloud.CloudCryptoServiceInterface;
import com.dataiku.fm.cloud.aws.AWSClientService;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class AWSUtils {
    public static TagSpecification getTagsWithName(ResourceType resourceType, @Nonnull String resourceName, CloudTagList tags) {
        return AWSUtils.getTags(resourceType, tags.with("Name", resourceName));
    }

    public static TagSpecification getTags(ResourceType resourceType, CloudTagList tags) {
        return (TagSpecification)TagSpecification.builder().resourceType(resourceType).tags((Collection)tags.stream().map(cloudTag -> (Tag)Tag.builder().key(cloudTag.key).value(cloudTag.value).build()).collect(Collectors.toSet())).build();
    }

    public static AWSClientService.Account buildAWSAccount(VirtualNetwork virtualNetwork, CloudCryptoServiceInterface cloudCryptoService) {
        return AWSUtils.buildAWSAccount(virtualNetwork.getCloudAccountOrVirtualCloudAccount(), virtualNetwork.getAwsRegion(), cloudCryptoService);
    }

    public static AWSClientService.Account buildAWSAccount(CloudAccount account, String region, CloudCryptoServiceInterface cryptoService) {
        return new AWSClientService.Account(region, AWSUtils.buildAWSAuthenticationInfo(account, cryptoService));
    }

    public static Optional<AWSClientService.AuthenticationInfo> buildAWSAuthenticationInfo(CloudAccount account, CloudCryptoServiceInterface cryptoService) {
        return switch (account.getAwsAuthenticationMode()) {
            default -> throw new IncompatibleClassChangeError();
            case CloudAccount.AWSAuthenticationMode.DEFAULT_INSTANCE_CREDENTIALS -> Optional.empty();
            case CloudAccount.AWSAuthenticationMode.IAM_ROLE -> {
                Optional<String> decryptedExternalId = Optional.ofNullable(account.getAwsIAMRoleExternalId()).filter(externalId -> !externalId.isBlank()).map(externalId -> account.isEncrypted() ? cryptoService.decrypt(account.getTenant(), account.getAwsIAMRoleExternalId()) : externalId);
                yield Optional.of(new AWSClientService.IamRole(account.getAwsIAMRoleARN(), decryptedExternalId));
            }
            case CloudAccount.AWSAuthenticationMode.KEYPAIR -> {
                String accessKey = account.isEncrypted() ? cryptoService.decrypt(account.getTenant(), account.getAwsSecretAccessKey()) : account.getAwsSecretAccessKey();
                yield Optional.of(new AWSClientService.KeyPair(account.getAwsAccessKeyId(), accessKey));
            }
        };
    }
}

