/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.azure;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Key;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Vault;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyVaultErrorException;
import com.dataiku.fm.cloud.CloudCryptoServiceInterface;
import com.dataiku.fm.cloud.azure.AzureClientService;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import jakarta.xml.bind.DatatypeConverter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;

public class AzureCloudCryptoService
implements CloudCryptoServiceInterface {
    @Autowired
    private AzureClientService clientService;
    @Autowired
    private DatabaseAccessService dbService;
    private static final EncryptionAlgorithm VAULT_ENCRYPTION_ALGORITHM = EncryptionAlgorithm.RSA_OAEP;
    private static final String SYMMETRIC_ALGORITHM = "AES";
    private static final List<Integer> SYMMETRIC_KEY_LENGTH_ARRAY = Arrays.asList(128, 192, 256);
    private static final int SYMMETRIC_KEY_LENGTH = 128;
    private static final Charset charset = StandardCharsets.UTF_8;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.crypto");

    @Override
    public boolean isAbleToEncryptUsingTenantMasterKey() {
        Tenant fmTenant = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", "main");
        return this.isAbleToEncrypt(fmTenant);
    }

    @Override
    public void checkEncryptionUsingTenantMasterKey() {
        Tenant fmTenant = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", "main");
        this.checkEncryption(fmTenant);
    }

    @Override
    public boolean isAbleToEncrypt(Tenant tenant) {
        if (!tenant.isAzureKeyVaultSetup()) {
            return false;
        }
        return tenant.getAzureKeyVaultId() != null;
    }

    @Override
    public void checkEncryption(Tenant tenant) {
        String test = "\"This is a test\" @\u00e7\u00a3\u00b0\u00e9\u00e0\u00a7";
        String encryptTest = this.encrypt(tenant, "\"This is a test\" @\u00e7\u00a3\u00b0\u00e9\u00e0\u00a7");
        String decryptTest = this.decrypt(tenant, encryptTest);
        if (!"\"This is a test\" @\u00e7\u00a3\u00b0\u00e9\u00e0\u00a7".equals(decryptTest)) {
            throw new IllegalStateException("Your key does not encrypt/decrypt correctly");
        }
    }

    @Override
    public String encrypt(Tenant tenant, String cleartext) {
        SecretKey symmetricKey = this.generateRandomSymmetricKey(128);
        CiphertextRecord ciphertextRecord = new CiphertextRecord(this.encryptSymmetricKeyUsingVaultKey(tenant, symmetricKey), this.encryptTextUsingSymmetricKey(cleartext, symmetricKey));
        return JSON.json((Object)ciphertextRecord);
    }

    private SecretKey generateRandomSymmetricKey(int keyLength) {
        assert (SYMMETRIC_KEY_LENGTH_ARRAY.contains(keyLength));
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(SYMMETRIC_ALGORITHM);
            keyGenerator.init(keyLength);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("AES is not in Java runtime", e);
        }
    }

    private String encryptTextUsingSymmetricKey(String value, SecretKey symmetricKey) {
        try {
            Cipher cipher = Cipher.getInstance(SYMMETRIC_ALGORITHM);
            cipher.init(1, symmetricKey);
            return Base64.encodeBase64String((byte[])cipher.doFinal(value.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption using symmetric key failed", e);
        }
    }

    private String encryptSymmetricKeyUsingVaultKey(Tenant tenant, SecretKey symmetricKey) {
        CryptographyClient cryptographyClient = this.getCryptographyClient(tenant);
        return Base64.encodeBase64String((byte[])cryptographyClient.encrypt(VAULT_ENCRYPTION_ALGORITHM, DatatypeConverter.printBase64Binary((byte[])symmetricKey.getEncoded()).getBytes(charset)).getCipherText());
    }

    @Override
    public String decrypt(Tenant tenant, String ciphertext) {
        CiphertextRecord ciphertextRecord;
        try {
            ciphertextRecord = (CiphertextRecord)JSON.parse((String)ciphertext, CiphertextRecord.class);
        }
        catch (Exception e) {
            logger.info((Object)"Could not deserialize value as cipher. Value may not be encrypted yet.");
            return ciphertext;
        }
        if (ciphertextRecord == null) {
            return "";
        }
        SecretKey symmetricKey = this.decryptSymmetricKeyUsingVaultKey(tenant, ciphertextRecord.encryptedSymmetricKey);
        return this.decryptTextUsingSymmetricKey(ciphertextRecord.nestedCiphertext, symmetricKey);
    }

    private SecretKey decryptSymmetricKeyUsingVaultKey(Tenant tenant, String symmetricKey) {
        return new SecretKeySpec(DatatypeConverter.parseBase64Binary((String)new String(this.getCryptographyClient(tenant).decrypt(VAULT_ENCRYPTION_ALGORITHM, Base64.decodeBase64((String)symmetricKey)).getPlainText(), charset)), SYMMETRIC_ALGORITHM);
    }

    private CryptographyClient getCryptographyClient(Tenant tenant) {
        return this.clientService.getAzureCryptographyClient(tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe()), this.getFMEncryptionKeyFromKeyVault(tenant).id());
    }

    private Key getFMEncryptionKeyFromKeyVault(Tenant tenant) {
        Vault vault;
        if (!tenant.isAzureKeyVaultSetup()) {
            throw new IllegalStateException("Encryption KeyVault settings in 'Cloud setup' is not setup and is required to encrypt/decrypt secrets.");
        }
        if (tenant.getAzureKeyVaultId() == null) {
            throw new IllegalStateException("Azure 'Encryption KeyVault Id' is not configured in the cloud setup section.");
        }
        try {
            CloudAccount cloudAccount = tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe());
            vault = (Vault)this.clientService.getAzureClient(cloudAccount).vaults().getById(tenant.getAzureKeyVaultId());
        }
        catch (InvalidParameterException e) {
            throw new IllegalStateException("Invalid 'Encryption KeyVault Id' in the cloud setup. It should be the Azure Key Vault Resource ID.", e);
        }
        if (vault == null) {
            throw new IllegalStateException("No Azure Key Vault exist with the resource ID '" + tenant.getAzureKeyVaultId() + ".\nVerify the 'Encryption KeyVault Id' in the cloud setup section");
        }
        if (vault.keys().getByName(tenant.getAzureKeyName()) == null) {
            throw new IllegalStateException("Azure Key '" + tenant.getAzureKeyName() + "' doesn't exist in Key vault '" + tenant.getAzureKeyVaultId() + "'.\nCheck the master key configuration in the cloud setup section.");
        }
        try {
            if (vault.keys().getByNameAndVersion(tenant.getAzureKeyName(), tenant.getAzureKeyVersion()) == null) {
                throw new IllegalStateException("Azure Key '" + tenant.getAzureKeyName() + "' exist in Key vault but hasn't got a version '" + tenant.getAzureKeyVersion() + "'.\nCheck the 'Encryption Key Version' in the cloud setup section.");
            }
        }
        catch (KeyVaultErrorException e) {
            throw new IllegalStateException("Azure Key '" + tenant.getAzureKeyName() + "' exist in Key vault but '" + tenant.getAzureKeyVersion() + "' is not a version valid format.\nCheck the 'Encryption Key Version' in the cloud setup section.", e);
        }
        Key vaultKey = vault.keys().getByNameAndVersion(tenant.getAzureKeyName(), tenant.getAzureKeyVersion());
        return vaultKey;
    }

    private String decryptTextUsingSymmetricKey(String encryptedValue, SecretKey symmetricKey) {
        try {
            Cipher cipher = Cipher.getInstance(SYMMETRIC_ALGORITHM);
            cipher.init(2, symmetricKey);
            return new String(cipher.doFinal(Base64.decodeBase64((String)encryptedValue)));
        }
        catch (Exception e) {
            throw new RuntimeException("Decryption using symmetric key failed", e);
        }
    }

    static class CiphertextRecord {
        private final String encryptedSymmetricKey;
        private final String nestedCiphertext;

        CiphertextRecord(String encryptedSymmetricKey, String nestedCiphertext) {
            this.encryptedSymmetricKey = encryptedSymmetricKey;
            this.nestedCiphertext = nestedCiphertext;
        }
    }
}

