/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.gcp;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.cloud.CloudCryptoServiceInterface;
import com.dataiku.fm.cloud.gcp.GCPClientService;
import com.dataiku.fm.cloud.gcp.KMSClient;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class GCPCloudCryptoService
implements CloudCryptoServiceInterface {
    @Autowired
    private GCPClientService clientService;
    @Autowired
    private DatabaseAccessService dbService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.crypto");

    @Override
    public boolean isAbleToEncryptUsingTenantMasterKey() {
        Tenant fmTenant = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", "main");
        return this.isAbleToEncrypt(fmTenant);
    }

    @Override
    public void checkEncryptionUsingTenantMasterKey() {
        Tenant fmTenant = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", "main");
        this.checkEncryption(fmTenant);
    }

    @Override
    public boolean isAbleToEncrypt(Tenant tenant) {
        return StringUtils.isNotBlank((String)tenant.getGcpLocationId()) && StringUtils.isNotBlank((String)tenant.getGcpKeyRing()) && StringUtils.isNotBlank((String)tenant.getGcpCryptoKey());
    }

    @Override
    public void checkEncryption(Tenant tenant) {
        String test = "\"This is a test\" @\u00e7\u00a3\u00b0\u00e9\u00e0\u00a7";
        String encryptTest = this.encrypt(tenant, "\"This is a test\" @\u00e7\u00a3\u00b0\u00e9\u00e0\u00a7");
        String decryptTest = this.decrypt(tenant, encryptTest);
        if (!"\"This is a test\" @\u00e7\u00a3\u00b0\u00e9\u00e0\u00a7".equals(decryptTest)) {
            throw new IllegalStateException("Your key does not encrypt/decrypt correctly");
        }
    }

    @Override
    public String encrypt(Tenant tenant, String cleartext) {
        if (StringUtils.isBlank((String)tenant.getGcpLocationId()) || StringUtils.isBlank((String)tenant.getGcpKeyRing()) || StringUtils.isBlank((String)tenant.getGcpCryptoKey())) {
            throw new IllegalArgumentException("Can't encrypt, master key in cloud setup is not configured");
        }
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String projectId = StringUtils.defaultIfBlank((String)tenant.getVirtualCloudAccount(settings).getGcpProjectId(), (String)settings.gcpSettings.projectId);
        KMSClient client = this.clientService.getKMSClient(tenant.getVirtualCloudAccount(settings));
        try {
            return client.encryptUTF8(projectId, tenant.getGcpLocationId(), tenant.getGcpKeyRing(), tenant.getGcpCryptoKey(), tenant.getGcpCryptoKeyVersion(), cleartext);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to encrypt. Tips: double check the master key configuration in the cloud setup section.", e);
        }
    }

    @Override
    public String decrypt(Tenant tenant, String ciphertext) {
        if (StringUtils.isBlank((String)tenant.getGcpLocationId()) || StringUtils.isBlank((String)tenant.getGcpKeyRing()) || StringUtils.isBlank((String)tenant.getGcpCryptoKey())) {
            throw new IllegalArgumentException("Can't decrypt, master key in cloud setup is not configured");
        }
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String projectId = StringUtils.defaultIfBlank((String)tenant.getVirtualCloudAccount(settings).getGcpProjectId(), (String)settings.gcpSettings.projectId);
        KMSClient client = this.clientService.getKMSClient(tenant.getVirtualCloudAccount(settings));
        try {
            return client.decryptUTF8(projectId, tenant.getGcpLocationId(), tenant.getGcpKeyRing(), tenant.getGcpCryptoKey(), ciphertext);
        }
        catch (IOException | GeneralSecurityException e) {
            logger.error((Object)"Decryption was attempted for a value that is probably not encrypted.", (Throwable)e);
            return ciphertext;
        }
    }
}

