/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.gcp;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.cloud.VirtualNetworkMetadata;
import com.dataiku.fm.server.FMApp;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class GCPInstanceMetadataReader {
    private static final Logger logger = Logger.getLogger((String)"dku.fm.gcp.metadata");

    public VirtualNetworkMetadata getVirtualNetworkMetadata() {
        JsonObject info;
        VirtualNetworkMetadata result = new VirtualNetworkMetadata();
        String projectId = GCPInstanceMetadataReader.getLocalMetadata("/project/project-id").trim();
        String zoneResource = GCPInstanceMetadataReader.getLocalMetadata("/instance/zone").trim();
        String zone = zoneResource.substring(zoneResource.lastIndexOf(47) + 1);
        String instance = GCPInstanceMetadataReader.getLocalMetadata("/instance/name").trim();
        logger.info((Object)("Sniffing network/subnetwork of " + instance + " in " + zone + " of " + projectId));
        try {
            HashMap<String, String> envVars = new HashMap<String, String>(System.getenv());
            ProxySettings proxySettings = FMApp.getFMSettingsUnsafe().proxySettings;
            if (FMApp.isCloudProxyEnabled() && proxySettings.hasProxy()) {
                envVars.put("http_proxy", "http://" + proxySettings.getAsString());
                envVars.put("https_proxy", "http://" + proxySettings.getAsString());
            }
            DKUtils.ExecutionResults cmdResult = DKUtils.execAndGetOutputAndErrors((String[])new String[]{"gcloud", "compute", "instances", "describe", instance, "--project", projectId, "--zone", zone, "--format=json"}, envVars);
            if (cmdResult.rv != 0) {
                logger.warn((Object)("Failed to get instance info: " + JSON.json((Object)cmdResult)));
                return result;
            }
            info = (JsonObject)JSON.parse((String)cmdResult.out, JsonObject.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get instance info", (Throwable)e);
            return result;
        }
        JsonArray networkInterfacesInfo = info.getAsJsonArray("networkInterfaces");
        JsonObject networkInterfaceInfo = networkInterfacesInfo.get(0).getAsJsonObject();
        String networkResource = networkInterfaceInfo.getAsJsonPrimitive("network").getAsString();
        String subnetworkResource = networkInterfaceInfo.getAsJsonPrimitive("subnetwork").getAsString();
        Pattern projectIdPattern = Pattern.compile("^.*projects/([^/]+)/global/networks/.*$");
        Matcher projectIdMatcher = projectIdPattern.matcher(networkResource);
        result.gcpProjectId = projectIdMatcher.matches() ? projectIdMatcher.group(1) : projectId;
        result.gcpNetwork = networkResource.substring(networkResource.lastIndexOf(47) + 1);
        result.gcpSubnetwork = subnetworkResource.substring(subnetworkResource.lastIndexOf(47) + 1);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalMetadata(String path) {
        try {
            URL url = new URL("http://metadata.google.internal/computeMetadata/v1" + path);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(15000);
            con.setRequestProperty("Metadata-Flavor", "Google");
            int statusCode = con.getResponseCode();
            if (statusCode != 200) {
                logger.warn((Object)("Unable to retrieve local metadata, HTTP " + statusCode + " : " + con.getResponseMessage()));
                return "";
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                String string = response.toString();
                return string;
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to retrieve local metadata " + path), (Throwable)e);
            return "";
        }
    }
}

